/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import jmirc.Database;
import jmirc.HttpIrc;
import jmirc.IrcConnection;
import jmirc.Listener;
import jmirc.SocketIrc;
import jmirc.UIHandler;

public class jmIrc
extends MIDlet
implements CommandListener {
    public static final String VERSION = "0.95.9";
    private static final int FORM_MAIN = 0;
    private static final int FORM_PROFILES = 1;
    private static final int FORM_CONFIG = 2;
    private static final int FORM_CONFIG_EDIT = 3;
    private static final int FORM_ADVANCED = 4;
    private static final int FORM_ALARM = 5;
    private static final int FORM_INTERFACE = 6;
    private static final int FORM_HTTP = 7;
    private Display display = Display.getDisplay((MIDlet)this);
    protected static Form mainform;
    private int currentform;
    private boolean running;
    private static IrcConnection irc;
    private static Listener listener;
    private static UIHandler uihandler;
    private static Database db;
    private Command cmd_connect = new Command("Connect", 4, 1);
    private Command cmd_profiles = new Command("Profiles", 1, 2);
    private Command cmd_advanced = new Command("Advanced", 1, 3);
    private Command cmd_interface;
    private Command cmd_http;
    private Command cmd_exit;
    private Command cmd_alarm = new Command("Alarms", 1, 4);
    private Command cmd_profile_add;
    private Command cmd_profile_edit;
    private Command cmd_profile_delete;
    private Command cmd_ok;
    private Command cmd_cancel;
    private TextField tf_profilename;
    private TextField tf_nick;
    private TextField tf_altnick;
    private TextField tf_host;
    private TextField tf_port;
    private TextField tf_channels;
    private TextField tf_username;
    private TextField tf_realname;
    private TextField tf_hilight;
    private TextField tf_passwd;
    private TextField tf_buflines;
    private TextField tf_maxeditlog;
    private TextField tf_vbrduration;
    private TextField tf_gwhost;
    private TextField tf_gwport;
    private TextField tf_gwpasswd;
    private TextField tf_polltime;
    private ChoiceGroup cg_misc;
    private ChoiceGroup cg_interface;
    private ChoiceGroup cg_fontsize;
    private ChoiceGroup cg_encoding;
    private ChoiceGroup cg_usehttp;
    private ChoiceGroup cg_vibrate;
    private ChoiceGroup cg_ticker;
    private ChoiceGroup cg_alm;
    private List list_profile;

    public jmIrc() {
        this.cmd_interface = new Command("Interface", 1, 5);
        this.cmd_http = new Command("HTTP Config", 1, 6);
        this.cmd_exit = new Command("Exit", 7, 7);
        this.cmd_profile_add = new Command("Add new profile", 1, 2);
        this.cmd_profile_edit = new Command("Edit profile", 1, 3);
        this.cmd_profile_delete = new Command("Delete profile", 1, 4);
        this.cmd_ok = new Command("Save", 4, 1);
        this.cmd_cancel = new Command("Cancel", 7, 10);
        mainform = new Form("jmIrc");
        mainform.addCommand(this.cmd_connect);
        mainform.addCommand(this.cmd_profiles);
        mainform.addCommand(this.cmd_advanced);
        mainform.addCommand(this.cmd_alarm);
        mainform.addCommand(this.cmd_interface);
        mainform.addCommand(this.cmd_http);
        mainform.addCommand(this.cmd_exit);
        mainform.setCommandListener((CommandListener)this);
        db = new Database();
        this.running = false;
    }

    private void updateMainform() {
        String string = jmIrc.db.profilename;
        if ("".equals(string)) {
            string = "Default";
        }
        int n = mainform.size() - 1;
        while (n >= 0) {
            mainform.delete(n);
            --n;
        }
        mainform.append("jmIrc 0.95.9 - ***MODDED*** \n");
        mainform.append("By juhovh\n");
        mainform.append("**************\n");
        mainform.append("mod by L0cutus\n");
        mainform.append("**************\n");
        mainform.append("Profile: " + string);
    }

    public void startApp() {
        if (!this.running) {
            db.load();
            this.updateMainform();
            this.display.setCurrent((Displayable)mainform);
            this.currentform = 0;
            this.running = true;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmd_connect) {
            irc = jmIrc.db.usehttp ? new HttpIrc(jmIrc.db.gwhost, jmIrc.db.gwport, jmIrc.db.gwpasswd, jmIrc.db.encoding) : new SocketIrc(jmIrc.db.usepoll, jmIrc.db.encoding);
            irc.setUnicodeMode(jmIrc.db.utf8detect, jmIrc.db.utf8output);
            uihandler = new UIHandler(db, this.display);
            uihandler.setDisplay((Displayable)uihandler.getConsole());
            listener = new Listener(db, irc, uihandler);
            listener.start();
            System.gc();
        } else if (command == this.cmd_exit) {
            try {
                this.destroyApp(true);
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {
                // empty catch block
            }
            this.notifyDestroyed();
        } else if ((command == this.cmd_ok || command == this.cmd_cancel || command == List.SELECT_COMMAND) && this.currentform != 0) {
            if (this.currentform == 1) {
                this.currentform = 0;
                jmIrc.db.profileidx = this.list_profile.getSelectedIndex();
                db.save_profile();
                this.list_profile = null;
                db.setProfile(jmIrc.db.profileidx);
                this.updateMainform();
                this.display.setCurrent((Displayable)mainform);
            } else if (this.currentform == 2 || this.currentform == 3) {
                boolean bl;
                boolean bl2 = bl = this.currentform == 3;
                if (command == this.cmd_ok) {
                    if (this.tf_nick.getString().equals("")) {
                        Alert alert = new Alert("Warning", "Nick must be set", null, AlertType.WARNING);
                        alert.setTimeout(-2);
                        this.display.setCurrent((Displayable)alert);
                        return;
                    }
                    this.currentform = 1;
                    jmIrc.db.profilename = this.tf_profilename.getString();
                    jmIrc.db.nick = this.tf_nick.getString();
                    jmIrc.db.altnick = this.tf_altnick.getString();
                    jmIrc.db.host = this.tf_host.getString();
                    jmIrc.db.port = this.parseInt(this.tf_port.getString());
                    jmIrc.db.channels = this.tf_channels.getString();
                    jmIrc.db.username = this.tf_username.getString();
                    jmIrc.db.realname = this.tf_realname.getString();
                    jmIrc.db.passwd = this.tf_passwd.getString();
                    if (bl) {
                        db.editProfile(this.list_profile.getSelectedIndex());
                    } else {
                        db.addProfile();
                    }
                }
                this.currentform = 1;
                this.tf_profilename = null;
                this.tf_nick = null;
                this.tf_altnick = null;
                this.tf_host = null;
                this.tf_port = null;
                this.tf_channels = null;
                this.tf_username = null;
                this.tf_realname = null;
                this.tf_passwd = null;
                if (command == this.cmd_ok) {
                    this.commandAction(this.cmd_profiles, null);
                } else {
                    this.display.setCurrent((Displayable)this.list_profile);
                }
            } else if (this.currentform == 4) {
                this.currentform = 0;
                if (command == this.cmd_ok) {
                    jmIrc.db.usepoll = this.cg_misc.isSelected(0);
                    jmIrc.db.showinput = this.cg_misc.isSelected(1);
                    jmIrc.db.utf8detect = this.cg_misc.isSelected(2);
                    jmIrc.db.utf8output = this.cg_misc.isSelected(3);
                    jmIrc.db.encoding = this.cg_encoding.getString(this.cg_encoding.getSelectedIndex());
                    jmIrc.db.buflines = this.parseInt(this.tf_buflines.getString());
                    jmIrc.db.maxeditlog = this.parseInt(this.tf_maxeditlog.getString());
                    jmIrc.db.hilight = this.tf_hilight.getString();
                    db.save_advanced();
                }
                this.cg_misc = null;
                this.cg_encoding = null;
                this.tf_buflines = null;
                this.tf_maxeditlog = null;
                this.tf_hilight = null;
                this.display.setCurrent((Displayable)mainform);
            } else if (this.currentform == 5) {
                this.currentform = 0;
                if (command == this.cmd_ok) {
                    jmIrc.db.vbrDuration = this.parseInt(this.tf_vbrduration.getString());
                    jmIrc.db.vbrOnPrv = this.cg_vibrate.isSelected(0);
                    jmIrc.db.vbrOnChn = this.cg_vibrate.isSelected(1);
                    jmIrc.db.vbrOnHigh = this.cg_vibrate.isSelected(2);
                    jmIrc.db.ticker = this.cg_ticker.isSelected(0);
                    jmIrc.db.almOnHigh = this.cg_alm.isSelected(0);
                    jmIrc.db.almOnPrv = this.cg_alm.isSelected(1);
                    db.save_advanced();
                }
                this.cg_ticker = null;
                this.cg_vibrate = null;
                this.cg_alm = null;
                this.tf_vbrduration = null;
                this.display.setCurrent((Displayable)mainform);
            } else if (this.currentform == 6) {
                this.currentform = 0;
                if (command == this.cmd_ok) {
                    jmIrc.db.header = this.cg_interface.isSelected(0);
                    jmIrc.db.timestamp = this.cg_interface.isSelected(1);
                    jmIrc.db.usecolor = this.cg_interface.isSelected(2);
                    jmIrc.db.usemirccol = this.cg_interface.isSelected(3);
                    jmIrc.db.fontsize = this.cg_fontsize.getSelectedIndex();
                    db.save_interface();
                }
                this.cg_interface = null;
                this.cg_fontsize = null;
                this.display.setCurrent((Displayable)mainform);
            } else if (this.currentform == 7) {
                this.currentform = 0;
                if (command == this.cmd_ok) {
                    jmIrc.db.usehttp = this.cg_usehttp.isSelected(0);
                    jmIrc.db.gwhost = this.tf_gwhost.getString();
                    jmIrc.db.gwport = this.parseInt(this.tf_gwport.getString());
                    jmIrc.db.gwpasswd = this.tf_gwpasswd.getString();
                    jmIrc.db.polltime = this.parseInt(this.tf_polltime.getString());
                    db.save_http();
                }
                this.cg_usehttp = null;
                this.tf_gwhost = null;
                this.tf_gwport = null;
                this.tf_gwpasswd = null;
                this.tf_polltime = null;
                this.display.setCurrent((Displayable)mainform);
            }
        } else {
            Form form;
            if (command == this.cmd_profiles) {
                String[] stringArray = db.getProfiles();
                this.list_profile = new List("Profiles", 3);
                int n = 0;
                while (n < stringArray.length) {
                    this.list_profile.append(stringArray[n], null);
                    ++n;
                }
                if (jmIrc.db.profileidx >= 0) {
                    this.list_profile.setSelectedIndex(jmIrc.db.profileidx, true);
                }
                this.list_profile.addCommand(this.cmd_profile_add);
                this.list_profile.addCommand(this.cmd_profile_edit);
                this.list_profile.addCommand(this.cmd_profile_delete);
                this.list_profile.addCommand(this.cmd_ok);
                this.list_profile.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.list_profile);
                this.currentform = 1;
                return;
            }
            if (command == this.cmd_profile_add || command == this.cmd_profile_edit) {
                if (command == this.cmd_profile_edit) {
                    db.setProfile(this.list_profile.getSelectedIndex());
                } else {
                    db.setProfile(-1);
                }
                this.tf_profilename = new TextField("Profile name", jmIrc.db.profilename, 10, 0);
                this.tf_nick = new TextField("Nick", jmIrc.db.nick, 20, 0);
                this.tf_altnick = new TextField("Alternative nick", jmIrc.db.altnick, 20, 0);
                this.tf_host = new TextField("IRC server", jmIrc.db.host, 200, 4);
                this.tf_port = new TextField("IRC server port", new Integer(jmIrc.db.port).toString(), 5, 2);
                this.tf_channels = new TextField("Channels", jmIrc.db.channels, 600, 0);
                this.tf_username = new TextField("Username", jmIrc.db.username, 25, 0);
                this.tf_realname = new TextField("Real name", jmIrc.db.realname, 50, 0);
                this.tf_passwd = new TextField("Server password", jmIrc.db.passwd, 10, 65536);
                form = new Form("Config");
                form.append((Item)this.tf_profilename);
                form.append((Item)this.tf_nick);
                form.append((Item)this.tf_altnick);
                form.append((Item)this.tf_host);
                form.append((Item)this.tf_port);
                form.append((Item)this.tf_channels);
                form.append((Item)this.tf_username);
                form.append((Item)this.tf_realname);
                form.append((Item)this.tf_passwd);
                this.currentform = command == this.cmd_profile_edit ? 3 : 2;
            } else {
                if (command == this.cmd_profile_delete) {
                    db.deleteProfile(this.list_profile.getSelectedIndex());
                    this.commandAction(this.cmd_profiles, null);
                    return;
                }
                if (command == this.cmd_advanced) {
                    this.cg_misc = new ChoiceGroup("Misc settings", 2);
                    this.cg_misc.append("Use socket poll", null);
                    this.cg_misc.append("Print unhandled input", null);
                    this.cg_misc.append("Detect UTF-8", null);
                    this.cg_misc.append("Output UTF-8", null);
                    this.cg_misc.setSelectedIndex(0, jmIrc.db.usepoll);
                    this.cg_misc.setSelectedIndex(1, jmIrc.db.showinput);
                    this.cg_misc.setSelectedIndex(2, jmIrc.db.utf8detect);
                    this.cg_misc.setSelectedIndex(3, jmIrc.db.utf8output);
                    this.cg_encoding = new ChoiceGroup("Character encoding", 1);
                    this.cg_encoding.append("ISO-8859-1", null);
                    this.cg_encoding.append("ISO-8859-2", null);
                    this.cg_encoding.append("UTF-8", null);
                    this.cg_encoding.append("KOI8-R", null);
                    this.cg_encoding.append("Windows-1251", null);
                    this.cg_encoding.append("Windows-1255", null);
                    if (jmIrc.db.encoding.equals("ISO-8859-1")) {
                        this.cg_encoding.setSelectedIndex(0, true);
                    } else if (jmIrc.db.encoding.equals("ISO-8859-2")) {
                        this.cg_encoding.setSelectedIndex(1, true);
                    } else if (jmIrc.db.encoding.equals("UTF-8")) {
                        this.cg_encoding.setSelectedIndex(2, true);
                    } else if (jmIrc.db.encoding.equals("KOI8-R")) {
                        this.cg_encoding.setSelectedIndex(3, true);
                    } else if (jmIrc.db.encoding.equals("Windows-1251")) {
                        this.cg_encoding.setSelectedIndex(4, true);
                    } else if (jmIrc.db.encoding.equals("Windows-1255")) {
                        this.cg_encoding.setSelectedIndex(5, true);
                    } else {
                        this.cg_encoding.setSelectedIndex(0, true);
                    }
                    this.tf_buflines = new TextField("Backbuffer lines", new Integer(jmIrc.db.buflines).toString(), 3, 2);
                    this.tf_maxeditlog = new TextField("Max EditLog lines", new Integer(jmIrc.db.maxeditlog).toString(), 3, 2);
                    this.tf_hilight = new TextField("Highlight string", jmIrc.db.hilight, 50, 0);
                    form = new Form("Advanced Config");
                    form.append((Item)this.cg_misc);
                    form.append((Item)this.cg_encoding);
                    form.append((Item)this.tf_buflines);
                    form.append((Item)this.tf_maxeditlog);
                    form.append((Item)this.tf_hilight);
                    this.currentform = 4;
                } else if (command == this.cmd_alarm) {
                    this.cg_vibrate = new ChoiceGroup("Vibrate Settings", 2);
                    this.cg_vibrate.append("Vibro On Priv. Msg", null);
                    this.cg_vibrate.append("Vibro On Chan. Msg", null);
                    this.cg_vibrate.append("Vibro On Hilight", null);
                    this.tf_vbrduration = new TextField("Vibro duration msec.", new Integer(jmIrc.db.vbrDuration).toString(), 3, 2);
                    this.cg_vibrate.setSelectedIndex(0, jmIrc.db.vbrOnPrv);
                    this.cg_vibrate.setSelectedIndex(1, jmIrc.db.vbrOnChn);
                    this.cg_vibrate.setSelectedIndex(2, jmIrc.db.vbrOnHigh);
                    this.cg_ticker = new ChoiceGroup("Ticker Settings", 2);
                    this.cg_ticker.append("Show/Hide", null);
                    this.cg_ticker.setSelectedIndex(0, jmIrc.db.ticker);
                    this.cg_alm = new ChoiceGroup("Alarm Settings", 2);
                    this.cg_alm.append("Alm on Highlight", null);
                    this.cg_alm.setSelectedIndex(0, jmIrc.db.almOnHigh);
                    this.cg_alm.append("Alm on Private", null);
                    this.cg_alm.setSelectedIndex(1, jmIrc.db.almOnPrv);
                    form = new Form("Alarms Config");
                    form.append((Item)this.cg_vibrate);
                    form.append((Item)this.cg_ticker);
                    form.append((Item)this.cg_alm);
                    form.append((Item)this.tf_vbrduration);
                    this.currentform = 5;
                } else if (command == this.cmd_interface) {
                    this.cg_interface = new ChoiceGroup("Interface settings", 2);
                    this.cg_interface.append("Use status header", null);
                    this.cg_interface.append("Use timestamp", null);
                    this.cg_interface.append("Use colours", null);
                    this.cg_interface.append("Use mIRC colours", null);
                    this.cg_interface.setSelectedIndex(0, jmIrc.db.header);
                    this.cg_interface.setSelectedIndex(1, jmIrc.db.timestamp);
                    this.cg_interface.setSelectedIndex(2, jmIrc.db.usecolor);
                    this.cg_interface.setSelectedIndex(3, jmIrc.db.usemirccol);
                    this.cg_fontsize = new ChoiceGroup("Font size", 1);
                    this.cg_fontsize.append("Small", null);
                    this.cg_fontsize.append("Medium", null);
                    this.cg_fontsize.append("Large", null);
                    this.cg_fontsize.setSelectedIndex(jmIrc.db.fontsize, true);
                    form = new Form("Interface Config");
                    form.append((Item)this.cg_interface);
                    form.append((Item)this.cg_fontsize);
                    this.currentform = 6;
                } else if (command == this.cmd_http) {
                    this.cg_usehttp = new ChoiceGroup("HTTP", 2);
                    this.cg_usehttp.append("Use HTTP proxy server", null);
                    this.cg_usehttp.setSelectedIndex(0, jmIrc.db.usehttp);
                    this.tf_gwhost = new TextField("Proxy server", jmIrc.db.gwhost, 200, 4);
                    this.tf_gwport = new TextField("Proxy port", new Integer(jmIrc.db.gwport).toString(), 5, 2);
                    this.tf_gwpasswd = new TextField("Proxy password", jmIrc.db.gwpasswd, 10, 65536);
                    this.tf_polltime = new TextField("HTTP poll time (sec):", new Integer(jmIrc.db.polltime).toString(), 2, 2);
                    form = new Form("HTTP Config");
                    form.append((Item)this.cg_usehttp);
                    form.append((Item)this.tf_gwhost);
                    form.append((Item)this.tf_gwport);
                    form.append((Item)this.tf_gwpasswd);
                    form.append((Item)this.tf_polltime);
                    this.currentform = 7;
                } else {
                    return;
                }
            }
            form.addCommand(this.cmd_ok);
            form.addCommand(this.cmd_cancel);
            form.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)form);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
        if (irc != null && irc.isConnected()) {
            if (!bl) {
                throw new MIDletStateChangeException("IRC is still connected");
            }
            jmIrc.disconnect("QUIT :jmIrc destroyed by the OS");
        }
        if (jmIrc.db.usehttp) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private int parseInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static void writeLine(String string) {
        if (irc.isConnected()) {
            String string2 = irc.writeData(String.valueOf(string) + "\r\n");
            if (string2 != null) {
                uihandler.getConsole().writeInfo(string2);
            }
            listener.setNeedUpdate(true);
        }
    }

    public static void forceUpdate() {
        listener.setNeedUpdate(true);
    }

    public static void disconnect(String string) {
        if (irc.isConnected()) {
            String string2 = irc.writeData(String.valueOf(string) + "\r\n");
            if (string2 != null) {
                uihandler.getConsole().writeInfo(string2);
            }
            listener.setNeedUpdate(true);
        }
    }

    public static int getBytesIn() {
        return irc.getBytesIn();
    }

    public static int getBytesOut() {
        return irc.getBytesOut();
    }
}

