/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import jmirc.Database;
import jmirc.TextArea;
import jmirc.UIHandler;
import jmirc.Utils;
import jmirc.jmIrc;

public class Window
extends Canvas
implements CommandListener {
    public static final int TYPE_CONSOLE = 0;
    public static final int TYPE_CHANNEL = 1;
    public static final int TYPE_PRIVATE = 2;
    public static final int STATE_NONE = 0;
    public static final int STATE_INFO = 1;
    public static final int STATE_MSG = 2;
    public static final int STATE_HILIGHT = 3;
    public static final int STATE_SELECTED = 4;
    public static final char MODE_NONE = '\u0000';
    public static final char MODE_VOICE = '\u0001';
    public static final char MODE_HALFOP = '\u0002';
    public static final char MODE_OP = '\u0004';
    private static boolean initialized = false;
    private static String JOIN_CHANNEL;
    private static String CHANGE_NICK;
    private static String OPEN_QUERY;
    private static String ADD_FAVORITE;
    private int type;
    private int state;
    private UIHandler uihandler;
    private Vector names;
    private Font headerfont;
    private TextBox textbox;
    private TextBox editlog;
    private Form favform;
    private static Command cmd_msg;
    private static Command cmd_join;
    private static Command cmd_query;
    private static Command cmd_favourites;
    private static Command cmd_traffic;
    private static Command cmd_timestamp;
    private static Command cmd_disconnect;
    private static Command cmd_closeconsole;
    private static Command cmd_closenamfav;
    private static Command cmd_addfav;
    private static Command cmd_delfav;
    private static Command cmd_sendfav;
    private static Command cmd_close;
    private static Command cmd_whois;
    private static Command cmd_names;
    private static Command cmd_send;
    private static Command cmd_cancel;
    private static Command cmd_ok;
    private static Command cmd_editlog;
    private ChoiceGroup cg_favourites;
    private StringBuffer chanmodes;
    private String name;
    private String header;
    private String chansize;
    private String hilight;
    private long keylocktime;
    private int buflines;
    private int maxeditlog;
    private int vbrDuration;
    private boolean vbrOnPrv;
    private boolean vbrOnChn;
    private boolean almOnHigh;
    private boolean almOnPrv;
    private boolean vbrOnHigh;
    private boolean timestamp;
    private TextArea textarea;
    private boolean showheader;
    private boolean usecol;
    private boolean mirccol;
    private static final int MAX_LIST_PERSONS = 20;
    private int person_position = 0;
    private List nameslist;
    private List namecmdlist;
    private int[] mirccols;

    public Window(Database database, UIHandler uIHandler, String string, int n, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3, int n4) {
        int[] nArray = new int[16];
        nArray[0] = 15;
        nArray[2] = 4;
        nArray[3] = 2;
        nArray[4] = 9;
        nArray[5] = 1;
        nArray[6] = 5;
        nArray[7] = 2;
        nArray[8] = 11;
        nArray[9] = 10;
        nArray[10] = 6;
        nArray[11] = 14;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 8;
        nArray[15] = 7;
        this.mirccols = nArray;
        this.vbrDuration = database.vbrDuration;
        this.vbrOnPrv = database.vbrOnPrv;
        this.vbrOnChn = database.vbrOnChn;
        this.vbrOnHigh = database.vbrOnHigh;
        this.almOnHigh = database.almOnHigh;
        this.almOnPrv = database.almOnPrv;
        this.uihandler = uIHandler;
        this.name = string;
        this.header = string;
        this.chansize = "";
        this.type = n;
        this.hilight = string2;
        this.showheader = bl;
        this.timestamp = bl2;
        this.usecol = bl3;
        this.mirccol = bl4;
        this.buflines = n3;
        this.maxeditlog = n4;
        this.state = 0;
        int n5 = 0;
        if (n2 == 0) {
            n5 = 8;
        }
        if (n2 == 2) {
            n5 = 16;
        }
        this.headerfont = Font.getFont((int)0, (int)1, (int)n5);
        this.textarea = new TextArea(0, 0, this.getWidth(), this.getHeight(), Font.getFont((int)0, (int)0, (int)n5), n3, true, n4);
        this.chanmodes = new StringBuffer();
        this.names = new Vector();
        this.setHeaderVisible(bl);
        if (!initialized) {
            JOIN_CHANNEL = "Join channel";
            OPEN_QUERY = "Query";
            CHANGE_NICK = "Change nick";
            ADD_FAVORITE = "Add favourite";
            cmd_ok = new Command("Ok", 4, 10);
            cmd_send = new Command("Send", 4, 10);
            cmd_cancel = new Command("Cancel", 3, 20);
            cmd_msg = new Command("Msg", 4, 10);
            cmd_join = new Command("Join", 1, 20);
            cmd_query = new Command("Query", 1, 30);
            cmd_favourites = new Command("Favourites", 1, 40);
            cmd_traffic = new Command("Bytecounter", 1, 50);
            cmd_timestamp = new Command("Timestamp on", 1, 60);
            cmd_disconnect = new Command("Disconnect", 1, 70);
            cmd_close = new Command("Close", 1, 65);
            cmd_whois = new Command("Whois", 1, 35);
            cmd_names = new Command("Names", 1, 35);
            cmd_editlog = new Command("Edit Log", 1, 69);
            cmd_sendfav = new Command("Send", 4, 10);
            cmd_addfav = new Command("Add new", 1, 20);
            cmd_delfav = new Command("Delete selected", 1, 30);
            cmd_closeconsole = new Command("Close", 3, 10);
            cmd_closenamfav = new Command("Close", 3, 90);
            initialized = true;
        }
        this.addMenu();
        this.setCommandListener(this);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void nickChangeAction() {
        this.textbox = new TextBox(CHANGE_NICK, "", 30, 0);
        this.textbox.setCommandListener((CommandListener)new TextboxListener());
        this.textbox.addCommand(cmd_ok);
        this.uihandler.setWinlock(true);
        this.uihandler.setDisplay((Displayable)this.textbox);
    }

    public void setHeaderVisible(boolean bl) {
        if (bl) {
            int n = this.headerfont.getHeight();
            this.textarea.setSize(n + 1, this.getHeight() - n);
        } else {
            this.textarea.setSize(0, this.getHeight());
        }
        this.showheader = bl;
    }

    private void updateHeader() {
        this.chansize = " [" + this.names.size() + "]";
    }

    private void show() {
        this.uihandler.setDisplay((Displayable)this);
    }

    public void clear() {
        this.textarea.clear();
    }

    public void enterExitMode() {
        this.addCommand(cmd_closeconsole);
        this.deleteMenu();
    }

    public void close() {
        this.uihandler.deleteWindow(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleMsg(String string) {
        block16: {
            block17: {
                block18: {
                    String string2;
                    block27: {
                        String[] stringArray;
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block21: {
                                                block20: {
                                                    block19: {
                                                        if (string == null || string.length() <= 0) break block16;
                                                        if (string.charAt(0) != '/') break block17;
                                                        stringArray = Utils.splitString(string, " ");
                                                        string2 = stringArray[0].toUpperCase();
                                                        if (stringArray.length <= 1) break block18;
                                                        boolean bl = string2.equals("/CTCP");
                                                        if (!bl && !string2.equals("/MSG") || stringArray.length <= 2) break block19;
                                                        Window window = Utils.isChannel(stringArray[1]) ? this.uihandler.getChannel(stringArray[1]) : this.uihandler.getPrivate(stringArray[1]);
                                                        if (!bl) {
                                                            jmIrc.writeLine("PRIVMSG " + stringArray[1] + " :" + string.substring(6 + stringArray[1].length()));
                                                            window.write(this.uihandler.nick, string.substring(6 + stringArray[1].length()));
                                                            window.show();
                                                            return;
                                                        }
                                                        jmIrc.writeLine("PRIVMSG " + stringArray[1] + " :\u0001" + stringArray[2].toUpperCase() + string.substring(7 + stringArray[1].length() + stringArray[2].length()) + "\u0001");
                                                        break block16;
                                                    }
                                                    if (!string2.equals("/ME")) break block20;
                                                    jmIrc.writeLine("PRIVMSG " + this.name + " :\u0001ACTION " + string.substring(4) + "\u0001");
                                                    this.writeAction("* " + this.uihandler.nick + " " + string.substring(4));
                                                    break block16;
                                                }
                                                if (!string2.equals("/RAW")) break block21;
                                                jmIrc.writeLine(string.substring(5));
                                                this.uihandler.getConsole().write("rawcmd", string.substring(5));
                                                break block16;
                                            }
                                            if (!string2.equals("/WII") && !string2.equals("/WHOIS")) break block22;
                                            jmIrc.writeLine("WHOIS " + stringArray[1] + " " + stringArray[1]);
                                            break block16;
                                        }
                                        if (!string2.equals("/NICK")) break block23;
                                        jmIrc.writeLine("NICK " + stringArray[1]);
                                        this.uihandler.nick = stringArray[1];
                                        break block16;
                                    }
                                    if (!string2.equals("/TOPIC")) break block24;
                                    if (this.type == 1) {
                                        jmIrc.writeLine("TOPIC " + this.name + " :" + string.substring(7));
                                    }
                                    break block16;
                                }
                                if (!string2.equals("/J") && !string2.equals("/JOIN")) break block25;
                                jmIrc.writeLine("JOIN " + string.substring(string2.length() + 1));
                                break block16;
                            }
                            if (!string2.equals("/PART")) break block26;
                            if (Utils.isChannel(stringArray[1])) {
                                jmIrc.writeLine("PART " + stringArray[1] + " :" + (stringArray.length > 2 ? string.substring(6 + stringArray[1].length()) : ""));
                                break block16;
                            } else if (this.type == 1) {
                                jmIrc.writeLine("PART " + this.name + " :" + string.substring(6));
                                break block16;
                            } else {
                                this.uihandler.getConsole().writeInfo("Can only part from channels");
                            }
                            break block16;
                        }
                        if (!string2.equals("/KICK")) break block27;
                        if (Utils.isChannel(stringArray[1]) && stringArray.length > 2) {
                            jmIrc.writeLine("KICK " + stringArray[1] + " " + stringArray[2] + " :" + (stringArray.length > 3 ? string.substring(8 + stringArray[1].length() + stringArray[2].length()) : ""));
                            break block16;
                        } else if (this.type == 1) {
                            jmIrc.writeLine("KICK " + this.name + " " + stringArray[1] + " :" + (stringArray.length > 2 ? string.substring(7 + stringArray[1].length()) : ""));
                            break block16;
                        } else {
                            this.uihandler.getConsole().writeInfo("Can only kick from channels");
                        }
                        break block16;
                    }
                    if (string2.equals("/MODE")) {
                        jmIrc.writeLine("MODE " + string.substring(6));
                        break block16;
                    } else if (string2.equals("/QUIT")) {
                        jmIrc.disconnect("QUIT :" + string.substring(6));
                        break block16;
                    } else {
                        this.uihandler.getConsole().writeInfo("Unknown command");
                    }
                    break block16;
                }
                this.uihandler.getConsole().writeInfo("Not enough parameters");
                break block16;
            }
            if (this.type != 0) {
                String[] stringArray = Utils.splitString(string, "\n");
                int n = 0;
                while (n < stringArray.length) {
                    jmIrc.writeLine("PRIVMSG " + this.name + " :" + stringArray[n]);
                    this.write(this.uihandler.nick, stringArray[n]);
                    ++n;
                }
            }
        }
        this.show();
    }

    private void addMenu() {
        this.addCommand(cmd_msg);
        this.addCommand(cmd_join);
        this.addCommand(cmd_query);
        this.addCommand(cmd_favourites);
        this.addCommand(cmd_traffic);
        this.addCommand(cmd_timestamp);
        if (this.type == 2 || this.type == 1) {
            this.addCommand(cmd_close);
            this.addCommand(cmd_editlog);
            if (this.type == 2) {
                this.addCommand(cmd_whois);
            } else {
                this.addCommand(cmd_names);
            }
        }
        this.addCommand(cmd_disconnect);
    }

    private void deleteMenu() {
        this.removeCommand(cmd_msg);
        this.removeCommand(cmd_join);
        this.removeCommand(cmd_query);
        this.removeCommand(cmd_favourites);
        this.removeCommand(cmd_traffic);
        this.removeCommand(cmd_timestamp);
        if (this.type == 2 || this.type == 1) {
            this.removeCommand(cmd_close);
            this.removeCommand(cmd_editlog);
            if (this.type == 2) {
                this.removeCommand(cmd_whois);
            } else {
                this.removeCommand(cmd_names);
            }
        }
        this.removeCommand(cmd_disconnect);
    }

    public void write(String string, String string2) {
        boolean bl = false;
        String[] stringArray = Utils.splitString(this.hilight, " ");
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals("") && string2.toLowerCase().indexOf(stringArray[n].toLowerCase()) >= 0) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            this.write(new String[]{"<", string, "> ", string2}, new char[]{'\u00f0', '\u00f4', '\u00f0', '\u02f4'});
            if (this.state < 3) {
                this.state = 3;
            }
            if (this.uihandler.keylock) {
                this.uihandler.playAlarm(false);
            }
        } else {
            this.write(new String[]{"<", string, "> ", string2}, new char[]{'\u00f0', '\u00f4', '\u00f0', '\u00f0'});
            if (this.state < 2) {
                this.state = 2;
            }
        }
        if (this.vbrOnPrv & this.type == 2) {
            this.uihandler.vbr(this.vbrDuration);
        }
        if (this.vbrOnChn & this.type == 1) {
            this.uihandler.vbr(this.vbrDuration);
        }
        if (this.almOnHigh & bl) {
            this.uihandler.playAlarm(true);
        }
        if (this.almOnPrv & this.type == 2) {
            this.uihandler.playAlarm(true);
        }
        if (this.vbrOnHigh & bl) {
            this.uihandler.vbr(this.vbrDuration);
        }
    }

    public void writeAction(String string) {
        this.write(new String[]{string}, new char[]{'\u00f4'});
        if (this.state < 2) {
            this.state = 2;
        }
    }

    public void writeInfo(String string) {
        this.write(new String[]{"*** ", string}, new char[]{'\u00f2', '\u00f2'});
        if (this.state < 1) {
            this.state = 1;
        }
    }

    public void write(String[] stringArray, char[] cArray) {
        String[] stringArray2;
        Comparable<Calendar> comparable;
        boolean bl = this.textarea.isAtEndpos();
        if (this.timestamp) {
            comparable = Calendar.getInstance();
            String string = "[" + ((Calendar)comparable).get(11) + ":" + (((Calendar)comparable).get(12) < 10 ? "0" : "") + ((Calendar)comparable).get(12) + "]";
            stringArray[0] = String.valueOf(string) + " " + stringArray[0];
        }
        if (this.usecol) {
            if (this.mirccol) {
                stringArray2 = new String[]{};
                int n = 0;
                while (n < stringArray.length) {
                    stringArray2 = Utils.mergeStringArray(stringArray2, this.parseMircColours(cArray[n], stringArray[n]));
                    ++n;
                }
            } else {
                stringArray2 = new String[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray2[n] = String.valueOf(cArray[n]) + stringArray[n];
                    ++n;
                }
            }
        } else {
            stringArray2 = new String[1];
            comparable = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                ((StringBuffer)comparable).append(stringArray[n]);
                ++n;
            }
            stringArray2[0] = String.valueOf('\u00f0') + ((StringBuffer)comparable).toString();
        }
        this.textarea.addText(stringArray2);
        if (bl) {
            this.textarea.setPosition(-1);
        }
        this.uihandler.repaint();
    }

    public void addNick(char c, String string) {
        int n = this.names.size();
        String string2 = string.toUpperCase();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)this.names.elementAt(n2);
            if (string3.charAt(0) <= c && (string2.compareTo(string3.substring(1).toUpperCase()) < 1 || string3.charAt(0) < c)) {
                this.names.insertElementAt(String.valueOf(c) + string, n2);
                break;
            }
            ++n2;
        }
        if (n2 == n) {
            this.names.addElement(String.valueOf(c) + string);
        }
        this.updateHeader();
    }

    public boolean hasNick(String string) {
        return this.getNickIndex(string) >= 0;
    }

    public void changeNick(String string, String string2) {
        int n = this.getNickIndex(string);
        if (n >= 0) {
            char c = ((String)this.names.elementAt(n)).charAt(0);
            this.deleteNick(string);
            this.addNick(c, string2);
        }
    }

    public void changeNickMode(char c, String string, boolean bl) {
        if (string == null) {
            return;
        }
        int n = this.getNickIndex(string);
        if (n >= 0) {
            char c2 = ((String)this.names.elementAt(n)).charAt(0);
            this.deleteNick(string);
            if (bl) {
                this.addNick((char)(c2 | c), string);
            } else {
                this.addNick((char)(c2 & ~c), string);
            }
        }
    }

    public void changeChanMode(char c, boolean bl) {
        int n = this.chanmodes.toString().indexOf("" + c);
        if (bl && n < 0) {
            int n2 = 0;
            while (n2 < this.chanmodes.length()) {
                if (this.chanmodes.charAt(n2) > c) break;
                ++n2;
            }
            this.chanmodes.insert(n2, c);
        } else if (!bl && n >= 0) {
            this.chanmodes.deleteCharAt(n);
        }
    }

    public void setChanModes(String string) {
        this.chanmodes = new StringBuffer(string);
        this.repaint();
    }

    public void deleteNick(String string) {
        int n = this.getNickIndex(string);
        if (n >= 0) {
            this.names.removeElementAt(n);
            this.updateHeader();
        }
    }

    public void printNicks() {
        if (this.names.size() > 10) {
            this.writeInfo("There are " + this.names.size() + " persons in this channel.");
        } else {
            String string = "";
            Enumeration enumeration = this.names.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                int n = string2.charAt(0) == '\u0004' ? 64 : (string2.charAt(0) == '\u0002' ? 37 : (string2.charAt(0) == '\u0001' ? 43 : 32));
                string = String.valueOf(string) + (char)n + string2.substring(1);
                if (!enumeration.hasMoreElements()) continue;
                string = String.valueOf(string) + ", ";
            }
            this.writeInfo("Nicks in channel: " + string);
        }
    }

    private int getNickIndex(String string) {
        int n = this.names.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)this.names.elementAt(n2);
            if (string2.substring(1).equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void listnames(Command command, Displayable displayable) {
        this.nameslist = new List("Names", 3);
        int n = (this.person_position + 1) * 20;
        if (this.person_position > 0) {
            this.nameslist.append("[Previous]", null);
        }
        if (this.names.size() > n) {
            this.nameslist.append("[Next]", null);
        }
        int n2 = this.person_position * 20;
        while (n2 < n && n2 < this.names.size()) {
            String string = (String)this.names.elementAt(n2);
            int n3 = string.charAt(0) == '\u0004' ? 64 : (string.charAt(0) == '\u0002' ? 37 : (string.charAt(0) == '\u0001' ? 43 : 32));
            this.nameslist.append(String.valueOf((char)n3) + string.substring(1), null);
            ++n2;
        }
        this.nameslist.addCommand(cmd_closenamfav);
        this.nameslist.setCommandListener((CommandListener)this);
        this.uihandler.setDisplay((Displayable)this.nameslist);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.showheader) {
            int n;
            graphics.setColor(140, 140, 230);
            graphics.fillRect(0, 0, this.getWidth(), this.headerfont.getHeight());
            int[] nArray = this.uihandler.getIndicators();
            int n2 = 0;
            while (n2 < nArray.length) {
                switch (nArray[n2]) {
                    case 0: {
                        graphics.setColor(255, 255, 255);
                        break;
                    }
                    case 1: {
                        graphics.setColor(170, 170, 170);
                        break;
                    }
                    case 2: {
                        graphics.setColor(170, 0, 170);
                        break;
                    }
                    case 3: {
                        graphics.setColor(170, 0, 0);
                        break;
                    }
                    case 4: {
                        graphics.setColor(0, 0, 0);
                    }
                }
                graphics.fillRect(3 + n2 * 5, 1, 3, 3);
                ++n2;
            }
            graphics.setFont(this.headerfont);
            graphics.setColor(0);
            String string = this.header;
            String string2 = this.chansize;
            if (this.chanmodes.length() > 0 && this.headerfont.stringWidth(String.valueOf(this.header) + "(+" + this.chanmodes.toString() + ")" + this.chansize) < this.getWidth() - 5 - n2 * 5) {
                string2 = "(+" + this.chanmodes.toString() + ")" + this.chansize;
            } else if (this.headerfont.stringWidth(String.valueOf(this.header) + this.chansize) >= this.getWidth() - 5 - n2 * 5) {
                n = this.getWidth() - 5 - n2 * 5 - this.headerfont.stringWidth(this.chansize);
                n -= this.headerfont.stringWidth(".." + this.header.substring(this.header.length() - 2));
                n2 = this.header.length() - 3;
                while (n2 >= 0 && this.headerfont.substringWidth(this.header, 0, n2) > n) {
                    --n2;
                }
                string = String.valueOf(this.header.substring(0, n2)) + ".." + this.header.substring(this.header.length() - 2);
            }
            graphics.drawString(string2, this.getWidth() - 2, 0, 24);
            graphics.drawString(string, this.getWidth() - 2 - this.headerfont.stringWidth(string2), 0, 24);
            if (this.uihandler.keylock) {
                n = 3;
                int n3 = 5;
                graphics.setColor(0, 0, 0);
                graphics.drawLine(n, n3 + 1, n, n3 + 3);
                graphics.drawLine(n + 2, n3 + 1, n + 2, n3 + 3);
                graphics.drawLine(n + 4, n3 + 1, n + 4, n3 + 2);
                graphics.drawLine(n + 6, n3 + 1, n + 6, n3 + 2);
                graphics.drawLine(n, n3 + 1, n + 3, n3 + 1);
                graphics.drawLine(n + 5, n3, n + 5, n3);
                graphics.drawLine(n + 5, n3 + 3, n + 5, n3 + 3);
            }
        }
        this.textarea.draw(graphics);
    }

    protected void keyPressed(int n) {
        if (n == 53) {
            this.keylocktime = System.currentTimeMillis();
            if (!this.uihandler.keylock) {
                jmIrc.forceUpdate();
            }
            return;
        }
        if (n == 35) {
            if (System.currentTimeMillis() - this.keylocktime < 1000L) {
                if (!this.uihandler.keylock) {
                    Alert alert = new Alert("Keylock", "Keypad locked!", null, AlertType.INFO);
                    alert.setTimeout(1000);
                    this.uihandler.setDisplay((Displayable)alert);
                    this.uihandler.setWinlock(true);
                    this.deleteMenu();
                } else {
                    Alert alert = new Alert("Keylock", "Keylock removed!", null, AlertType.INFO);
                    alert.setTimeout(1000);
                    this.uihandler.setDisplay((Displayable)alert);
                    this.uihandler.setWinlock(false);
                    this.addMenu();
                }
                this.uihandler.keylock = !this.uihandler.keylock;
                this.keylocktime = 0L;
                this.repaint();
                return;
            }
        } else {
            this.keylocktime = 0L;
        }
        if (!this.uihandler.keylock) {
            if (n >= 97 && n <= 122 || n >= 65 && n <= 90) {
                this.textbox = new TextBox("Write text", null, 512, 0);
                this.textbox.insert("" + (char)n, 0);
                this.textbox.setCommandListener((CommandListener)new TextboxListener());
                this.textbox.addCommand(cmd_send);
                this.textbox.addCommand(cmd_cancel);
                this.uihandler.setWinlock(true);
                this.uihandler.setDisplay((Displayable)this.textbox);
            } else if (n == 137) {
                this.commandAction(cmd_msg, null);
            } else if (n == 50 || this.getGameAction(n) == 1) {
                if (this.textarea.updatePosition(-1)) {
                    this.repaint();
                }
            } else if (n == 56 || this.getGameAction(n) == 6) {
                if (this.textarea.updatePosition(1)) {
                    this.repaint();
                }
            } else if (n == 52 || this.getGameAction(n) == 2) {
                this.uihandler.displayPreviousWindow();
            } else if (n == 54 || this.getGameAction(n) == 5) {
                this.uihandler.displayNextWindow();
            } else if (n == 49) {
                if (this.textarea.setPosition(0)) {
                    this.repaint();
                }
            } else if (n == 55) {
                if (this.textarea.setPosition(-1)) {
                    this.repaint();
                }
            } else if (n == 51) {
                if (this.textarea.setPosition(-2)) {
                    this.repaint();
                }
            } else if (n == 57) {
                if (this.textarea.setPosition(-3)) {
                    this.repaint();
                }
            } else if (n == 48) {
                this.commandAction(cmd_favourites, null);
            } else if (n == 35) {
                this.uihandler.setHeader(!this.showheader);
                this.repaint();
            } else if (this.getGameAction(n) == 8) {
                this.commandAction(cmd_msg, null);
            }
        }
    }

    protected void keyReleased(int n) {
        if (!this.uihandler.keylock && n == 42) {
            this.commandAction(cmd_msg, null);
        }
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == cmd_msg || command == cmd_join || command == cmd_query) {
            if (command == cmd_msg) {
                this.textbox = new TextBox("Write text", "", 1000, 0);
                this.textbox.addCommand(cmd_send);
            } else {
                this.textbox = new TextBox(command == cmd_join ? JOIN_CHANNEL : OPEN_QUERY, "", 100, 0);
                this.textbox.addCommand(cmd_ok);
            }
            this.textbox.addCommand(cmd_cancel);
            this.textbox.setCommandListener((CommandListener)new TextboxListener());
            this.uihandler.setWinlock(true);
            this.uihandler.setDisplay((Displayable)this.textbox);
        } else if (command == cmd_editlog) {
            String string = this.textarea.getBuffer();
            this.editlog = new TextBox("Edit Log", string, string.length() + 1, 0);
            this.editlog.addCommand(cmd_cancel);
            this.editlog.setCommandListener((CommandListener)new TextboxListener());
            this.uihandler.setWinlock(true);
            this.uihandler.setDisplay((Displayable)this.editlog);
        } else if (command == cmd_disconnect) {
            jmIrc.disconnect("QUIT :used jmIrc\r\n");
            this.uihandler.clearChanPriv();
            this.uihandler.cleanup();
        } else if (command == cmd_closeconsole) {
            this.uihandler.cleanup();
        } else if (command == cmd_traffic) {
            String string = "Bytes in:" + jmIrc.getBytesIn() + "\n";
            string = String.valueOf(string) + "Bytes out:" + jmIrc.getBytesOut() + "\n";
            string = String.valueOf(string) + "Total:" + (jmIrc.getBytesOut() + jmIrc.getBytesIn());
            Alert alert = new Alert("ByteCounter", string, null, AlertType.INFO);
            alert.setTimeout(-2);
            this.uihandler.setDisplay((Displayable)alert);
        } else if (command == cmd_timestamp) {
            this.removeCommand(cmd_timestamp);
            cmd_timestamp = this.timestamp ? new Command("Timestamp on", 1, 60) : new Command("Timestamp off", 1, 60);
            this.addCommand(cmd_timestamp);
            this.timestamp = !this.timestamp;
            this.repaint();
        } else if (command == cmd_names) {
            this.listnames(command, displayable);
        } else if (command == cmd_whois) {
            jmIrc.writeLine("WHOIS " + this.name + " " + this.name);
        } else if (command == cmd_close) {
            if (this.type == 1) {
                jmIrc.writeLine("PART " + this.name);
            }
            this.close();
        } else if (command == cmd_closenamfav) {
            this.nameslist = null;
            this.cg_favourites = null;
            this.favform = null;
            this.uihandler.setWinlock(false);
            this.show();
        } else if (command == cmd_favourites) {
            this.favform = new Form("Favourites");
            Vector vector = this.uihandler.getFavs();
            this.cg_favourites = new ChoiceGroup("Favourites", 2);
            int n = 0;
            while (n < vector.size()) {
                this.cg_favourites.append((String)vector.elementAt(n), null);
                ++n;
            }
            this.favform.append((Item)this.cg_favourites);
            this.favform.addCommand(cmd_sendfav);
            this.favform.addCommand(cmd_addfav);
            this.favform.addCommand(cmd_delfav);
            this.favform.addCommand(cmd_closenamfav);
            this.favform.setCommandListener((CommandListener)this);
            this.uihandler.setWinlock(true);
            this.uihandler.setDisplay((Displayable)this.favform);
        } else if (command == cmd_sendfav) {
            boolean[] blArray = new boolean[this.cg_favourites.size()];
            this.cg_favourites.getSelectedFlags(blArray);
            int n = 0;
            while (n < blArray.length) {
                if (blArray[n]) {
                    String string = this.cg_favourites.getString(n);
                    this.handleMsg(string);
                }
                ++n;
            }
            this.uihandler.setWinlock(false);
            this.show();
        } else if (command == cmd_addfav) {
            this.textbox = new TextBox(ADD_FAVORITE, "", 128, 0);
            this.textbox.setCommandListener((CommandListener)new TextboxListener());
            this.textbox.addCommand(cmd_ok);
            this.textbox.addCommand(cmd_cancel);
            this.uihandler.setDisplay((Displayable)this.textbox);
        } else if (command == cmd_delfav) {
            boolean[] blArray = new boolean[this.cg_favourites.size()];
            this.cg_favourites.getSelectedFlags(blArray);
            int n = 0;
            while (n < blArray.length) {
                if (blArray[n]) {
                    this.uihandler.removeFav(this.cg_favourites.getString(n));
                }
                ++n;
            }
            Vector vector = this.uihandler.getFavs();
            while (this.cg_favourites.size() > 0) {
                this.cg_favourites.delete(0);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                this.cg_favourites.append((String)vector.elementAt(n2), null);
                ++n2;
            }
            this.uihandler.saveFavs();
        } else if (this.nameslist != null && command == List.SELECT_COMMAND) {
            String string = this.nameslist.getString(this.nameslist.getSelectedIndex());
            if (string.equals("[Next]")) {
                ++this.person_position;
                this.listnames(command, displayable);
            } else if (string.equals("[Previous]")) {
                --this.person_position;
                this.listnames(command, displayable);
            } else {
                this.namecmdlist = new List(string, 3);
                this.namecmdlist.append("[Back]", null);
                this.namecmdlist.append("Query", null);
                this.namecmdlist.append("Whois", null);
                this.namecmdlist.append("Kick", null);
                this.namecmdlist.append("Ban", null);
                this.namecmdlist.append("Op", null);
                this.namecmdlist.append("Deop", null);
                this.namecmdlist.append("Voice", null);
                this.namecmdlist.append("Devoice", null);
                this.namecmdlist.setCommandListener((CommandListener)this);
                this.uihandler.setDisplay((Displayable)this.namecmdlist);
                this.nameslist = null;
            }
        } else if (this.namecmdlist != null && command == List.SELECT_COMMAND) {
            String string = this.namecmdlist.getString(this.namecmdlist.getSelectedIndex());
            String string2 = this.namecmdlist.getTitle();
            if (string.equals("[Back]")) {
                this.listnames(command, displayable);
                this.namecmdlist = null;
            } else if (string.equals("Query")) {
                Window window = this.uihandler.getPrivate(string2.substring(1));
                this.state = 0;
                window.show();
                this.namecmdlist = null;
            } else if (string.equals("Whois")) {
                jmIrc.writeLine("WHOIS " + string2.substring(1) + " " + string2.substring(1));
                this.show();
                this.namecmdlist = null;
            } else if (string.equals("Kick")) {
                jmIrc.writeLine("KICK " + this.name + " " + string2.substring(1) + " :" + this.uihandler.nick);
                this.show();
                this.namecmdlist = null;
            } else if (string.equals("Ban")) {
                jmIrc.writeLine("MODE " + this.name + " +b " + string2.substring(1) + "!*@*");
                this.show();
                this.namecmdlist = null;
            } else {
                String string3 = "";
                if (string.equals("Op")) {
                    string3 = "+o";
                } else if (string.equals("Deop")) {
                    string3 = "-o";
                } else if (string.equals("Voice")) {
                    string3 = "+v";
                } else if (string.equals("Devoice")) {
                    string3 = "-v";
                }
                jmIrc.writeLine("MODE " + this.name + " " + string3 + " " + string2.substring(1));
                this.show();
                this.namecmdlist = null;
            }
        }
    }

    private String[] parseMircColours(int n, String string) {
        String[] stringArray = null;
        int n2 = n;
        Vector<String> vector = new Vector<String>();
        Vector<Character> vector2 = new Vector<Character>();
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == '\u0002' || c == '\u0003' || c == '\u0016' | c == '\u001f') {
                if (!string.substring(0, n3).equals("")) {
                    vector.addElement(string.substring(0, n3));
                    vector2.addElement(new Character((char)n2));
                }
                string = string.substring(n3 + 1);
                n3 = -1;
                switch (c) {
                    case '\u0002': {
                        n2 ^= 0x100;
                        break;
                    }
                    case '\u001f': {
                        n2 ^= 0x400;
                        break;
                    }
                    case '\u0016': {
                        int n4 = n2;
                        n2 &= 0xFFFFFF00;
                        n2 |= (n4 & 0xF) << 4;
                        n2 |= (n4 & 0xF0) >> 4;
                        break;
                    }
                    case '\u0003': {
                        String[] stringArray2 = new String[2];
                        int n5 = 0;
                        while (n5 < string.length()) {
                            char c2 = string.charAt(n5);
                            if (c2 != ',' && !Character.isDigit(c2)) {
                                if (n5 == 0) break;
                                if (stringArray2[0] == null) {
                                    stringArray2[0] = string.substring(0, n5);
                                } else {
                                    stringArray2[1] = string.substring(0, n5);
                                }
                                string = string.substring(n5);
                                break;
                            }
                            if (c2 == ',' && stringArray2[0] != null) {
                                if (n5 == 0) break;
                                stringArray2[1] = string.substring(0, n5);
                                string = string.substring(n5);
                                break;
                            }
                            if (c2 == ',') {
                                if (n5 == 0) {
                                    string.substring(n5 + 1);
                                    break;
                                }
                                stringArray2[0] = string.substring(0, n5);
                                if (n5 == string.length() - 1 || !Character.isDigit(string.charAt(n5 + 1))) {
                                    string = string.substring(n5);
                                    break;
                                }
                                string = string.substring(n5 + 1);
                                n5 = 0;
                            }
                            ++n5;
                        }
                        if (stringArray2[0] == null) {
                            n2 &= 0xFFFFFF00;
                            n2 |= n & 0xFF;
                            break;
                        }
                        if (stringArray2[0] != null) {
                            n2 &= 0xFFFFFFF0;
                            n2 |= this.mirccols[Integer.parseInt(stringArray2[0]) & 0xF];
                        }
                        if (stringArray2[1] == null) break;
                        n2 &= 0xFFFFFF0F;
                        n2 |= this.mirccols[Integer.parseInt(stringArray2[1]) & 0xF] << 4;
                    }
                }
            }
            ++n3;
        }
        if (!string.equals("")) {
            vector.addElement(string);
            vector2.addElement(new Character((char)n2));
        }
        stringArray = new String[vector.size()];
        n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = String.valueOf(((Character)vector2.elementAt(n3)).charValue()) + (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    private class TextboxListener
    implements CommandListener {
        private TextboxListener() {
        }

        public void commandAction(Command command, Displayable displayable) {
            Window.this.uihandler.setWinlock(false);
            if (Window.this.editlog != null) {
                Window.this.editlog = null;
                Window.this.show();
            }
            if (Window.this.textbox == null) {
                return;
            }
            String string = Window.this.textbox.getTitle();
            String string2 = Window.this.textbox.getString();
            Window.this.textbox = null;
            if (command == cmd_send) {
                Window.this.handleMsg(string2);
            } else if (command == cmd_cancel) {
                if (string.equals(ADD_FAVORITE)) {
                    Window.this.uihandler.setDisplay((Displayable)Window.this.favform);
                } else {
                    Window.this.show();
                }
            } else if (command == cmd_ok) {
                if (string2.trim().equals("")) {
                    return;
                }
                if (string.equals(JOIN_CHANNEL)) {
                    if (!Utils.isChannel(string2)) {
                        string2 = "#" + string2;
                    }
                    jmIrc.writeLine("JOIN " + string2);
                    jmIrc.writeLine("MODE " + string2);
                    Window.this.show();
                } else if (string.equals(CHANGE_NICK)) {
                    jmIrc.writeLine("NICK " + string2);
                    ((Window)Window.this).uihandler.nick = string2;
                    Window.this.show();
                } else if (string.equals(OPEN_QUERY)) {
                    Window.this.uihandler.setDisplay((Displayable)Window.this.uihandler.getPrivate(string2));
                } else if (string.equals(ADD_FAVORITE)) {
                    Window.this.uihandler.addFav(string2);
                    Window.this.uihandler.saveFavs();
                    Vector vector = Window.this.uihandler.getFavs();
                    while (Window.this.cg_favourites.size() > 0) {
                        Window.this.cg_favourites.delete(0);
                    }
                    int n = 0;
                    while (n < vector.size()) {
                        Window.this.cg_favourites.append((String)vector.elementAt(n), null);
                        ++n;
                    }
                    Window.this.uihandler.setDisplay((Displayable)Window.this.favform);
                }
            }
        }
    }
}

