/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class Utils {
    public static byte[] readLine(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[512];
        int n = 0;
        while (n < 512) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                throw new EOFException();
            }
            byArray[n] = (byte)n2;
            if (byArray[n] == 10) break;
            ++n;
        }
        if (n == 512) {
            return null;
        }
        if (n > 0 && byArray[n - 1] == 13) {
            --n;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static String[] splitString(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.equals("") || string2 == null || string2.length() == 0) {
            return new String[]{string};
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.indexOf(string2, n);
        while (n2 != -1) {
            vector.addElement(string.substring(n, n2));
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        vector.addElement(string.substring(n));
        String[] stringArray = new String[vector.size()];
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public static boolean hasNoValue(String string) {
        return string == null || string.equals("") || string.getBytes().length == 0;
    }

    public static String URLEncode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 >= 48 && n2 <= 57 || n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122 || n2 == 46 || n2 == 45 || n2 == 42 || n2 == 95) {
                stringBuffer.append((char)n2);
            } else if (n2 == 32) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('%');
                if (n2 < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isChannel(String string) {
        int n = 32;
        if (string.length() > 0) {
            n = string.charAt(0);
        }
        return n == 35 || n == 38 || n == 33;
    }

    public static String[] mergeStringArray(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static String formatDateMillis(long l) {
        String string = "SunMonTueWedThuFriSat";
        String string2 = "JanFebMarAprMayJunJulAugSepOctNovDec";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        return String.valueOf(string.substring((calendar.get(7) - 1) * 3).substring(0, 3)) + " " + string2.substring(calendar.get(2) * 3).substring(0, 3) + " " + calendar.get(5) + " " + calendar.get(11) + ":" + (calendar.get(12) < 10 ? "0" : "") + calendar.get(12) + " " + calendar.get(1);
    }

    public static String trim(String string) {
        int n = 0;
        while (n <= string.length() && string.charAt(n) == ' ') {
            ++n;
        }
        int n2 = string.length() - 1;
        while (n2 > n && string.charAt(n2) == ' ') {
            --n2;
        }
        return string.substring(n, n2 + 1);
    }
}

