/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStore;
import jmirc.Database;
import jmirc.Window;
import jmirc.jmIrc;

public class UIHandler {
    private Display display;
    private Database db;
    private Window console;
    private boolean header;
    private boolean timestamp;
    private boolean winlock;
    private boolean usecol;
    private boolean mirccol;
    private boolean vbrOnPrv;
    private boolean vbrOnChn;
    private boolean vbrOnHigh;
    private int fontsize;
    private int buflines;
    private int maxeditlog;
    private int vbrDuration;
    private Hashtable channels;
    private Hashtable privates;
    private Vector windows;
    private Vector favourites;
    private int currentwin;
    private String hilight;
    public String nick;
    public boolean keylock;

    public UIHandler(Database database, Display display) {
        this.db = database;
        this.nick = database.nick;
        this.keylock = false;
        this.header = database.header;
        this.timestamp = database.timestamp;
        this.hilight = database.hilight;
        this.fontsize = database.fontsize;
        this.buflines = database.buflines;
        this.maxeditlog = database.maxeditlog;
        this.vbrDuration = database.vbrDuration;
        this.vbrOnPrv = database.vbrOnPrv;
        this.vbrOnChn = database.vbrOnChn;
        this.vbrOnHigh = database.vbrOnHigh;
        this.usecol = database.usecolor;
        this.mirccol = database.usemirccol;
        this.display = display;
        this.winlock = false;
        this.channels = new Hashtable();
        this.privates = new Hashtable();
        this.windows = new Vector();
        this.loadFavs();
        this.currentwin = 0;
        this.console = new Window(database, this, "Status", 0, this.hilight, this.header, this.timestamp, this.usecol, this.mirccol, this.fontsize, this.buflines, this.maxeditlog);
        this.addWindow(this.console);
    }

    public Window getConsole() {
        return this.console;
    }

    public Window getChannel(String string) {
        Window window = (Window)((Object)this.channels.get((string = string.trim()).toUpperCase()));
        if (window == null) {
            window = new Window(this.db, this, string, 1, this.hilight, this.header, this.timestamp, this.usecol, this.mirccol, this.fontsize, this.buflines, this.maxeditlog);
            this.channels.put(string.toUpperCase(), window);
            this.addWindow(window);
        }
        return window;
    }

    public Window getPrivate(String string) {
        Window window = (Window)((Object)this.privates.get((string = string.trim()).toUpperCase()));
        if (window == null) {
            window = new Window(this.db, this, string, 2, this.hilight, this.header, this.timestamp, this.usecol, this.mirccol, this.fontsize, this.buflines, this.maxeditlog);
            this.privates.put(string.toUpperCase(), window);
            this.addWindow(window);
            if (this.keylock) {
                this.playAlarm(true);
            }
        }
        return window;
    }

    public void addWindow(Window window) {
        this.windows.addElement(window);
        this.displayWindow(-1);
    }

    public int[] getIndicators() {
        int[] nArray = new int[this.windows.size()];
        int n = 0;
        while (n < this.windows.size()) {
            nArray[n] = n == this.currentwin ? 4 : ((Window)((Object)this.windows.elementAt(n))).getState();
            ++n;
        }
        return nArray;
    }

    public void setHeader(boolean bl) {
        this.header = bl;
        int n = 0;
        while (n < this.windows.size()) {
            ((Window)((Object)this.windows.elementAt(n))).setHeaderVisible(this.header);
            ++n;
        }
    }

    public void displayNextWindow() {
        this.displayWindow(this.currentwin + 1);
    }

    public void displayPreviousWindow() {
        this.displayWindow(this.currentwin - 1);
    }

    public void displayWindow(int n) {
        if (this.winlock) {
            return;
        }
        if (n >= this.windows.size()) {
            n = 0;
        }
        if (n < 0) {
            n = this.windows.size() - 1;
        }
        if (n != this.currentwin) {
            ((Window)((Object)this.windows.elementAt(this.currentwin))).setState(0);
            this.setDisplay((Displayable)((Window)((Object)this.windows.elementAt(n))));
            this.currentwin = n;
        }
        System.gc();
    }

    public void deleteWindow(Window window) {
        if (window.getType() == 2) {
            this.privates.remove(window.getName().toUpperCase());
        }
        if (window.getType() == 1) {
            this.channels.remove(window.getName().toUpperCase());
        }
        if (this.windows.indexOf((Object)window) <= this.currentwin) {
            --this.currentwin;
            this.setDisplay((Displayable)((Window)((Object)this.windows.elementAt(this.currentwin))));
            this.windows.removeElement((Object)window);
        } else {
            this.windows.removeElement((Object)window);
            this.repaint();
        }
    }

    public void setDisplay(Displayable displayable) {
        this.display.setCurrent(displayable);
    }

    public Hashtable getChannels() {
        return this.channels;
    }

    public void clearChanPriv() {
        this.console.enterExitMode();
        if (this.currentwin >= 0) {
            this.setDisplay((Displayable)this.console);
            this.currentwin = 0;
        }
        int n = this.windows.size() - 1;
        while (n >= 1) {
            ((Window)((Object)this.windows.elementAt(n))).enterExitMode();
            --n;
        }
        this.console.repaint();
    }

    public void cleanup() {
        this.windows.removeAllElements();
        this.channels.clear();
        this.privates.clear();
        this.currentwin = -1;
        System.gc();
        this.setDisplay((Displayable)jmIrc.mainform);
    }

    public void repaint() {
        if (this.windows.size() > 0) {
            ((Window)((Object)this.windows.elementAt(this.currentwin))).repaint();
        }
    }

    public void setWinlock(boolean bl) {
        this.winlock = bl;
    }

    public boolean playAlarm(boolean bl) {
        if (bl) {
            return AlertType.ALARM.playSound(this.display);
        }
        return AlertType.INFO.playSound(this.display);
    }

    public void vbr(int n) {
        this.display.vibrate(n);
    }

    public void loadFavs() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"jmircfav", (boolean)true);
            this.favourites = new Vector();
            if (recordStore.getNumRecords() > 0) {
                byte[] byArray = recordStore.enumerateRecords(null, null, false).nextRecord();
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                int n = dataInputStream.readInt();
                int n2 = 0;
                while (n2 < n) {
                    this.favourites.addElement(dataInputStream.readUTF());
                    ++n2;
                }
                dataInputStream.close();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveFavs() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.favourites.size());
            int n = 0;
            while (n < this.favourites.size()) {
                dataOutputStream.writeUTF((String)this.favourites.elementAt(n));
                ++n;
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore.deleteRecordStore((String)"jmircfav");
            RecordStore recordStore = RecordStore.openRecordStore((String)"jmircfav", (boolean)true);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addFav(String string) {
        int n = 0;
        while (n < this.favourites.size()) {
            if (string.compareTo((String)this.favourites.elementAt(n)) < 0) {
                this.favourites.insertElementAt(string, n);
                return;
            }
            ++n;
        }
        this.favourites.addElement(string);
    }

    public void removeFav(String string) {
        this.favourites.removeElement(string);
    }

    public Vector getFavs() {
        return this.favourites;
    }
}

