/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import jmirc.Utils;

public class TextArea {
    private int left;
    private int top;
    private int width;
    private int height;
    private Font font;
    private int fontheight;
    private int position = 0;
    private int emptylines;
    private boolean scrollbar;
    private String[][] scrollbuffer;
    private int bufindex;
    private int maxeditlog;
    private final int MAX_LINES;

    public TextArea(int n, int n2, int n3, int n4, Font font, int n5, boolean bl, int n6) {
        this.left = n;
        this.top = n2;
        this.width = n3;
        this.height = n4;
        this.font = font;
        this.scrollbar = bl;
        this.fontheight = font.getHeight();
        this.MAX_LINES = n5;
        this.maxeditlog = n6;
        this.scrollbuffer = new String[this.MAX_LINES][];
        this.emptylines = this.MAX_LINES;
    }

    public void setSize(int n, int n2) {
        boolean bl = this.isAtEndpos();
        this.top = n;
        this.height = n2;
        if (bl) {
            this.setPosition(-1);
        } else {
            this.setPosition(this.position);
        }
    }

    public boolean setPosition(int n) {
        int n2 = this.height / this.fontheight;
        int n3 = this.MAX_LINES - this.emptylines - n2;
        int n4 = this.position;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n == -3) {
            this.updatePosition(n2);
        } else if (n == -2) {
            this.updatePosition(0 - n2);
        } else {
            this.position = n < 0 ? n3 : (n > n3 ? n3 : n);
        }
        return n4 != this.position;
    }

    public boolean updatePosition(int n) {
        if (this.position + n < 0) {
            return this.setPosition(0);
        }
        return this.setPosition(this.position + n);
    }

    public boolean isAtEndpos() {
        return this.position >= this.MAX_LINES - this.emptylines - this.height / this.fontheight;
    }

    private void addLine(String[] stringArray) {
        boolean bl = this.isAtEndpos();
        this.scrollbuffer[this.bufindex] = stringArray;
        this.bufindex = (this.bufindex + 1) % this.MAX_LINES;
        if (!bl && this.emptylines == 0) {
            this.updatePosition(-1);
        }
        if (this.emptylines > 0) {
            --this.emptylines;
        }
    }

    public synchronized void addText(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        Vector<Character> vector2 = new Vector<Character>();
        Font font = this.font;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = null;
            String string2 = null;
            char c = stringArray[n2].charAt(0);
            stringArray[n2] = stringArray[n2].substring(1);
            font = Font.getFont((int)font.getFace(), (int)(c >> 8 & 0xF), (int)font.getSize());
            String[] stringArray2 = Utils.splitString(stringArray[n2], " ");
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (string2 == null) {
                    string2 = stringArray2[n3];
                    if (n + font.stringWidth(string2) > this.width - 5) {
                        if (bl) {
                            string = "";
                            string2 = " " + string2;
                        } else {
                            int n4 = 1;
                            while (n + font.stringWidth(string2.substring(0, n4)) < this.width - 5) {
                                ++n4;
                            }
                            string = string2.substring(0, n4 - 1);
                            string2 = " " + string2.substring(n4 - 1);
                        }
                        n = 0;
                    }
                    n += font.stringWidth(string2);
                } else if (n + font.stringWidth(" " + stringArray2[n3]) > this.width - 5) {
                    string = string2;
                    string2 = " " + stringArray2[n3];
                    n = font.stringWidth(string2);
                } else {
                    string2 = String.valueOf(string2) + " " + stringArray2[n3];
                    n += font.stringWidth(" " + stringArray2[n3]);
                }
                while (string != null) {
                    if (!string.equals("")) {
                        vector.addElement(string);
                        vector2.addElement(new Character(c));
                    }
                    String[] stringArray3 = new String[vector.size()];
                    int n5 = 0;
                    while (n5 < stringArray3.length) {
                        stringArray3[n5] = String.valueOf(((Character)vector2.elementAt(n5)).charValue()) + (String)vector.elementAt(n5);
                        ++n5;
                    }
                    this.addLine(stringArray3);
                    vector.removeAllElements();
                    vector2.removeAllElements();
                    if (font.stringWidth(string2) > this.width - 5) {
                        n5 = 1;
                        while (font.stringWidth(string2.substring(0, n5)) < this.width - 5) {
                            ++n5;
                        }
                        string = string2.substring(0, n5 - 1);
                        string2 = " " + string2.substring(n5 - 1);
                        n = font.stringWidth(string2);
                        continue;
                    }
                    string = null;
                }
                ++n3;
            }
            vector.addElement(string2);
            vector2.addElement(new Character(c));
            bl = string2.length() > 0 && string2.charAt(string2.length() - 1) == ' ';
            ++n2;
        }
        if (vector.size() > 0 && vector2.size() > 0) {
            String[] stringArray4 = new String[vector.size()];
            int n6 = 0;
            while (n6 < stringArray4.length) {
                stringArray4[n6] = String.valueOf(((Character)vector2.elementAt(n6)).charValue()) + (String)vector.elementAt(n6);
                ++n6;
            }
            this.addLine(stringArray4);
            vector.removeAllElements();
            vector2.removeAllElements();
        }
    }

    public void draw(Graphics graphics) {
        int n = this.height / this.fontheight;
        graphics.setFont(this.font);
        graphics.setColor(0);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 1 + this.left;
            int n4 = (this.bufindex + this.emptylines + this.position + n2) % this.scrollbuffer.length;
            String[] stringArray = this.scrollbuffer[n4];
            char c = '\u0000';
            if (stringArray == null) break;
            if (stringArray[0].charAt(1) == ' ') {
                n3 += graphics.getFont().stringWidth(" ");
            }
            int n5 = 0;
            while (n5 < stringArray.length) {
                char c2 = stringArray[n5].charAt(0);
                String string = stringArray[n5].substring(1);
                if (string.charAt(0) == ' ' && n5 == 0) {
                    string = string.substring(1);
                }
                if (c2 != c) {
                    graphics.setFont(Font.getFont((int)this.font.getFace(), (int)(c2 >> 8 & 0xF), (int)this.font.getSize()));
                    graphics.setColor(this.getColor(c2 >> 4 & 0xF));
                    graphics.fillRect(n3, this.top + n2 * this.fontheight, graphics.getFont().stringWidth(string), this.fontheight);
                    graphics.setColor(this.getColor(c2 & 0xF));
                    c = c2;
                }
                graphics.drawString(string, n3, this.top + n2 * this.fontheight, 20);
                n3 += graphics.getFont().stringWidth(string);
                ++n5;
            }
            ++n2;
        }
        if (this.scrollbar && this.MAX_LINES - this.emptylines > n) {
            n2 = this.position * this.height / (this.MAX_LINES - this.emptylines - n);
            graphics.setColor(200, 200, 200);
            graphics.fillRect(this.width - 3, this.top, 2, this.height);
            graphics.setColor(0, 0, 0);
            graphics.fillRect(this.width - 3, this.top + n2, 2, 10);
        }
    }

    private int getColor(int n) {
        switch (n &= 0xF) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0xAA0000;
            }
            case 2: {
                return 53760;
            }
            case 3: {
                return 0xAA5522;
            }
            case 4: {
                return 170;
            }
            case 5: {
                return 0xAA00AA;
            }
            case 6: {
                return 43690;
            }
            case 7: {
                return 0xAAAAAA;
            }
            case 8: {
                return 0x444444;
            }
            case 9: {
                return 0xFF4444;
            }
            case 10: {
                return 0x44FF44;
            }
            case 11: {
                return 0xFFFF44;
            }
            case 12: {
                return 0x4444FF;
            }
            case 13: {
                return 0xFF44FF;
            }
            case 14: {
                return 0x44FFFF;
            }
            case 15: {
                return 0xFFFFFF;
            }
        }
        return 0xFFFFFF;
    }

    public void clear() {
        this.scrollbuffer = new String[this.MAX_LINES][];
        this.emptylines = this.MAX_LINES;
    }

    public String getBuffer() {
        int n;
        String string = new String();
        int n2 = n = this.bufindex - this.maxeditlog - 1 < 0 ? 0 : this.bufindex - this.maxeditlog - 1;
        while (n2 < this.bufindex) {
            String[] stringArray = this.scrollbuffer[n2];
            if (stringArray == null) break;
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string2 = stringArray[n3].substring(1);
                if (string2.charAt(0) == ' ' && n3 == 0) {
                    string2 = string2.substring(1);
                }
                string = String.valueOf(string) + string2;
                ++n3;
            }
            string = String.valueOf(string) + "\n";
            ++n2;
        }
        return string;
    }
}

