/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import jmirc.IrcConnection;
import jmirc.Utils;

public class SocketIrc
extends IrcConnection {
    private DataInputStream in;
    private DataOutputStream out;
    private String encoding;
    private String outbuf;
    private boolean pollmode;
    private boolean connected;
    private int bytein;
    private int byteout;

    public SocketIrc(boolean bl, String string) {
        this.encoding = string;
        this.bytein = 0;
        this.byteout = 0;
        this.pollmode = bl;
        this.connected = false;
    }

    public String connect(String string, int n, String string2) {
        String string3 = null;
        try {
            StreamConnection streamConnection = (StreamConnection)Connector.open((String)("socket://" + string + ":" + n), (int)3, (boolean)true);
            this.in = streamConnection.openDataInputStream();
            this.out = streamConnection.openDataOutputStream();
            this.outbuf = null;
            this.connected = true;
            string3 = this.writeData(string2);
        }
        catch (Exception exception) {
            string3 = "Error trying to connect to IRC server, aborting... ";
            string3 = String.valueOf(string3) + "Exception: " + exception.getMessage();
            return string3;
        }
        return null;
    }

    public void disconnect() {
        if (this.connected) {
            try {
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
                if (this.in != null) {
                    this.in.close();
                }
                this.connected = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String updateConnection() {
        if (this.outbuf != null && this.connected) {
            try {
                byte[] byArray = this.stringToByteArray(this.outbuf, this.encoding);
                ((OutputStream)this.out).write(byArray);
                this.out.flush();
                this.byteout += byArray.length;
                this.outbuf = null;
            }
            catch (Exception exception) {
                String string = "Error reading/writing to IRC socket, aborting... ";
                string = String.valueOf(string) + "Exception: " + exception.getMessage();
                this.connected = false;
                return string;
            }
        }
        return null;
    }

    public String readLine() {
        byte[] byArray;
        String string;
        block3: {
            string = null;
            byArray = Utils.readLine(this.in);
            if (byArray != null) break block3;
            return null;
        }
        try {
            this.bytein += byArray.length + 40;
            string = this.byteArrayToString(byArray, this.encoding);
        }
        catch (Exception exception) {
            this.connected = false;
        }
        return string;
    }

    public String writeData(String string) {
        this.outbuf = this.outbuf == null ? string : String.valueOf(this.outbuf) + string;
        return this.updateConnection();
    }

    public boolean hasDataInBuffer() {
        if (this.pollmode) {
            try {
                return this.in.available() > 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getBytesIn() {
        return this.bytein;
    }

    public int getBytesOut() {
        return this.byteout;
    }
}

