/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Ticker;
import jmirc.Database;
import jmirc.IrcConnection;
import jmirc.UIHandler;
import jmirc.Utils;
import jmirc.Window;
import jmirc.jmIrc;

public class Listener
extends Thread {
    private IrcConnection irc;
    private UIHandler uihandler;
    private Hashtable whois;
    private boolean needupdate;
    private boolean nicktried;
    private boolean pollmode;
    private boolean showinput;
    private String sTick;
    private Ticker Tick;
    private String altnick;
    private String host;
    private String password;
    private String username;
    private String realname;
    private int port;
    private int polltime;
    private String[] channels;

    public Listener(Database database, IrcConnection ircConnection, UIHandler uIHandler) {
        this.irc = ircConnection;
        this.uihandler = uIHandler;
        this.sTick = new String("not connected...");
        this.Tick = new Ticker(this.sTick);
        if (database.ticker) {
            uIHandler.getConsole().setTicker(this.Tick);
        }
        this.altnick = database.altnick;
        this.host = database.host;
        this.password = database.passwd;
        this.username = database.username;
        this.realname = database.realname;
        this.port = database.port;
        if (database.usehttp) {
            this.pollmode = false;
            uIHandler.getConsole().writeInfo("using HTTP proxy server to connect");
        } else {
            this.pollmode = database.usepoll;
        }
        this.polltime = database.polltime;
        this.showinput = database.showinput;
        this.channels = database.getChannels();
        this.whois = new Hashtable();
        this.needupdate = false;
        this.nicktried = false;
    }

    public void run() {
        String string;
        String string2 = "";
        String string3 = this.host;
        int n = this.port;
        this.uihandler.getConsole().writeInfo("connecting to " + string3 + " at port " + n);
        String string4 = this.uihandler.nick.equals("") ? "jmIrc_usr" : this.uihandler.nick;
        String string5 = this.username.equals("") ? string4 : this.username;
        String string6 = string = this.realname.equals("") ? "jmIrc user" : this.realname;
        if (!Utils.hasNoValue(this.password)) {
            string2 = String.valueOf(string2) + "PASS " + this.password + "\r\n";
        }
        string2 = String.valueOf(string2) + "NICK " + string4 + "\r\n";
        String string7 = this.irc.connect(string3, n, string2 = String.valueOf(string2) + "USER " + string5 + " 8 * :" + string + "\r\n");
        if (string7 == null) {
            this.listen();
        } else {
            this.uihandler.getConsole().writeInfo(string7);
        }
        this.uihandler.clearChanPriv();
    }

    private void listen() {
        String string = null;
        this.sTick = "In: " + String.valueOf(this.irc.getBytesIn()) + " - Out: " + String.valueOf(this.irc.getBytesOut());
        this.Tick.setString(this.sTick);
        int n = 0;
        int n2 = 0;
        while (this.irc.isConnected()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
            if (n2 >= 29) {
                n2 = 0;
                this.sTick = "In: " + String.valueOf(this.irc.getBytesIn()) + " - Out: " + String.valueOf(this.irc.getBytesOut());
                this.Tick.setString(this.sTick);
            }
            if (n >= this.polltime * 2 && this.polltime != 0) {
                this.needupdate = true;
            }
            if (this.needupdate || this.pollmode) {
                string = this.irc.updateConnection();
                this.needupdate = false;
                n = 0;
            }
            if (string == null) {
                while (this.irc.hasDataInBuffer()) {
                    String string2 = this.irc.readLine();
                    if (string2 == null || (string2 = Utils.trim(string2)).equals("")) continue;
                    this.checkMessage(string2);
                }
            }
            if (string == null) continue;
            this.uihandler.getConsole().writeInfo(string);
            string = null;
        }
        this.uihandler.getConsole().writeInfo("Disconnected from server");
    }

    private void checkMessage(String string) {
        block99: {
            try {
                int n;
                if (string.indexOf("ERROR ") == 0) {
                    this.uihandler.getConsole().writeInfo(string);
                    this.irc.disconnect();
                    return;
                }
                String[] stringArray = this.parseLine(string);
                if (stringArray[1] == null) {
                    return;
                }
                String[] stringArray2 = Utils.splitString(stringArray[1], " ");
                if (stringArray2[0].equals("PING")) {
                    jmIrc.writeLine("PONG" + string.substring(4));
                    return;
                }
                if (stringArray[0] == null) {
                    return;
                }
                String string2 = stringArray[0].indexOf(33) >= 0 ? stringArray[0].substring(0, stringArray[0].indexOf(33)) : stringArray[0];
                String string3 = stringArray[2] == null ? "" : (stringArray[2].indexOf(" ") != -1 ? stringArray[2].substring(0, stringArray[2].indexOf(" ")) : stringArray[2]);
                try {
                    n = Integer.parseInt(stringArray2[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (n == 0) {
                    if (stringArray2[0].equals("MODE")) {
                        String string4 = "beIqd,k";
                        String string5 = "lfJ";
                        if (Utils.isChannel(stringArray2[1])) {
                            String string6;
                            String[] stringArray3 = new String[3];
                            int n2 = 0;
                            boolean bl = true;
                            Window window = this.uihandler.getChannel(stringArray2[1]);
                            if (stringArray2.length >= 3) {
                                stringArray3[2] = stringArray2.length == 5 ? stringArray[2] : null;
                                stringArray3[1] = stringArray2.length == 5 ? stringArray2[4] : null;
                                stringArray3[1] = stringArray2.length == 4 ? stringArray[2] : stringArray3[1];
                                stringArray3[0] = stringArray2.length >= 4 ? stringArray2[3] : stringArray[2];
                                string6 = stringArray2[2];
                            } else {
                                string6 = stringArray[2];
                            }
                            int n3 = 0;
                            while (n3 < string6.length()) {
                                char c = string6.charAt(n3);
                                switch (c) {
                                    case '+': {
                                        bl = true;
                                        break;
                                    }
                                    case '-': {
                                        bl = false;
                                        break;
                                    }
                                    case 'o': {
                                        if (stringArray3[n2] == null) break;
                                        window.changeNickMode('\u0004', stringArray3[n2], bl);
                                        ++n2;
                                        break;
                                    }
                                    case 'h': {
                                        if (stringArray3[n2] == null) break;
                                        window.changeNickMode('\u0002', stringArray3[n2], bl);
                                        ++n2;
                                        break;
                                    }
                                    case 'v': {
                                        if (stringArray3[n2] == null) break;
                                        window.changeNickMode('\u0001', stringArray3[n2], bl);
                                        ++n2;
                                        break;
                                    }
                                    default: {
                                        window.changeChanMode(c, bl);
                                        if (string4.indexOf("" + c) < 0 && (string5.indexOf("" + c) < 0 || !bl)) break;
                                        ++n2;
                                    }
                                }
                                if (n2 > 2) break;
                                ++n3;
                            }
                            String string7 = "* " + string2 + " changed mode: '" + string6 + "' ";
                            n3 = 0;
                            while (n3 < 3 && stringArray3[n3] != null) {
                                string7 = String.valueOf(string7) + " " + stringArray3[n3];
                                ++n3;
                            }
                            window.writeAction(string7);
                        }
                        break block99;
                    }
                    if (stringArray2[0].equals("PRIVMSG")) {
                        char c = stringArray2[1].charAt(0);
                        if (stringArray[2].indexOf(1) != -1) {
                            int n4;
                            int n5 = -1;
                            while ((n4 = stringArray[2].indexOf(1, n5 + 1)) != -1) {
                                n5 = stringArray[2].indexOf(1, n4 + 1);
                                if (n5 != -1) {
                                    String string8;
                                    String string9 = stringArray[2].substring(n4 + 1, n5);
                                    if (string9.indexOf(32) != -1) {
                                        string8 = string9.substring(0, string9.indexOf(32)).toUpperCase();
                                        string9 = string9.substring(string9.indexOf(32));
                                    } else {
                                        string8 = string9.toUpperCase();
                                        string9 = "";
                                    }
                                    if (string8.equals("ACTION")) {
                                        if (c == '#' || c == '&' || c == '!') {
                                            this.uihandler.getChannel(stringArray2[1]).writeAction("* " + string2 + " " + string9);
                                            continue;
                                        }
                                        this.uihandler.getPrivate(string2).writeAction("* " + string2 + " " + string9);
                                        continue;
                                    }
                                    if (string8.equals("PING")) {
                                        jmIrc.writeLine("NOTICE " + string2 + " :\u0001PING" + string9 + "\u0001");
                                        continue;
                                    }
                                    if (string8.equals("VERSION")) {
                                        String string10 = System.getProperty("microedition.platform");
                                        if (string10 == null) {
                                            string10 = "J2ME device";
                                        }
                                        jmIrc.writeLine("NOTICE " + string2 + " :\u0001VERSION jmIrc v" + "0.95.9" + " on " + string10 + "\u0001");
                                        continue;
                                    }
                                    this.uihandler.getConsole().writeInfo("* Requested unknown CTCP '" + string8 + "' from " + string2 + ":" + string9);
                                    continue;
                                }
                                break block99;
                            }
                            break block99;
                        }
                        if (c == '#' || c == '&' || c == '!') {
                            this.uihandler.getChannel(stringArray2[1]).write(string2, stringArray[2]);
                        } else {
                            this.uihandler.getPrivate(string2).write(string2, stringArray[2]);
                        }
                        break block99;
                    }
                    if (stringArray2[0].equals("NOTICE")) {
                        this.uihandler.getConsole().writeAction("-" + string2 + "- " + stringArray[2]);
                    } else if (stringArray2[0].equals("NICK")) {
                        String string11;
                        if (string2.equals(this.uihandler.nick)) {
                            string11 = "You're now known as " + string3;
                            this.uihandler.nick = string3;
                        } else {
                            string11 = String.valueOf(string2) + " is now known as " + string3;
                        }
                        Hashtable hashtable = this.uihandler.getChannels();
                        Enumeration enumeration = hashtable.elements();
                        while (enumeration.hasMoreElements()) {
                            Window window = (Window)((Object)enumeration.nextElement());
                            if (!window.hasNick(string2)) continue;
                            window.writeInfo(string11);
                            window.changeNick(string2, string3);
                        }
                    } else if (stringArray2[0].equals("QUIT")) {
                        Hashtable hashtable = this.uihandler.getChannels();
                        Enumeration enumeration = hashtable.elements();
                        while (enumeration.hasMoreElements()) {
                            Window window = (Window)((Object)enumeration.nextElement());
                            if (!window.hasNick(string2)) continue;
                            window.writeInfo(String.valueOf(string2) + " has quit irc (" + stringArray[2] + ")");
                            window.deleteNick(string2);
                        }
                    } else if (stringArray2[0].equals("INVITE")) {
                        this.uihandler.getConsole().writeAction("* You have been invited to " + stringArray[2]);
                    } else if (stringArray2[0].equals("JOIN")) {
                        Window window = this.uihandler.getChannel(string3);
                        window.writeInfo(String.valueOf(string2) + " has joined " + string3);
                        if (!string2.equals(this.uihandler.nick)) {
                            window.addNick('\u0000', string2);
                        }
                    } else if (stringArray2[0].equals("PART")) {
                        if (!string2.equals(this.uihandler.nick)) {
                            Window window;
                            if (stringArray2.length == 1) {
                                window = this.uihandler.getChannel(stringArray[2]);
                                window.writeInfo(String.valueOf(string2) + " has left " + stringArray[2]);
                            } else {
                                window = this.uihandler.getChannel(stringArray2[1]);
                                window.writeInfo(String.valueOf(string2) + " has left " + stringArray2[1] + " (" + stringArray[2] + ")");
                            }
                            window.deleteNick(string2);
                        } else if (stringArray2.length == 1) {
                            this.uihandler.getChannel(stringArray[2]).close();
                        } else {
                            this.uihandler.getChannel(stringArray2[1]).close();
                        }
                    } else if (stringArray2[0].equals("KICK")) {
                        if (stringArray2[2].equals(this.uihandler.nick)) {
                            this.uihandler.getConsole().writeInfo("You were kicked from " + stringArray2[1] + " by " + string2 + "(" + stringArray[2] + ")");
                            this.uihandler.getChannel(stringArray2[1]).close();
                        } else {
                            Window window = this.uihandler.getChannel(stringArray2[1]);
                            window.writeInfo(String.valueOf(stringArray2[2]) + " was kicked by " + string2 + "(" + stringArray[2] + ")");
                            window.deleteNick(stringArray2[2]);
                        }
                    } else if (stringArray2[0].equals("TOPIC")) {
                        Window window = this.uihandler.getChannel(stringArray2[1]);
                        window.writeInfo(String.valueOf(string2) + " changed topic to '" + stringArray[2] + "'");
                    } else if (this.showinput) {
                        this.uihandler.getConsole().writeAction("-" + string);
                    }
                    break block99;
                }
                switch (n) {
                    case 1: {
                        this.uihandler.getConsole().writeInfo("Connected to server, joining channels");
                        String[] stringArray4 = this.channels;
                        if (stringArray4 != null) {
                            int n6 = 0;
                            while (n6 < stringArray4.length) {
                                jmIrc.writeLine("JOIN " + stringArray4[n6].trim());
                                jmIrc.writeLine("MODE " + stringArray4[n6].trim());
                                ++n6;
                            }
                        }
                        this.needupdate = true;
                        break;
                    }
                    case 301: {
                        this.uihandler.getConsole().writeAction("* " + stringArray2[2] + " is marked as away: " + stringArray[2]);
                        break;
                    }
                    case 305: 
                    case 306: {
                        this.uihandler.getConsole().writeAction("* " + stringArray[2]);
                        break;
                    }
                    case 311: 
                    case 314: {
                        String string12 = "Nick: " + stringArray2[2] + "\n";
                        string12 = String.valueOf(string12) + "Name: " + stringArray[2] + "\n";
                        string12 = String.valueOf(string12) + "Address: " + stringArray2[3] + "@" + stringArray2[4] + "\n";
                        this.addWhois(stringArray2[2].toUpperCase(), string12);
                        break;
                    }
                    case 312: {
                        this.addWhois(stringArray2[2].toUpperCase(), "Server: " + stringArray[2] + "\n");
                        break;
                    }
                    case 317: {
                        this.addWhois(stringArray2[2].toUpperCase(), "Idle: " + this.parseTime(stringArray2[3]) + " \n");
                        break;
                    }
                    case 318: 
                    case 369: {
                        Alert alert = new Alert("Whois", (String)this.whois.get(stringArray2[2].toUpperCase()), null, AlertType.INFO);
                        this.whois.remove(stringArray2[2].toUpperCase());
                        alert.setTimeout(-2);
                        this.uihandler.setDisplay((Displayable)alert);
                        break;
                    }
                    case 319: {
                        this.addWhois(stringArray2[2], "Channels: " + stringArray[2] + "\n");
                        break;
                    }
                    case 321: 
                    case 322: 
                    case 323: {
                        break;
                    }
                    case 324: {
                        Window window = this.uihandler.getChannel(stringArray2[2]);
                        String string13 = stringArray2.length > 3 ? stringArray2[3] : stringArray[2];
                        if (string13.charAt(0) == '+') {
                            window.setChanModes(string13.substring(1));
                        }
                        break;
                    }
                    case 331: {
                        this.uihandler.getChannel(stringArray2[2]).writeInfo("Channel has no topic");
                        break;
                    }
                    case 332: {
                        this.uihandler.getChannel(stringArray2[2]).writeInfo("Topic is '" + stringArray[2] + "'");
                        break;
                    }
                    case 333: {
                        String string14 = "";
                        string14 = String.valueOf(string14) + "Topic set by '" + stringArray2[3].substring(0, stringArray2[3].indexOf(33)) + "'";
                        string14 = String.valueOf(string14) + " on " + Utils.formatDateMillis(Long.parseLong(stringArray[2]) * 1000L);
                        this.uihandler.getChannel(stringArray2[2]).writeInfo(string14);
                        break;
                    }
                    case 341: {
                        if (stringArray2.length == 3) {
                            this.uihandler.getConsole().writeAction("* Inviting " + stringArray2[2] + " to " + stringArray[2]);
                        }
                        break;
                    }
                    case 315: 
                    case 342: 
                    case 351: 
                    case 352: {
                        break;
                    }
                    case 353: {
                        Window window = this.uihandler.getChannel(stringArray2[3]);
                        String[] stringArray5 = Utils.splitString(stringArray[2].trim(), " ");
                        int n7 = 0;
                        while (n7 < stringArray5.length) {
                            char c = '\u0000';
                            if (stringArray5[n7].charAt(0) == '@') {
                                c = '\u0004';
                            }
                            if (stringArray5[n7].charAt(0) == '+') {
                                c = '\u0001';
                            }
                            String string15 = c != '\u0000' ? stringArray5[n7].substring(1) : stringArray5[n7];
                            window.addNick(c, string15);
                            ++n7;
                        }
                        break;
                    }
                    case 366: {
                        this.uihandler.getChannel(stringArray2[2]).printNicks();
                        break;
                    }
                    case 367: 
                    case 368: {
                        break;
                    }
                    case 371: 
                    case 374: {
                        this.uihandler.getConsole().writeInfo(stringArray[2]);
                        break;
                    }
                    case 372: 
                    case 375: 
                    case 376: {
                        break;
                    }
                    case 381: 
                    case 382: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: {
                        break;
                    }
                    case 431: 
                    case 432: 
                    case 433: {
                        if (!this.nicktried && !this.altnick.trim().equals("")) {
                            this.uihandler.getConsole().writeInfo("Nickname in use, trying '" + this.altnick + "'");
                            jmIrc.writeLine("NICK " + this.altnick);
                            this.uihandler.nick = this.altnick;
                            this.nicktried = true;
                            break;
                        }
                        Window window = this.uihandler.getConsole();
                        window.nickChangeAction();
                        break;
                    }
                    case 471: 
                    case 473: 
                    case 474: 
                    case 475: {
                        this.uihandler.getConsole().writeInfo(String.valueOf(stringArray[2]) + " joining " + stringArray2[2]);
                        break;
                    }
                    default: {
                        if (this.showinput) {
                            this.uihandler.getConsole().writeAction("-" + string);
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setNeedUpdate(boolean bl) {
        this.needupdate = bl;
    }

    private void addWhois(String string, String string2) {
        String string3 = (String)this.whois.get(string);
        string3 = string3 != null ? String.valueOf(string3) + string2 : string2;
        this.whois.put(string, string3);
    }

    private String[] parseLine(String string) {
        int n;
        String[] stringArray = new String[3];
        if (string.charAt(0) == ':') {
            stringArray[0] = string.substring(1, string.indexOf(32));
            n = string.indexOf(" ") + 1;
        } else {
            stringArray[0] = null;
            n = 0;
        }
        int n2 = string.indexOf(":", n);
        if (n2 != -1) {
            stringArray[1] = string.substring(n, n2);
            stringArray[2] = string.substring(n2 + 1);
        } else {
            n2 = string.lastIndexOf(32);
            if (n2 != -1) {
                stringArray[1] = string.substring(n, n2);
                stringArray[2] = string.substring(n2 + 1);
            } else {
                stringArray[1] = string.substring(n);
                stringArray[2] = null;
            }
        }
        return stringArray;
    }

    private String parseTime(String string) {
        String string2 = "";
        try {
            int n = Integer.parseInt(string);
            int n2 = n / 86400;
            int n3 = (n -= n2 * 86400) / 3600;
            int n4 = (n -= n3 * 3600) / 60;
            string2 = new String(String.valueOf(n2) + "d " + n3 + "h " + n4 + "m " + (n -= n4 * 60) + "s");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string2;
    }
}

