/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import java.io.ByteArrayOutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public abstract class IrcConnection {
    protected char[] koi8rmap = "\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c\u2580\u2584\u2588\u258c\u2590\u2591\u2592\u2593\u2320\u25a0\u2219\u221a\u2248\u2264\u2265\u00a0\u2321\u00b0\u00b2\u00b7\u00f7\u2550\u2551\u2552\u0451\u2553\u2554\u2555\u2556\u2557\u2558\u2559\u255a\u255b\u255c\u255d\u255e\u255f\u2560\u2561\u0401\u2562\u2563\u2564\u2565\u2566\u2567\u2568\u2569\u256a\u256b\u256c\u00a9\u044e\u0430\u0431\u0446\u0434\u0435\u0444\u0433\u0445\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u044f\u0440\u0441\u0442\u0443\u0436\u0432\u044c\u044b\u0437\u0448\u044d\u0449\u0447\u044a\u042e\u0410\u0411\u0426\u0414\u0415\u0424\u0413\u0425\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u042f\u0420\u0421\u0422\u0423\u0416\u0412\u042c\u042b\u0417\u0428\u042d\u0429\u0427\u042a".toCharArray();
    protected char[] cp1251map = "\u0402\u0403\u201a\u0453\u201e\u2026\u2020\u2021\u20ac\u2030\u0409\u2039\u040a\u040c\u040b\u040f\u0452\u2018\u2019\u201c\u201d\u2022\u2013\u2014\ufffd\u2122\u0459\u203a\u045a\u045c\u045b\u045f\u00a0\u040e\u045e\u0408\u00a4\u0490\u00a6\u00a7\u0401\u00a9\u0404\u00ab\u00ac\u00ad\u00ae\u0407\u00b0\u00b1\u0406\u0456\u0491\u00b5\u00b6\u00b7\u0451\u2116\u0454\u00bb\u0458\u0405\u0455\u0457\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f".toCharArray();
    protected char[] cp1255map = "\u02ac\ufffd\u201a\u0192\u201e\u2026\u2020\u2021\u02c6\u2030\ufffd\u2039\ufffd\ufffd\ufffd\ufffd\ufffd\u2018\u2019\u201c\u201d\u2022\u2013\u2014\u02dc\u2122\ufffd\u203a\ufffd\ufffd\ufffd\ufffd\u00a0\u00a1\u00a2\u00a3\u20aa\u00a5\u00a6\u00a7\u00a8\u00a9\u00d7\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00f7\u00bb\u00bc\u00bd\u00be\u00bf\u05b0\u05b1\u05b2\u05b3\u05b4\u05b5\u05b6\u05b7\u05b8\u05b9\ufffd\u05bb\u05bc\u05bd\u05be\u05bf\u05c0\u05c1\u05c2\u05c3\u05f0\u05f1\u05f2\u05f3\u05f4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05da\u05db\u05dc\u05dd\u05de\u05df\u05e0\u05e1\u05e2\u05e3\u05e4\u05e5\u05e6\u05e7\u05e8\u05e9\u05ea\ufffd\ufffd\u200e\u200f\ufffd".toCharArray();
    protected Hashtable hashmap = null;
    private boolean utf8detect = false;
    private boolean utf8output = false;

    public abstract String connect(String var1, int var2, String var3);

    public abstract void disconnect();

    public abstract String updateConnection();

    public abstract String readLine();

    public abstract String writeData(String var1);

    public abstract boolean hasDataInBuffer();

    public abstract boolean isConnected();

    public abstract int getBytesIn();

    public abstract int getBytesOut();

    IrcConnection() {
    }

    public void setUnicodeMode(boolean bl, boolean bl2) {
        this.utf8detect = bl;
        this.utf8output = bl2;
    }

    protected String byteArrayToString(byte[] byArray, String string) {
        String string2;
        char[] cArray = null;
        if (this.utf8detect) {
            if (string.equals("UTF-8")) {
                string = "ISO-8859-1";
            }
            try {
                String string3 = this.decodeUTF8(byArray, false);
                return string3;
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                // empty catch block
            }
        }
        if (string.equals("KOI8-R")) {
            cArray = this.koi8rmap;
        } else if (string.equals("Windows-1251")) {
            cArray = this.cp1251map;
        } else if (string.equals("Windows-1255")) {
            cArray = this.cp1255map;
        }
        if (cArray != null) {
            char[] cArray2 = new char[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                byte by = byArray[n];
                cArray2[n] = by >= 0 ? (char)by : cArray[by + 128];
                ++n;
            }
            string2 = new String(cArray2);
        } else if (string.equals("UTF-8")) {
            try {
                string2 = this.decodeUTF8(byArray, true);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                string2 = new String(byArray);
            }
        } else {
            try {
                string2 = new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = new String(byArray);
            }
        }
        return string2;
    }

    protected byte[] stringToByteArray(String string, String string2) {
        byte[] byArray;
        if (this.utf8output) {
            string2 = "UTF-8";
        }
        if (string2.equals("KOI8-R") || string2.equals("Windows-1251") || string2.equals("Windows-1255")) {
            if (this.hashmap == null || !string2.equals((String)this.hashmap.get("encoding"))) {
                if (string2.equals("KOI8-R")) {
                    this.hashmap = this.generateHashmap(this.koi8rmap);
                } else if (string2.equals("Windows-1251")) {
                    this.hashmap = this.generateHashmap(this.cp1251map);
                } else if (string2.equals("Windows-1255")) {
                    this.hashmap = this.generateHashmap(this.cp1255map);
                }
                this.hashmap.put("encoding", string2);
            }
            char[] cArray = string.toCharArray();
            byte[] byArray2 = new byte[cArray.length];
            int n = 0;
            while (n < cArray.length) {
                Byte by;
                byArray2[n] = cArray[n] < '\u0080' ? (int)cArray[n] : ((by = (Byte)this.hashmap.get(new Character(cArray[n]))) == null ? 63 : (int)by.byteValue());
                ++n;
            }
            byArray = byArray2;
        } else if (string2.equals("UTF-8")) {
            byArray = this.encodeUTF8(string);
        } else {
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
        }
        return byArray;
    }

    private Hashtable generateHashmap(char[] cArray) {
        Hashtable<Character, Byte> hashtable = new Hashtable<Character, Byte>();
        int n = 0;
        while (n < cArray.length) {
            hashtable.put(new Character(cArray[n]), new Byte((byte)(128 + n)));
            ++n;
        }
        return hashtable;
    }

    private byte[] encodeUTF8(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\u0000' && c < '\u0080') {
                byteArrayOutputStream.write(c);
            } else if (c == '\u0000' || c >= '\u0080' && c < '\u0800') {
                byteArrayOutputStream.write((byte)(0xC0 | 0x1F & c >> 6));
                byteArrayOutputStream.write((byte)(0x80 | 0x3F & c));
            } else {
                byteArrayOutputStream.write((byte)(0xE0 | 0xF & c >> 12));
                byteArrayOutputStream.write((byte)(0x80 | 0x3F & c >> 6));
                byteArrayOutputStream.write((byte)(0x80 | 0x3F & c));
            }
            ++n;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String decodeUTF8(byte[] byArray, boolean bl) throws UTFDataFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            try {
                byte by;
                byte by2 = byArray[n];
                if ((by2 & 0x80) == 0) {
                    stringBuffer.append((char)by2);
                } else if ((by2 & 0xE0) == 192) {
                    by = byArray[n + 1];
                    if ((by & 0xC0) != 128) throw new UTFDataFormatException("Illegal 2-byte group");
                    stringBuffer.append((char)((by2 & 0x1F) << 6 | by & 0x3F));
                    ++n;
                } else if ((by2 & 0xF0) == 224) {
                    by = byArray[n + 1];
                    byte by3 = byArray[n + 2];
                    if ((by & 0xC0) != 128 || (by3 & 0xC0) != 128) throw new UTFDataFormatException("Illegal 3-byte group");
                    stringBuffer.append((char)((by2 & 0xF) << 12 | (by & 0x3F) << 6 | by3 & 0x3F));
                    n += 2;
                } else if ((by2 & 0xF0) == 240 || (by2 & 0xC0) == 128) {
                    throw new UTFDataFormatException("Illegal first byte of a group");
                }
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                if (!bl) throw uTFDataFormatException;
                stringBuffer.append("?");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!bl) throw new UTFDataFormatException("Unexpected EOF");
                stringBuffer.append("?");
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

