/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import jmirc.IrcConnection;
import jmirc.Utils;

public class HttpIrc
extends IrcConnection {
    private Vector inqueue;
    private String encoding;
    private String identifier;
    private String gwhost;
    private String gwpasswd;
    private String outbuf;
    private int gwport;
    private boolean connected;
    private boolean closeconn;
    private int bytein;
    private int byteout;

    public HttpIrc(String string, int n, String string2, String string3) {
        this.gwhost = string;
        this.gwport = n;
        this.gwpasswd = string2;
        this.encoding = string3;
        this.inqueue = new Vector();
        this.outbuf = null;
        this.bytein = 0;
        this.byteout = 0;
        this.closeconn = false;
        this.connected = false;
        this.identifier = "";
    }

    public String connect(String string, int n, String string2) {
        int n2;
        HttpConnection httpConnection = null;
        String string3 = "";
        String string4 = "http://" + this.gwhost + ":" + this.gwport + "/connect?host=" + Utils.URLEncode(string.getBytes()) + "&port=" + Utils.URLEncode(("" + n).getBytes()) + "&passwd=" + Utils.URLEncode(this.gwpasswd.getBytes()) + "&data=" + Utils.URLEncode(this.stringToByteArray(string2, this.encoding));
        try {
            httpConnection = (HttpConnection)Connector.open((String)string4, (int)3, (boolean)true);
            httpConnection.setRequestMethod("GET");
            n2 = httpConnection.getResponseCode();
            this.identifier = httpConnection.getHeaderField("X-Identifier");
            if (httpConnection != null) {
                httpConnection.close();
            }
        }
        catch (Exception exception) {
            string3 = String.valueOf(string3) + "Error trying to connect to HTTP proxy server, aborting... ";
            string3 = String.valueOf(string3) + "Exception: " + exception.getMessage();
            return string3;
        }
        if (n2 != 200) {
            string3 = String.valueOf(string3) + "Error trying to connect to IRC server, reason: ";
            switch (n2) {
                case 403: {
                    string3 = String.valueOf(string3) + "Wrong password";
                    break;
                }
                case 502: {
                    string3 = String.valueOf(string3) + "Bad gateway";
                    break;
                }
                case 404: {
                    string3 = String.valueOf(string3) + "IRC connection not found";
                    break;
                }
                default: {
                    string3 = String.valueOf(string3) + "HTTP response code: " + n2;
                }
            }
            return string3;
        }
        this.connected = true;
        return null;
    }

    public void disconnect() {
        if (this.connected) {
            this.closeconn = true;
        }
    }

    public String readLine() {
        String string;
        if (this.inqueue.size() > 0) {
            string = (String)this.inqueue.firstElement();
            this.inqueue.removeElementAt(0);
        } else {
            string = "";
        }
        return string;
    }

    public String updateConnection() {
        String string = "http://" + this.gwhost + ":" + this.gwport + "/" + this.identifier;
        if (this.outbuf != null) {
            string = String.valueOf(string) + "?data=" + Utils.URLEncode(this.stringToByteArray(this.outbuf, this.encoding));
            this.byteout += string.getBytes().length;
            this.outbuf = null;
        }
        String string2 = this.handleRequest(string, true);
        if (this.closeconn) {
            this.connected = false;
        }
        return string2;
    }

    public String writeData(String string) {
        this.outbuf = this.outbuf == null ? string : String.valueOf(this.outbuf) + string;
        return null;
    }

    private String handleRequest(String string, boolean bl) {
        int n;
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        String string2 = "";
        try {
            httpConnection = (HttpConnection)Connector.open((String)string);
            if (bl) {
                httpConnection.setRequestMethod("GET");
            } else {
                httpConnection.setRequestMethod("HEAD");
            }
            n = httpConnection.getResponseCode();
            if (bl) {
                inputStream = httpConnection.openInputStream();
                int n2 = (int)httpConnection.getLength();
                if (n2 > 0) {
                    byte[] byArray = new byte[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        byArray[n3] = (byte)inputStream.read();
                        ++n3;
                    }
                    this.bytein += byArray.length;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    while (byteArrayInputStream.available() > 0) {
                        byte[] byArray2 = Utils.readLine(byteArrayInputStream);
                        if (byArray2 == null) continue;
                        String string3 = this.byteArrayToString(byArray2, this.encoding);
                        this.inqueue.addElement(string3);
                    }
                }
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
        }
        catch (Exception exception) {
            string2 = String.valueOf(string2) + "Request failed, continuing...";
            return string2;
        }
        if (n != 200) {
            if (n != 404) {
                string2 = String.valueOf(string2) + "Error in connection to IRC server, aborting... ";
                string2 = String.valueOf(string2) + "Error: HTTP response code: " + n;
            }
            this.connected = false;
            return string2;
        }
        return null;
    }

    public boolean hasDataInBuffer() {
        return this.inqueue.size() != 0;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getBytesIn() {
        return this.bytein;
    }

    public int getBytesOut() {
        return this.byteout;
    }
}

