/*
 * Decompiled with CFR 0.152.
 */
package jmirc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;
import jmirc.Utils;

public class Database {
    String profilename;
    String nick;
    String altnick;
    String host;
    int port;
    String channels;
    String username;
    String realname;
    String passwd;
    int[] idxarray;
    int profileidx = -1;
    boolean usepoll = false;
    boolean showinput = false;
    String encoding = "ISO-8859-1";
    boolean utf8detect = true;
    boolean utf8output = false;
    String hilight = "";
    int buflines = 300;
    int maxeditlog = 10;
    boolean almOnHigh = true;
    boolean almOnPrv = true;
    boolean vbrOnHigh = true;
    boolean vbrOnPrv = true;
    boolean vbrOnChn = false;
    int vbrDuration = 500;
    boolean ticker = true;
    boolean header = true;
    boolean timestamp = false;
    boolean usecolor = true;
    boolean usemirccol = false;
    int fontsize = 0;
    boolean usehttp = false;
    String gwhost = "";
    int gwport = 8080;
    String gwpasswd = "";
    int polltime = 10;
    private static final String STORE_CONFIG = "jmirccfg";
    private static final String STORE_PROFILE = "jmircprof";

    public void load() {
        try {
            String string;
            byte[] byArray;
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
            int n = recordStore.getNumRecords();
            try {
                byArray = recordStore.getRecord(1);
                string = new DataInputStream(new ByteArrayInputStream(byArray)).readUTF();
            }
            catch (Exception exception) {
                string = "";
            }
            if (!string.equals("0.95.9")) {
                recordStore.closeRecordStore();
                try {
                    RecordStore.deleteRecordStore((String)STORE_CONFIG);
                    RecordStore.deleteRecordStore((String)STORE_PROFILE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeUTF("0.95.9");
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                recordStore.addRecord(byArray, 0, byArray.length);
                byArray = new byte[]{};
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray, 0, byArray.length);
                this.save_profile();
                this.save_advanced();
                this.save_interface();
                this.save_http();
            } else {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(2)));
                this.profileidx = dataInputStream.readInt();
                dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(3)));
                this.usepoll = dataInputStream.readBoolean();
                this.showinput = dataInputStream.readBoolean();
                this.encoding = dataInputStream.readUTF();
                this.utf8detect = dataInputStream.readBoolean();
                this.utf8output = dataInputStream.readBoolean();
                this.buflines = dataInputStream.readInt();
                this.maxeditlog = dataInputStream.readInt();
                this.hilight = dataInputStream.readUTF();
                this.vbrOnPrv = dataInputStream.readBoolean();
                this.vbrOnChn = dataInputStream.readBoolean();
                this.vbrDuration = dataInputStream.readInt();
                this.ticker = dataInputStream.readBoolean();
                this.almOnHigh = dataInputStream.readBoolean();
                this.vbrOnHigh = dataInputStream.readBoolean();
                this.almOnPrv = dataInputStream.readBoolean();
                dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(4)));
                this.header = dataInputStream.readBoolean();
                this.timestamp = dataInputStream.readBoolean();
                this.usecolor = dataInputStream.readBoolean();
                this.usemirccol = dataInputStream.readBoolean();
                this.fontsize = dataInputStream.readInt();
                dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(5)));
                this.usehttp = dataInputStream.readBoolean();
                this.gwhost = dataInputStream.readUTF();
                this.gwport = dataInputStream.readInt();
                this.gwpasswd = dataInputStream.readUTF();
                this.polltime = dataInputStream.readInt();
                dataInputStream.close();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getProfiles();
        this.setProfile(this.profileidx);
    }

    public String[] getProfiles() {
        String[] stringArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_PROFILE, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(new byte[4], 0, 4);
                this.idxarray = new int[0];
                stringArray = new String[]{};
            } else {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(1)));
                recordStore.closeRecordStore();
                int n = dataInputStream.readInt();
                stringArray = new String[n];
                this.idxarray = new int[n];
                int n2 = 0;
                while (n2 < stringArray.length) {
                    stringArray[n2] = dataInputStream.readUTF();
                    this.idxarray[n2] = dataInputStream.readInt();
                    ++n2;
                }
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    public void setProfile(int n) {
        if (n < 0) {
            this.profilename = "";
            this.nick = "";
            this.altnick = "";
            this.host = "irc.us.ircnet.net";
            this.port = 6667;
            this.channels = "#jmIrc";
            this.username = "";
            this.realname = "jmIrc user";
            this.passwd = "";
        } else if (n < this.idxarray.length) {
            try {
                int n2 = this.idxarray[n];
                RecordStore recordStore = RecordStore.openRecordStore((String)STORE_PROFILE, (boolean)false);
                if (n2 > 0) {
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(n2)));
                    this.profilename = dataInputStream.readUTF();
                    this.nick = dataInputStream.readUTF();
                    this.altnick = dataInputStream.readUTF();
                    this.host = dataInputStream.readUTF();
                    this.port = dataInputStream.readInt();
                    this.channels = dataInputStream.readUTF();
                    this.username = dataInputStream.readUTF();
                    this.realname = dataInputStream.readUTF();
                    this.passwd = dataInputStream.readUTF();
                }
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addProfile() {
        this.editProfile(this.idxarray.length);
    }

    public void editProfile(int n) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_PROFILE, (boolean)false);
            this.editProfileName(recordStore, n, this.profilename);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this.profilename);
            dataOutputStream.writeUTF(this.nick);
            dataOutputStream.writeUTF(this.altnick);
            dataOutputStream.writeUTF(this.host);
            dataOutputStream.writeInt(this.port);
            dataOutputStream.writeUTF(this.channels);
            dataOutputStream.writeUTF(this.username);
            dataOutputStream.writeUTF(this.realname);
            dataOutputStream.writeUTF(this.passwd);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            recordStore.setRecord(this.idxarray[n], byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deleteProfile(int n) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_PROFILE, (boolean)false);
            recordStore.deleteRecord(this.idxarray[n]);
            this.editProfileName(recordStore, n, null);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void editProfileName(RecordStore var1_1, int var2_2, String var3_3) throws Exception {
        var9_4 = false;
        var10_5 = var1_1.getRecord(1);
        var6_6 = new DataInputStream(new ByteArrayInputStream(var10_5));
        var8_7 = new ByteArrayOutputStream();
        var7_8 = new DataOutputStream(var8_7);
        var5_9 = var6_6.readInt();
        if (var3_3 == null && var2_2 >= 0 && var2_2 < var5_9) {
            this.idxarray = new int[--var5_9];
        } else if (var2_2 < 0 || var2_2 >= var5_9) {
            this.idxarray = new int[++var5_9];
            var9_4 = true;
        } else if (var3_3 == null) {
            return;
        }
        var7_8.writeInt(var5_9);
        var4_10 = 0;
        while (var4_10 < var5_9) {
            if (var4_10 == var5_9 - 1 && var9_4) break;
            if (var4_10 != var2_2) ** GOTO lbl32
            if (var3_3 != null) {
                var6_6.readUTF();
                var7_8.writeUTF(var3_3);
                this.idxarray[var4_10] = var6_6.readInt();
                var7_8.writeInt(this.idxarray[var4_10]);
            } else {
                var6_6.readUTF();
                var6_6.readInt();
lbl32:
                // 2 sources

                var7_8.writeUTF(var6_6.readUTF());
                this.idxarray[var4_10] = var6_6.readInt();
                var7_8.writeInt(this.idxarray[var4_10]);
            }
            ++var4_10;
        }
        if (var9_4) {
            var7_8.writeUTF(var3_3);
            this.idxarray[var4_10] = var1_1.getNextRecordID();
            var7_8.writeInt(this.idxarray[var4_10]);
            var1_1.addRecord(new byte[0], 0, 0);
        }
        var10_5 = var8_7.toByteArray();
        var6_6.close();
        var7_8.close();
        var1_1.setRecord(1, var10_5, 0, var10_5.length);
        if (this.profileidx >= this.idxarray.length) {
            this.profileidx = this.idxarray.length - 1;
        }
    }

    public String[] getChannels() {
        return Utils.hasNoValue(this.channels) ? null : Utils.splitString(this.channels, ",");
    }

    public void save_profile() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.profileidx);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
            recordStore.setRecord(2, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save_advanced() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(this.usepoll);
            dataOutputStream.writeBoolean(this.showinput);
            dataOutputStream.writeUTF(this.encoding);
            dataOutputStream.writeBoolean(this.utf8detect);
            dataOutputStream.writeBoolean(this.utf8output);
            dataOutputStream.writeInt(this.buflines);
            dataOutputStream.writeInt(this.maxeditlog);
            dataOutputStream.writeUTF(this.hilight);
            dataOutputStream.writeBoolean(this.vbrOnPrv);
            dataOutputStream.writeBoolean(this.vbrOnChn);
            dataOutputStream.writeInt(this.vbrDuration);
            dataOutputStream.writeBoolean(this.ticker);
            dataOutputStream.writeBoolean(this.almOnHigh);
            dataOutputStream.writeBoolean(this.vbrOnHigh);
            dataOutputStream.writeBoolean(this.almOnPrv);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
            recordStore.setRecord(3, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save_interface() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(this.header);
            dataOutputStream.writeBoolean(this.timestamp);
            dataOutputStream.writeBoolean(this.usecolor);
            dataOutputStream.writeBoolean(this.usemirccol);
            dataOutputStream.writeInt(this.fontsize);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
            recordStore.setRecord(4, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save_http() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(this.usehttp);
            dataOutputStream.writeUTF(this.gwhost);
            dataOutputStream.writeInt(this.gwport);
            dataOutputStream.writeUTF(this.gwpasswd);
            dataOutputStream.writeInt(this.polltime);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_CONFIG, (boolean)true);
            recordStore.setRecord(5, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

