/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.rms.RecordStore;
import wlirc2.Profile;
import wlirc2.Utils;
import wlirc2.WLIrc2;

public class Database {
    protected Vector messages = new Vector();
    protected String gateway = "http://thesverre.servebeer.com/wap/httpgateway";
    public static final int LITTLE_INFO = 0;
    public static final int NORMAL_INFO = 1;
    protected int debug = 1;
    protected int connection = 0;
    protected int polltime = 30;
    protected int font_face = 0;
    protected int font_style = 0;
    protected int font_size = 2;
    protected boolean waitafterdata = true;
    protected String encoding = "";
    protected int maxLinesInWindow = 200;
    protected String userkey = "";
    protected boolean fastconnect = false;
    protected String notifier_PRIV = "";
    protected String notifier_CHAN = "";
    protected String notifier_FRIEND = "";
    protected String bluetoothstring = "";
    protected boolean gui_show_textfield = true;
    protected boolean gui_show_names = true;
    protected boolean gui_light = false;
    protected boolean gui_timestamp = false;
    protected boolean dcc_proxy = true;
    protected String dcc_proxy_server = "thesverre.servebeer.com";
    protected int dcc_proxy_port = 20000;
    protected boolean socket_poll = false;
    protected boolean show_motd = true;
    protected int window_width = -1;
    protected int window_height = -1;
    protected Vector profiles = new Vector();
    private Display display;
    public static final int CON_SOCKET = 0;
    public static final int CON_HTTPPOLL = 1;
    public static final int CON_BLUETOOTH = 2;
    private static final int NUMREC_CONFIG = 27;
    private static final int NUMREC_PROFILE = 10;
    private static final String NAMEOFSTORE = "config";
    public static final int SAVETYPE_CONFIG = 2;
    public static final int SAVETYPE_FAVORITES = 3;
    public static final int SAVETYPE_PROFILE = 4;

    public Database(Display display) {
        this.display = display;
    }

    public boolean load() {
        boolean bl = true;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)NAMEOFSTORE, (boolean)true);
            int n = recordStore.getNumRecords();
            if (n != 4 || !new String(recordStore.getRecord(1)).equals("2.0 Beta 5")) {
                recordStore.closeRecordStore();
                RecordStore.deleteRecordStore((String)NAMEOFSTORE);
                recordStore = RecordStore.openRecordStore((String)NAMEOFSTORE, (boolean)true);
                byte[] byArray = "2.0 Beta 5".getBytes();
                recordStore.addRecord(byArray, 0, byArray.length);
                this.encoding = System.getProperty("microedition.encoding");
                if (this.encoding == null || this.encoding.equals("")) {
                    this.encoding = "ISO-8859-1";
                }
                this.userkey = "";
                Random random = new Random();
                for (int i = 0; i < 2; ++i) {
                    int n2 = Math.abs(random.nextInt() % 25) + 65;
                    this.userkey = this.userkey + String.valueOf((char)n2);
                }
                String[] stringArray = this.setRecStoreConfig();
                byte[] byArray2 = this.getByteArray(stringArray);
                recordStore.addRecord(byArray2, 0, byArray2.length);
                byte[] byArray3 = new ByteArrayOutputStream().toByteArray();
                recordStore.addRecord(byArray3, 0, byArray3.length);
                byArray2 = new byte[21];
                stringArray = new String[10];
                Profile profile = new Profile();
                profile.host = "irc.homelien.no";
                profile.profilename = "EFNet";
                this.profiles.addElement(profile);
                profile = new Profile();
                profile.autoconnect = false;
                profile.profilename = "BitlBee";
                profile.host = "im.bitlbee.org";
                profile.port = 6667;
                profile.startupScript = "NICKSERV identify <password>";
                this.profiles.addElement(profile);
                stringArray = this.setRecStoreProfile();
                byArray2 = this.getByteArray(stringArray);
                recordStore.addRecord(byArray2, 0, byArray2.length);
            } else {
                String[] stringArray = new String[27];
                bl = false;
                String string = new String(recordStore.getRecord(2));
                stringArray = Utils.splitString(string, String.valueOf('\u0000'));
                this.gateway = this.getRecordString(stringArray, 0);
                this.debug = this.getRecordInt(stringArray, 1);
                this.connection = this.getRecordInt(stringArray, 2);
                this.polltime = this.getRecordInt(stringArray, 3);
                this.font_face = this.getRecordInt(stringArray, 4);
                this.font_style = this.getRecordInt(stringArray, 5);
                this.font_size = this.getRecordInt(stringArray, 6);
                this.waitafterdata = this.getRecordBoolean(stringArray, 7);
                this.encoding = this.getRecordString(stringArray, 8);
                this.maxLinesInWindow = this.getRecordInt(stringArray, 9);
                this.userkey = this.getRecordString(stringArray, 10);
                this.fastconnect = this.getRecordBoolean(stringArray, 11);
                this.notifier_CHAN = this.getRecordString(stringArray, 12);
                this.notifier_FRIEND = this.getRecordString(stringArray, 13);
                this.notifier_PRIV = this.getRecordString(stringArray, 14);
                this.gui_show_textfield = this.getRecordBoolean(stringArray, 15);
                this.gui_show_names = this.getRecordBoolean(stringArray, 16);
                this.gui_light = this.getRecordBoolean(stringArray, 17);
                this.gui_timestamp = this.getRecordBoolean(stringArray, 18);
                this.bluetoothstring = this.getRecordString(stringArray, 19);
                this.dcc_proxy = this.getRecordBoolean(stringArray, 20);
                this.dcc_proxy_server = this.getRecordString(stringArray, 21);
                this.dcc_proxy_port = this.getRecordInt(stringArray, 22);
                this.socket_poll = this.getRecordBoolean(stringArray, 23);
                this.show_motd = this.getRecordBoolean(stringArray, 24);
                this.window_width = this.getRecordInt(stringArray, 25);
                this.window_height = this.getRecordInt(stringArray, 26);
                String string2 = "";
                byte[] byArray = recordStore.getRecord(3);
                if (byArray != null) {
                    string2 = new String(byArray);
                }
                this.messages = Utils.splitStringToVector(string2, String.valueOf('\u0000'));
                byArray = recordStore.getRecord(4);
                if (byArray != null) {
                    string2 = new String(byArray);
                }
                stringArray = Utils.splitString(string2, String.valueOf('\u0000'));
                System.err.println("RSTORE: " + byArray);
                System.err.println("RS: " + stringArray);
                this.profiles.removeAllElements();
                if (stringArray != null) {
                    int n3 = stringArray.length / 10;
                    for (int i = 0; i < n3; ++i) {
                        Profile profile = new Profile();
                        block16: for (int j = 0; j < 10; ++j) {
                            int n4 = i * 10 + j;
                            switch (j) {
                                case 0: {
                                    profile.host = this.getRecordString(stringArray, n4);
                                    continue block16;
                                }
                                case 1: {
                                    profile.port = this.getRecordInt(stringArray, n4);
                                    continue block16;
                                }
                                case 2: {
                                    profile.nick = this.getRecordString(stringArray, n4);
                                    continue block16;
                                }
                                case 3: {
                                    profile.channels = this.getRecordString(stringArray, n4);
                                    continue block16;
                                }
                                case 4: {
                                    profile.startupScript = this.getRecordString(stringArray, n4);
                                    continue block16;
                                }
                                case 5: {
                                    profile.password = this.getRecordString(stringArray, n4);
                                    continue block16;
                                }
                                case 6: {
                                    profile.realname = this.getRecordString(stringArray, n4);
                                    continue block16;
                                }
                                case 7: {
                                    profile.friends = this.getRecordString(stringArray, n4);
                                    continue block16;
                                }
                                case 8: {
                                    profile.autoconnect = this.getRecordBoolean(stringArray, n4);
                                    continue block16;
                                }
                                case 9: {
                                    profile.profilename = this.getRecordString(stringArray, n4);
                                    continue block16;
                                }
                            }
                        }
                        this.profiles.addElement(profile);
                    }
                }
            }
            recordStore.closeRecordStore();
            recordStore = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("ERROR DATABASE");
            WLIrc2.writeError(exception, this.display, (Displayable)WLIrc2.mainForm);
        }
        return bl;
    }

    private byte[] getByteArray(String[] stringArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i] + String.valueOf('\u0000');
            byteArrayOutputStream.write(string.getBytes());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private String getRecordString(String[] stringArray, int n) throws Exception {
        String string = stringArray[n];
        return string != null ? string.trim() : "";
    }

    private boolean getRecordBoolean(String[] stringArray, int n) throws Exception {
        String string = stringArray[n];
        return string != null && new String(string).equals("1");
    }

    private int getRecordInt(String[] stringArray, int n) throws Exception {
        String string = stringArray[n];
        return string != null ? Integer.parseInt(new String(string)) : 0;
    }

    private String toString(boolean bl) {
        return bl ? "1" : "0";
    }

    public Font getFont() {
        int n = this.font_style;
        n = n == 0 ? 0 : (n == 1 ? 1 : 2);
        int n2 = this.font_size;
        n2 = n2 == 0 ? 16 : (n2 == 1 ? 0 : 8);
        int n3 = this.font_face;
        n3 = n3 == 0 ? 32 : (n3 == 1 ? 64 : 0);
        return Font.getFont((int)n3, (int)n, (int)n2);
    }

    public Font getHeaderFont() {
        return this.getFont();
    }

    public Font getInfoFont() {
        return this.getFont();
    }

    public void save(int n) {
        try {
            String[] stringArray = null;
            if (n == 2) {
                stringArray = this.setRecStoreConfig();
            } else if (n == 3) {
                stringArray = new String[this.messages.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)this.messages.elementAt(i);
                }
            } else if (n == 4) {
                stringArray = this.setRecStoreProfile();
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)NAMEOFSTORE, (boolean)true);
            byte[] byArray = this.getByteArray(stringArray);
            recordStore.setRecord(n, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
            recordStore = null;
        }
        catch (Exception exception) {
            WLIrc2.writeError(exception, this.display, (Displayable)WLIrc2.mainForm);
        }
    }

    private String[] setRecStoreConfig() {
        String[] stringArray = new String[]{this.gateway, new Integer(this.debug).toString(), new Integer(this.connection).toString(), new Integer(this.polltime).toString(), new Integer(this.font_face).toString(), new Integer(this.font_style).toString(), new Integer(this.font_size).toString(), this.toString(this.waitafterdata), this.encoding, new Integer(this.maxLinesInWindow).toString(), this.userkey, this.toString(this.fastconnect), this.notifier_CHAN, this.notifier_FRIEND, this.notifier_PRIV, this.toString(this.gui_show_textfield), this.toString(this.gui_show_names), this.toString(this.gui_light), this.toString(this.gui_timestamp), this.bluetoothstring, this.toString(this.dcc_proxy), this.dcc_proxy_server, new Integer(this.dcc_proxy_port).toString(), this.toString(this.socket_poll), this.toString(this.show_motd), new Integer(this.window_width).toString(), new Integer(this.window_height).toString()};
        return stringArray;
    }

    private String[] setRecStoreProfile() {
        Enumeration enumeration = this.profiles.elements();
        String[] stringArray = new String[10 * this.profiles.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Profile profile = (Profile)enumeration.nextElement();
            stringArray[n * 10 + 0] = profile.host;
            stringArray[n * 10 + 1] = new Integer(profile.port).toString();
            stringArray[n * 10 + 2] = profile.nick;
            stringArray[n * 10 + 3] = profile.channels;
            stringArray[n * 10 + 4] = profile.startupScript;
            stringArray[n * 10 + 5] = profile.password;
            stringArray[n * 10 + 6] = profile.realname;
            stringArray[n * 10 + 7] = profile.friends;
            stringArray[n * 10 + 8] = this.toString(profile.autoconnect);
            stringArray[n * 10 + 9] = profile.profilename;
            ++n;
        }
        return stringArray;
    }
}

