/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class HelpReader {
    private StringBuffer buffer = new StringBuffer();
    private String directory = "/properties/";
    private String extenssion = "properties";
    private String name = "help";
    private String fileName = null;
    private String help_text = null;

    public String get() {
        try {
            InputStream inputStream = this.getInputStream();
            inputStream = this.getInputStream();
            this.help_text = this.readValue(inputStream);
            return this.help_text;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private InputStream getInputStream() {
        if (this.fileName == null) {
            InputStream inputStream = null;
            String string = System.getProperty("microedition.locale");
            if (string != null) {
                string = string.replace('-', '_');
                this.fileName = this.directory + this.name + "_" + string + "." + this.extenssion;
                inputStream = this.getClass().getResourceAsStream(this.fileName);
                if (inputStream != null) {
                    return inputStream;
                }
                int n = string.indexOf(95);
                if (n != -1) {
                    string = string.substring(0, n);
                    this.fileName = this.directory + this.name + "_" + string + "." + this.extenssion;
                    inputStream = this.getClass().getResourceAsStream(this.fileName);
                    if (inputStream != null) {
                        return inputStream;
                    }
                }
            }
            this.fileName = this.directory + this.name + "." + this.extenssion;
            inputStream = this.getClass().getResourceAsStream(this.fileName);
            if (inputStream == null) {
                return null;
            }
            return inputStream;
        }
        return this.getClass().getResourceAsStream(this.fileName);
    }

    private String readValue(InputStream inputStream) throws IOException {
        this.buffer.setLength(0);
        int n = 0;
        while ((n = inputStream.read()) > 0) {
            int n2 = n & 0xFF;
            switch (n2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.buffer.append((char)n2);
                    break;
                }
                case 12: 
                case 13: {
                    int n3 = this.getByte(inputStream);
                    if ((n3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.buffer.append((char)((n2 & 0x1F) << 6 | n3 & 0x3F));
                    break;
                }
                case 14: {
                    int n3 = this.getByte(inputStream);
                    int n4 = this.getByte(inputStream);
                    if ((n3 & 0xC0) != 128 || (n4 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.buffer.append((char)((n2 & 0xF) << 12 | (n3 & 0x3F) << 6 | (n4 & 0x3F) << 0));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return this.buffer.toString();
    }

    private int getByte(InputStream inputStream) throws IOException, UTFDataFormatException {
        int n = inputStream.read();
        if (n < 0) {
            throw new UTFDataFormatException();
        }
        return n;
    }
}

