/*
 * Decompiled with CFR 0.152.
 */
package calc;

public final class Real {
    long mantissa;
    int exponent;
    byte sign;
    public static boolean magicRounding = true;
    public static final Real ZERO = new Real(0, 0, 0L);
    public static final Real ONE = new Real(0, 0x40000000, 0x4000000000000000L);
    public static final Real TWO = new Real(0, 0x40000001, 0x4000000000000000L);
    public static final Real THREE = new Real(0, 0x40000001, 0x6000000000000000L);
    public static final Real FIVE = new Real(0, 0x40000002, 0x5000000000000000L);
    public static final Real TEN = new Real(0, 0x40000003, 0x5000000000000000L);
    public static final Real HUNDRED = new Real(0, 0x40000006, 0x6400000000000000L);
    public static final Real HALF = new Real(0, 0x3FFFFFFF, 0x4000000000000000L);
    public static final Real THIRD = new Real(0, 0x3FFFFFFE, 0x5555555555555555L);
    public static final Real PERCENT = new Real(0, 0x3FFFFFF9, 5902958103587056517L);
    public static final Real SQRT2 = new Real(0, 0x40000000, 6521908912666391106L);
    public static final Real SQRT1_2 = new Real(0, 0x3FFFFFFF, 6521908912666391106L);
    public static final Real PI2 = new Real(0, 0x40000002, 7244019458077122842L);
    public static final Real PI = new Real(0, 0x40000001, 7244019458077122842L);
    public static final Real PI_2 = new Real(0, 0x40000000, 7244019458077122842L);
    public static final Real PI_4 = new Real(0, 0x3FFFFFFF, 7244019458077122842L);
    public static final Real PI_8 = new Real(0, 0x3FFFFFFE, 7244019458077122842L);
    public static final Real E = new Real(0, 0x40000001, 6267931151224907085L);
    public static final Real LN2 = new Real(0, 0x3FFFFFFF, 6393154322601327830L);
    public static final Real LN10 = new Real(0, 0x40000001, 5309399739799983627L);
    public static final Real LOG2E = new Real(0, 0x40000000, 6653256548922161246L);
    public static final Real LOG10E = new Real(0, 0x3FFFFFFE, 8011319160293570763L);
    public static final Real MAX = new Real(0, Integer.MAX_VALUE, Long.MAX_VALUE);
    public static final Real MIN = new Real(0, 0, 0x4000000000000000L);
    public static final Real NAN = new Real(0, Integer.MIN_VALUE, 0x4000000000000000L);
    public static final Real INF = new Real(0, Integer.MIN_VALUE, 0L);
    public static final Real INF_N = new Real(1, Integer.MIN_VALUE, 0L);
    public static final Real ZERO_N = new Real(1, 0, 0L);
    public static final Real ONE_N = new Real(1, 0x40000000, 0x4000000000000000L);
    private static Real tmp0 = new Real();
    private static Real recipTmp = new Real();
    private static Real recipTmp2 = new Real();
    private static Real sqrtTmp = new Real();
    private static Real expTmp = new Real();
    private static Real expTmp2 = new Real();
    private static Real expTmp3 = new Real();
    private static Real tmp1 = new Real();
    private static Real tmp2 = new Real();
    private static Real tmp3 = new Real();
    private static Real tmp4 = new Real();
    private static Real tmp5 = new Real();
    public static long randSeedA = 7244019458077122842L;
    public static long randSeedB = 6267931151224907085L;
    private static StringBuffer ftoaBuf = new StringBuffer(40);
    private static StringBuffer ftoaExp = new StringBuffer(15);
    public static final String hexChar = "0123456789ABCDEF";
    private static NumberFormat tmpFormat = new NumberFormat();

    public Real() {
    }

    public Real(Real real) {
        this.mantissa = real.mantissa;
        this.exponent = real.exponent;
        this.sign = real.sign;
    }

    public Real(int n) {
        this.assign(n);
    }

    public Real(long l) {
        this.assign(l);
    }

    public Real(String string) {
        this.assign(string, 10);
    }

    public Real(String string, int n) {
        this.assign(string, n);
    }

    public Real(int n, int n2, long l) {
        this.assign(n, n2, l);
    }

    public Real(byte[] byArray, int n) {
        this.assign(byArray, n);
    }

    public void assign(Real real) {
        if (real == null) {
            this.makeZero();
            return;
        }
        this.sign = real.sign;
        this.exponent = real.exponent;
        this.mantissa = real.mantissa;
    }

    public void assign(int n) {
        this.sign = 0;
        if (n < 0) {
            this.sign = 1;
            n = -n;
        }
        this.exponent = 1073741854;
        this.mantissa = (long)n << 32;
        this.normalize();
    }

    public void assign(long l) {
        this.sign = 0;
        if (l < 0L) {
            this.sign = 1;
            l = -l;
        }
        this.exponent = 1073741886;
        this.mantissa = l;
        this.normalize();
    }

    public void assign(String string) {
        this.assign(string, 10);
    }

    public void assign(String string, int n) {
        if (string == null || string.length() == 0) {
            this.assign(ZERO);
            return;
        }
        this.atof(string, n);
    }

    public void assign(int n, int n2, long l) {
        this.sign = (byte)n;
        this.exponent = n2;
        this.mantissa = l;
    }

    public void assign(byte[] byArray, int n) {
        this.sign = (byte)(byArray[n + 4] >> 7 & 1);
        this.exponent = ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
        this.mantissa = ((long)(byArray[n + 4] & 0x7F) << 56) + ((long)(byArray[n + 5] & 0xFF) << 48) + ((long)(byArray[n + 6] & 0xFF) << 40) + ((long)(byArray[n + 7] & 0xFF) << 32) + ((long)(byArray[n + 8] & 0xFF) << 24) + ((long)(byArray[n + 9] & 0xFF) << 16) + ((long)(byArray[n + 10] & 0xFF) << 8) + (long)(byArray[n + 11] & 0xFF);
    }

    public void toBytes(byte[] byArray, int n) {
        byArray[n] = (byte)(this.exponent >> 24);
        byArray[n + 1] = (byte)(this.exponent >> 16);
        byArray[n + 2] = (byte)(this.exponent >> 8);
        byArray[n + 3] = (byte)this.exponent;
        byArray[n + 4] = (byte)((long)(this.sign << 7) + (this.mantissa >> 56));
        byArray[n + 5] = (byte)(this.mantissa >> 48);
        byArray[n + 6] = (byte)(this.mantissa >> 40);
        byArray[n + 7] = (byte)(this.mantissa >> 32);
        byArray[n + 8] = (byte)(this.mantissa >> 24);
        byArray[n + 9] = (byte)(this.mantissa >> 16);
        byArray[n + 10] = (byte)(this.mantissa >> 8);
        byArray[n + 11] = (byte)this.mantissa;
    }

    public void assignFloatBits(int n) {
        this.sign = (byte)(n >>> 31);
        this.exponent = n >> 23 & 0xFF;
        this.mantissa = (long)(n & 0x7FFFFF) << 39;
        if (this.exponent == 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa != 0L) {
            this.exponent = 1073741698;
            this.normalize();
            return;
        }
        if (this.exponent <= 254) {
            this.exponent += 1073741697;
            this.mantissa |= 0x4000000000000000L;
            return;
        }
        if (this.mantissa == 0L) {
            this.makeInfinity(this.sign);
        } else {
            this.makeNan();
        }
    }

    public void assignDoubleBits(long l) {
        this.sign = (byte)(l >>> 63);
        this.exponent = (int)(l >> 52 & 0x7FFL);
        this.mantissa = (l & 0xFFFFFFFFFFFFFL) << 10;
        if (this.exponent == 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa != 0L) {
            this.exponent = 1073740802;
            this.normalize();
            return;
        }
        if (this.exponent <= 2046) {
            this.exponent += 1073740801;
            this.mantissa |= 0x4000000000000000L;
            return;
        }
        if (this.mantissa == 0L) {
            this.makeInfinity(this.sign);
        } else {
            this.makeNan();
        }
    }

    public int toFloatBits() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return Integer.MAX_VALUE;
        }
        int n = this.exponent - 0x40000000 + 127;
        long l = this.mantissa;
        if ((l += 0x4000000000L) < 0L) {
            l >>>= 1;
            ++n;
            if (this.exponent < 0) {
                return this.sign << 31 | 0x7F800000;
            }
        }
        if (this.exponent < 0 && this.mantissa == 0L || n > 254) {
            return this.sign << 31 | 0x7F800000;
        }
        if (this.exponent == 0 && this.mantissa == 0L || n < -22) {
            return this.sign << 31;
        }
        if (n > 0) {
            return this.sign << 31 | n << 23 | (int)(l >>> 39) & 0x7FFFFF;
        }
        return this.sign << 31 | (int)(l >>> 40 - n) & 0x7FFFFF;
    }

    public long toDoubleBits() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return Long.MAX_VALUE;
        }
        int n = this.exponent - 0x40000000 + 1023;
        long l = this.mantissa;
        if ((l += 512L) < 0L) {
            l >>>= 1;
            ++n;
            if (this.exponent < 0) {
                return (long)this.sign << 63 | 0x7FF0000000000000L;
            }
        }
        if (this.exponent < 0 && this.mantissa == 0L || n > 2046) {
            return (long)this.sign << 63 | 0x7FF0000000000000L;
        }
        if (this.exponent == 0 && this.mantissa == 0L || n < -51) {
            return (long)this.sign << 63;
        }
        if (n > 0) {
            return (long)this.sign << 63 | (long)n << 52 | l >>> 10 & 0xFFFFFFFFFFFFFL;
        }
        return (long)this.sign << 63 | l >>> 11 - n & 0xFFFFFFFFFFFFFL;
    }

    public void makeZero() {
        this.sign = 0;
        this.mantissa = 0L;
        this.exponent = 0;
    }

    public void makeZero(int n) {
        this.sign = (byte)n;
        this.mantissa = 0L;
        this.exponent = 0;
    }

    public void makeInfinity(int n) {
        this.sign = (byte)n;
        this.mantissa = 0L;
        this.exponent = Integer.MIN_VALUE;
    }

    public void makeNan() {
        this.sign = 0;
        this.mantissa = 0x4000000000000000L;
        this.exponent = Integer.MIN_VALUE;
    }

    public boolean isZero() {
        return this.exponent == 0 && this.mantissa == 0L;
    }

    public boolean isInfinity() {
        return this.exponent < 0 && this.mantissa == 0L;
    }

    public boolean isNan() {
        return this.exponent < 0 && this.mantissa != 0L;
    }

    public boolean isFinite() {
        return this.exponent >= 0;
    }

    public boolean isFiniteNonZero() {
        return this.exponent >= 0 && this.mantissa != 0L;
    }

    public boolean isNegative() {
        return this.sign != 0;
    }

    public void abs() {
        this.sign = 0;
    }

    public void neg() {
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = (byte)(this.sign ^ 1);
        }
    }

    public void copysign(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = real.sign;
    }

    public void normalize() {
        if (this.exponent < 0) {
            return;
        }
        if (this.mantissa == 0L) {
            this.exponent = 0;
            return;
        }
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.mantissa == 0L) {
                this.mantissa = 0x4000000000000000L;
                ++this.exponent;
            }
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
            return;
        }
        while (this.mantissa >>> 47 == 0L) {
            this.mantissa <<= 16;
            this.exponent -= 16;
        }
        while (this.mantissa >>> 59 == 0L) {
            this.mantissa <<= 4;
            this.exponent -= 4;
        }
        while (this.mantissa >>> 62 == 0L) {
            this.mantissa <<= 1;
            --this.exponent;
        }
        if (this.exponent < 0) {
            this.makeZero(this.sign);
        }
    }

    public long normalize128(long l) {
        if (this.exponent < 0) {
            return 0L;
        }
        if (this.mantissa == 0L && l == 0L) {
            this.exponent = 0;
            return 0L;
        }
        if (this.mantissa < 0L) {
            l = (this.mantissa << 63) + (l >>> 1);
            this.mantissa >>>= 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
            return l;
        }
        while (this.mantissa >>> 47 == 0L) {
            this.mantissa = (this.mantissa << 16) + (l >>> 48);
            l <<= 16;
            this.exponent -= 16;
        }
        while (this.mantissa >>> 59 == 0L) {
            this.mantissa = (this.mantissa << 4) + (l >>> 60);
            l <<= 4;
            this.exponent -= 4;
        }
        while (this.mantissa >>> 62 == 0L) {
            this.mantissa = (this.mantissa << 1) + (l >>> 63);
            l <<= 1;
            --this.exponent;
        }
        if (this.exponent < 0) {
            this.makeZero(this.sign);
            return 0L;
        }
        return l;
    }

    public void roundFrom128(long l) {
        this.mantissa += l >>> 63;
        this.normalize();
    }

    private int compare(Real real) {
        int n;
        if (this.exponent == 0 && this.mantissa == 0L && real.exponent == 0 && real.mantissa == 0L) {
            return 0;
        }
        if (this.sign != real.sign) {
            return real.sign - this.sign;
        }
        int n2 = n = this.sign == 0 ? 1 : -1;
        if (this.exponent < 0 && this.mantissa == 0L) {
            return n;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            return -n;
        }
        if (this.exponent != real.exponent) {
            return this.exponent < real.exponent ? -n : n;
        }
        if (this.mantissa != real.mantissa) {
            return this.mantissa < real.mantissa ? -n : n;
        }
        return 0;
    }

    private boolean invalidCompare(Real real) {
        return this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign == real.sign;
    }

    public boolean equalTo(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) == 0;
    }

    public boolean notEqualTo(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) != 0;
    }

    public boolean lessThan(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) < 0;
    }

    public boolean lessEqual(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) <= 0;
    }

    public boolean greaterThan(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) > 0;
    }

    public boolean greaterEqual(Real real) {
        if (this.invalidCompare(real)) {
            return false;
        }
        return this.compare(real) >= 0;
    }

    public boolean absLessThan(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L) {
            return false;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            return true;
        }
        if (this.exponent != real.exponent) {
            return this.exponent < real.exponent;
        }
        return this.mantissa < real.mantissa;
    }

    public void scalbn(int n) {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        this.exponent += n;
        if (this.exponent < 0) {
            if (n < 0) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
        }
    }

    public void nextafter(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign == real.sign) {
            return;
        }
        int n = -this.compare(real);
        if (n == 0) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.MIN.mantissa;
            this.exponent = Real.MIN.exponent;
            this.sign = Real.MIN.sign;
            this.sign = (byte)(n < 0 ? 1 : 0);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.mantissa = Real.MAX.mantissa;
            this.exponent = Real.MAX.exponent;
            this.sign = Real.MAX.sign;
            this.sign = (byte)(n >= 0 ? 1 : 0);
            return;
        }
        if (this.sign == 0 ^ n < 0) {
            ++this.mantissa;
        } else {
            if (this.mantissa == 0x4000000000000000L) {
                this.mantissa <<= 1;
                --this.exponent;
            }
            --this.mantissa;
        }
        this.normalize();
    }

    public void floor() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x40000000) {
            if (this.sign == 0) {
                this.makeZero(this.sign);
            } else {
                this.exponent = Real.ONE.exponent;
                this.mantissa = Real.ONE.mantissa;
            }
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return;
        }
        if (this.sign != 0) {
            this.mantissa += (1L << n) - 1L;
        }
        this.mantissa &= (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.sign != 0) {
            this.normalize();
        }
    }

    public void ceil() {
        this.neg();
        this.floor();
        this.neg();
    }

    public void round() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x3FFFFFFF) {
            this.makeZero(this.sign);
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return;
        }
        this.mantissa += 1L << n - 1;
        this.mantissa &= (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.normalize();
    }

    public void trunc() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x40000000) {
            this.makeZero(this.sign);
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return;
        }
        this.mantissa &= (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.normalize();
    }

    public void frac() {
        if (this.exponent < 0 || this.mantissa == 0L || this.exponent < 0x40000000) {
            return;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            this.makeZero(this.sign);
            return;
        }
        this.mantissa &= (1L << n) - 1L;
        this.normalize();
    }

    public int toInteger() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return 0;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                return Integer.MAX_VALUE;
            }
            return -2147483647;
        }
        if (this.exponent < 0x40000000) {
            return 0;
        }
        int n = 1073741886 - this.exponent;
        if (n < 32) {
            if (this.sign == 0) {
                return Integer.MAX_VALUE;
            }
            return -2147483647;
        }
        return this.sign == 0 ? (int)(this.mantissa >>> n) : -((int)(this.mantissa >>> n));
    }

    public long toLong() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                return Long.MAX_VALUE;
            }
            return -9223372036854775807L;
        }
        if (this.exponent < 0x40000000) {
            return 0L;
        }
        int n = 1073741886 - this.exponent;
        if (n < 0) {
            if (this.sign == 0) {
                return Long.MAX_VALUE;
            }
            return -9223372036854775807L;
        }
        return this.sign == 0 ? this.mantissa >>> n : -(this.mantissa >>> n);
    }

    public boolean isIntegral() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return false;
        }
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa == 0L) {
            return true;
        }
        if (this.exponent < 0x40000000) {
            return false;
        }
        int n = 1073741886 - this.exponent;
        if (n <= 0) {
            return true;
        }
        return (this.mantissa & (1L << n) - 1L) == 0L;
    }

    public boolean isOdd() {
        if (this.exponent < 0 || this.mantissa == 0L || this.exponent < 0x40000000 || this.exponent > 1073741886) {
            return false;
        }
        int n = 1073741886 - this.exponent;
        return (this.mantissa >>> n & 1L) != 0L;
    }

    public void swap(Real real) {
        long l = this.mantissa;
        this.mantissa = real.mantissa;
        real.mantissa = l;
        int n = this.exponent;
        this.exponent = real.exponent;
        real.exponent = n;
        byte by = this.sign;
        this.sign = real.sign;
        real.sign = by;
    }

    public void add(Real real) {
        long l;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign != real.sign) {
                this.makeNan();
            } else {
                this.makeInfinity(this.exponent < 0 && this.mantissa == 0L ? this.sign : real.sign);
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
            }
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.sign = 0;
            }
            return;
        }
        if (this.exponent > real.exponent || this.exponent == real.exponent && this.mantissa >= real.mantissa) {
            by = real.sign;
            n = real.exponent;
            l = real.mantissa;
        } else {
            by = this.sign;
            n = this.exponent;
            l = this.mantissa;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
        }
        int n2 = this.exponent - n;
        if (n2 >= 64) {
            return;
        }
        if (this.sign == by) {
            this.mantissa += l >>> n2;
            if (this.mantissa >= 0L && n2 > 0 && (l >>> n2 - 1 & 1L) != 0L) {
                ++this.mantissa;
            }
            if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
                if (this.exponent < 0) {
                    this.makeInfinity(this.sign);
                    return;
                }
            }
        } else {
            if (n2 > 0) {
                this.mantissa <<= 1;
                --this.exponent;
                --n2;
            }
            l = -l;
            this.mantissa += l >> n2;
            if (this.mantissa >= 0L && n2 > 0 && (l >>> n2 - 1 & 1L) != 0L) {
                ++this.mantissa;
            }
            if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
            } else {
                if (magicRounding && this.mantissa >= 0L && this.mantissa <= 7L) {
                    this.mantissa = 0L;
                }
                this.normalize();
            }
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        }
    }

    public long add128(long l, Real real, long l2) {
        long l3;
        long l4;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L && this.sign != real.sign) {
                this.makeNan();
            } else {
                this.makeInfinity(this.exponent < 0 && this.mantissa == 0L ? this.sign : real.sign);
            }
            return 0L;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
                l = l2;
            }
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.sign = 0;
            }
            return l;
        }
        if (this.exponent > real.exponent || this.exponent == real.exponent && this.mantissa > real.mantissa || this.exponent == real.exponent && this.mantissa == real.mantissa && l >>> 1 >= l2 >>> 1) {
            by = real.sign;
            n = real.exponent;
            l4 = real.mantissa;
            l3 = l2;
        } else {
            by = this.sign;
            n = this.exponent;
            l4 = this.mantissa;
            l3 = l;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
            l = l2;
        }
        int n2 = this.exponent - n;
        if (n2 >= 127) {
            return l;
        }
        if (n2 >= 64) {
            l3 = l4 >>> n2 - 64;
            l4 = 0L;
        } else if (n2 > 0) {
            l3 = (l3 >>> n2) + (l4 << 64 - n2);
            l4 >>>= n2;
        }
        l >>>= 1;
        l3 >>>= 1;
        if (this.sign == by) {
            this.mantissa += (l += l3) >>> 63;
            this.mantissa += l4;
        } else {
            this.mantissa -= (l -= l3) >>> 63;
            this.mantissa -= l4;
            if (this.mantissa == 0L && l >= 0L && l <= 31L) {
                l = 0L;
            }
        }
        l <<= 1;
        l = this.normalize128(l);
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        }
        return l;
    }

    public void sub(Real real) {
        Real.tmp0.mantissa = real.mantissa;
        Real.tmp0.exponent = real.exponent;
        Real.tmp0.sign = (byte)(real.sign ^ 1);
        this.add(tmp0);
    }

    public void mul(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = (byte)(this.sign ^ real.sign);
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            } else {
                this.makeZero(this.sign);
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        int n = real.exponent;
        this.exponent += n - 0x40000000;
        if (this.exponent < 0) {
            if (this.exponent == -1 && n < 0x40000000) {
                this.exponent = 0;
                this.mantissa = this.mantissa + 1L >>> 1;
            } else {
                if (n < 0x40000000) {
                    this.makeZero(this.sign);
                } else {
                    this.makeInfinity(this.sign);
                }
                return;
            }
        }
        long l = this.mantissa & Integer.MAX_VALUE;
        long l2 = this.mantissa >>> 31;
        long l3 = real.mantissa & Integer.MAX_VALUE;
        long l4 = real.mantissa >>> 31;
        this.mantissa = l2 * l4;
        int n2 = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += l * l4 + l2 * l3 + (l * l3 >>> 31) + (long)n2 >>> 31;
        this.normalize();
    }

    public long mul128(long l, Real real, long l2) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return 0L;
        }
        this.sign = (byte)(this.sign ^ real.sign);
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            } else {
                this.makeZero(this.sign);
            }
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return 0L;
        }
        int n = real.exponent;
        this.exponent += n - 0x40000000;
        if (this.exponent < 0) {
            if (n < 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return 0L;
        }
        long l3 = 0xFFFFFFFFL;
        long l4 = l & l3;
        long l5 = l >>> 32;
        long l6 = this.mantissa & l3;
        long l7 = this.mantissa >>> 32;
        long l8 = l2 & l3;
        long l9 = l2 >>> 32;
        long l10 = real.mantissa & l3;
        long l11 = real.mantissa >>> 32;
        l4 = (l7 * l8 >>> 2) + (l6 * l9 >>> 2) + (l5 * l10 >>> 2) + (l4 * l11 >>> 2) + 0x60000000L >>> 28;
        l8 = l6 * l10;
        l5 = ((l4 += ((l5 *= l11) << 2 & l3) + (l8 << 2 & l3) + ((l9 *= l7) << 2 & l3)) >>> 32) + (l5 >>> 30) + (l8 >>> 30) + (l9 >>> 30);
        l = ((l5 += ((l6 *= l11) << 2 & l3) + ((l10 *= l7) << 2 & l3)) << 32) + (l4 &= l3);
        this.mantissa = (l7 * l11 << 2) + (l5 >>> 32) + (l6 >>> 30) + (l10 >>> 30);
        l = this.normalize128(l);
        return l;
    }

    private void mul10() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        this.mantissa += this.mantissa + 2L >>> 2;
        this.exponent += 3;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
        }
        if (this.exponent < 0) {
            this.makeInfinity(this.sign);
        }
    }

    public void sqr() {
        this.sign = 0;
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        int n = this.exponent;
        this.exponent += this.exponent - 0x40000000;
        if (this.exponent < 0) {
            if (n < 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return;
        }
        long l = this.mantissa & Integer.MAX_VALUE;
        long l2 = this.mantissa >>> 31;
        this.mantissa = l2 * l2;
        int n2 = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += (l * l2 << 1) + (l * l >>> 31) + (long)n2 >>> 31;
        this.normalize();
    }

    private static long ldiv(long l, long l2) {
        int n;
        int n2 = 1;
        int n3 = 0;
        l -= l2;
        l <<= 1;
        for (n = 0; n < 31; ++n) {
            n2 <<= 1;
            if (l < 0L || l >= l2) {
                l -= l2;
                n2 |= 1;
            }
            l <<= 1;
        }
        for (n = 0; n < 31; ++n) {
            n3 <<= 1;
            if (l < 0L || l >= l2) {
                l -= l2;
                n3 |= 1;
            }
            l <<= 1;
        }
        long l3 = (((long)n2 & 0xFFFFFFFFL) << 31) + (long)n3;
        if (l < 0L || l >= l2) {
            ++l3;
        }
        return l3;
    }

    public void div(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = (byte)(this.sign ^ real.sign);
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (real.exponent == 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.exponent += 0x40000000 - real.exponent;
        if (this.mantissa < real.mantissa) {
            this.mantissa <<= 1;
            --this.exponent;
        }
        if (this.exponent < 0) {
            if (real.exponent >= 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return;
        }
        if (real.mantissa == 0x4000000000000000L) {
            return;
        }
        this.mantissa = Real.ldiv(this.mantissa, real.mantissa);
    }

    public void rdiv(Real real) {
        Real.recipTmp.mantissa = real.mantissa;
        Real.recipTmp.exponent = real.exponent;
        Real.recipTmp.sign = real.sign;
        recipTmp.div(this);
        this.mantissa = Real.recipTmp.mantissa;
        this.exponent = Real.recipTmp.exponent;
        this.sign = Real.recipTmp.sign;
    }

    public void recip() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.exponent = Integer.MIN_VALUE - this.exponent;
        if (this.mantissa == 0x4000000000000000L) {
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
            return;
        }
        --this.exponent;
        this.mantissa = Real.ldiv(Long.MIN_VALUE, this.mantissa);
    }

    public long recip128(long l) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return 0L;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return 0L;
        }
        byte by = this.sign;
        this.sign = 0;
        if (this.mantissa == 0x4000000000000000L && l == 0L) {
            this.exponent = Integer.MIN_VALUE - this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(by);
            }
            return 0L;
        }
        int n = 0x40000000 - this.exponent;
        this.exponent = 0x40000000;
        Real.recipTmp.mantissa = this.mantissa;
        Real.recipTmp.exponent = this.exponent;
        Real.recipTmp.sign = this.sign;
        long l2 = l;
        recipTmp.neg();
        this.recip();
        Real.recipTmp2.mantissa = this.mantissa;
        Real.recipTmp2.exponent = this.exponent;
        Real.recipTmp2.sign = this.sign;
        l = this.mul128(0L, recipTmp, l2);
        l = this.add128(l, ONE, 0L);
        l = this.mul128(l, recipTmp2, 0L);
        l = this.add128(l, recipTmp2, 0L);
        this.scalbn(n);
        if (!this.isNan()) {
            this.sign = by;
        }
        return l;
    }

    public void divf(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (real.exponent < 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (real.exponent == 0 && real.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        Real.tmp0.mantissa = real.mantissa;
        Real.tmp0.exponent = real.exponent;
        Real.tmp0.sign = real.sign;
        long l = tmp0.recip128(0L);
        l = this.mul128(0L, tmp0, l);
        if (this.sign != 0 && l != 0L) {
            ++this.mantissa;
            this.normalize();
        }
        this.floor();
    }

    private void modInternal(Real real, long l) {
        Real.tmp0.mantissa = real.mantissa;
        Real.tmp0.exponent = real.exponent;
        Real.tmp0.sign = real.sign;
        long l2 = tmp0.recip128(l);
        l2 = tmp0.mul128(l2, this, 0L);
        if (Real.tmp0.exponent > 1073741886) {
            this.makeZero(real.sign);
            return;
        }
        if (Real.tmp0.sign != 0 && l2 != 0L) {
            ++Real.tmp0.mantissa;
            tmp0.normalize();
        }
        tmp0.floor();
        tmp0.neg();
        l2 = tmp0.mul128(0L, real, l);
        l2 = this.add128(0L, tmp0, l2);
        this.roundFrom128(l2);
    }

    public void mod(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (real.exponent == 0 && real.mantissa == 0L) {
                this.makeNan();
            } else {
                this.sign = real.sign;
            }
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            if (this.sign != real.sign) {
                this.makeInfinity(real.sign);
            }
            return;
        }
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.makeZero(real.sign);
            return;
        }
        this.modInternal(real, 0L);
    }

    public void and(Real real) {
        long l;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            this.makeZero();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if ((this.exponent >= 0 || this.mantissa != 0L) && this.sign != 0) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
            } else if ((real.exponent < 0 && real.mantissa == 0L || real.sign == 0) && (this.exponent >= 0 || this.mantissa != 0L || real.exponent >= 0 || real.mantissa != 0L || this.sign == 0 || real.sign == 0)) {
                this.makeZero();
            }
            return;
        }
        if (this.exponent >= real.exponent) {
            by = real.sign;
            n = real.exponent;
            l = real.mantissa;
        } else {
            by = this.sign;
            n = this.exponent;
            l = this.mantissa;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
        }
        int n2 = this.exponent - n;
        if (n2 >= 64) {
            if (by == 0) {
                this.makeZero(this.sign);
            }
            return;
        }
        if (by != 0) {
            l = -l;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        this.mantissa &= l >> n2;
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public void or(Real real) {
        long l;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || this.sign == 0) {
                if ((real.exponent >= 0 || real.mantissa != 0L) && real.sign != 0) {
                    this.mantissa = real.mantissa;
                    this.exponent = real.exponent;
                    this.sign = real.sign;
                } else {
                    this.makeInfinity(this.sign | real.sign);
                }
            }
            return;
        }
        if (this.sign != 0 && this.exponent <= real.exponent || real.sign == 0 && this.exponent >= real.exponent) {
            by = real.sign;
            n = real.exponent;
            l = real.mantissa;
        } else {
            by = this.sign;
            n = this.exponent;
            l = this.mantissa;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
        }
        int n2 = this.exponent - n;
        if (n2 >= 64 || n2 <= -64) {
            return;
        }
        if (by != 0) {
            l = -l;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        this.mantissa = n2 >= 0 ? (this.mantissa |= l >> n2) : (this.mantissa |= l << -n2);
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public void xor(Real real) {
        long l;
        int n;
        byte by;
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = real.mantissa;
                this.exponent = real.exponent;
                this.sign = real.sign;
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            this.makeInfinity(this.sign ^ real.sign);
            return;
        }
        if (this.exponent >= real.exponent) {
            by = real.sign;
            n = real.exponent;
            l = real.mantissa;
        } else {
            by = this.sign;
            n = this.exponent;
            l = this.mantissa;
            this.sign = real.sign;
            this.exponent = real.exponent;
            this.mantissa = real.mantissa;
        }
        int n2 = this.exponent - n;
        if (n2 >= 64) {
            return;
        }
        if (by != 0) {
            l = -l;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        this.mantissa ^= l >> n2;
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public void bic(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || real.exponent == 0 && real.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || real.exponent < 0 && real.mantissa == 0L) {
            if (this.exponent >= 0 || this.mantissa != 0L) {
                if (this.sign != 0) {
                    if (real.sign != 0) {
                        this.makeInfinity(0);
                    } else {
                        this.makeInfinity(1);
                    }
                }
            } else if (real.sign != 0) {
                if (real.exponent < 0 && real.mantissa == 0L) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            }
            return;
        }
        int n = this.exponent - real.exponent;
        if (n >= 64 || n <= -64 && this.sign == 0) {
            return;
        }
        long l = real.mantissa;
        if (real.sign != 0) {
            l = -l;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        if (n < 0) {
            if (this.sign != 0) {
                this.mantissa = n <= -64 ? l ^ 0xFFFFFFFFFFFFFFFFL : this.mantissa >> -n & (l ^ 0xFFFFFFFFFFFFFFFFL);
                this.exponent = real.exponent;
            } else {
                this.mantissa &= l << -n ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            this.mantissa &= l >> n ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public void add(int n) {
        tmp0.assign(n);
        this.add(tmp0);
    }

    public void sub(int n) {
        tmp0.assign(n);
        this.sub(tmp0);
    }

    public void mul(int n) {
        tmp0.assign(n);
        this.mul(tmp0);
    }

    public void div(int n) {
        tmp0.assign(n);
        this.div(tmp0);
    }

    public void rdiv(int n) {
        tmp0.assign(n);
        this.rdiv(tmp0);
    }

    public boolean equalTo(int n) {
        tmp0.assign(n);
        return this.equalTo(tmp0);
    }

    public boolean notEqualTo(int n) {
        tmp0.assign(n);
        return this.notEqualTo(tmp0);
    }

    public boolean lessThan(int n) {
        tmp0.assign(n);
        return this.lessThan(tmp0);
    }

    public boolean lessEqual(int n) {
        tmp0.assign(n);
        return this.lessEqual(tmp0);
    }

    public boolean greaterThan(int n) {
        tmp0.assign(n);
        return this.greaterThan(tmp0);
    }

    public boolean greaterEqual(int n) {
        tmp0.assign(n);
        return this.greaterEqual(tmp0);
    }

    private int compare(int n) {
        tmp0.assign(n);
        return this.compare(tmp0);
    }

    private void rsqrtInternal() {
        Real.recipTmp.mantissa = this.mantissa;
        Real.recipTmp.exponent = this.exponent;
        Real.recipTmp.sign = this.sign;
        recipTmp.neg();
        this.mantissa = 5647513932722601984L - (this.mantissa >>> 2);
        boolean bl = (this.exponent & 1) != 0;
        this.exponent = 0x60000000 - (this.exponent >> 1);
        this.normalize();
        if (bl) {
            this.mul(SQRT1_2);
        }
        for (int i = 0; i < 4; ++i) {
            Real.recipTmp2.mantissa = this.mantissa;
            Real.recipTmp2.exponent = this.exponent;
            Real.recipTmp2.sign = this.sign;
            this.sqr();
            this.mul(recipTmp);
            this.add(ONE);
            this.scalbn(-1);
            this.mul(recipTmp2);
            this.add(recipTmp2);
        }
    }

    public void rsqrt() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(0);
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        this.rsqrtInternal();
    }

    public void sqrt() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        Real.sqrtTmp.mantissa = this.mantissa;
        Real.sqrtTmp.exponent = this.exponent;
        Real.sqrtTmp.sign = this.sign;
        sqrtTmp.rsqrtInternal();
        this.mul(sqrtTmp);
    }

    public void cbrt() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        byte by = this.sign;
        this.sign = 0;
        this.log2();
        long l = this.mul128(0L, THIRD, 0x5555555555555555L);
        this.exp2Internal(l);
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = by;
        }
    }

    public void nroot(Real real) {
        boolean bl = false;
        if (this.sign != 0 && real.isIntegral() && real.isOdd()) {
            bl = true;
            this.abs();
        }
        Real.tmp2.mantissa = real.mantissa;
        Real.tmp2.exponent = real.exponent;
        Real.tmp2.sign = real.sign;
        tmp2.recip();
        this.pow(tmp2);
        if (bl) {
            this.neg();
        }
    }

    public void hypot(Real real) {
        Real.tmp1.mantissa = real.mantissa;
        Real.tmp1.exponent = real.exponent;
        Real.tmp1.sign = real.sign;
        tmp1.sqr();
        this.sqr();
        this.add(tmp1);
        this.sqrt();
    }

    private void exp2Internal(long l) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign != 0) {
                this.makeZero(0);
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        if (Real.expTmp.sign != 0 && l != 0L) {
            ++Real.expTmp.mantissa;
            expTmp.normalize();
        }
        expTmp.floor();
        int n = expTmp.toInteger();
        if (n >= 0x40000000) {
            this.makeInfinity(this.sign);
            return;
        }
        if (n < -1073741824) {
            this.makeZero(this.sign);
            return;
        }
        expTmp.neg();
        l = this.add128(l, expTmp, 0L);
        expTmp.assign(0, 0x3FFFFFFF, 6393154322601327829L);
        l = this.mul128(l, expTmp, -1949537693445031080L);
        this.roundFrom128(l);
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        Real.expTmp2.mantissa = Real.ONE.mantissa;
        Real.expTmp2.exponent = Real.ONE.exponent;
        Real.expTmp2.sign = Real.ONE.sign;
        for (int i = 18; i >= 2; --i) {
            expTmp2.mul(i);
            this.add(expTmp2);
            this.mul(expTmp);
        }
        this.div(expTmp2);
        this.add(ONE);
        this.exponent += n;
    }

    public void exp() {
        expTmp.assign(0, 0x40000000, 6653256548922161245L);
        long l = this.mul128(0L, expTmp, -2358760956788564156L);
        this.exp2Internal(l);
    }

    public void exp2() {
        this.exp2Internal(0L);
    }

    public void exp10() {
        expTmp.assign(0, 0x40000001, 7659844674706589055L);
        long l = this.mul128(0L, expTmp, 2636289682573880742L);
        this.exp2Internal(l);
    }

    private void lnInternal() {
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        expTmp.add(ONE);
        this.sub(ONE);
        this.div(expTmp);
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        Real.expTmp2.mantissa = this.mantissa;
        Real.expTmp2.exponent = this.exponent;
        Real.expTmp2.sign = this.sign;
        expTmp2.sqr();
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        Real.expTmp3.mantissa = Real.ONE.mantissa;
        Real.expTmp3.exponent = Real.ONE.exponent;
        Real.expTmp3.sign = Real.ONE.sign;
        for (int i = 37; i >= 3; i -= 2) {
            this.mul(expTmp2);
            this.mul(i - 2);
            expTmp3.mul(i);
            this.add(expTmp3);
        }
        this.mul(expTmp);
        this.div(expTmp3);
        this.scalbn(1);
    }

    public void ln() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(1);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        int n = this.exponent - 0x40000000;
        this.exponent = 0x40000000;
        this.lnInternal();
        expTmp.assign(n);
        expTmp.mul(LN2);
        this.add(expTmp);
    }

    public void log2() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(1);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        int n = this.exponent - 0x40000000;
        this.exponent = 0x40000000;
        this.lnInternal();
        this.mul(LOG2E);
        this.add(n);
    }

    public void log10() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(1);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        int n = this.exponent - 0x40000000;
        this.exponent = 0x40000000;
        this.lnInternal();
        expTmp.assign(n);
        expTmp.mul(LN2);
        this.add(expTmp);
        this.mul(LOG10E);
    }

    public int lowPow10() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return 0;
        }
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        int n = this.exponent - 0x40000000;
        n = n < 0 ? -((int)((long)(-n) * 1292913987L + 0xFFFFFFFFL >> 32)) : (int)((long)n * 1292913987L >> 32);
        this.mantissa = Real.TEN.mantissa;
        this.exponent = Real.TEN.exponent;
        this.sign = Real.TEN.sign;
        this.pow(n);
        Real.tmp3.mantissa = this.mantissa;
        Real.tmp3.exponent = this.exponent;
        Real.tmp3.sign = this.sign;
        tmp3.mul10();
        if (tmp3.compare(tmp2) <= 0) {
            ++n;
            this.mantissa = Real.tmp3.mantissa;
            this.exponent = Real.tmp3.exponent;
            this.sign = Real.tmp3.sign;
        }
        return n;
    }

    public void pow(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        long l = 0L;
        long l2 = 0L;
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        while (n != 0) {
            if ((n & 1) != 0) {
                l = this.mul128(l, expTmp, l2);
            }
            l2 = expTmp.mul128(l2, expTmp, l2);
            n >>>= 1;
        }
        if (bl) {
            l = this.recip128(l);
        }
        this.roundFrom128(l);
    }

    public void pow(Real real) {
        if (real.exponent == 0 && real.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (real.compare(ONE) == 0) {
            return;
        }
        if (real.exponent < 0 && real.mantissa == 0L) {
            Real.tmp1.mantissa = this.mantissa;
            Real.tmp1.exponent = this.exponent;
            Real.tmp1.sign = this.sign;
            tmp1.abs();
            int n = tmp1.compare(ONE);
            if (n > 0) {
                if (real.sign == 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else if (n < 0) {
                if (real.sign != 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else {
                this.makeNan();
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                if (real.sign == 0) {
                    this.makeZero();
                } else {
                    this.makeInfinity(0);
                }
            } else if (real.isIntegral() && real.isOdd()) {
                if (real.sign == 0) {
                    this.makeZero(1);
                } else {
                    this.makeInfinity(1);
                }
            } else if (real.sign == 0) {
                this.makeZero();
            } else {
                this.makeInfinity(0);
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                if (real.sign == 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else if (real.isIntegral()) {
                if (real.isOdd()) {
                    if (real.sign == 0) {
                        this.makeInfinity(1);
                    } else {
                        this.makeZero(1);
                    }
                } else if (real.sign == 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else {
                this.makeNan();
            }
            return;
        }
        if (real.isIntegral() && real.exponent <= 1073741854) {
            this.pow(real.toInteger());
            return;
        }
        byte by = 0;
        if (this.sign != 0) {
            if (real.isIntegral()) {
                if (real.isOdd()) {
                    by = 1;
                }
            } else {
                this.makeNan();
                return;
            }
            this.sign = 0;
        }
        Real.tmp1.mantissa = real.mantissa;
        Real.tmp1.exponent = real.exponent;
        Real.tmp1.sign = real.sign;
        if (Real.tmp1.exponent <= 1073741854) {
            Real.tmp2.mantissa = Real.tmp1.mantissa;
            Real.tmp2.exponent = Real.tmp1.exponent;
            Real.tmp2.sign = Real.tmp1.sign;
            tmp2.floor();
            Real.tmp3.mantissa = this.mantissa;
            Real.tmp3.exponent = this.exponent;
            Real.tmp3.sign = this.sign;
            tmp3.pow(tmp2.toInteger());
            tmp1.sub(tmp2);
        } else {
            Real.tmp3.mantissa = Real.ONE.mantissa;
            Real.tmp3.exponent = Real.ONE.exponent;
            Real.tmp3.sign = Real.ONE.sign;
        }
        int n = this.exponent - 0x40000000;
        this.exponent = 0x40000000;
        this.lnInternal();
        tmp2.assign(0, 0x40000000, 6653256548922161245L);
        long l = this.mul128(0L, tmp2, -2358760956788564156L);
        tmp2.assign(n);
        l = this.add128(l, tmp2, 0L);
        l = tmp1.mul128(0L, this, l);
        tmp1.exp2Internal(l);
        this.mantissa = Real.tmp1.mantissa;
        this.exponent = Real.tmp1.exponent;
        this.sign = Real.tmp1.sign;
        this.mul(tmp3);
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = by;
        }
    }

    private void sinInternal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.sqr();
        tmp2.neg();
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        Real.tmp3.mantissa = Real.ONE.mantissa;
        Real.tmp3.exponent = Real.ONE.exponent;
        Real.tmp3.sign = Real.ONE.sign;
        for (int i = 19; i >= 3; i -= 2) {
            this.mul(tmp2);
            tmp3.mul(i * (i - 1));
            this.add(tmp3);
        }
        this.mul(tmp1);
        this.div(tmp3);
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.abs();
        }
    }

    private void cosInternal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.sqr();
        tmp2.neg();
        this.mantissa = Real.tmp2.mantissa;
        this.exponent = Real.tmp2.exponent;
        this.sign = Real.tmp2.sign;
        Real.tmp3.mantissa = Real.ONE.mantissa;
        Real.tmp3.exponent = Real.ONE.exponent;
        Real.tmp3.sign = Real.ONE.sign;
        for (int i = 18; i >= 4; i -= 2) {
            tmp3.mul(i * (i - 1));
            this.add(tmp3);
            this.mul(tmp2);
        }
        tmp3.scalbn(1);
        this.div(tmp3);
        this.add(ONE);
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.abs();
        }
    }

    public void sin() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            if (this.exponent != 0 || this.mantissa != 0L) {
                this.makeNan();
            }
            return;
        }
        boolean bl = false;
        if (this.sign != 0) {
            this.abs();
            bl = true;
        }
        if (this.compare(PI2) > 0) {
            this.modInternal(PI2, 7089564414062235241L);
        }
        if (this.compare(PI) > 0) {
            this.sub(PI2);
            this.neg();
            boolean bl2 = bl = !bl;
        }
        if (this.compare(PI_2) > 0) {
            this.sub(PI);
            this.neg();
        }
        if (this.compare(PI_4) > 0) {
            this.sub(PI_2);
            this.neg();
            this.cosInternal();
        } else {
            this.sinInternal();
        }
        if (bl) {
            this.neg();
        }
    }

    public void cos() {
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.sign != 0) {
            this.abs();
        }
        if (this.compare(PI_4) < 0) {
            this.cosInternal();
        } else {
            this.add(PI_2);
            this.sin();
        }
    }

    public void tan() {
        Real.tmp4.mantissa = this.mantissa;
        Real.tmp4.exponent = this.exponent;
        Real.tmp4.sign = this.sign;
        tmp4.cos();
        this.sin();
        this.div(tmp4);
    }

    public void asin() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.sqr();
        this.neg();
        this.add(ONE);
        this.rsqrt();
        this.mul(tmp1);
        this.atan();
    }

    public void acos() {
        boolean bl = this.sign != 0;
        this.abs();
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.sqr();
        this.neg();
        this.add(ONE);
        this.sqrt();
        this.div(tmp1);
        this.atan();
        if (bl) {
            this.neg();
            this.add(PI);
        }
    }

    private void atanInternal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.sqr();
        tmp2.neg();
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        Real.tmp3.mantissa = Real.ONE.mantissa;
        Real.tmp3.exponent = Real.ONE.exponent;
        Real.tmp3.sign = Real.ONE.sign;
        for (int i = 45; i >= 3; i -= 2) {
            this.mul(tmp2);
            this.mul(i - 2);
            tmp3.mul(i);
            this.add(tmp3);
        }
        this.mul(tmp1);
        this.div(tmp3);
    }

    public void atan() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            byte by = this.sign;
            this.mantissa = Real.PI_2.mantissa;
            this.exponent = Real.PI_2.exponent;
            this.sign = Real.PI_2.sign;
            this.sign = by;
            return;
        }
        byte by = this.sign;
        this.sign = 0;
        boolean bl = false;
        if (this.compare(ONE) > 0) {
            bl = true;
            this.recip();
        }
        Real.tmp1.mantissa = Real.SQRT2.mantissa;
        Real.tmp1.exponent = Real.SQRT2.exponent;
        Real.tmp1.sign = Real.SQRT2.sign;
        tmp1.sub(ONE);
        boolean bl2 = false;
        if (this.compare(tmp1) > 0) {
            bl2 = true;
            Real.tmp2.mantissa = this.mantissa;
            Real.tmp2.exponent = this.exponent;
            Real.tmp2.sign = this.sign;
            this.sub(tmp1);
            tmp2.mul(tmp1);
            tmp2.add(ONE);
            this.div(tmp2);
        }
        this.atanInternal();
        if (bl2) {
            this.add(PI_8);
        }
        if (bl) {
            this.neg();
            this.add(PI_2);
        }
        this.sign = by;
    }

    public void atan2(Real real) {
        if (this.exponent < 0 && this.mantissa != 0L || real.exponent < 0 && real.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L && real.exponent < 0 && real.mantissa == 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L && real.exponent == 0 && real.mantissa == 0L) {
            return;
        }
        byte by = this.sign;
        byte by2 = real.sign;
        this.sign = 0;
        real.sign = 0;
        this.div(real);
        this.atan();
        if (by2 != 0) {
            this.neg();
            this.add(PI);
        }
        this.sign = by;
    }

    public void sinh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.neg();
        tmp1.exp();
        this.exp();
        this.sub(tmp1);
        this.scalbn(-1);
    }

    public void cosh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.neg();
        tmp1.exp();
        this.exp();
        this.add(tmp1);
        this.scalbn(-1);
    }

    public void tanh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.neg();
        tmp1.exp();
        this.exp();
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.add(tmp1);
        this.sub(tmp1);
        this.div(tmp2);
    }

    public void asinh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.sqr();
        tmp1.add(ONE);
        tmp1.sqrt();
        this.add(tmp1);
        this.ln();
    }

    public void acosh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.sqr();
        tmp1.sub(ONE);
        tmp1.sqrt();
        this.add(tmp1);
        this.ln();
    }

    public void atanh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.neg();
        tmp1.add(ONE);
        this.add(ONE);
        this.div(tmp1);
        this.ln();
        this.scalbn(-1);
    }

    public void fact() {
        if (this.exponent < 0) {
            return;
        }
        if (!this.isIntegral() || this.compare(ZERO) < 0 || this.compare(200) > 0) {
            this.add(ONE);
            this.gamma();
            return;
        }
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        while (tmp1.compare(ONE) > 0) {
            this.mul(tmp1);
            tmp1.sub(ONE);
        }
    }

    public void gamma() {
        if (this.exponent < 0) {
            return;
        }
        boolean bl = this.sign != 0;
        this.abs();
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = Real.ONE.mantissa;
        Real.tmp2.exponent = Real.ONE.exponent;
        Real.tmp2.sign = Real.ONE.sign;
        boolean bl2 = false;
        while (this.compare(20) < 0) {
            bl2 = true;
            tmp2.mul(this);
            this.add(ONE);
        }
        Real.tmp3.mantissa = this.mantissa;
        Real.tmp3.exponent = this.exponent;
        Real.tmp3.sign = this.sign;
        Real.tmp4.mantissa = this.mantissa;
        Real.tmp4.exponent = this.exponent;
        Real.tmp4.sign = this.sign;
        tmp4.sqr();
        this.ln();
        Real.tmp5.mantissa = Real.tmp3.mantissa;
        Real.tmp5.exponent = Real.tmp3.exponent;
        Real.tmp5.sign = Real.tmp3.sign;
        tmp5.sub(HALF);
        this.mul(tmp5);
        this.sub(tmp3);
        tmp5.assign(0, 0x3FFFFFFF, 8475711970748322458L);
        this.add(tmp5);
        tmp5.assign(12);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.add(tmp5);
        tmp3.mul(tmp4);
        tmp5.assign(360);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.sub(tmp5);
        tmp3.mul(tmp4);
        tmp5.assign(1260);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.add(tmp5);
        tmp3.mul(tmp4);
        tmp5.assign(1680);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.sub(tmp5);
        tmp3.mul(tmp4);
        tmp5.assign(1188);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.add(tmp5);
        this.exp();
        if (bl2) {
            this.div(tmp2);
        }
        if (bl) {
            Real.tmp5.mantissa = Real.tmp1.mantissa;
            Real.tmp5.exponent = Real.tmp1.exponent;
            Real.tmp5.sign = Real.tmp1.sign;
            this.mul(tmp5);
            tmp5.scalbn(-1);
            tmp5.frac();
            tmp5.mul(PI2);
            tmp5.sin();
            this.mul(tmp5);
            this.recip();
            this.mul(PI);
            this.neg();
        }
    }

    private void erfc1Internal() {
        long l = 0L;
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        long l2 = 0L;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        long l3 = tmp2.mul128(0L, tmp2, 0L);
        tmp2.neg();
        Real.tmp3.mantissa = Real.ONE.mantissa;
        Real.tmp3.exponent = Real.ONE.exponent;
        Real.tmp3.sign = Real.ONE.sign;
        long l4 = 0L;
        int n = 1;
        do {
            l2 = tmp1.mul128(l2, tmp2, l3);
            tmp4.assign(n);
            l4 = tmp3.mul128(l4, tmp4, 0L);
            tmp4.assign(2 * n + 1);
            long l5 = tmp4.mul128(0L, tmp3, l4);
            l5 = tmp4.recip128(l5);
            l5 = tmp4.mul128(l5, tmp1, l2);
            l = this.add128(l, tmp4, l5);
            ++n;
        } while (this.exponent - Real.tmp4.exponent < 128);
        tmp1.assign(1, 0x40000000, 5203730428379116614L);
        l = this.mul128(l, tmp1, -5122205486241848926L);
        l = this.add128(l, ONE, 0L);
        this.roundFrom128(l);
    }

    private void erfc2Internal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.sqr();
        tmp2.assign(0, 0x40000000, 6645080718195083435L);
        tmp2.mul(tmp1);
        tmp2.sub(HALF);
        int n = tmp2.toInteger();
        if (n > 64) {
            n = 64;
        }
        tmp1.scalbn(1);
        int n2 = tmp1.toInteger() + 1;
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.recip();
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        Real.tmp3.mantissa = this.mantissa;
        Real.tmp3.exponent = this.exponent;
        Real.tmp3.sign = this.sign;
        tmp3.sqr();
        tmp3.neg();
        tmp3.scalbn(-1);
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        Real.tmp4.mantissa = Real.ONE.mantissa;
        Real.tmp4.exponent = Real.ONE.exponent;
        Real.tmp4.sign = Real.ONE.sign;
        int n3 = 1;
        do {
            tmp4.mul(2 * n3 - 1);
            tmp4.mul(tmp3);
            this.add(tmp4);
        } while (Real.tmp4.exponent - 0x40000000 > -(n + 2) && 2 * ++n3 - 1 < n2);
        this.mul(tmp2);
        tmp1.sqr();
        tmp1.neg();
        tmp1.exp();
        this.mul(tmp1);
        tmp1.assign(0, 0x3FFFFFFF, 5203730428379116615L);
        this.mul(tmp1);
    }

    public void erfc() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || this.toInteger() > 27281) {
            if (this.sign != 0) {
                this.mantissa = Real.TWO.mantissa;
                this.exponent = Real.TWO.exponent;
                this.sign = Real.TWO.sign;
            } else {
                this.makeZero(0);
            }
            return;
        }
        byte by = this.sign;
        this.sign = 0;
        tmp1.assign(0, 0x40000002, 6271892985061247549L);
        if (this.lessThan(tmp1)) {
            this.erfc1Internal();
        } else {
            this.erfc2Internal();
        }
        if (by != 0) {
            this.neg();
            this.add(TWO);
        }
    }

    private static int floorDiv(int n, int n2) {
        if (n >= 0) {
            return n / n2;
        }
        return -((-n + n2 - 1) / n2);
    }

    private static int floorMod(int n, int n2) {
        if (n >= 0) {
            return n % n2;
        }
        return n + (-n + n2 - 1) / n2 * n2;
    }

    private static boolean leap_gregorian(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static int gregorian_to_jd(int n, int n2, int n3) {
        return 365 + 365 * (n - 1) + Real.floorDiv(n - 1, 4) + -Real.floorDiv(n - 1, 100) + Real.floorDiv(n - 1, 400) + ((367 * n2 - 362) / 12 + (n2 <= 2 ? 0 : (Real.leap_gregorian(n) ? -1 : -2)) + n3);
    }

    public static int jd_to_gregorian(int n) {
        int n2 = n;
        int n3 = n2 - 366;
        int n4 = Real.floorDiv(n3, 146097);
        int n5 = Real.floorMod(n3, 146097);
        int n6 = Real.floorDiv(n5, 36524);
        int n7 = Real.floorMod(n5, 36524);
        int n8 = Real.floorDiv(n7, 1461);
        int n9 = Real.floorMod(n7, 1461);
        int n10 = Real.floorDiv(n9, 365);
        int n11 = n4 * 400 + n6 * 100 + n8 * 4 + n10;
        if (n6 != 4 && n10 != 4) {
            ++n11;
        }
        int n12 = n2 - Real.gregorian_to_jd(n11, 1, 1);
        int n13 = n2 < Real.gregorian_to_jd(n11, 3, 1) ? 0 : (Real.leap_gregorian(n11) ? 1 : 2);
        int n14 = Real.floorDiv((n12 + n13) * 12 + 373, 367);
        int n15 = n2 - Real.gregorian_to_jd(n11, n14, 1) + 1;
        return (n11 * 100 + n14) * 100 + n15;
    }

    public void toDHMS() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        boolean bl = this.sign != 0;
        this.abs();
        long l = this.toLong();
        this.frac();
        tmp1.assign(60);
        this.mul(tmp1);
        int n = this.toInteger();
        this.frac();
        this.mul(tmp1);
        Real.tmp2.mantissa = Real.ONE.mantissa;
        Real.tmp2.exponent = Real.ONE.exponent;
        Real.tmp2.sign = Real.ONE.sign;
        tmp2.scalbn(-16);
        this.add(tmp2);
        if (this.compare(tmp1) >= 0) {
            this.mantissa = Real.ZERO.mantissa;
            this.exponent = Real.ZERO.exponent;
            this.sign = Real.ZERO.sign;
            if (++n >= 60) {
                n -= 60;
                ++l;
            }
        } else {
            this.sub(tmp2);
        }
        int n2 = (int)(l / 24L);
        l %= 24L;
        if (n2 >= 366) {
            n2 = Real.jd_to_gregorian(n2);
        }
        this.add(n * 100);
        this.div(10000);
        tmp1.assign((long)n2 * 100L + l);
        this.add(tmp1);
        if (bl) {
            this.neg();
        }
    }

    public void fromDHMS() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        boolean bl = this.sign != 0;
        this.abs();
        long l = this.toLong();
        this.frac();
        tmp1.assign(100);
        this.mul(tmp1);
        int n = this.toInteger();
        this.frac();
        this.mul(tmp1);
        Real.tmp2.mantissa = Real.ONE.mantissa;
        Real.tmp2.exponent = Real.ONE.exponent;
        Real.tmp2.sign = Real.ONE.sign;
        tmp2.scalbn(-10);
        this.add(tmp2);
        if (this.compare(tmp1) >= 0) {
            this.mantissa = Real.ZERO.mantissa;
            this.exponent = Real.ZERO.exponent;
            this.sign = Real.ZERO.sign;
            if (++n >= 100) {
                n -= 100;
                ++l;
            }
        } else {
            this.sub(tmp2);
        }
        int n2 = (int)(l / 100L);
        l %= 100L;
        if (n2 >= 10000) {
            int n3 = n2 / 100;
            if ((n2 %= 100) == 0) {
                n2 = 1;
            }
            int n4 = n3 / 100;
            if ((n3 %= 100) == 0) {
                n3 = 1;
            }
            n2 = Real.gregorian_to_jd(n4, n3, n2);
        }
        this.add(n * 60);
        this.div(3600);
        tmp1.assign((long)n2 * 24L + l);
        this.add(tmp1);
        if (bl) {
            this.neg();
        }
    }

    public void time() {
        long l = System.currentTimeMillis();
        int n = (int)((l /= 1000L) % 60L);
        int n2 = (int)((l /= 60L) % 60L);
        int n3 = (int)((l /= 60L) % 24L);
        this.assign((n3 * 100 + n2) * 100 + n);
        this.div(10000);
    }

    public void date() {
        long l = System.currentTimeMillis();
        l /= 86400000L;
        this.assign(l *= 24L);
        this.add(17268672);
        this.toDHMS();
    }

    private static void advanceBit() {
        randSeedA = randSeedA << 1 ^ (long)(randSeedA < 0L ? 27 : 0);
        randSeedB = randSeedB << 1 ^ (randSeedB < 0L ? -5764607523034234879L : 0L);
    }

    private static long nextBits(int n) {
        long l = 0L;
        while (n-- > 0) {
            while (randSeedA >= 0L) {
                Real.advanceBit();
            }
            l = (l << 1) + (long)(randSeedB < 0L ? 1 : 0);
            Real.advanceBit();
        }
        return l;
    }

    public static void accumulateRandomness(long l) {
        randSeedA ^= l & 0x5555555555555555L;
        randSeedB ^= l & 0xAAAAAAAAAAAAAAAAL;
        Real.nextBits(63);
    }

    public void random() {
        this.sign = 0;
        this.exponent = 0x3FFFFFFF;
        this.mantissa = Real.nextBits(63);
        this.normalize();
    }

    private int digit(char c, int n, boolean bl) {
        int n2 = -1;
        if (c >= '0' && c <= '9') {
            n2 = c - 48;
        } else if (c >= 'A' && c <= 'F') {
            n2 = c - 65 + 10;
        }
        if (n2 >= n) {
            return -1;
        }
        if (bl) {
            n2 ^= n - 1;
        }
        return n2;
    }

    private void shiftUp(int n) {
        if (n == 2) {
            this.scalbn(1);
        } else if (n == 8) {
            this.scalbn(3);
        } else if (n == 16) {
            this.scalbn(4);
        } else {
            this.mul10();
        }
    }

    private void atof(String string, int n) {
        int n2;
        int n3;
        this.makeZero();
        int n4 = string.length();
        byte by = 0;
        boolean bl = false;
        for (n3 = 0; n3 < n4 && string.charAt(n3) == ' '; ++n3) {
        }
        if (n3 < n4 && string.charAt(n3) == '-') {
            by = 1;
            ++n3;
        } else if (n3 < n4 && string.charAt(n3) == '+') {
            ++n3;
        } else if (n3 < n4 && string.charAt(n3) == '/') {
            bl = true;
            by = 1;
            ++n3;
        }
        while (n3 < n4 && (n2 = this.digit(string.charAt(n3), n, bl)) >= 0) {
            this.shiftUp(n);
            this.add(n2);
            ++n3;
        }
        if (n3 < n4 && (string.charAt(n3) == '.' || string.charAt(n3) == ',')) {
            ++n3;
            Real.tmp2.mantissa = Real.ONE.mantissa;
            Real.tmp2.exponent = Real.ONE.exponent;
            Real.tmp2.sign = Real.ONE.sign;
            while (n3 < n4 && (n2 = this.digit(string.charAt(n3), n, bl)) >= 0) {
                tmp2.shiftUp(n);
                this.shiftUp(n);
                this.add(n2);
                ++n3;
            }
            if (bl) {
                this.add(ONE);
            }
            this.div(tmp2);
        } else if (bl) {
            this.add(ONE);
        }
        while (n3 < n4 && string.charAt(n3) == ' ') {
            ++n3;
        }
        if (n3 < n4 && (string.charAt(n3) == 'e' || string.charAt(n3) == 'E')) {
            int n5 = 0;
            boolean bl2 = false;
            if (++n3 < n4 && string.charAt(n3) == '-') {
                bl2 = true;
                ++n3;
            } else if (n3 < n4 && string.charAt(n3) == '+') {
                ++n3;
            }
            while (n3 < n4 && string.charAt(n3) >= '0' && string.charAt(n3) <= '9') {
                if (n5 < 400000000) {
                    n5 = n5 * 10 + (string.charAt(n3) - 48);
                }
                ++n3;
            }
            if (bl2) {
                n5 = -n5;
            }
            if (n == 2) {
                this.scalbn(n5);
            } else if (n == 8) {
                this.scalbn(n5 * 3);
            } else if (n == 16) {
                this.scalbn(n5 * 4);
            } else {
                if (this.exponent > 300000000 || this.exponent < -300000000) {
                    Real.tmp1.mantissa = Real.TEN.mantissa;
                    Real.tmp1.exponent = Real.TEN.exponent;
                    Real.tmp1.sign = Real.TEN.sign;
                    tmp1.pow(n5 / 2);
                    this.mul(tmp1);
                    n5 -= n5 / 2;
                }
                Real.tmp1.mantissa = Real.TEN.mantissa;
                Real.tmp1.exponent = Real.TEN.exponent;
                Real.tmp1.sign = Real.TEN.sign;
                tmp1.pow(n5);
                this.mul(tmp1);
            }
        }
        this.sign = by;
    }

    private void normalizeBCD() {
        if (this.mantissa == 0L) {
            this.exponent = 0;
            return;
        }
        int n = 0;
        for (int i = 0; i < 64; i += 4) {
            int n2 = (int)(this.mantissa >>> i & 0xFL) + n;
            n = 0;
            if (n2 >= 10) {
                n2 -= 10;
                n = 1;
            }
            this.mantissa &= 15L << i ^ 0xFFFFFFFFFFFFFFFFL;
            this.mantissa += (long)n2 << i;
        }
        if (n != 0) {
            if ((int)(this.mantissa & 0xFL) >= 5) {
                this.mantissa += 16L;
            }
            this.mantissa >>>= 4;
            this.mantissa += 0x1000000000000000L;
            ++this.exponent;
            if ((int)(this.mantissa & 0xFL) >= 10) {
                this.normalizeBCD();
            }
        }
        while (this.mantissa >>> 60 == 0L) {
            this.mantissa <<= 4;
            --this.exponent;
        }
    }

    private void toBCD() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.abs();
        Real.tmp2.mantissa = Real.tmp1.mantissa;
        Real.tmp2.exponent = Real.tmp1.exponent;
        Real.tmp2.sign = Real.tmp1.sign;
        this.exponent = tmp1.lowPow10();
        if (this.exponent > 300000000 || this.exponent < -300000000) {
            Real.tmp1.mantissa = Real.TEN.mantissa;
            Real.tmp1.exponent = Real.TEN.exponent;
            Real.tmp1.sign = Real.TEN.sign;
            tmp1.pow(this.exponent / 2);
            tmp2.div(tmp1);
            Real.tmp1.mantissa = Real.TEN.mantissa;
            Real.tmp1.exponent = Real.TEN.exponent;
            Real.tmp1.sign = Real.TEN.sign;
            tmp1.pow(this.exponent - this.exponent / 2);
        }
        tmp2.div(tmp1);
        this.mantissa = 0L;
        for (int i = 60; i >= 0; i -= 4) {
            Real.tmp1.mantissa = Real.tmp2.mantissa;
            Real.tmp1.exponent = Real.tmp2.exponent;
            Real.tmp1.sign = Real.tmp2.sign;
            tmp1.floor();
            this.mantissa += (long)tmp1.toInteger() << i;
            tmp2.sub(tmp1);
            tmp2.mul10();
        }
        if (tmp2.compare(FIVE) >= 0) {
            ++this.mantissa;
        }
        this.normalizeBCD();
    }

    private boolean testCarryWhenRounded(int n, int n2, int n3) {
        if (this.mantissa >= 0L) {
            return false;
        }
        int n4 = 64 - n3 * n2;
        if (n4 <= 0) {
            return false;
        }
        Real.tmp5.mantissa = this.mantissa;
        Real.tmp5.exponent = this.exponent;
        Real.tmp5.sign = this.sign;
        if (n == 10) {
            Real.tmp5.mantissa += 5L << n4 - 4;
            tmp5.normalizeBCD();
        } else {
            Real.tmp5.mantissa += 1L << n4 - 1;
        }
        if (Real.tmp5.mantissa >= 0L) {
            this.mantissa = 1L << 64 - n2;
            ++this.exponent;
            return true;
        }
        return false;
    }

    private void round(int n, int n2, int n3) {
        if (this.exponent == 0 && this.mantissa == 0L) {
            return;
        }
        int n4 = 64 - n3 * n2;
        if (n4 <= 0) {
            return;
        }
        long l = this.mantissa;
        if (n == 10) {
            this.mantissa += 5L << n4 - 4;
            this.normalizeBCD();
        } else {
            this.mantissa += 1L << n4 - 1;
        }
        if (l < 0L && this.mantissa >= 0L) {
            this.mantissa = 1L << 64 - n2;
            ++this.exponent;
        }
    }

    private String ftoa(NumberFormat numberFormat) {
        char c;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.exponent < 0 && this.mantissa != 0L) {
            return "nan";
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return this.sign != 0 ? "-inf" : "inf";
        }
        switch (numberFormat.base) {
            case 2: {
                n5 = 1;
                n4 = 8;
                break;
            }
            case 8: {
                n5 = 3;
                n4 = 1000;
                break;
            }
            case 16: {
                n5 = 4;
                n4 = 4;
                break;
            }
            default: {
                n5 = 4;
                n4 = 3;
            }
        }
        if (numberFormat.thousand == '\u0000') {
            n4 = 1000;
        }
        int n6 = 64;
        Real.tmp4.mantissa = this.mantissa;
        Real.tmp4.exponent = this.exponent;
        Real.tmp4.sign = this.sign;
        if (this.exponent == 0 && this.mantissa == 0L) {
            Real.tmp4.exponent = 0;
            if (numberFormat.base != 10) {
                Real.tmp4.sign = 0;
            }
        } else if (numberFormat.base == 10) {
            tmp4.toBCD();
        } else {
            if (Real.tmp4.sign != 0) {
                Real.tmp4.mantissa = -Real.tmp4.mantissa;
                if (Real.tmp4.mantissa >>> 62 == 3L) {
                    Real.tmp4.mantissa <<= 1;
                    --Real.tmp4.exponent;
                    --n6;
                }
            }
            Real.tmp4.exponent -= 0x3FFFFFFF;
            n3 = n5 - 1 - Real.floorMod(Real.tmp4.exponent, n5);
            Real.tmp4.exponent = Real.floorDiv(Real.tmp4.exponent, n5);
            if (n3 == n5 - 1) {
                Real.tmp4.mantissa <<= 1;
                --Real.tmp4.exponent;
                --n6;
            } else if (n3 > 0) {
                Real.tmp4.mantissa = Real.tmp4.mantissa + (1L << n3 - 1) >>> n3;
                if (Real.tmp4.sign != 0) {
                    Real.tmp4.mantissa |= Long.MIN_VALUE >> n3 - 1;
                }
            }
        }
        n3 = (n6 + n5 - 1) / n5;
        int n7 = 0;
        do {
            n = numberFormat.maxwidth - 1;
            c = '\u0000';
            if (numberFormat.base != 10) {
                c = '\u0001';
            } else if (Real.tmp4.sign != 0) {
                --n;
            }
            boolean bl = false;
            switch (numberFormat.fse) {
                case 2: {
                    n2 = numberFormat.precision + 1;
                    bl = true;
                    break;
                }
                case 3: {
                    n7 = Real.floorMod(Real.tmp4.exponent, 3);
                    n2 = numberFormat.precision + 1 + n7;
                    bl = true;
                    break;
                }
                default: {
                    n2 = 1000;
                    if (numberFormat.fse == 1) {
                        n2 = numberFormat.precision + 1;
                    }
                    if (Real.tmp4.exponent + 1 > n - (Real.tmp4.exponent + c) / n4 - c + (numberFormat.removePoint ? 1 : 0) || Real.tmp4.exponent + 1 > n3 || -Real.tmp4.exponent >= n || -Real.tmp4.exponent >= n2) {
                        bl = true;
                        break;
                    }
                    n7 = Real.tmp4.exponent;
                    n2 += Real.tmp4.exponent;
                    if (Real.tmp4.exponent > 0) {
                        n -= (Real.tmp4.exponent + c) / n4;
                    }
                    if (!numberFormat.removePoint || Real.tmp4.exponent != n - c) break;
                    ++n;
                }
            }
            if (c != '\u0000' && n7 >= 0) {
                n -= c;
            }
            ftoaExp.setLength(0);
            if (bl) {
                ftoaExp.append('e');
                ftoaExp.append(Real.tmp4.exponent - n7);
                n -= ftoaExp.length();
            }
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 > n) {
                n2 = n;
            }
            if (n2 > n + n7) {
                n2 = n + n7;
            }
            if (n2 > 0) continue;
            n2 = 1;
        } while (tmp4.testCarryWhenRounded(numberFormat.base, n5, n2));
        tmp4.round(numberFormat.base, n5, n2);
        ftoaBuf.setLength(0);
        if (Real.tmp4.sign != 0 && numberFormat.base == 10) {
            ftoaBuf.append('-');
        }
        n = n7;
        char c2 = c = numberFormat.base == 10 || Real.tmp4.sign == 0 ? (char)'0' : hexChar.charAt(numberFormat.base - 1);
        if (n7 < 0) {
            ftoaBuf.append(c);
            ftoaBuf.append(numberFormat.point);
            while (n7 < -1) {
                ftoaBuf.append(c);
                ++n7;
            }
        }
        while (n2 > 0) {
            ftoaBuf.append(hexChar.charAt((int)(Real.tmp4.mantissa >>> 64 - n5)));
            Real.tmp4.mantissa <<= n5;
            if (n7 > 0 && n7 % n4 == 0) {
                ftoaBuf.append(numberFormat.thousand);
            }
            if (n7 == 0) {
                ftoaBuf.append(numberFormat.point);
            }
            --n2;
            --n7;
        }
        if (numberFormat.fse == 0) {
            while (ftoaBuf.charAt(ftoaBuf.length() - 1) == '0') {
                ftoaBuf.setLength(ftoaBuf.length() - 1);
            }
        }
        if (numberFormat.removePoint && ftoaBuf.charAt(ftoaBuf.length() - 1) == numberFormat.point) {
            ftoaBuf.setLength(ftoaBuf.length() - 1);
        }
        ftoaBuf.append((Object)ftoaExp);
        if (numberFormat.base != 10) {
            while (ftoaBuf.length() < numberFormat.maxwidth) {
                if (++n > 0 && n % n4 == 0) {
                    ftoaBuf.insert(0, numberFormat.thousand);
                }
                if (ftoaBuf.length() >= numberFormat.maxwidth) continue;
                ftoaBuf.insert(0, c);
            }
            if (ftoaBuf.charAt(0) == numberFormat.thousand) {
                ftoaBuf.deleteCharAt(0);
            }
        }
        return ftoaBuf.toString();
    }

    public String toString() {
        Real.tmpFormat.base = 10;
        return this.ftoa(tmpFormat);
    }

    public String toString(int n) {
        Real.tmpFormat.base = n;
        return this.ftoa(tmpFormat);
    }

    public String toString(NumberFormat numberFormat) {
        return this.ftoa(numberFormat);
    }

    public static class NumberFormat {
        public int base = 10;
        public int maxwidth = 30;
        public int precision = 16;
        public int fse = 0;
        public char point = (char)46;
        public boolean removePoint = true;
        public char thousand = '\u0000';
        public static final int FSE_NONE = 0;
        public static final int FSE_FIX = 1;
        public static final int FSE_SCI = 2;
        public static final int FSE_ENG = 3;

        NumberFormat() {
        }
    }
}

