/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class BTInquiry
implements DiscoveryListener,
CommandListener {
    private DiscoveryAgent discoveryAgent;
    public Vector devices = new Vector();
    public Vector records = new Vector();
    private Object prevScreen = new Object();
    private List devicesList = new List(null, 3);
    Command cmdSelect = new Command("Select", 4, 1);
    Command cmdBack = new Command("Back", 2, 2);
    private Display display;
    UUID[] uuidSet;
    int[] attrSet;
    private boolean BTReady;

    BTInquiry(Display display) {
        this.display = display;
    }

    public void startInquiry() {
        this.prevScreen = this.display.getCurrent();
        this.display.setCurrent((Displayable)this.devicesList);
        new Thread(){

            public void run() {
                BTInquiry.this.inquiryDevices();
            }
        }.start();
    }

    private void informError(String msg) {
        Alert al = new Alert("Error", msg, null, AlertType.ERROR);
        al.setTimeout(1000);
        this.display.setCurrent(al, this.display.getCurrent());
    }

    private synchronized void inquiryDevices() {
        this.BTReady = false;
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = localDevice.getDiscoveryAgent();
            this.BTReady = true;
        }
        catch (Exception e) {
            this.informError("Can't initialize bluetooth: " + e);
        }
        if (this.BTReady) {
            this.devicesList.deleteAll();
            this.devicesList.setTitle("Searching...");
            this.devicesList.setCommandListener((CommandListener)this);
            this.devices.removeAllElements();
            try {
                this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
            }
            catch (BluetoothStateException e) {
                this.informError("Can't start inquiry");
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.informError("Unknown error");
            }
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (this.devices.indexOf(btDevice) == -1) {
            this.devices.addElement(btDevice);
        }
        this.devicesList.append(btDevice.getBluetoothAddress(), null);
    }

    private void backToMScreen() {
        this.display.setCurrent((Displayable)this.prevScreen);
    }

    private void noDevices() {
        this.informError("No devices have been found :(");
        this.backToMScreen();
    }

    public void inquiryCompleted(int discType) {
        if (this.devices.size() == 0) {
            this.noDevices();
        } else {
            new Thread(){

                public void run() {
                    BTInquiry.this.searchServices();
                }
            }.start();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.cmdSelect) {
            if (this.devices.size() != 0) {
                String url;
                int index = this.devicesList.getSelectedIndex();
                BTRadio.bturl = url = ((ServiceRecord)this.records.elementAt(index)).getConnectionURL(0, false);
                Settings.setParam("bturl", url);
                this.devicesList.append("fuck", null);
                this.devicesList.append(url, null);
                this.backToMScreen();
            }
        } else if (c == this.cmdBack) {
            this.backToMScreen();
        }
    }

    public synchronized void searchServices() {
        this.devicesList.deleteAll();
        this.records.removeAllElements();
        this.uuidSet = new UUID[]{new UUID("F0E0D0C0B0A000908070605040302010", false)};
        this.attrSet = new int[]{17185};
        this.devicesList.setTitle("Searching services...");
        int i = 0;
        while (i < this.devices.size()) {
            RemoteDevice RD = (RemoteDevice)this.devices.elementAt(i);
            try {
                this.discoveryAgent.searchServices(null, this.uuidSet, RD, (DiscoveryListener)this);
                this.wait();
            }
            catch (BluetoothStateException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.backToMScreen();
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        int i = 0;
        while (i < servRecord.length) {
            this.records.addElement(servRecord[i]);
            this.devicesList.append(((ServiceRecord)this.records.elementAt(i)).getHostDevice().getBluetoothAddress(), null);
            ++i;
        }
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        this.devicesList.setTitle("Search completed.");
        this.devicesList.addCommand(this.cmdBack);
        this.devicesList.addCommand(this.cmdSelect);
        int i = 0;
        while (i < this.records.size()) {
            String deviceName = ((ServiceRecord)this.records.elementAt(i)).getConnectionURL(0, false);
            this.devicesList.set(i, deviceName, null);
            ++i;
        }
    }
}

