/*
 * Decompiled with CFR 0.152.
 */
package com.vmx;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class BufDataInputStream
implements DataInput {
    byte[] buffer;
    int bmax;
    int blen;
    int bpos;
    InputStream is;

    public BufDataInputStream(int bufsize, InputStream iis) throws IOException {
        if (bufsize <= 0) {
            throw new IOException("Buffer size must be greater than 0");
        }
        this.bmax = bufsize;
        this.blen = 0;
        this.bpos = 0;
        this.buffer = new byte[this.bmax];
        this.is = iis;
    }

    public void close() throws IOException {
        this.is.close();
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public void reset() throws IOException {
        this.is.reset();
    }

    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int rest;
        int n;
        int pos = off;
        for (rest = len; rest > 0; rest -= n) {
            if (this.bpos >= this.blen) {
                this.bpos = 0;
                this.blen = this.is.read(this.buffer, 0, this.bmax);
                if (this.blen == 0) break;
            }
            if ((n = rest) > this.blen - this.bpos) {
                n = this.blen - this.bpos;
            }
            System.arraycopy(this.buffer, this.bpos, b, pos, n);
            pos += n;
            this.bpos += n;
        }
        return len - rest;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        if (this.bpos >= this.blen) {
            this.bpos = 0;
            this.blen = this.is.read(this.buffer, 0, this.bmax);
            if (this.blen == 0) {
                return -1;
            }
        }
        return this.buffer[this.bpos++] & 0xFF;
    }

    public void flush() throws IOException {
        if (this.bpos != 0 && this.bpos != this.blen) {
            System.arraycopy(this.buffer, this.bpos, this.buffer, 0, this.blen - this.bpos);
        }
        this.blen -= this.bpos;
        this.bpos = 0;
        this.blen += this.is.read(this.buffer, this.blen, this.bmax - this.blen);
    }

    public boolean readBoolean() throws IOException {
        int r = this.read();
        if (r == -1) {
            throw new IOException("EOF");
        }
        return r != 0;
    }

    public byte readByte() throws IOException {
        int r = this.read();
        if (r == -1) {
            throw new IOException("EOF");
        }
        return (byte)r;
    }

    public char readChar() throws IOException {
        return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] b) throws IOException {
        if (this.read(b) < b.length) {
            throw new IOException("EOF");
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.read(b, off, len) < len) {
            throw new IOException("EOF");
        }
    }

    public int readInt() throws IOException {
        return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    public long readLong() throws IOException {
        byte[] bb = new byte[8];
        this.readFully(bb);
        return bb[0] << 24 | bb[1] << 16 | bb[2] << 8 | bb[3];
    }

    public short readShort() throws IOException {
        return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public int skipBytes(int len) throws IOException {
        int rest = len;
        while (rest > 0) {
            int n;
            if (this.blen - this.bpos == 0) {
                this.bpos = 0;
                this.blen = this.is.read(this.buffer, 0, this.bmax);
                if (this.blen == 0) break;
            }
            if ((n = rest) > this.blen - this.bpos) {
                n = this.blen - this.bpos;
            }
            this.bpos += n;
        }
        return len - rest;
    }

    public String readUTF() throws IOException {
        String s = "";
        int n = this.readUnsignedShort();
        byte[] b = new byte[n];
        this.readFully(b);
        int i = 0;
        while (i < n) {
            if ((b[i] & 0x80) == 0) {
                s = s + (char)b[i++];
                continue;
            }
            if ((b[i] & 0xE0) == 192) {
                if (i >= n - 1 || (b[i + 1] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                s = s + (char)((b[i] & 0x1F) << 6 | b[i + 1] & 0x3F);
                i += 2;
                continue;
            }
            if ((b[i] & 0xF0) == 224) {
                if (i >= n - 2 || (b[i + 1] & 0xC0) != 128 || (b[i + 2] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                s = s + (char)((b[i] & 0xF) << 12 | (b[i + 1] & 0x3F) << 6 | b[i + 2] & 0x3F);
                i += 3;
                continue;
            }
            throw new UTFDataFormatException();
        }
        return s;
    }
}

