/*
 * Decompiled with CFR 0.152.
 */
package cameratoggler;

import cameratoggler.CameraTogglerMidlet;
import cameratoggler.SoundRenamer;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class CameraTogglerDisplayable
extends List
implements CommandListener {
    private int eLoadedState;
    private SoundRenamer renamer;
    private CameraTogglerMidlet parent;
    public int eUnlocked;

    public CameraTogglerDisplayable(CameraTogglerMidlet cameraTogglerMidlet) {
        super("Set Camera Sound", 3);
        this.parent = cameraTogglerMidlet;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isReady() {
        return this.eLoadedState != -1;
    }

    private void jbInit() throws Exception {
        boolean bl = false;
        this.renamer = new SoundRenamer();
        this.eLoadedState = this.renamer.getCameraSound();
        if (this.eLoadedState == -2) {
            this.eUnlocked = 0;
            bl = false;
            this.eLoadedState = -1;
        } else {
            this.eUnlocked = 1;
        }
        bl = this.eLoadedState == -1 ? false : this.eLoadedState == 0;
        this.setCommandListener(this);
        this.addCommand(new Command("Cancel", 3, 1));
        this.append("On", null);
        this.append("Off", null);
        if (bl) {
            this.setSelectedIndex(0, true);
        } else {
            this.setSelectedIndex(1, true);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 3) {
            CameraTogglerMidlet.quitApp();
        }
        if (command == List.SELECT_COMMAND) {
            if (this.getSelectedIndex() == 0) {
                if (this.eLoadedState == 0) {
                    this.parent.showAlert("Wait please", "Enabling sound...");
                    this.sleep(1000L);
                    this.renamer.setCameraSound(true);
                    this.parent.sleep(1000L);
                }
            } else {
                if (this.eLoadedState == 1) {
                    this.parent.showAlert("Wait please", "Disabling sound...");
                }
                this.sleep(1000L);
                this.renamer.setCameraSound(false);
                this.parent.sleep(1000L);
            }
            CameraTogglerMidlet.quitApp();
        }
    }
}

