/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class Clock
extends Canvas
implements CommandListener,
PlayerListener {
    private VoCo voco;
    private int hour;
    private int minute;
    private String[] playlist;
    private int current = 0;

    public Clock(VoCo voCo) {
        this.voco = voCo;
        this.setTitle("\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f");
        Calendar calendar = Calendar.getInstance();
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.setCommandListener(this);
        this.addCommand(this.voco.cmdBack);
        this.playlist = this.makePlaylist();
    }

    public void showNotify() {
        try {
            this.current = 0;
            Player player = Studio.getStudioVoice(this.playlist[0]);
            player.addPlayerListener((PlayerListener)this);
            player.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.voco.background, this.getWidth() / 2, 0, 1 | 0x10);
        Font font = Font.getFont((int)0, (int)1, (int)16);
        graphics.setFont(font);
        graphics.setColor(0xFFFFFF);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hour < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.hour).append(':');
        if (this.minute < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.minute);
        graphics.drawString(stringBuffer.toString(), this.getWidth() / 2, this.getHeight() / 2, 0x40 | 1);
    }

    public void keyRepeated(int n) {
        if (n == this.voco.PTT_KEY_CODE) {
            this.commandAction(this.voco.cmdBack, (Displayable)this);
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if ("endOfMedia".equals(string)) {
            player.removePlayerListener((PlayerListener)this);
            ++this.current;
            if (this.current < this.playlist.length) {
                try {
                    Player player2 = Studio.getStudioVoice(this.playlist[this.current]);
                    player2.addPlayerListener((PlayerListener)this);
                    player2.start();
                }
                catch (Exception exception) {}
            } else {
                this.commandAction(this.voco.cmdBack, (Displayable)this);
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.voco.cmdBack && this.voco.home()) {
            Studio.finalize();
            this.setCommandListener(null);
            this.removeCommand(this.voco.cmdBack);
            this.voco = null;
        }
    }

    private String[] makePlaylist() {
        Vector<String> vector = new Vector<String>();
        if (this.hour == 1 || this.hour == 2) {
            vector.addElement(Integer.toString(this.hour) + "h.wav");
        } else if (this.hour < 21) {
            vector.addElement(Integer.toString(this.hour) + ".wav");
        } else {
            vector.addElement("20.wav");
            if (this.hour - 20 == 1 || this.hour - 20 == 2) {
                vector.addElement(Integer.toString(this.hour - 20) + "h.wav");
            } else {
                vector.addElement(Integer.toString(this.hour - 20) + ".wav");
            }
        }
        if (this.hour % 10 == 1 && this.hour != 11) {
            vector.addElement("hour1.wav");
        } else if (this.hour == 2 || this.hour == 3 || this.hour == 4 || this.hour == 22 || this.hour == 23 || this.hour == 24) {
            vector.addElement("hour2.wav");
        } else {
            vector.addElement("hours.wav");
        }
        if (this.minute == 1 || this.minute == 2) {
            vector.addElement(Integer.toString(this.minute) + "m.wav");
        } else if (this.minute < 21 || this.minute % 10 == 0) {
            vector.addElement(Integer.toString(this.minute) + ".wav");
        } else {
            vector.addElement(Integer.toString(this.minute / 10 * 10) + ".wav");
            if (this.minute - this.minute / 10 * 10 == 1 || this.minute - this.minute / 10 * 10 == 2) {
                vector.addElement(Integer.toString(this.minute - this.minute / 10 * 10) + "m.wav");
            } else {
                vector.addElement(Integer.toString(this.minute - this.minute / 10 * 10) + ".wav");
            }
        }
        if (this.minute % 10 == 1 && this.minute != 11) {
            vector.addElement("minute1.wav");
        } else if (this.minute == 2 || this.minute == 3 || this.minute == 4 || this.minute > 20 && (this.minute % 10 == 2 || this.minute % 10 == 3 || this.minute % 10 == 4)) {
            vector.addElement("minute2.wav");
        } else {
            vector.addElement("minutes.wav");
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = "/" + (String)vector.elementAt(i);
        }
        vector.removeAllElements();
        return stringArray;
    }
}

