/*
 * Decompiled with CFR 0.152.
 */
import browser.AutoSearch;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.midlet.MIDlet;

public class Jukebox
extends Canvas
implements CommandListener,
PlayerListener {
    private VoCo voco;
    private String[] playlist;
    private int current = -1;
    private boolean repeat;
    private boolean shuffle;
    private Player player = null;

    public Jukebox(VoCo voCo, PlayerCommand playerCommand) {
        this.voco = voCo;
        this.setTitle("\u041f\u043b\u0435\u0435\u0440");
        this.setCommandListener(this);
        this.addCommand(this.voco.cmdBack);
        this.playlist = playerCommand.playlist;
        this.repeat = playerCommand.repeat;
        if (playerCommand.shuffle) {
            this.shuffle = true;
            this.shuffle();
        }
        this.current = -1;
    }

    public void showNotify() {
        final Jukebox jukebox = this;
        Display.getDisplay((MIDlet)this.voco).callSerially(new Runnable(){

            public void run() {
                try {
                    if (Jukebox.this.playlist.length == 0) {
                        Jukebox.access$002(Jukebox.this, AutoSearch.findFiles());
                        if (Jukebox.this.shuffle) {
                            Jukebox.this.shuffle();
                        }
                    }
                    if (Jukebox.this.player != null) {
                        Jukebox.this.player.start();
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (true) {
                    try {
                        Jukebox.this.current++;
                        if (Jukebox.this.current >= Jukebox.this.playlist.length) {
                            Jukebox.this.commandAction(((Jukebox)Jukebox.this).voco.cmdBack, null);
                            break;
                        }
                        Jukebox.this.player = Manager.createPlayer((String)("file:///" + Jukebox.this.playlist[Jukebox.this.current]));
                        Jukebox.this.player.addPlayerListener(jukebox);
                        Jukebox.this.player.start();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
                Jukebox.this.repaint();
            }
        });
    }

    public void pause() {
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop() {
        if (this.player != null) {
            this.player.removePlayerListener((PlayerListener)this);
            this.player.close();
            this.player = null;
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.voco.background, this.getWidth() / 2, 0, 1 | 0x10);
        Font font = Font.getFont((int)0, (int)1, (int)8);
        Font font2 = Font.getFont((int)0, (int)0, (int)0);
        graphics.setFont(font);
        graphics.setColor(0xFFFFFF);
        if (this.current > -1) {
            graphics.drawString(this.playlist[this.current].substring(this.playlist[this.current].lastIndexOf(47) + 1, this.playlist[this.current].lastIndexOf(46)), this.getWidth() / 2, this.getHeight() / 2, 0x40 | 1);
        } else {
            graphics.drawString("\u041f\u043e\u0438\u0441\u043a \u0444\u0430\u0439\u043b\u043e\u0432...", this.getWidth() / 2, this.getHeight() / 2, 0x40 | 1);
        }
        graphics.setFont(font2);
        if (this.current > -1) {
            graphics.drawString(Integer.toString(this.current + 1) + '/' + Integer.toString(this.playlist.length), 0, this.getHeight(), 0x40 | 4);
        }
    }

    public void keyRepeated(int n) {
        if (n == this.voco.PTT_KEY_CODE) {
            this.commandAction(this.voco.cmdBack, (Displayable)this);
        }
    }

    public void keyPressed(int n) {
        if (n == this.voco.PTT_KEY_CODE) {
            this.playerUpdate(this.player, "endOfMedia", null);
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if ("endOfMedia".equals(string)) {
            player.removePlayerListener((PlayerListener)this);
            player.close();
            while (true) {
                ++this.current;
                if (this.current < this.playlist.length) {
                    try {
                        this.player = Manager.createPlayer((String)("file:///" + this.playlist[this.current]));
                        this.player.addPlayerListener((PlayerListener)this);
                        this.player.start();
                        this.repaint();
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!this.repeat) {
                    this.commandAction(this.voco.cmdBack, (Displayable)this);
                    break;
                }
                this.current = -1;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.voco.cmdBack && this.voco.home()) {
            this.stop();
            this.setCommandListener(null);
            this.removeCommand(this.voco.cmdBack);
            this.voco = null;
        }
    }

    private void shuffle() {
        int n;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        for (int i = 0; i < this.playlist.length; ++i) {
            vector.addElement(this.playlist[i]);
        }
        Random random = new Random();
        while (vector.size() > 0) {
            n = Math.abs(random.nextInt() % vector.size());
            vector2.addElement(vector.elementAt(n));
            vector.removeElementAt(n);
        }
        for (n = 0; n < vector2.size(); ++n) {
            this.playlist[n] = (String)vector2.elementAt(n);
        }
    }

    static /* synthetic */ String[] access$002(Jukebox jukebox, String[] stringArray) {
        jukebox.playlist = stringArray;
        return stringArray;
    }
}

