/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class DatabaseManager {
    private static final String VOICE_STORE = "VoiceStore";
    private static final String COMMAND_STORE = "CommandStore";
    private static final String OPTION_STORE = "OptionStore";
    private RecordStore rmsVoice = RecordStore.openRecordStore((String)"VoiceStore", (boolean)true, (int)0, (boolean)false);
    private RecordStore rmsCommand = RecordStore.openRecordStore((String)"CommandStore", (boolean)true, (int)0, (boolean)false);
    private RecordStore rmsOption = RecordStore.openRecordStore((String)"OptionStore", (boolean)true, (int)0, (boolean)false);
    private RecordEnumeration enumCommand = this.rmsCommand.enumerateRecords(null, (RecordComparator)new CommandFrequencyComparator(), true);

    public void closeDatabase() throws RecordStoreException {
        this.enumCommand.destroy();
        this.rmsVoice.closeRecordStore();
        this.rmsCommand.closeRecordStore();
        this.rmsOption.closeRecordStore();
    }

    public void saveSettings(VoCo voCo) throws RecordStoreException, IOException {
        while (this.rmsOption.getNumRecords() < 1) {
            this.rmsOption.addRecord(null, 0, 0);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (int i = 1; i < 2; ++i) {
            byteArrayOutputStream.reset();
            switch (i) {
                case 1: {
                    dataOutputStream.writeInt(voCo.PTT_KEY_CODE);
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.rmsOption.setRecord(i, byArray, 0, byArray.length);
        }
        dataOutputStream.close();
    }

    public void loadSettings(VoCo voCo) throws RecordStoreException, IOException {
        for (int i = 1; i < 2; ++i) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rmsOption.getRecord(i));
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            switch (i) {
                case 1: {
                    voCo.PTT_KEY_CODE = dataInputStream.readInt();
                }
            }
            dataInputStream.close();
        }
    }

    public void addVoiceCommand(VoiceCommand voiceCommand) throws RecordStoreException, IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(voiceCommand.getType());
        dataOutputStream.writeInt(0);
        if (voiceCommand instanceof CallCommand) {
            object = (CallCommand)voiceCommand;
            dataOutputStream.writeUTF(((CallCommand)object).number);
        }
        if (voiceCommand instanceof MessageCommand) {
            object = (MessageCommand)voiceCommand;
            dataOutputStream.writeUTF(((MessageCommand)object).text);
        }
        if (voiceCommand instanceof PlayerCommand) {
            object = (PlayerCommand)voiceCommand;
            dataOutputStream.writeInt(((PlayerCommand)object).playlist.length);
            dataOutputStream.writeBoolean(((PlayerCommand)object).repeat);
            dataOutputStream.writeBoolean(((PlayerCommand)object).shuffle);
            for (int i = 0; i < ((PlayerCommand)object).playlist.length; ++i) {
                dataOutputStream.writeUTF(((PlayerCommand)object).playlist[i]);
            }
        }
        object = byteArrayOutputStream.toByteArray();
        dataOutputStream.close();
        this.rmsCommand.addRecord((byte[])object, 0, ((Object)object).length);
        this.rmsVoice.addRecord(voiceCommand.voice, 0, voiceCommand.voice.length);
    }

    private void setVoiceCommand(int n, VoiceCommand voiceCommand, int n2) throws RecordStoreException, IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(voiceCommand.getType());
        dataOutputStream.writeInt(n2);
        if (voiceCommand instanceof CallCommand) {
            object = (CallCommand)voiceCommand;
            dataOutputStream.writeUTF(((CallCommand)object).number);
        }
        if (voiceCommand instanceof MessageCommand) {
            object = (MessageCommand)voiceCommand;
            dataOutputStream.writeUTF(((MessageCommand)object).text);
        }
        if (voiceCommand instanceof PlayerCommand) {
            object = (PlayerCommand)voiceCommand;
            dataOutputStream.writeInt(((PlayerCommand)object).playlist.length);
            dataOutputStream.writeBoolean(((PlayerCommand)object).repeat);
            dataOutputStream.writeBoolean(((PlayerCommand)object).shuffle);
            for (int i = 0; i < ((PlayerCommand)object).playlist.length; ++i) {
                dataOutputStream.writeUTF(((PlayerCommand)object).playlist[i]);
            }
        }
        object = byteArrayOutputStream.toByteArray();
        dataOutputStream.close();
        this.rmsCommand.setRecord(n, (byte[])object, 0, ((Object)object).length);
        if (voiceCommand.voice != null) {
            this.rmsVoice.setRecord(n, voiceCommand.voice, 0, voiceCommand.voice.length);
        }
    }

    public byte[] getSpeech(int n) throws RecordStoreException {
        return this.rmsVoice.getRecord(n);
    }

    public VoiceCommand getVoiceCommand(int n) throws RecordStoreException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rmsCommand.getRecord(n));
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        byte by = dataInputStream.readByte();
        int n2 = dataInputStream.readInt();
        VoiceCommand voiceCommand = null;
        switch (by) {
            case 0: {
                voiceCommand = new CallCommand(dataInputStream.readUTF(), null);
                break;
            }
            case 1: {
                voiceCommand = new MessageCommand(dataInputStream.readUTF(), dataInputStream.readUTF(), null);
                break;
            }
            case 3: {
                String[] stringArray = new String[dataInputStream.readInt()];
                boolean bl = dataInputStream.readBoolean();
                boolean bl2 = dataInputStream.readBoolean();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = dataInputStream.readUTF();
                }
                voiceCommand = new PlayerCommand(stringArray, bl, bl2, null);
                break;
            }
            case 2: {
                voiceCommand = new ClockCommand(null);
            }
        }
        dataInputStream.close();
        return voiceCommand;
    }

    public void deleteVoiceCommand(int n) throws RecordStoreException {
        this.rmsVoice.deleteRecord(n);
        this.rmsCommand.deleteRecord(n);
    }

    public int nextRecord() throws RecordStoreException {
        return this.enumCommand.nextRecordId();
    }

    public int prevRecord() throws RecordStoreException {
        return this.enumCommand.previousRecordId();
    }

    public boolean hasNextRecord() throws RecordStoreException {
        return this.enumCommand.hasNextElement();
    }

    public boolean hasPrevRecord() throws RecordStoreException {
        return this.enumCommand.hasPreviousElement();
    }

    public void reset() throws RecordStoreException {
        this.enumCommand.reset();
    }

    public int getNumRecords() throws RecordStoreException {
        return this.rmsCommand.getNumRecords();
    }

    public void incrementFrequency(int n) throws RecordStoreException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rmsCommand.getRecord(n));
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        byte by = dataInputStream.readByte();
        int n2 = dataInputStream.readInt() + 1;
        VoiceCommand voiceCommand = null;
        switch (by) {
            case 0: {
                voiceCommand = new CallCommand(dataInputStream.readUTF(), null);
                break;
            }
            case 1: {
                voiceCommand = new MessageCommand(dataInputStream.readUTF(), dataInputStream.readUTF(), null);
                break;
            }
            case 3: {
                String[] stringArray = new String[dataInputStream.readInt()];
                boolean bl = dataInputStream.readBoolean();
                boolean bl2 = dataInputStream.readBoolean();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = dataInputStream.readUTF();
                }
                voiceCommand = new PlayerCommand(stringArray, bl, bl2, null);
                break;
            }
            case 2: {
                voiceCommand = new ClockCommand(null);
            }
        }
        dataInputStream.close();
        this.setVoiceCommand(n, voiceCommand, n2);
    }

    private class CommandFrequencyComparator
    implements RecordComparator {
        private CommandFrequencyComparator() {
        }

        public int compare(byte[] byArray, byte[] byArray2) {
            int n = 0;
            int n2 = 0;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                dataInputStream.readByte();
                n = dataInputStream.readInt();
                dataInputStream.close();
                byteArrayInputStream = new ByteArrayInputStream(byArray2);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                dataInputStream.readByte();
                n2 = dataInputStream.readInt();
                dataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n < n2) {
                return 1;
            }
            if (n > n2) {
                return -1;
            }
            return 0;
        }
    }
}

