/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

class LighterCanvas
extends Canvas
implements CommandListener {
    private Lighter midlet;
    private Display dpy;
    private Displayable prev;
    private options options;
    private errorForm er;
    private colorForm colorForm;
    private optionsForm optionsForm;
    private morzeForm morzeForm;
    private tonePlayer t = new tonePlayer();
    public static int nextSymbol = -1;
    public static int morzeLength;
    public static int morzeColor;
    public static int impulseColor;
    public static int nextText;
    public static String morzeStr;
    public static String dashStr;
    private static int colorNumber;
    private static int[] standardColors;
    public static final int MODE_CANVAS = 0;
    public static final int MODE_COLOR1 = 1;
    public static final int MODE_COLOR2 = 2;
    public static final int MODE_MORZE = 3;
    public static final int MODE_IMPULSE = 4;
    public static int mode;
    private static int width;
    private static int height;
    private Command cmdExit = new Command("\u0412\u044b\u0445\u043e\u0434", 7, 1);
    private Command cmdColor = new Command("\u0426\u0432\u0435\u0442 RGB", 8, 2);
    private Command cmdGradient1 = new Command("\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442: \u043e\u0442", 8, 2);
    private Command cmdGradient2 = new Command("\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442: \u0434\u043e", 8, 2);
    private Command cmdImpulse = new Command("\u0418\u043c\u043f\u0443\u043b\u044c\u0441\u044b", 8, 2);
    private Command cmdMorze = new Command("\u041c\u043e\u0440\u0437\u044f\u043d\u043a\u0430", 8, 2);
    private Command cmdOptions = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 8, 2);
    private Command cmdAbout = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 8, 2);

    public LighterCanvas(Lighter lighter) {
        this.midlet = lighter;
        this.dpy = Display.getDisplay((MIDlet)lighter);
        this.prev = this.dpy.getCurrent();
        this.options = new options(false);
        this.setFullScreenMode(true);
        width = this.getWidth();
        height = this.getHeight();
        mode = 0;
        this.addCommand(this.cmdExit);
        this.addCommand(this.cmdColor);
        this.addCommand(this.cmdGradient1);
        this.addCommand(this.cmdGradient2);
        this.addCommand(this.cmdImpulse);
        this.addCommand(this.cmdMorze);
        this.addCommand(this.cmdOptions);
        this.addCommand(this.cmdAbout);
        this.setCommandListener(this);
        this.dpy.flashBacklight(Integer.MAX_VALUE);
    }

    public int abs(int n) {
        return n > 0 ? n : -n;
    }

    private void drawGradient(Graphics graphics, int n, int n2) {
        int n3 = this.colorForm.getRed(n);
        int n4 = this.colorForm.getRed(n2);
        int n5 = this.colorForm.getGreen(n);
        int n6 = this.colorForm.getGreen(n2);
        int n7 = this.colorForm.getBlue(n);
        int n8 = this.colorForm.getBlue(n2);
        for (int i = 0; i < height; ++i) {
            int n9 = n3 + (i - height + 1) * (n4 - n3) / (height - 1) + (n4 - n3);
            int n10 = n5 + (i - height + 1) * (n6 - n5) / (height - 1) + (n6 - n5);
            int n11 = n7 + (i - height + 1) * (n8 - n7) / (height - 1) + (n8 - n7);
            graphics.setColor(n9, n10, n11);
            graphics.drawLine(0, i, width - 1, i);
        }
    }

    protected void paint(Graphics graphics) {
        switch (mode) {
            case 0: {
                graphics.setColor(options.color1);
                graphics.fillRect(0, 0, width, height);
                this.midlet.animateTo(this.midlet.timerInterval);
                break;
            }
            case 4: {
                graphics.setColor(impulseColor);
                graphics.fillRect(0, 0, width, height);
                if (impulseColor == options.color1) {
                    impulseColor = options.color1 ^ 0xFFFFFF;
                    if (options.vibrator > 0) {
                        this.dpy.vibrate(this.midlet.timerInterval);
                    }
                } else {
                    impulseColor = options.color1;
                }
                this.midlet.animateTo(this.midlet.timerInterval);
                break;
            }
            case 1: 
            case 2: {
                this.drawGradient(graphics, options.gColor1, options.gColor2);
                this.midlet.animateTo(this.midlet.timerInterval);
                break;
            }
            case 3: {
                if (nextSymbol <= -1) break;
                if (nextSymbol == 0) {
                    morzeLength = dashStr.length();
                    nextText = 0;
                }
                char c = dashStr.charAt(nextSymbol++);
                int n = 0;
                switch (c) {
                    case '.': {
                        n = options.dot;
                        morzeColor = 0xFFFFFF;
                        break;
                    }
                    case '-': {
                        n = options.dash;
                        morzeColor = 0xFFFFFF;
                        break;
                    }
                    case '0': {
                        n = options.dot;
                        morzeColor = 0;
                        break;
                    }
                    case '1': {
                        n = options.dash * 2;
                        morzeColor = 0;
                        ++nextText;
                        break;
                    }
                    case '2': {
                        n = options.dash * 4;
                        morzeColor = 0;
                        nextText += 2;
                    }
                }
                graphics.setColor(morzeColor);
                graphics.fillRect(0, 0, width, height);
                if (nextText < morzeStr.length()) {
                    String string = "" + morzeStr.charAt(nextText);
                    graphics.setColor(morzeColor ^ 0xFFFFFF);
                    graphics.drawString(string, width / 2, height / 2 - 10, 17);
                    int n2 = morzeForm.letters.indexOf(morzeStr.charAt(nextText));
                    if (n2 == -1) {
                        n2 = morzeForm.lowerStr.indexOf(morzeStr.charAt(nextText));
                    }
                    if (n2 > -1) {
                        string = morzeForm.codes[morzeForm.numbers[n2]];
                        graphics.drawString(string, width / 2, height / 2 + 10, 17);
                    }
                }
                this.midlet.animateTo(n);
                if (c == '.' || c == '-') {
                    if (options.vibrator > 0) {
                        this.dpy.vibrate(n);
                    }
                    if (options.sound > 0) {
                        if (c == '.') {
                            this.t.setDuration(options.dot);
                        } else {
                            this.t.setDuration(options.dash);
                        }
                        this.t.play(options.note);
                    }
                }
                if (nextSymbol != morzeLength) break;
                if (options.morzeCycle > 0) {
                    nextSymbol = 0;
                    break;
                }
                nextSymbol = -1;
                mode = 0;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdExit) {
            this.midlet.exitMIDlet();
        } else if (command == this.cmdColor) {
            mode = 0;
            this.colorForm = new colorForm(this.midlet, "\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430", options.color1);
            this.dpy.setCurrent((Displayable)this.colorForm);
        } else if (command == this.cmdGradient1) {
            mode = 1;
            this.colorForm = new colorForm(this.midlet, "\u0426\u0432\u0435\u0442 \u0433\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u0430 1", options.gColor1);
            this.dpy.setCurrent((Displayable)this.colorForm);
        } else if (command == this.cmdGradient2) {
            mode = 2;
            this.colorForm = new colorForm(this.midlet, "\u0426\u0432\u0435\u0442 \u0433\u0440\u0430\u0434\u0438\u0435\u043d\u0442\u0430 2", options.gColor2);
            this.dpy.setCurrent((Displayable)this.colorForm);
        } else if (command == this.cmdImpulse) {
            mode = 4;
            impulseColor = options.color1;
        } else if (command == this.cmdOptions) {
            this.optionsForm = new optionsForm(this.midlet);
            this.dpy.setCurrent((Displayable)this.optionsForm);
        } else if (command == this.cmdMorze) {
            mode = 3;
            nextSymbol = -1;
            this.morzeForm = new morzeForm(this.midlet);
            this.dpy.setCurrent((Displayable)this.morzeForm);
        } else if (command == this.cmdAbout) {
            this.er = new errorForm(this.dpy, "\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435");
            this.er.show("Lighter - \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435-\u0444\u043e\u043d\u0430\u0440\u0438\u043a\n\u0426\u0432\u0435\u0442 RGB - \u0437\u0430\u043a\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u0442 \u044d\u043a\u0440\u0430\u043d \u0444\u043e\u043d\u043e\u043c, \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c \u043f\u043e \u0438\u043d\u0442\u0435\u043d\u0441\u0438\u0432\u043d\u043e\u0441\u0442\u044f\u043c \u043a\u0440\u0430\u0441\u043d\u043e\u0439, \u0437\u0435\u043b\u0435\u043d\u043e\u0439 \u0438 \u0441\u0438\u043d\u0435\u0439 \u0446\u0432\u0435\u0442\u043e\u0432\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442. \u041a\u043b\u0430\u0432\u0438\u0448\u0430 1 - \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u043f\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u043c \u0446\u0432\u0435\u0442\u0430\u043c\n\u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442: \u043e\u0442 \u0438 \u0413\u0440\u0430\u0434\u0438\u0435\u043d\u0442: \u0434\u043e - \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044e\u0442 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u043b\u0430\u0432\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0446\u0432\u0435\u0442\u0430 (\u0433\u0440\u0430\u0434\u0438\u0435\u043d\u0442)\n\u0418\u043c\u043f\u0443\u043b\u044c\u0441\u044b - \u0437\u0430\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u044d\u043a\u0440\u0430\u043d \u043f\u0443\u043b\u044c\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c. \u0423\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043f\u0443\u043b\u044c\u0441\u0430\u0446\u0438\u0438 \u043c\u043e\u0436\u043d\u043e \u043a\u043b\u0430\u0432\u0438\u0448\u0435\u0439 *, \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c - #, \u0432\u0435\u0440\u043d\u0443\u0442\u044c \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e - 0\n\u041c\u043e\u0440\u0437\u044f\u043d\u043a\u0430 - \u0443\u043c\u0435\u0435\u0442 \u043f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0442\u044c \u0432\u0432\u0435\u0434\u0435\u043d\u043d\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443 \u0430\u0437\u0431\u0443\u043a\u043e\u0439 \u041c\u043e\u0440\u0437\u0435, \u0437\u0430\u0434\u0435\u0439\u0441\u0442\u0432\u0443\u044f, \u043a\u0440\u043e\u043c\u0435 \u0446\u0432\u0435\u0442\u0430, \u0432\u0438\u0431\u0440\u0430\u0446\u0438\u044e \u0438 \u0437\u0432\u0443\u043a\u043e\u0432\u0443\u044e \u043d\u043e\u0442\u0443 (\u0441\u043c. \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438). \u0414\u043b\u044f \u0431\u044b\u0441\u0442\u0440\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u043a \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0441\u0438\u0433\u043d\u0430\u043b\u0430 SOS \u043d\u0430\u0436\u043c\u0438\u0442\u0435 2\n\u0412 \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u0442\u0430\u043a\u0436\u0435 \u043c\u043e\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u043b\u0438\u043d\u0443 \u0442\u043e\u0447\u043a\u0438 \u0438 \u0442\u0438\u0440\u0435 \u0432 \u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445, \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043d\u043e\u0442\u0443, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0431\u0443\u0434\u0435\u0442 \u0437\u0432\u0443\u0447\u0430\u0442\u044c \u043c\u043e\u0440\u0437\u044f\u043d\u043a\u0430\n(C) PerS (pers@mail.ru)");
        }
        this.repaint();
    }

    public void keyPressed(int n) {
        switch (n) {
            case 42: {
                if (this.midlet.timerInterval >= 5000) break;
                this.midlet.timerInterval += 100;
                break;
            }
            case 35: {
                if (this.midlet.timerInterval <= 100) break;
                this.midlet.timerInterval -= 100;
                break;
            }
            case 48: {
                this.midlet.timerInterval = 1000;
                break;
            }
            case 49: {
                mode = 0;
                colorNumber = colorNumber == standardColors.length - 1 ? 0 : ++colorNumber;
                options.color1 = standardColors[colorNumber];
                this.repaint();
                break;
            }
            case 50: {
                mode = 3;
                nextSymbol = 0;
                morzeStr = "SOS";
                dashStr = ".0.0.1-0-0-1.0.0.2";
                this.repaint();
            }
        }
    }

    static {
        morzeStr = "";
        dashStr = "";
        colorNumber = 0;
        standardColors = new int[]{0xFFFFFF, 255, 65280, 65535, 0xFF0000, 0xFF00FF, 0xFFFF00, 0x808080, 0x8080FF, 0x80FF80, 0xFF8080, 0xFF80FF, 0xFFFF80};
        mode = 0;
    }
}

