/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;

public class GuitarTunerCanvas
extends Canvas
implements Runnable {
    int width;
    int height;
    int center_width;
    int center_height;
    Thread myThread;
    int button = -1;
    int string_on = -1;
    int[] freqs = new int[6];
    String[] notes = new String[6];

    public GuitarTunerCanvas() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.center_width = this.width / 2;
        this.center_height = this.height / 2;
        this.setStandard();
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void setStandard() {
        this.notes[0] = "E";
        this.notes[1] = "B";
        this.notes[2] = "G";
        this.notes[3] = "D";
        this.notes[4] = "A";
        this.notes[5] = "E";
        this.freqs[0] = 76;
        this.freqs[1] = 71;
        this.freqs[2] = 67;
        this.freqs[3] = 62;
        this.freqs[4] = 57;
        this.freqs[5] = 52;
    }

    public void setHalfStep() {
        this.notes[0] = "Eb";
        this.notes[1] = "Bb";
        this.notes[2] = "Gb";
        this.notes[3] = "Db";
        this.notes[4] = "Ab";
        this.notes[5] = "Eb";
        this.freqs[0] = 75;
        this.freqs[1] = 70;
        this.freqs[2] = 66;
        this.freqs[3] = 61;
        this.freqs[4] = 56;
        this.freqs[5] = 51;
    }

    public void setWholeStep() {
        this.notes[0] = "D";
        this.notes[1] = "A";
        this.notes[2] = "F";
        this.notes[3] = "C";
        this.notes[4] = "G";
        this.notes[5] = "D";
        this.freqs[0] = 74;
        this.freqs[1] = 69;
        this.freqs[2] = 65;
        this.freqs[3] = 60;
        this.freqs[4] = 55;
        this.freqs[5] = 50;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            if (this.button == -1) continue;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            for (int i = 0; i < 5; ++i) {
                try {
                    this.string_on = this.button;
                    this.repaint();
                    Manager.playTone((int)this.freqs[this.button], (int)200, (int)100);
                    Thread.sleep(200L);
                    this.string_on = -1;
                    this.repaint();
                    Thread.sleep(200L);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
            this.button = -1;
        }
    }

    public void keyPressed(int n) {
        System.out.println(n);
        if (n >= 49 && n <= 54) {
            this.button = n - 49;
        } else if (n == 42) {
            this.setStandard();
            this.repaint();
        } else if (n == 48) {
            this.setHalfStep();
            this.repaint();
        } else if (n == 35) {
            this.setWholeStep();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        String string = "-----------";
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.width, this.height);
        int n = Font.getDefaultFont().stringWidth(string) / 2;
        int n2 = Font.getDefaultFont().stringWidth("Guitar Tuner 1.0");
        graphics.setColor(255, 255, 0);
        graphics.drawString("Guitar Tuner 1.0", this.center_width - n2 / 2, 7, 0);
        n2 = Font.getDefaultFont().stringWidth("www.mikekohn.net");
        graphics.setColor(0, 255, 255);
        graphics.drawString("www.mikekohn.net", this.center_width - n2 / 2, 20, 0);
        graphics.setColor(255, 255, 255);
        for (n2 = 0; n2 < 6; ++n2) {
            if (this.string_on == n2) {
                graphics.setColor(255, 0, 0);
            } else {
                graphics.setColor(200, 200, 200);
            }
            graphics.drawString(n2 + 1 + "", this.center_width - n - 5, 37 + n2 * 10, 0);
            graphics.drawString(string, this.center_width - n + 5, 37 + n2 * 10, 0);
            graphics.drawString(this.notes[n2], this.center_width + n + 7, 37 + n2 * 10, 0);
        }
        int n3 = 102;
        if (this.freqs[5] != 52) {
            n2 = Font.getDefaultFont().stringWidth("Press * for E tuning");
            graphics.setColor(0, 255, 255);
            graphics.drawString("Press * for E tuning", this.center_width - n2 / 2, n3, 0);
            n3 += 12;
        }
        if (this.freqs[5] != 51) {
            n2 = Font.getDefaultFont().stringWidth("Press 0 for Eb tuning");
            graphics.setColor(0, 255, 255);
            graphics.drawString("Press 0 for Eb tuning", this.center_width - n2 / 2, n3, 0);
            n3 += 12;
        }
        if (this.freqs[5] != 50) {
            n2 = Font.getDefaultFont().stringWidth("Press # for D tuning");
            graphics.setColor(0, 255, 255);
            graphics.drawString("Press # for D tuning", this.center_width - n2 / 2, n3, 0);
            n3 += 12;
        }
    }
}

