/*
 * Decompiled with CFR 0.152.
 */
package henson.midp;

public class Float {
    private static final Float ERROR = new Float(Long.MAX_VALUE, Long.MAX_VALUE);
    private static final int ITNUM = 5;
    public static final Float SQRT3 = new Float(1732050807568877294L, -18L);
    public static final Float PI = new Float(3141592653589793238L, -18L);
    public static final Float ZERO = new Float();
    public static final Float ONE = new Float(1L);
    public static final Float E = new Float(271828182845904512L, -17L);
    public static final Float LOG10 = new Float(2302585092994045684L, -18L);
    public static final Float PIdiv2 = PI.Div(2L);
    public static final Float PIdiv4 = PIdiv2.Div(2L);
    public static final Float PIdiv6 = PIdiv2.Div(3L);
    public static final Float PIdiv12 = PIdiv6.Div(2L);
    public static final Float PImul2 = PI.Mul(2L);
    public static final Float PImul4 = PI.Mul(4L);
    public static final Float LOGdiv2 = new Float(-6931471805599453094L, -19L);
    public long m_Val;
    public long m_E;
    private long maxLimit = 92233720368547758L;

    public Float() {
        this.m_E = 0L;
        this.m_Val = 0L;
    }

    public Float(long value) {
        this.m_Val = value;
        this.m_E = 0L;
    }

    public Float(long value, long e) {
        this.m_Val = value;
        this.m_E = this.m_Val == 0L ? 0L : e;
    }

    public Float(Float value) {
        this.m_Val = value.m_Val;
        this.m_E = this.m_Val == 0L ? 0L : value.m_E;
    }

    public long toLong() {
        long tmpE = this.m_E;
        long tmpVal = this.m_Val;
        while (tmpE != 0L) {
            if (tmpE < 0L) {
                tmpVal /= 10L;
                ++tmpE;
                continue;
            }
            tmpVal *= 10L;
            --tmpE;
        }
        return tmpVal;
    }

    public String toShortString() {
        if (this.isError()) {
            return "NaN";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_Val);
        int len = (int)this.m_E;
        if (len > 0) {
            for (int k = 0; k < len; ++k) {
                sb.append("0");
            }
            len = 0;
        }
        String str = sb.toString();
        len += str.length();
        if (this.m_Val < 0L ? len > 1 : len > 0) {
            return str.substring(0, len);
        }
        return "0";
    }

    public boolean isError() {
        return this.m_Val == Float.ERROR.m_Val && this.m_E == Float.ERROR.m_E;
    }

    public String toString() {
        if (this.isError()) {
            return "NaN";
        }
        this.RemoveZero();
        Long l = new Long(this.m_Val);
        String str = l.toString();
        int len = str.length();
        boolean neg = false;
        if (this.m_Val < 0L) {
            neg = true;
            str = str.substring(1, len);
            --len;
        }
        StringBuffer sb = new StringBuffer();
        if (this.m_E < 0L) {
            int absE = (int)Math.abs(this.m_E);
            if (absE < len) {
                sb.append(str.substring(0, len - absE));
                sb.append(".");
                sb.append(str.substring(len - absE));
            } else {
                sb.append(str);
                for (int i = 0; i < absE - len; ++i) {
                    sb.insert(0, "0");
                }
                sb.insert(0, "0.");
            }
        } else if ((long)len + this.m_E > 6L) {
            sb.append(str.charAt(0));
            if (str.length() > 1) {
                sb.append(".");
                sb.append(str.substring(1));
            } else {
                sb.append(".0");
            }
            sb.append("E" + ((long)(len - 1) + this.m_E));
        } else {
            sb.append(str);
            int i = 0;
            while ((long)i < this.m_E) {
                sb.append("0");
                ++i;
            }
        }
        str = sb.toString();
        sb = null;
        if (neg) {
            str = "-" + str;
        }
        return str;
    }

    public Float Add(Float value) {
        if (value.Equal(ZERO)) {
            return new Float(this);
        }
        long e1 = this.m_E;
        long e2 = value.m_E;
        long v1 = this.m_Val;
        long v2 = value.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        if (v1 > 0L && v2 > Long.MAX_VALUE - v1 || v1 < 0L && v2 < Long.MIN_VALUE - v1) {
            v1 /= 10L;
            ++e1;
            v2 /= 10L;
            ++e2;
        }
        if (v1 > 0L && v2 > Long.MAX_VALUE - v1) {
            return new Float(ERROR);
        }
        if (v1 < 0L && v2 < Long.MIN_VALUE - v1) {
            return new Float(ERROR);
        }
        return new Float(v1 + v2, e1);
    }

    public Float Sub(Float value) {
        if (value.Equal(ZERO)) {
            return new Float(this.m_Val, this.m_E);
        }
        return this.Add(new Float(-value.m_Val, value.m_E));
    }

    public Float Mul(long value) {
        return this.Mul(new Float(value, 0L));
    }

    public Float Mul(Float value) {
        boolean negative2;
        boolean negative1;
        if (value.Equal(ZERO) || this.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (value.Equal(ONE)) {
            return new Float(this);
        }
        boolean bl = negative1 = this.m_Val < 0L;
        if (negative1) {
            this.m_Val = -this.m_Val;
        }
        boolean bl2 = negative2 = value.m_Val < 0L;
        if (negative2) {
            value.m_Val = -value.m_Val;
        }
        while (true) {
            if (value.m_Val > this.m_Val) {
                if (Long.MAX_VALUE / this.m_Val >= value.m_Val) break;
                value.m_Val /= 10L;
                ++value.m_E;
                continue;
            }
            if (Long.MAX_VALUE / value.m_Val >= this.m_Val) break;
            this.m_Val /= 10L;
            ++this.m_E;
        }
        if (negative1) {
            this.m_Val = -this.m_Val;
        }
        if (negative2) {
            value.m_Val = -value.m_Val;
        }
        long e = this.m_E + value.m_E;
        long v = this.m_Val * value.m_Val;
        return new Float(v, e);
    }

    public Float Div(long value) {
        return this.Div(new Float(value, 0L));
    }

    public Float Div(Float value) {
        if (value.Equal(ONE)) {
            return new Float(this);
        }
        long e1 = this.m_E;
        long e2 = value.m_E;
        long v2 = value.m_Val;
        if (v2 == 0L) {
            return new Float(ERROR);
        }
        long v1 = this.m_Val;
        if (v1 == 0L) {
            return new Float(ZERO);
        }
        long val = 0L;
        while ((v1 %= v2) != 0L && Math.abs(val += v1 / v2) <= 0xCCCCCCCCCCCCCCCL) {
            if (Math.abs(v1) > 0xCCCCCCCCCCCCCCCL) {
                v2 /= 10L;
                ++e2;
            } else {
                v1 *= 10L;
                --e1;
            }
            val *= 10L;
        }
        Float f = new Float(val, e1 - e2);
        f.RemoveZero();
        return f;
    }

    public void RemoveZero() {
        if (this.m_Val == 0L) {
            return;
        }
        while (this.m_Val % 10L == 0L) {
            this.m_Val /= 10L;
            ++this.m_E;
        }
    }

    public boolean Great(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 > v2;
    }

    public boolean Less(long x) {
        return this.Less(new Float(x, 0L));
    }

    public boolean Less(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 < v2;
    }

    public boolean Equal(Float x) {
        long e1 = this.m_E;
        long e2 = x.m_E;
        long v1 = this.m_Val;
        long v2 = x.m_Val;
        if (v1 == 0L && v2 == 0L || v1 == v2 && e1 == e2) {
            return true;
        }
        long diff = e1 - e2;
        if (diff < -20L || diff > 20L) {
            return false;
        }
        while (e1 != e2) {
            if (e1 > e2) {
                if (Math.abs(v1) < this.maxLimit) {
                    v1 *= 10L;
                    --e1;
                    continue;
                }
                v2 /= 10L;
                ++e2;
                continue;
            }
            if (e1 >= e2) continue;
            if (Math.abs(v2) < this.maxLimit) {
                v2 *= 10L;
                --e2;
                continue;
            }
            v1 /= 10L;
            ++e1;
        }
        return v1 == v2;
    }

    public Float Neg() {
        return new Float(-this.m_Val, this.m_E);
    }

    public static Float sin(Float x) {
        while (x.Great(PI)) {
            x = x.Sub(PImul2);
        }
        while (x.Less(PI.Neg())) {
            x = x.Add(PImul2);
        }
        Float m1 = x.Mul(x.Mul(x));
        Float q1 = m1.Div(6L);
        Float m2 = x.Mul(x.Mul(m1));
        Float q2 = m2.Div(120L);
        Float m3 = x.Mul(x.Mul(m2));
        Float q3 = m3.Div(5040L);
        Float m4 = x.Mul(x.Mul(m3));
        Float q4 = m4.Div(362880L);
        Float m5 = x.Mul(x.Mul(m4));
        Float q5 = m5.Div(39916800L);
        Float result = x.Sub(q1).Add(q2).Sub(q3).Add(q4).Sub(q5);
        if (result.Less(new Float(-999999L, -6L))) {
            return new Float(-1L);
        }
        if (result.Great(new Float(999999L, -6L))) {
            return new Float(1L);
        }
        if (result.Great(new Float(-5L, -4L)) && result.Less(new Float(5L, -4L))) {
            return new Float(0L);
        }
        return result;
    }

    public static Float cos(Float x) {
        while (x.Great(PI)) {
            x = x.Sub(PImul2);
        }
        while (x.Less(PI.Neg())) {
            x = x.Add(PImul2);
        }
        Float m1 = x.Mul(x);
        Float q1 = m1.Div(2L);
        Float m2 = m1.Mul(m1);
        Float q2 = m2.Div(24L);
        Float m3 = m1.Mul(m2);
        Float q3 = m3.Div(720L);
        Float m4 = m2.Mul(m2);
        Float q4 = m4.Div(40320L);
        Float m5 = m4.Mul(m1);
        Float q5 = m5.Div(3628800L);
        Float result = ONE.Sub(q1).Add(q2).Sub(q3).Add(q4).Sub(q5);
        if (result.Less(new Float(-999999L, -6L))) {
            return new Float(-1L);
        }
        if (result.Great(new Float(999999L, -6L))) {
            return new Float(1L);
        }
        if (result.Great(new Float(-5L, -4L)) && result.Less(new Float(5L, -4L))) {
            return new Float(0L);
        }
        return result;
    }

    public static Float sqrt(Float x) {
        int sp = 0;
        boolean inv = false;
        if (x.Less(ZERO)) {
            return new Float(ERROR);
        }
        if (x.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (x.Equal(ONE)) {
            return new Float(ONE);
        }
        if (x.Less(ONE)) {
            x = ONE.Div(x);
            inv = true;
        }
        long e = x.m_E / 2L;
        Float tmp = new Float(x.m_Val, x.m_E - e * 2L);
        while (tmp.Great(new Float(16L))) {
            ++sp;
            tmp = tmp.Div(16L);
        }
        Float a = new Float(2L);
        for (int i = 5; i > 0; --i) {
            Float b = tmp.Div(a);
            a = a.Add(b);
            a = a.Div(2L);
        }
        while (sp > 0) {
            --sp;
            a = a.Mul(4L);
        }
        a.m_E += e;
        if (inv) {
            a = ONE.Div(a);
        }
        return a;
    }

    public static Float tan(Float x) {
        Float c = Float.cos(x);
        if (c.Equal(ZERO)) {
            return new Float(ERROR);
        }
        return Float.sin(x).Div(c);
    }

    public static Float parse(String str, int radix) {
        boolean neg = false;
        if (str.charAt(0) == '-') {
            str = str.substring(1);
            neg = true;
        }
        int pos = str.indexOf(".");
        long exp = 0L;
        int pos2 = str.indexOf(69);
        if (pos2 == -1) {
            pos2 = str.indexOf(101);
        }
        if (pos2 != -1) {
            String tmp = new String(str.substring(pos2 + 1));
            exp = Long.parseLong(tmp);
            str = str.substring(0, pos2);
        }
        if (pos != -1) {
            for (int m = pos + 1; m < str.length() && Character.isDigit(str.charAt(m)); ++m) {
                --exp;
            }
            str = str.substring(0, pos) + str.substring(pos + 1);
            while (str.length() > 1 && str.charAt(0) == '0' && str.charAt(1) != '.') {
                str = str.substring(1);
            }
        }
        long result = 0L;
        int len = str.length();
        StringBuffer sb = new StringBuffer(str);
        while (true) {
            if (len > 20) {
                sb = sb.deleteCharAt(len - 1);
                if (len < pos || pos == -1) {
                    ++exp;
                }
                --len;
                continue;
            }
            try {
                result = Long.parseLong(sb.toString(), radix);
                if (!neg) break;
                result = -result;
            }
            catch (Exception e) {
                sb = sb.deleteCharAt(len - 1);
                if (len < pos || pos == -1) {
                    ++exp;
                }
                --len;
                continue;
            }
            break;
        }
        sb = null;
        Float newValue = new Float(result, exp);
        newValue.RemoveZero();
        return newValue;
    }

    public static Float acos(Float x) {
        Float f = Float.asin(x);
        if (f.isError()) {
            return f;
        }
        return PIdiv2.Sub(f);
    }

    public static Float asin(Float x) {
        if (x.Less(ONE.Neg()) || x.Great(ONE)) {
            return new Float(ERROR);
        }
        if (x.Equal(ONE.Neg())) {
            return PIdiv2.Neg();
        }
        if (x.Equal(ONE)) {
            return PIdiv2;
        }
        return Float.atan(x.Div(Float.sqrt(ONE.Sub(x.Mul(x)))));
    }

    public static Float atan(Float x) {
        Float a;
        boolean signChange = false;
        boolean Invert = false;
        int sp = 0;
        if (x.Less(ZERO)) {
            x = x.Neg();
            signChange = true;
        }
        if (x.Great(ONE)) {
            x = ONE.Div(x);
            Invert = true;
        }
        while (x.Great(PIdiv12)) {
            ++sp;
            a = x.Add(SQRT3);
            a = ONE.Div(a);
            x = x.Mul(SQRT3);
            x = x.Sub(ONE);
            x = x.Mul(a);
        }
        Float x2 = x.Mul(x);
        a = x2.Add(new Float(14087812L, -7L));
        a = new Float(55913709L, -8L).Div(a);
        a = a.Add(new Float(60310579L, -8L));
        a = a.Sub(x2.Mul(new Float(5160454L, -8L)));
        a = a.Mul(x);
        while (sp > 0) {
            a = a.Add(PIdiv6);
            --sp;
        }
        if (Invert) {
            a = PIdiv2.Sub(a);
        }
        if (signChange) {
            a = a.Neg();
        }
        return a;
    }

    public static Float atan2(Float y, Float x) {
        if (y.Equal(ZERO) && x.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (x.Great(ZERO)) {
            return Float.atan(y.Div(x));
        }
        if (x.Less(ZERO)) {
            if (y.Less(ZERO)) {
                return PI.Sub(Float.atan(y.Div(x))).Neg();
            }
            return PI.Sub(Float.atan(y.Div(x).Neg()));
        }
        if (y.Less(ZERO)) {
            return PIdiv2.Neg();
        }
        return new Float(PIdiv2);
    }

    public static Float exp(Float x) {
        if (x.Equal(ZERO)) {
            return new Float(ONE);
        }
        Float f = new Float(ONE);
        long d = 1L;
        Float k = null;
        boolean isless = x.Less(ZERO);
        if (isless) {
            x = x.Neg();
        }
        k = new Float(x).Div(d);
        for (long i = 2L; i < 50L; ++i) {
            f = f.Add(k);
            k = k.Mul(x).Div(i);
        }
        if (isless) {
            return ONE.Div(f);
        }
        return f;
    }

    private static Float _log(Float x) {
        if (!x.Great(ZERO)) {
            return new Float(ERROR);
        }
        Float f = new Float(ZERO);
        int appendix = 0;
        while (x.Great(ZERO) && x.Less(ONE)) {
            x = x.Mul(2L);
            ++appendix;
        }
        x = x.Div(2L);
        --appendix;
        Float y1 = x.Sub(ONE);
        Float y2 = x.Add(ONE);
        Float y = y1.Div(y2);
        Float k = new Float(y);
        y2 = k.Mul(y);
        for (long i = 1L; i < 50L; i += 2L) {
            f = f.Add(k.Div(i));
            k = k.Mul(y2);
        }
        f = f.Mul(2L);
        for (int i = 0; i < appendix; ++i) {
            f = f.Add(LOGdiv2);
        }
        return f;
    }

    public static Float log(Float x) {
        if (!x.Great(ZERO)) {
            return new Float(ERROR);
        }
        if (x.Equal(ONE)) {
            return new Float(ZERO);
        }
        if (x.Great(ONE)) {
            x = ONE.Div(x);
            return Float._log(x).Neg();
        }
        return Float._log(x);
    }

    public static Float log10(Float x) {
        if (!x.Great(ZERO)) {
            return new Float(ERROR);
        }
        if (x.Equal(ONE)) {
            return new Float(ZERO);
        }
        Float f = Float.log(x);
        if (f.isError()) {
            return f;
        }
        return f.Div(LOG10);
    }

    public static Float pow(Float x, Float y) {
        if (x.Equal(ZERO)) {
            return new Float(ZERO);
        }
        if (x.Equal(ONE)) {
            return new Float(ONE);
        }
        if (y.Equal(ZERO)) {
            return new Float(ONE);
        }
        if (y.Equal(ONE)) {
            return new Float(x);
        }
        long l = y.toLong();
        boolean integerValue = y.Equal(new Float(l));
        if (integerValue) {
            boolean neg = false;
            if (y.Less(0L)) {
                neg = true;
            }
            Float result = new Float(x);
            for (long i = 1L; i < (neg ? -l : l); ++i) {
                result = result.Mul(x);
            }
            if (neg) {
                return ONE.Div(result);
            }
            return result;
        }
        if (x.Great(ZERO)) {
            return Float.exp(y.Mul(Float.log(x)));
        }
        return new Float(ERROR);
    }

    public static Float ceil(Float x) {
        long tmpVal = x.m_Val;
        if (x.m_E < 0L) {
            long coeff = 1L;
            if (x.m_E > -19L) {
                for (long i = 0L; i < -x.m_E; ++i) {
                    coeff *= 10L;
                }
                tmpVal /= coeff;
                if (x.m_Val - (tmpVal *= coeff) > 0L) {
                    tmpVal += coeff;
                }
            } else {
                if (tmpVal > 0L) {
                    return ONE;
                }
                return ZERO;
            }
        }
        return new Float(tmpVal, x.m_E);
    }

    public static Float floor(Float x) {
        long tmpVal = x.m_Val;
        if (x.m_E < 0L) {
            long coeff = 1L;
            if (x.m_E > -19L) {
                for (long i = 0L; i < -x.m_E; ++i) {
                    coeff *= 10L;
                }
                tmpVal /= coeff;
                if (x.m_Val - (tmpVal *= coeff) < 0L) {
                    tmpVal -= coeff;
                }
            } else {
                if (tmpVal < 0L) {
                    return ONE.Neg();
                }
                return ZERO;
            }
        }
        return new Float(tmpVal, x.m_E);
    }

    public static Float abs(Float x) {
        if (x.m_Val < 0L) {
            return x.Neg();
        }
        return new Float(x);
    }

    public static Float Int(Float x) {
        long tmpVal = x.m_Val;
        if (x.m_E < 0L) {
            long coeff = 1L;
            if (x.m_E > -19L) {
                for (long i = 0L; i < -x.m_E; ++i) {
                    coeff *= 10L;
                }
                tmpVal /= coeff;
                tmpVal *= coeff;
            } else {
                return ZERO;
            }
        }
        return new Float(tmpVal, x.m_E);
    }

    public static Float Frac(Float x) {
        return x.Sub(Float.Int(x));
    }

    public static Float toRadians(Float x) {
        return x.Mul(PI).Div(180L);
    }

    public static Float toDegrees(Float x) {
        return x.Mul(180L).Div(PI);
    }
}

