/*
 * Decompiled with CFR 0.152.
 */
package compass;

import henson.midp.Float;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Compass
extends MIDlet {
    private Float rads = Float.PI.Div(180L);
    private Display display;
    private short latitude;
    private short longitude;
    private short timeoffset;
    private UTCDate utc;
    private SkyPosition sunPosition;
    private SkyPosition moonPosition;

    public void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        this.moonPosition = null;
        this.sunPosition = null;
        this.loadSettings();
        CompassCanvas canvas = new CompassCanvas();
        if (this.latitude == 0 && this.longitude == 0) {
            this.display.setCurrent((Displayable)new OptionsForm((Displayable)canvas));
        } else {
            this.display.setCurrent((Displayable)canvas);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    private void saveSettings() {
        RecordStore recordStore;
        try {
            recordStore = RecordStore.openRecordStore((String)"compass", (boolean)true);
        }
        catch (RecordStoreException rsc) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        try {
            outputStream.writeShort(this.latitude);
            outputStream.writeShort(this.longitude);
            outputStream.writeShort(this.timeoffset);
            byte[] bytes = baos.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(bytes, 0, bytes.length);
            } else {
                recordStore.setRecord(1, bytes, 0, bytes.length);
            }
            outputStream.close();
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadSettings() {
        RecordStore recordStore;
        try {
            recordStore = RecordStore.openRecordStore((String)"compass", (boolean)false);
        }
        catch (RecordStoreException rse) {
            this.latitude = 0;
            this.longitude = 0;
            this.timeoffset = Short.MAX_VALUE;
            return;
        }
        try {
            byte[] bytes = recordStore.getRecord(1);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream inputStream = new DataInputStream(bais);
            this.latitude = inputStream.readShort();
            this.longitude = inputStream.readShort();
            this.timeoffset = inputStream.readShort();
            inputStream.close();
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void recalculate() {
        this.utc = new UTCDate();
        this.sunPosition = this.getSunPosition();
        this.moonPosition = this.getMoonPosition();
    }

    public SkyPosition getSunPosition() {
        Float radPerDeg = Float.PI.Div(180L);
        int year = this.utc.year;
        int month = this.utc.month;
        int day = this.utc.day;
        Float solarMins = new Float(this.longitude).Mul(4L).Add(new Float(this.utc.hour * 60 + this.utc.minute));
        Float minsInDay = new Float(1440L);
        if (solarMins.Less(0L)) {
            --day;
            solarMins = solarMins.Add(minsInDay);
        } else if (solarMins.Great(minsInDay)) {
            ++day;
            solarMins = solarMins.Sub(minsInDay);
        }
        if (month > 2) {
            month -= 3;
        } else {
            --year;
            month += 9;
        }
        Float lat = new Float(this.latitude).Mul(radPerDeg);
        Float t = solarMins.Div(minsInDay);
        t = t.Add(new Float(day));
        t = t.Add(Float.floor(new Float(306L, -1L).Mul(month).Add(new Float(5L, -1L))));
        t = t.Add(Float.floor(new Float(36525L, -2L).Mul(year - 1976)));
        t = t.Sub(new Float(87075L, -1L));
        t = t.Div(36525L);
        Float G = new Float(357528L, -3L);
        G = G.Add(new Float(3599905L, -2L).Mul(t));
        G = G.Sub(Float.floor(G.Div(360L).Mul(360L)));
        G = G.Mul(radPerDeg);
        Float L = new Float(28046L, -2L);
        L = L.Add(new Float(3600077L, -2L).Mul(t));
        L = L.Add(new Float(1915L, -3L).Mul(Float.sin(G)));
        L = L.Add(Float.sin(G.Mul(2L)).Div(50L));
        L = L.Sub(Float.floor(L.Div(360L)).Mul(360L));
        L = L.Mul(radPerDeg);
        Float alpha = new Float(2466L, -3L).Mul(Float.sin(L.Mul(2L)));
        alpha = alpha.Add(new Float(53L, -3L).Mul(Float.sin(L.Mul(4L))));
        alpha = alpha.Mul(radPerDeg);
        alpha = L.Sub(alpha);
        Float obliquity = new Float(234393L, -4L).Sub(new Float(13L, -3L).Mul(t));
        obliquity = obliquity.Mul(radPerDeg);
        Float declination = Float.atan(Float.tan(obliquity).Mul(Float.sin(alpha)));
        Float hourangle = solarMins.Sub(minsInDay.Div(2L)).Div(4L);
        hourangle = hourangle.Mul(radPerDeg).Neg();
        Float altitudeAngle = Float.cos(lat);
        altitudeAngle = altitudeAngle.Mul(Float.cos(declination));
        altitudeAngle = altitudeAngle.Mul(Float.cos(hourangle));
        altitudeAngle = altitudeAngle.Add(Float.sin(lat).Mul(Float.sin(declination)));
        altitudeAngle = Float.asin(altitudeAngle);
        Float azimuthAngle = Float.sin(altitudeAngle).Mul(Float.sin(lat));
        azimuthAngle = azimuthAngle.Sub(Float.sin(declination));
        azimuthAngle = azimuthAngle.Div(Float.cos(altitudeAngle).Mul(Float.cos(lat)));
        azimuthAngle = Float.acos(azimuthAngle);
        SkyPosition sun = new SkyPosition();
        if (!azimuthAngle.isError()) {
            if (azimuthAngle.Less(0L)) {
                azimuthAngle = azimuthAngle.Neg();
            }
            if (hourangle.Less(0L)) {
                azimuthAngle = azimuthAngle.Neg();
            }
            sun.Azimuth = (int)azimuthAngle.Div(radPerDeg).Neg().Add(new Float(180L)).toLong();
            sun.Elevation = (int)altitudeAngle.Div(radPerDeg).toLong();
        } else {
            sun.Azimuth = 0;
            sun.Elevation = 0;
        }
        return sun;
    }

    public SkyPosition getMoonPosition() {
        Float d = this.DaysSince2000Dec31();
        Float Nm = this.AdjustRange(new Float(1251228L, -4L).Sub(new Float(529538083L, -10L).Mul(d)).Mul(this.rads));
        Float im = new Float(51454L, -4L).Mul(this.rads);
        Float wm = this.AdjustRange(new Float(3180634L, -4L).Add(new Float(1643573223L, -10L).Mul(d)).Mul(this.rads));
        Float am = new Float(602666L, -4L);
        Float ecm = new Float(549L, -4L);
        Float Mm = this.AdjustRange(new Float(1153654L, -4L).Add(new Float(130649929509L, -10L).Mul(d)).Mul(this.rads));
        Float ws = this.AdjustRange(new Float(2829404L, -4L).Add(new Float(470935L, -10L).Mul(d)).Mul(this.rads));
        Float ecs = new Float(16709L, -6L).Sub(new Float(1151L, -12L).Mul(d));
        Float Ms = this.AdjustRange(new Float(356047L, -3L).Add(new Float(9856002585L, -10L).Mul(d)).Mul(this.rads));
        Float Em = ecm.Mul(Float.sin(Mm)).Mul(new Float(1L).Add(ecm.Mul(Float.cos(Mm)))).Add(Mm);
        Float xv = am.Mul(Float.cos(Em).Sub(ecm));
        Float yv = am.Mul(Float.sqrt(new Float(1L).Sub(ecm.Mul(ecm))).Mul(Float.sin(Em)));
        Float vm = Float.atan2(yv, xv);
        Float rm = Float.sqrt(xv.Mul(xv).Add(yv.Mul(yv)));
        Float xh = rm.Mul(Float.cos(Nm).Mul(Float.cos(vm.Add(wm))).Sub(Float.sin(Nm).Mul(Float.sin(vm.Add(wm))).Mul(Float.cos(im))));
        Float yh = rm.Mul(Float.sin(Nm).Mul(Float.cos(vm.Add(wm))).Add(Float.cos(Nm).Mul(Float.sin(vm.Add(wm))).Mul(Float.cos(im))));
        Float zh = rm.Mul(Float.sin(vm.Add(wm)).Mul(Float.sin(im)));
        Float lon = Float.atan2(yh, xh);
        Float lat = Float.atan2(zh, Float.sqrt(xh.Mul(xh).Add(yh.Mul(yh))));
        Float dm = Mm.Add(wm).Add(Nm).Sub(Ms).Sub(ws);
        rm = rm.Sub(new Float(58L, -2L).Mul(Float.cos(Mm.Sub(dm.Mul(2L)))));
        rm = rm.Sub(new Float(46L, -2L).Mul(Float.cos(dm.Mul(2L))));
        Float xg = rm.Mul(Float.cos(lon)).Mul(Float.cos(lat));
        Float yg = rm.Mul(Float.sin(lon)).Mul(Float.cos(lat));
        Float zg = rm.Mul(Float.sin(lat));
        Float ecl = new Float(234393L, -4L).Sub(new Float(3563L, -10L).Mul(d)).Mul(this.rads);
        Float xe = xg;
        Float ye = yg.Mul(Float.cos(ecl)).Sub(zg.Mul(Float.sin(ecl)));
        Float ze = yg.Mul(Float.sin(ecl)).Add(zg.Mul(Float.cos(ecl)));
        Float RA = Float.atan2(ye, xe).Div(this.rads.Mul(15L));
        Float Dec = Float.atan(ze.Div(Float.sqrt(xe.Mul(xe).Add(ye.Mul(ye)))));
        return this.ConvertCoordinates(RA, Dec);
    }

    private Float DaysSince2000Dec31() {
        return new Float(367 * this.utc.year - 7 * (this.utc.year + (this.utc.month + 9) / 12) / 4 + 275 * this.utc.month / 9 + this.utc.day - 730530).Add(new Float(this.utc.hour).Div(24L));
    }

    private SkyPosition ConvertCoordinates(Float ra, Float dec) {
        Float lst = this.LocalSiderealTime();
        Float x = Float.cos(new Float(15L).Mul(lst.Sub(ra)).Mul(this.rads)).Mul(Float.cos(dec));
        Float y = Float.sin(new Float(15L).Mul(lst.Sub(ra)).Mul(this.rads)).Mul(Float.cos(dec));
        Float z = Float.sin(dec);
        Float xhor = x.Mul(Float.sin(new Float(this.latitude).Mul(this.rads))).Sub(z.Mul(Float.cos(new Float(this.latitude).Mul(this.rads))));
        Float yhor = y;
        Float zhor = x.Mul(Float.cos(new Float(this.latitude).Mul(this.rads))).Add(z.Mul(Float.sin(new Float(this.latitude).Mul(this.rads))));
        SkyPosition skyPosition = new SkyPosition();
        skyPosition.Azimuth = (int)this.Rev(this.ATan2d(yhor, xhor).Add(new Float(180L))).toLong();
        skyPosition.Elevation = (int)this.ATan2d(zhor, Float.sqrt(xhor.Mul(xhor).Add(yhor.Mul(yhor)))).toLong();
        return skyPosition;
    }

    private Float ATan2d(Float y, Float x) {
        if (x.Less(Float.ZERO)) {
            return Float.atan(y.Div(x)).Div(this.rads).Sub(new Float(180L));
        }
        return Float.atan(y.Div(x)).Div(this.rads);
    }

    private Float Rev(Float angle) {
        return angle.Sub(Float.floor(angle.Div(new Float(360L))).Mul(new Float(360L)));
    }

    private Float AdjustRange(Float x) {
        Float b = x.Div(Float.PImul2);
        Float a = Float.PImul2.Mul(b.Sub(Float.floor(b)));
        if (a.Less(Float.ZERO)) {
            a = Float.PImul2.Add(a);
        }
        return a;
    }

    private Float SiderealTime() {
        Float T = this.JulianDate().Sub(new Float(2451545L)).Div(new Float(36525L));
        Float res = new Float(10046061837L, -8L).Add(T.Mul(new Float(36000770053608L, -9L).Add(T.Mul(new Float(387933L, -9L).Sub(T.Div(new Float(38710000L)))))));
        return this.Rev(res).Div(new Float(15L));
    }

    private Float LocalSiderealTime() {
        Float res = this.SiderealTime();
        res = res.Add(new Float(100273790935L, -11L).Mul(new Float(this.utc.hour).Add(new Float(this.utc.minute).Add(new Float(this.utc.second).Div(new Float(60L))).Div(new Float(60L)))));
        res = res.Add(new Float(this.longitude).Div(new Float(15L)));
        while (res.Less(Float.ZERO)) {
            res = res.Add(new Float(24L));
        }
        while (res.Great(new Float(24L))) {
            res = res.Sub(new Float(24L));
        }
        return res;
    }

    private Float JulianDate() {
        int m = this.utc.month;
        int y = this.utc.year;
        if (m < 3) {
            m += 12;
            --y;
        }
        Float a = Float.floor(new Float(y).Div(new Float(100L)));
        Float b = new Float(2L).Sub(a).Add(Float.floor(a.Div(new Float(4L))));
        return Float.floor(new Float(36525L, -2L).Mul(new Float(y).Add(new Float(4716L)))).Add(Float.floor(new Float(306001L, -4L).Mul(new Float(m + 1)))).Add(new Float(this.utc.day)).Add(b).Sub(new Float(15245L, -1L));
    }

    public class OptionsForm
    extends Form
    implements CommandListener {
        private Displayable parentDisplayable;
        private TextField latitudeTextField;
        private TextField longitudeTextField;
        private ChoiceGroup timezoneChoiceGroup;
        private Command cancelCommand;
        private Command okCommand;
        private short[] timeoffsets = new short[]{Short.MAX_VALUE, -720, -660, -600, -540, -480, -420, -360, -300, -240, -180, -120, -60, 0, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 660, 720, 780};

        public OptionsForm(Displayable parent) {
            super("Options");
            this.parentDisplayable = parent;
            this.latitudeTextField = new TextField("Latitude", "" + Compass.this.latitude, 3, 2);
            this.longitudeTextField = new TextField("Longitude", "" + Compass.this.longitude, 4, 2);
            String[] timenames = new String[this.timeoffsets.length];
            int selectedIndex = 0;
            for (int i = 0; i < this.timeoffsets.length; ++i) {
                if (this.timeoffsets[i] == Compass.this.timeoffset) {
                    selectedIndex = i;
                }
                timenames[i] = i == 0 ? "Use Default" : "GMT" + (this.timeoffsets[i] < 0 ? "-" : "+") + (Math.abs(this.timeoffsets[i] / 60) < 10 ? "0" : "") + Math.abs(this.timeoffsets[i] / 60) + ":" + (Math.abs(this.timeoffsets[i] % 60) < 10 ? "0" : "") + Math.abs(this.timeoffsets[i] % 60);
            }
            this.timezoneChoiceGroup = new ChoiceGroup("Time offset", 1, timenames, null);
            this.timezoneChoiceGroup.setSelectedIndex(selectedIndex, true);
            this.cancelCommand = new Command("Cancel", 7, 1);
            this.okCommand = new Command("OK", 4, 1);
            this.append((Item)this.latitudeTextField);
            this.append((Item)this.longitudeTextField);
            this.append((Item)this.timezoneChoiceGroup);
            this.addCommand(this.cancelCommand);
            this.addCommand(this.okCommand);
            this.setCommandListener(this);
        }

        public void commandAction(Command c, Displayable d) {
            if (c == this.okCommand) {
                Compass.this.latitude = (short)Integer.parseInt(this.latitudeTextField.getString());
                Compass.this.longitude = (short)Integer.parseInt(this.longitudeTextField.getString());
                Compass.this.timeoffset = this.timeoffsets[this.timezoneChoiceGroup.getSelectedIndex()];
                Compass.this.saveSettings();
                Compass.this.sunPosition = null;
                Compass.this.moonPosition = null;
                Compass.this.display.setCurrent(this.parentDisplayable);
            } else if (c == this.cancelCommand) {
                Compass.this.display.setCurrent(this.parentDisplayable);
            }
        }
    }

    class CompassCanvas
    extends Canvas
    implements CommandListener,
    Runnable {
        private Command optionsCommand = new Command("Options", 4, 1);
        private Command detailsCommand = new Command("Details", 1, 1);
        private Command aboutCommand = new Command("About", 1, 1);
        private Command exitCommand = new Command("Exit", 7, 1);

        public CompassCanvas() {
            this.addCommand(this.optionsCommand);
            this.addCommand(this.detailsCommand);
            this.addCommand(this.aboutCommand);
            this.addCommand(this.exitCommand);
            this.setCommandListener(this);
        }

        public void run() {
            Compass.this.recalculate();
            this.repaint();
        }

        public void commandAction(Command c, Displayable s) {
            if (c == this.optionsCommand) {
                Compass.this.display.setCurrent((Displayable)new OptionsForm((Displayable)this));
            } else if (c == this.detailsCommand) {
                Alert alert = new Alert("Details");
                alert.setTimeout(-2);
                alert.setString(this.getDetails());
                Compass.this.display.setCurrent((Displayable)alert);
            } else if (c == this.exitCommand) {
                Compass.this.destroyApp(false);
                Compass.this.notifyDestroyed();
            } else if (c == this.aboutCommand) {
                Alert alert = new Alert("About Compass");
                alert.setTimeout(-2);
                alert.setString("Compass 1.0\n\u00a9 2005 Dana Peters\nqcontinuum.org\nFree software\nGNU GPL\nNo Warranty\nUses math library\nhenson.midp.Float\n\u00a9 Nikolay Klimchuk\nhenson.newmail.ru");
                Compass.this.display.setCurrent((Displayable)alert);
            }
        }

        private String getDetails() {
            StringBuffer sb = new StringBuffer();
            if (Compass.this.utc != null) {
                sb.append("GMT: ");
                sb.append(((Compass)Compass.this).utc.year);
                sb.append('-');
                sb.append(((Compass)Compass.this).utc.month);
                sb.append('-');
                sb.append(((Compass)Compass.this).utc.day);
                sb.append(' ');
                sb.append(((Compass)Compass.this).utc.hour);
                sb.append(':');
                sb.append(((Compass)Compass.this).utc.minute < 10 ? "0" + ((Compass)Compass.this).utc.minute : "" + ((Compass)Compass.this).utc.minute);
                sb.append("\n");
            }
            if (Compass.this.sunPosition != null) {
                sb.append("Sun azimuth: ");
                sb.append(((Compass)Compass.this).sunPosition.Azimuth);
                sb.append("\u00b0\n");
                sb.append("Sun elevation: ");
                sb.append(((Compass)Compass.this).sunPosition.Elevation);
                sb.append("\u00b0\n");
            }
            if (Compass.this.moonPosition != null) {
                sb.append("Moon azimuth: ");
                sb.append(((Compass)Compass.this).moonPosition.Azimuth);
                sb.append("\u00b0\n");
                sb.append("Moon elevation: ");
                sb.append(((Compass)Compass.this).moonPosition.Elevation);
                sb.append("\u00b0\n");
            }
            return sb.toString();
        }

        private void clear(Graphics g) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            Graphics graphics = g;
            synchronized (graphics) {
                this.clear(g);
                int maxR = (this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight()) / 2;
                for (int i = 6; i > 0; --i) {
                    int r = maxR * i / 6;
                    if (i == 6) {
                        g.setColor(65280);
                        g.fillArc(maxR - r, maxR - r, r * 2, r * 2, 0, 360);
                        g.setColor(0);
                    } else {
                        g.setColor(32768);
                    }
                    g.drawArc(maxR - r, maxR - r, r * 2, r * 2, 0, 360);
                }
                SkyPosition lineSkyPosition = new SkyPosition();
                lineSkyPosition.Elevation = 0;
                for (int step = 0; step < 16; ++step) {
                    lineSkyPosition.Azimuth = step * 45;
                    ScreenPosition lineScreenPosition = this.SkyToScreen(lineSkyPosition, maxR);
                    g.drawLine(maxR, maxR, lineScreenPosition.x, lineScreenPosition.y);
                }
                g.setColor(0);
                g.setFont(Font.getFont((int)0, (int)1, (int)16));
                g.drawString("N", maxR, 0, 0x10 | 1);
                g.drawString("S", maxR, maxR * 2, 0x20 | 1);
                g.drawString(" W", 0, maxR - g.getFont().getHeight() / 2, 0x10 | 4);
                g.drawString("E ", maxR * 2, maxR - g.getFont().getHeight() / 2, 0x10 | 8);
                if (Compass.this.sunPosition == null || Compass.this.moonPosition == null) {
                    g.drawString("Please", maxR, maxR, 0x20 | 1);
                    g.drawString("Wait", maxR, maxR, 0x10 | 1);
                    Compass.this.display.callSerially((Runnable)this);
                } else {
                    ScreenPosition line2;
                    ScreenPosition line1;
                    SkyPosition line;
                    if (((Compass)Compass.this).sunPosition.Elevation > -10) {
                        ScreenPosition sun = this.SkyToScreen(Compass.this.sunPosition, maxR);
                        line = new SkyPosition();
                        line.Azimuth = ((Compass)Compass.this).sunPosition.Azimuth;
                        line.Elevation = 0;
                        line1 = this.SkyToScreen(line, maxR);
                        line.Azimuth += 180;
                        line2 = this.SkyToScreen(line, maxR);
                        g.setStrokeStyle(1);
                        g.drawLine(line1.x, line1.y, line2.x, line2.y);
                        g.setStrokeStyle(0);
                        g.setColor(0xFFFF00);
                        g.fillArc(sun.x - 8, sun.y - 8, 15, 15, 0, 360);
                        g.setColor(0);
                        g.drawArc(sun.x - 8, sun.y - 8, 15, 15, 0, 360);
                    }
                    if (((Compass)Compass.this).moonPosition.Elevation > -5) {
                        ScreenPosition moon = this.SkyToScreen(Compass.this.moonPosition, maxR);
                        line = new SkyPosition();
                        line.Azimuth = ((Compass)Compass.this).moonPosition.Azimuth;
                        line.Elevation = 0;
                        line1 = this.SkyToScreen(line, maxR);
                        line.Azimuth += 180;
                        line2 = this.SkyToScreen(line, maxR);
                        g.setStrokeStyle(1);
                        g.drawLine(line1.x, line1.y, line2.x, line2.y);
                        g.setStrokeStyle(0);
                        g.setColor(0xFFFFFF);
                        g.fillArc(moon.x - 8, moon.y - 8, 15, 15, 90, 180);
                        g.setColor(0);
                        g.fillArc(moon.x - 8, moon.y - 8, 15, 15, 270, 180);
                        g.drawArc(moon.x - 8, moon.y - 8, 15, 15, 0, 360);
                    }
                }
            }
        }

        private ScreenPosition SkyToScreen(SkyPosition skyPosition, int maxR) {
            ScreenPosition screenPosition = new ScreenPosition();
            Float r = new Float(90 - skyPosition.Elevation).Div(90L).Mul(maxR);
            Float azimuth = Float.toRadians(new Float(skyPosition.Azimuth));
            screenPosition.x = (int)Float.sin(azimuth).Mul(r).toLong() + maxR;
            screenPosition.y = (int)Float.cos(azimuth).Mul(r).Neg().toLong() + maxR;
            return screenPosition;
        }
    }

    protected class UTCDate {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int minute;
        public int second;

        public UTCDate() {
            Date time = new Date(System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            if (Compass.this.timeoffset == Short.MAX_VALUE) {
                cal.setTimeZone(TimeZone.getTimeZone("GMT"));
                cal.setTime(time);
            } else {
                cal.setTimeZone(TimeZone.getDefault());
                Date adjustedTime = new Date();
                adjustedTime.setTime(time.getTime() - (long)(Compass.this.timeoffset * 60 * 1000));
                cal.setTime(adjustedTime);
            }
            this.year = cal.get(1);
            this.month = cal.get(2) + 1;
            this.day = cal.get(5);
            this.hour = cal.get(11);
            this.minute = cal.get(12);
            this.second = cal.get(13);
        }
    }

    protected class ScreenPosition {
        public int x;
        public int y;

        protected ScreenPosition() {
        }
    }

    protected class SkyPosition {
        public int Azimuth;
        public int Elevation;

        protected SkyPosition() {
        }
    }
}

