/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class calendarCanvas
extends Canvas {
    private Display display;
    private Displayable displayable;
    private Font font;
    private globalCalendar now;
    private static int groundColor = 0xFFFFFF;
    private static int linesColor = 0xCCCCCC;
    private static int drawColor = 0;
    private static int drawWeekendColor = 0xFF0000;
    private static int hsp = 1;
    private static int vsp = 1;
    private int day;
    private int mon;
    private int year;
    private int weekDay;
    private int h;
    private int w;
    private int x;
    private int y;
    private String s;

    public calendarCanvas(Display display, int n, int n2) {
        this.display = display;
        this.displayable = display.getCurrent();
        this.font = Font.getFont((int)0, (int)0, (int)0);
        this.w = 2 * this.font.charWidth('0') + 2 * hsp;
        this.h = this.font.getHeight() + 2 * vsp;
        this.x = (this.getWidth() - 7 * this.w) / 2;
        this.y = (this.getHeight() - 7 * this.h) / 2;
        this.now = new globalCalendar();
        this.mon = n;
        this.year = n2;
    }

    protected void keyPressed(int n) {
        this.display.setCurrent(this.displayable);
    }

    protected void paint(Graphics graphics) {
        int n;
        graphics.setColor(groundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(linesColor);
        for (n = 0; n < 8; ++n) {
            graphics.drawLine(this.x + n * this.w, this.y, this.x + n * this.w, this.y + 7 * this.h);
        }
        for (n = 0; n < 8; ++n) {
            graphics.drawLine(this.x, this.y + n * this.h, this.x + 7 * this.w, this.y + n * this.h);
        }
        graphics.setColor(drawColor);
        for (n = 1; n < 7; ++n) {
            graphics.drawString(this.now.shortDay(n), this.x + hsp + (n - 1) * this.w, this.y + vsp, 20);
        }
        graphics.drawString(this.now.shortDay(0), this.x + hsp + 6 * this.w, this.y + vsp, 20);
        int n2 = this.now.getMonthDays(this.mon, this.year);
        int n3 = this.now.getWeekDayInAnyYear(1, this.mon, this.year);
        if (n3 == 0) {
            n3 = 7;
        }
        int n4 = this.y + this.h + vsp;
        int n5 = this.x + hsp;
        for (n = 0; n < n3 - 1; ++n) {
            n5 += this.w;
        }
        int n6 = 1;
        while (n6 <= n2) {
            if (n3 > 5) {
                graphics.setColor(drawWeekendColor);
            } else {
                graphics.setColor(drawColor);
            }
            graphics.drawString("" + n6, n5, n4, 20);
            ++n6;
            n5 += this.w;
            if (++n3 <= 7) continue;
            n3 = 1;
            n5 = this.x + hsp;
            n4 += this.h;
        }
    }
}

