/*
 * Decompiled with CFR 0.152.
 */
package midp.shopper;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import midp.shopper.Category;
import midp.shopper.Locale;
import midp.shopper.Product;

public class Shopper
extends MIDlet
implements CommandListener {
    private static Shopper instance = null;
    private Vector categories;
    private RecordStore store;
    private static Image[] categoryImages;
    private static Image productsImage;
    private static Hashtable imageHash;
    static Command BACK_CMD;
    static Command ADD_CMD;
    static Command REMOVE_CMD;
    static Command RENAME_CMD;
    static Command ENTER_CMD;
    static Command QUIT_CMD;
    static final String ENCODING = "UTF-8";
    private Class[] actions = new Class[]{Shopper.getClassObject("midp.shopper.NeedList"), Shopper.getClassObject("midp.shopper.CategoryList"), Shopper.getClassObject("midp.shopper.ResetList")};
    private List actionList;
    static final String STORE_NAME = "Shopper104";

    public Vector getCategories() {
        return this.categories;
    }

    private static Class getClassObject(String string) {
        try {
            return Class.forName(string);
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getClass().getName() + ": " + throwable.getMessage());
            throwable.printStackTrace();
            return null;
        }
    }

    static Shopper getInstance() {
        return instance;
    }

    public Shopper() {
        new Locale(this.getAppProperty("Shopper.Locale"));
        BACK_CMD = new Command(Locale.current.back, 2, 1);
        ADD_CMD = new Command(Locale.current.add, 8, 1);
        REMOVE_CMD = new Command(Locale.current.remove, 8, 1);
        RENAME_CMD = new Command(Locale.current.rename, 8, 1);
        ENTER_CMD = new Command(Locale.current.enter, 2, 1);
        QUIT_CMD = new Command(Locale.current.quit, 2, 1);
        categoryImages = new Image[Locale.current.categoryIcons.length];
        imageHash = new Hashtable();
        try {
            productsImage = Image.createImage((String)"/midp/shopper/products.png");
            for (int i = 0; i < Locale.current.categoryIcons.length; ++i) {
                Shopper.categoryImages[i] = Image.createImage((String)("/midp/shopper/" + Locale.current.categoryIcons[i] + ".png"));
                imageHash.put(Locale.current.categories[i], categoryImages[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.actionList = new List(Locale.current.name, 3, Locale.current.actionNames, null);
        this.actionList.addCommand(QUIT_CMD);
        instance = this;
    }

    private void openStore() {
        try {
            try {
                this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
                this.loadData();
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
                this.initializeStore();
            }
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    private static void pack(byte[] byArray, int n) {
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
    }

    private static int unpack(byte[] byArray) {
        return byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private static byte[] str2Bytes(String string) {
        try {
            return string.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    private void initializeStore() {
        try {
            this.categories = new Vector();
            for (int i = 0; i < Locale.current.categories.length; ++i) {
                byte[] byArray = Shopper.str2Bytes(Locale.current.categories[i]);
                byte[] byArray2 = new byte[byArray.length + 5];
                System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
                int n = this.store.addRecord(byArray2, 0, byArray2.length);
                Category category = new Category(n, Locale.current.categories[i], categoryImages[i]);
                this.categories.addElement(category);
                for (int j = 0; j < Locale.current.products[i].length; ++j) {
                    byArray = Shopper.str2Bytes(Locale.current.products[i][j]);
                    byArray2 = new byte[byArray.length + 5];
                    Shopper.pack(byArray2, n);
                    System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
                    int n2 = this.store.addRecord(byArray2, 0, byArray2.length);
                    Product product = new Product(n2, category, byArray2, false, Locale.current.products[i][j]);
                    category.products.addElement(product);
                }
            }
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    private final Image getCategoryIcon(String string) {
        Image image = (Image)imageHash.get(string);
        return image == null ? productsImage : image;
    }

    private void loadData() throws Exception {
        this.categories = new Vector();
        Hashtable<Integer, Category> hashtable = new Hashtable<Integer, Category>();
        try {
            int n = this.store.getNextRecordID();
            for (int i = 1; i < n; ++i) {
                Category category;
                byte[] byArray = null;
                try {
                    byArray = this.store.getRecord(i);
                }
                catch (InvalidRecordIDException invalidRecordIDException) {
                    // empty catch block
                }
                if (byArray == null) continue;
                int n2 = Shopper.unpack(byArray);
                String string = new String(byArray, 5, byArray.length - 5, ENCODING);
                if (n2 == 0) {
                    category = new Category(i, string, this.getCategoryIcon(string));
                    this.categories.addElement(category);
                    hashtable.put(new Integer(i), category);
                    continue;
                }
                category = (Category)hashtable.get(new Integer(n2));
                if (category == null) {
                    this.store.closeRecordStore();
                    RecordStore.deleteRecordStore((String)STORE_NAME);
                    this.criticalError("Failed to locate category");
                    return;
                }
                Product product = new Product(i, category, byArray, byArray[4] != 0, string);
                category.products.addElement(product);
            }
        }
        catch (Exception exception) {
            try {
                this.store.closeRecordStore();
                RecordStore.deleteRecordStore((String)STORE_NAME);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.criticalException(exception);
        }
    }

    public void storeProduct(Product product) {
        try {
            product.record[4] = (byte)(product.selected ? 1 : 0);
            this.store.setRecord(product.recordId, product.record, 0, product.record.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    public void storeCategory(Category category) {
        try {
            byte[] byArray = Shopper.str2Bytes(category.name);
            byte[] byArray2 = new byte[byArray.length + 5];
            System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
            this.store.setRecord(category.recordId, byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
    }

    public Category addCategory(String string) {
        byte[] byArray = Shopper.str2Bytes(string);
        byte[] byArray2 = new byte[byArray.length + 5];
        int n = 0;
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        try {
            n = this.store.addRecord(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
        Category category = new Category(n, string, this.getCategoryIcon(string));
        this.categories.addElement(category);
        return category;
    }

    public void removeCategory(int n) {
        Category category = (Category)this.categories.elementAt(n);
        if (category.products.size() != 0) {
            this.error(Locale.current.notEmpty);
        } else {
            try {
                this.store.deleteRecord(category.recordId);
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
            this.categories.removeElementAt(n);
        }
    }

    public Product addProduct(String string, Category category) {
        byte[] byArray = Shopper.str2Bytes(string);
        byte[] byArray2 = new byte[byArray.length + 5];
        int n = 0;
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        Shopper.pack(byArray2, category.recordId);
        try {
            n = this.store.addRecord(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            this.criticalException(exception);
        }
        Product product = new Product(n, category, byArray2, false, string);
        category.products.addElement(product);
        return product;
    }

    public void removeProduct(int n, Product product) {
        try {
            this.store.deleteRecord(product.recordId);
        }
        catch (Exception exception) {
            this.criticalException(exception);
            return;
        }
        product.category.products.removeElementAt(n);
    }

    public void restoreData() {
        int n = this.categories.size();
        for (int i = 0; i < n; ++i) {
            Vector vector = ((Category)this.categories.elementAt((int)i)).products;
            int n2 = vector.size();
            for (int j = 0; j < n2; ++j) {
                Product product = (Product)vector.elementAt(j);
                product.restore();
                this.storeProduct(product);
            }
        }
    }

    public void clearData() {
        int n = this.categories.size();
        for (int i = 0; i < n; ++i) {
            Vector vector = ((Category)this.categories.elementAt((int)i)).products;
            int n2 = vector.size();
            for (int j = 0; j < n2; ++j) {
                Product product = (Product)vector.elementAt(j);
                product.unselect();
                this.storeProduct(product);
            }
        }
    }

    public void setData() {
        int n = this.categories.size();
        for (int i = 0; i < n; ++i) {
            Vector vector = ((Category)this.categories.elementAt((int)i)).products;
            int n2 = vector.size();
            for (int j = 0; j < n2; ++j) {
                Product product = (Product)vector.elementAt(j);
                product.select();
                this.storeProduct(product);
            }
        }
    }

    protected void destroyApp(boolean bl) {
        if (this.store != null) {
            try {
                this.store.closeRecordStore();
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        }
        this.actionList = null;
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        if (this.store == null) {
            this.openStore();
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.actionList);
        this.actionList.setCommandListener((CommandListener)this);
    }

    public static void quit() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    public static void goBack() {
        instance.startApp();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == QUIT_CMD) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            int n = this.actionList.getSelectedIndex();
            try {
                Displayable displayable2 = (Displayable)this.actions[n].newInstance();
                Display.getDisplay((MIDlet)this).setCurrent(displayable2);
            }
            catch (Exception exception) {
                this.criticalException(exception);
            }
        }
    }

    void criticalException(Exception exception) {
        exception.printStackTrace();
        this.criticalError(exception.toString());
    }

    void criticalError(String string) {
        System.err.println(string);
        this.error(string);
    }

    void error(String string) {
        Alert alert = new Alert(Locale.current.error);
        alert.setType(AlertType.ERROR);
        alert.setString(string);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
    }
}

