/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class ShopList
extends List
implements CommandListener {
    Econometer econometer;
    Displayable parent;

    ShopList(Econometer econometer, Displayable displayable) {
        super(Locale.current.shopList, 3);
        this.econometer = econometer;
        this.parent = displayable;
        int n = 0;
        int n2 = econometer.shops.size();
        while (n < n2) {
            Shop shop = (Shop)econometer.shops.elementAt(n);
            this.append(shop.name, null);
            ++n;
        }
        this.setCommandListener(this);
        this.addCommand(Econometer.ADD_CMD);
        this.addCommand(Econometer.EDIT_CMD);
        this.addCommand(Econometer.DELETE_CMD);
        this.addCommand(Econometer.BACK_CMD);
        Display.getDisplay((MIDlet)econometer).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Econometer.BACK_CMD) {
            Display.getDisplay((MIDlet)this.econometer).setCurrent(this.parent);
        } else if (command == Econometer.ADD_CMD) {
            new NewShopForm(this.econometer, this);
        } else if (command == Econometer.DELETE_CMD) {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                Shop shop = (Shop)this.econometer.shops.elementAt(n);
                if (shop.nPurchases == 0) {
                    this.econometer.removeShop(shop, n);
                    this.delete(n);
                } else {
                    this.econometer.showAlert(AlertType.ERROR, Locale.current.error, Locale.current.notEmpty, (Displayable)this);
                }
            }
        } else if (command == Econometer.EDIT_CMD) {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                new EditShopForm(this.econometer, this, n);
            }
        } else {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                new ShopMenu(this.econometer, (Displayable)this, (Shop)this.econometer.shops.elementAt(n));
            }
        }
    }
}

