/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class NewPurchaseForm
extends Form
implements CommandListener {
    Econometer econometer;
    Displayable parent;
    TextField priceField;
    TextField descriptionField;
    Shop shop;

    NewPurchaseForm(Econometer econometer, Displayable displayable, Shop shop) {
        super(Locale.current.newPurchase);
        this.econometer = econometer;
        this.parent = displayable;
        this.shop = shop;
        this.priceField = new TextField(Locale.current.price, "", 32, Settings.instance.getPriceFieldFormat(0L));
        this.descriptionField = new TextField(Locale.current.description, "", 64, 0);
        this.append((Item)new StringItem(Locale.current.location, shop.name));
        this.append((Item)this.priceField);
        this.append((Item)this.descriptionField);
        this.setCommandListener(this);
        this.addCommand(Econometer.BACK_CMD);
        this.addCommand(Econometer.ENTER_CMD);
        Display.getDisplay((MIDlet)econometer).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Econometer.ENTER_CMD) {
            long l = 0L;
            try {
                l = Purchase.parsePrice(this.priceField.getString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (l <= 0L) {
                this.econometer.showAlert(AlertType.ERROR, Locale.current.error, Locale.current.priceNotValid, (Displayable)this);
                return;
            }
            Purchase purchase = new Purchase(this.descriptionField.getString(), l, this.shop);
            this.econometer.storePurchase(purchase);
        } else if (command != Econometer.BACK_CMD) {
            return;
        }
        Display.getDisplay((MIDlet)this.econometer).setCurrent(this.parent);
    }
}

