/*
 * Decompiled with CFR 0.152.
 */
package com.sc.chordbook;

import com.sc.chordbook.ChordBox;
import com.sc.chordbook.ChordViewCanvas;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class FindShapeMidlet
extends MIDlet
implements CommandListener {
    private String[] mRootNames = new String[]{"A", "Bb", "B", "C", "C#", "D", "Eb", "E", "F", "F#", "G", "Ab"};
    private String[] mTypeNames = new String[]{"maj", "m", "7", "maj7", "m7", "6", "maj6", "m6", "9", "maj9", "m9", "6/9", "sus4", "7sus4", "9sus4", "dim", "aug", "aug7", "aug9", "m11", "13", "maj13", "min13", "7b5", "m7b5", "9b5"};
    private Display mDisplay;
    private List mRootList;
    private List mTypeList;
    private Form mProgressForm;
    private ChordViewCanvas mChordViewCanvas;
    private StringItem mProgressString;
    private Gauge mProgressGauge;
    private Command mNextCommand;
    private Command mBackCommand;
    private Command mFindCommand;
    private Command mMoreCommand;
    private Command mExitCommand;
    private String mRoot;
    private String mType;
    private Vector mChords = new Vector();
    private int mProgressValue = 0;

    public FindShapeMidlet() {
        this.mRootList = new List("Chord root", 3, this.mRootNames, null);
        this.mTypeList = new List("Chord type", 3, this.mTypeNames, null);
        this.mProgressForm = new Form("Please wait...");
        this.mProgressGauge = new Gauge(null, false, 10, 0);
        this.mProgressString = new StringItem(null, null);
        this.mProgressForm.append((Item)this.mProgressGauge);
        this.mProgressForm.append((Item)this.mProgressString);
        this.mChordViewCanvas = new ChordViewCanvas();
        this.mNextCommand = new Command("Next", 1, 0);
        this.mBackCommand = new Command("Back", 2, 0);
        this.mFindCommand = new Command("Find", 1, 0);
        this.mMoreCommand = new Command("More", 1, 0);
        this.mExitCommand = new Command("Exit", 7, 0);
        this.mRootList.addCommand(this.mNextCommand);
        this.mRootList.addCommand(this.mExitCommand);
        this.mRootList.setCommandListener((CommandListener)this);
        this.mTypeList.addCommand(this.mBackCommand);
        this.mTypeList.addCommand(this.mFindCommand);
        this.mTypeList.setCommandListener((CommandListener)this);
        this.mProgressForm.addCommand(this.mBackCommand);
        this.mProgressForm.setCommandListener((CommandListener)this);
        this.mChordViewCanvas.addCommand(this.mBackCommand);
        this.mChordViewCanvas.addCommand(this.mMoreCommand);
        this.mChordViewCanvas.setCommandListener(this);
    }

    public void startApp() {
        this.mDisplay = Display.getDisplay((MIDlet)this);
        this.mChordViewCanvas.setUseColour(this.mDisplay.isColor());
        this.mChordViewCanvas.setNumColours(this.mDisplay.numColors());
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mRootList);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable s) {
        if (s == this.mRootList && (c == this.mNextCommand || c == List.SELECT_COMMAND)) {
            this.mRoot = this.mRootNames[this.mRootList.getSelectedIndex()];
            this.mDisplay.setCurrent((Displayable)this.mTypeList);
        } else if (s == this.mTypeList && (c == this.mFindCommand || c == List.SELECT_COMMAND)) {
            this.mType = this.mTypeNames[this.mTypeList.getSelectedIndex()];
            if (this.mType == "6/9") {
                this.mType = "6slash9";
            }
            this.mDisplay.setCurrent((Displayable)this.mProgressForm);
            Fetcher f = new Fetcher(this.getAppProperty("chordbook.shapeServletURL"), this.mRoot, this.mType);
            f.start();
        } else if (c == this.mBackCommand) {
            this.mDisplay.setCurrent((Displayable)this.mRootList);
        } else if (c == this.mMoreCommand) {
            this.mChordViewCanvas.nextChord();
            this.mChordViewCanvas.repaint();
        } else if (c == this.mExitCommand) {
            this.notifyDestroyed();
        }
    }

    private class ProgressSpinner
    extends TimerTask {
        private ProgressSpinner() {
        }

        public void run() {
            FindShapeMidlet.this.mProgressValue++;
            FindShapeMidlet.this.mProgressValue %= 11;
            FindShapeMidlet.this.mProgressGauge.setValue(FindShapeMidlet.this.mProgressValue);
        }
    }

    private class Fetcher
    extends Thread {
        private StringBuffer url;

        public Fetcher(String baseURL, String rootValue, String typeValue) {
            FindShapeMidlet.this.mChords.removeAllElements();
            rootValue = rootValue.replace('#', 's');
            this.url = new StringBuffer();
            this.url.append(baseURL);
            this.url.append("?root=");
            this.url.append(rootValue);
            this.url.append("&type=");
            this.url.append(typeValue);
            System.out.println("url = " + this.url.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block18: {
                HttpConnection c = null;
                InputStream in = null;
                Timer timer = new Timer();
                timer.schedule((TimerTask)new ProgressSpinner(), 0L, 100L);
                try {
                    c = (HttpConnection)Connector.open((String)this.url.toString());
                    in = c.openInputStream();
                    if (c.getResponseCode() != 200) {
                        System.out.println("HTTP error: " + c.getResponseCode());
                        break block18;
                    }
                    int numChords = Integer.parseInt(c.getHeaderField("numChords"));
                    int i = 0;
                    while (i < numChords) {
                        byte pos = (byte)in.read();
                        byte[] frets = new byte[6];
                        in.read(frets);
                        byte[] fingers = new byte[6];
                        in.read(fingers);
                        if (FindShapeMidlet.this.mType == "6slash9") {
                            FindShapeMidlet.this.mType = "6/9";
                        }
                        ChordBox chord = new ChordBox(FindShapeMidlet.this.mRoot + FindShapeMidlet.this.mType, pos, frets, fingers);
                        FindShapeMidlet.this.mChords.addElement(chord);
                        ++i;
                    }
                    try {
                        in.close();
                        c.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (FindShapeMidlet.this.mChords.size() == 0) {
                        String msg = "sorry, no match for " + FindShapeMidlet.this.mRoot + FindShapeMidlet.this.mType;
                        Alert results = new Alert("Search Result", msg, null, null);
                        FindShapeMidlet.this.mDisplay.setCurrent(results, (Displayable)FindShapeMidlet.this.mRootList);
                    } else {
                        FindShapeMidlet.this.mChordViewCanvas.reset();
                        FindShapeMidlet.this.mChordViewCanvas.setChords(FindShapeMidlet.this.mChords);
                        FindShapeMidlet.this.mDisplay.setCurrent((Displayable)FindShapeMidlet.this.mChordViewCanvas);
                    }
                }
                catch (IOException ioe) {
                    String msg = "Servlet error: " + ioe;
                    Alert error = new Alert("Error", msg, null, null);
                    FindShapeMidlet.this.mDisplay.setCurrent(error, (Displayable)FindShapeMidlet.this.mRootList);
                }
                finally {
                    try {
                        in.close();
                        c.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

