/*
 * Decompiled with CFR 0.152.
 */
package com.sc.chordbook;

import com.sc.chordbook.ChordBox;
import com.sc.chordbook.ChordEntryCanvas;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class FindNameMidlet
extends MIDlet
implements CommandListener {
    private Display mDisplay;
    private Form mProgressForm;
    private Form mResultForm;
    private ChordEntryCanvas mChordEntryCanvas;
    private StringItem mProgressString;
    private StringItem mResultHeader;
    private Gauge mProgressGauge;
    private Command mFindCommand;
    private Command mBackCommand;
    private Command mExitCommand;
    private Vector mChords = new Vector();
    private int mProgressValue = 0;

    public FindNameMidlet() {
        this.mProgressForm = new Form("Please wait...");
        this.mProgressGauge = new Gauge(null, false, 10, 0);
        this.mProgressString = new StringItem(null, null);
        this.mProgressForm.append((Item)this.mProgressGauge);
        this.mProgressForm.append((Item)this.mProgressString);
        this.mResultForm = new Form("Search Result");
        this.mResultHeader = new StringItem("Pos Chord", null);
        this.mResultForm.append((Item)this.mResultHeader);
        this.mChordEntryCanvas = new ChordEntryCanvas();
        this.mFindCommand = new Command("Find", 1, 0);
        this.mBackCommand = new Command("Back", 2, 0);
        this.mExitCommand = new Command("Exit", 7, 0);
        this.mResultForm.addCommand(this.mBackCommand);
        this.mResultForm.addCommand(this.mExitCommand);
        this.mResultForm.setCommandListener((CommandListener)this);
        this.mChordEntryCanvas.addCommand(this.mFindCommand);
        this.mChordEntryCanvas.addCommand(this.mExitCommand);
        this.mChordEntryCanvas.setCommandListener(this);
    }

    public void startApp() {
        this.mDisplay = Display.getDisplay((MIDlet)this);
        this.mChordEntryCanvas.setUseColour(this.mDisplay.isColor());
        this.mChordEntryCanvas.setNumColours(this.mDisplay.numColors());
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mChordEntryCanvas);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.mFindCommand) {
            String shape = this.mChordEntryCanvas.getShape();
            this.mDisplay.setCurrent((Displayable)this.mProgressForm);
            Fetcher f = new Fetcher(this.getAppProperty("chordbook.nameServletURL"), shape);
            f.start();
        } else if (c == this.mBackCommand) {
            this.mDisplay.setCurrent((Displayable)this.mChordEntryCanvas);
        } else if (c == this.mExitCommand) {
            this.notifyDestroyed();
        }
    }

    private class ProgressSpinner
    extends TimerTask {
        private ProgressSpinner() {
        }

        public void run() {
            FindNameMidlet.this.mProgressValue++;
            FindNameMidlet.this.mProgressValue %= 11;
            FindNameMidlet.this.mProgressGauge.setValue(FindNameMidlet.this.mProgressValue);
        }
    }

    private class Fetcher
    extends Thread {
        private StringBuffer url;

        public Fetcher(String baseURL, String shapeValue) {
            FindNameMidlet.this.mChords.removeAllElements();
            int i = 1;
            while (i < FindNameMidlet.this.mResultForm.size()) {
                FindNameMidlet.this.mResultForm.delete(i);
                ++i;
            }
            this.url = new StringBuffer();
            this.url.append(baseURL);
            this.url.append("?shape=");
            this.url.append(shapeValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block19: {
                HttpConnection c = null;
                InputStream in = null;
                Timer timer = new Timer();
                timer.schedule((TimerTask)new ProgressSpinner(), 0L, 100L);
                try {
                    c = (HttpConnection)Connector.open((String)this.url.toString());
                    in = c.openInputStream();
                    if (c.getResponseCode() != 200) {
                        System.out.println("HTTP error: " + c.getResponseCode());
                        break block19;
                    }
                    int numChords = Integer.parseInt(c.getHeaderField("numChords"));
                    int i = 0;
                    while (i < numChords) {
                        byte pos = (byte)in.read();
                        byte nameLength = (byte)in.read();
                        byte[] name = new byte[nameLength];
                        in.read(name);
                        ChordBox chord = new ChordBox();
                        chord.setName(new String(name));
                        chord.setPos(pos);
                        FindNameMidlet.this.mChords.addElement(chord);
                        ++i;
                    }
                    timer.cancel();
                    try {
                        in.close();
                        c.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (FindNameMidlet.this.mChords.size() == 0) {
                        String msg = "sorry, no matching chords";
                        Alert results = new Alert("Search Result", msg, null, null);
                        results.setTimeout(-2);
                        FindNameMidlet.this.mDisplay.setCurrent(results, (Displayable)FindNameMidlet.this.mChordEntryCanvas);
                    } else {
                        StringBuffer msg = new StringBuffer("\n");
                        int i2 = 0;
                        while (i2 < FindNameMidlet.this.mChords.size()) {
                            ChordBox chord = (ChordBox)FindNameMidlet.this.mChords.elementAt(i2);
                            String name = chord.getName();
                            byte pos = chord.getPos();
                            msg.append(pos);
                            msg.append("    ");
                            if (pos < 10) {
                                msg.append(' ');
                            }
                            msg.append(name);
                            msg.append('\n');
                            ++i2;
                        }
                        FindNameMidlet.this.mResultForm.append(msg.toString());
                        FindNameMidlet.this.mDisplay.setCurrent((Displayable)FindNameMidlet.this.mResultForm);
                    }
                }
                catch (IOException ioe) {
                    timer.cancel();
                    String msg = "Servlet communication error: " + ioe;
                    Alert error = new Alert("Error", msg, null, null);
                    FindNameMidlet.this.mDisplay.setCurrent(error, (Displayable)FindNameMidlet.this.mChordEntryCanvas);
                }
                finally {
                    try {
                        in.close();
                        c.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

