/*
 * Decompiled with CFR 0.152.
 */
package com.sc.chordbook;

import com.sc.chordbook.ChordBox;
import com.sc.chordbook.ChordCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class ChordViewCanvas
extends ChordCanvas {
    private Vector mChords = new Vector();
    private ChordBox mChordBox;
    private int mCurrent = 0;

    public void setChords(Vector chords) {
        this.mChords = chords;
    }

    public void nextChord() {
        this.mCurrent = this.mCurrent < this.mChords.size() - 1 ? ++this.mCurrent : 0;
    }

    public void setChord(int index) {
        this.mCurrent = index;
    }

    public boolean lastChord() {
        return this.mCurrent >= this.mChords.size() - 1;
    }

    public void reset() {
        this.mCurrent = 0;
    }

    public void paint(Graphics g) {
        this.mChordBox = (ChordBox)this.mChords.elementAt(this.mCurrent);
        int highFret = this.mChordBox.getHighestFret();
        this.plotLayout(highFret);
        super.paint(g);
        boolean zeroFret = false;
        if (this.mChordBox.getPos() == 1) {
            zeroFret = true;
        }
        this.paintBox(g, zeroFret);
        this.paintPos(g, this.mChordBox.getPos());
        this.paintName(g, this.mChordBox.getName(), this.mCurrent + 1);
        this.paintDots(g);
    }

    protected void paintDots(Graphics g) {
        if (this.mPortrait) {
            this.paintDotsPortrait(g);
        } else {
            this.paintDotsLandscape(g);
        }
    }

    private void paintDotsPortrait(Graphics g) {
        int str = 0;
        int x = this.mBoxLeft;
        while (x <= this.mBoxRight) {
            str = (byte)(str + 1);
            byte fret = (byte)(this.mChordBox.getFret(str) - 1);
            byte finger = (byte)(this.mChordBox.getFinger(str) + 48);
            switch (fret) {
                case 8: {
                    this.chooseColour(g, (byte)4);
                    g.drawChar('X', x, this.mBoxTop, 33);
                    break;
                }
                case -1: {
                    this.chooseColour(g, (byte)5);
                    g.drawChar('O', x, this.mBoxTop, 33);
                    break;
                }
                default: {
                    int dotTop = this.mBoxTop + this.mFretGap * fret + this.mHalfFretGap - this.mDotRadius;
                    this.chooseColour(g, (byte)6);
                    g.fillArc(x - this.mDotRadius, dotTop, this.mDotDiameter, this.mDotDiameter, 0, 360);
                    this.chooseColour(g, (byte)7);
                    char c = (char)finger;
                    g.drawChar(c, x, dotTop + this.mDotFingerGap, 17);
                }
            }
            x += this.mStringGap;
        }
    }

    private void paintDotsLandscape(Graphics g) {
        int str = 7;
        int y = this.mBoxTop;
        while (y <= this.mBoxBottom) {
            str = (byte)(str - 1);
            byte fret = (byte)(this.mChordBox.getFret(str) - 1);
            byte finger = (byte)(this.mChordBox.getFinger(str) + 48);
            switch (fret) {
                case 8: {
                    this.chooseColour(g, (byte)4);
                    g.drawChar('X', this.mBoxLeft - this.mFontWidth + 1, y - this.mDotRadius + this.mDotFingerGap + 1, 20);
                    break;
                }
                case -1: {
                    this.chooseColour(g, (byte)5);
                    g.drawChar('O', this.mBoxLeft - this.mFontWidth, y - this.mDotRadius + this.mDotFingerGap + 1, 20);
                    break;
                }
                default: {
                    int dotLeft = this.mBoxLeft + this.mFretGap * fret + this.mHalfFretGap - this.mDotRadius;
                    this.chooseColour(g, (byte)6);
                    g.fillArc(dotLeft, y - this.mDotRadius, this.mDotDiameter, this.mDotDiameter, 0, 360);
                    this.chooseColour(g, (byte)7);
                    char c = (char)finger;
                    int charWidth = this.mFont.charWidth(c);
                    g.drawChar(c, dotLeft + this.mDotRadius - charWidth / 2, y - this.mDotRadius + this.mDotFingerGap, 20);
                }
            }
            y += this.mStringGap;
        }
    }
}

