/*
 * Decompiled with CFR 0.152.
 */
package com.sc.chordbook;

import com.sc.chordbook.ChordBox;
import com.sc.chordbook.ChordCanvas;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;

public class ChordEntryCanvas
extends ChordCanvas {
    private ChordBox mChord = new ChordBox();
    private byte mCursorString;
    private byte mCursorFret;
    private Timer mCursorTimer;
    private boolean mCursorVisible = true;

    public ChordEntryCanvas() {
        this.mChord.setFrets("022100");
        this.plotLayout(5);
        this.mCursorFret = 1;
        this.mCursorString = this.mPortrait ? (byte)1 : (byte)4;
    }

    public byte[] getShapeArray() {
        return this.mChord.getFretArray();
    }

    public String getShape() {
        return this.mChord.getFrets();
    }

    protected void showNotify() {
        this.mCursorTimer = new Timer();
        this.mCursorTimer.schedule((TimerTask)new CursorFlasher(), 0L, 400L);
    }

    protected void hideNotify() {
        this.mCursorTimer.cancel();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.mPortrait) {
            g.translate(0, 2);
        } else {
            g.translate(2, 0);
        }
        this.paintStringLabels(g);
        this.paintBox(g, false);
        this.paintDots(g);
        this.paintCursor(g);
    }

    protected void paintStringLabels(Graphics g) {
        if (this.mPortrait) {
            this.paintStringLabelsPortrait(g);
        } else {
            this.paintStringLabelsLandscape(g);
        }
    }

    private void paintStringLabelsPortrait(Graphics g) {
        int str = 0;
        int x = this.mBoxLeft;
        while (x <= this.mBoxRight) {
            this.chooseColour(g, (byte)9);
            int n = str;
            str = (byte)(str + 1);
            g.drawChar(ChordCanvas.TUNING[n], x, this.mBoxTop + 1, 33);
            x += this.mStringGap;
        }
    }

    private void paintStringLabelsLandscape(Graphics g) {
        int str = 6;
        int y = this.mBoxTop;
        while (y <= this.mBoxBottom) {
            this.chooseColour(g, (byte)9);
            str = (byte)(str - 1);
            char label = ChordCanvas.TUNING[str];
            int labelWidth = this.mFont.charWidth(label);
            g.drawChar(label, this.mBoxLeft - labelWidth - 2, y - this.mDotRadius + this.mDotFingerGap + 1, 20);
            y += this.mStringGap;
        }
    }

    protected void paintDots(Graphics g) {
        if (this.mPortrait) {
            this.paintDotsPortrait(g);
        } else {
            this.paintDotsLandscape(g);
        }
    }

    private void paintDotsPortrait(Graphics g) {
        int str = 0;
        int x = this.mBoxLeft;
        while (x <= this.mBoxRight) {
            this.chooseColour(g, (byte)6);
            str = (byte)(str + 1);
            byte fret = (byte)(this.mChord.getFret(str) - 1);
            if (fret > -1) {
                g.fillArc(x - this.mDotRadius, this.mBoxTop + this.mFretGap * fret - this.mDotRadius + this.mHalfFretGap, this.mDotDiameter, this.mDotDiameter, 0, 360);
            }
            x += this.mStringGap;
        }
    }

    private void paintDotsLandscape(Graphics g) {
        int str = 7;
        int y = this.mBoxTop;
        while (y <= this.mBoxBottom) {
            this.chooseColour(g, (byte)6);
            str = (byte)(str - 1);
            byte fret = (byte)(this.mChord.getFret(str) - 1);
            if (fret > -1) {
                g.fillArc(this.mBoxLeft + this.mFretGap * fret - this.mDotRadius + this.mHalfFretGap, y - this.mDotRadius, this.mDotDiameter, this.mDotDiameter, 0, 360);
            }
            y += this.mStringGap;
        }
    }

    protected void paintCursor(Graphics g) {
        if (this.mPortrait) {
            this.paintCursorPortrait(g);
        } else {
            this.paintCursorLandscape(g);
        }
    }

    private void paintCursorPortrait(Graphics g) {
        if (!this.mCursorVisible) {
            return;
        }
        this.chooseColour(g, (byte)0);
        int x = this.mBoxLeft + this.mCursorString * this.mStringGap;
        int top = this.mBoxTop + this.mFretGap * this.mCursorFret + 1;
        int bot = top + this.mFretGap - 2;
        g.drawLine(x, top, x, bot);
    }

    private void paintCursorLandscape(Graphics g) {
        if (!this.mCursorVisible) {
            return;
        }
        this.chooseColour(g, (byte)0);
        int y = this.mBoxTop + this.mCursorString * this.mStringGap;
        int left = this.mBoxLeft + this.mFretGap * this.mCursorFret + 1;
        int right = left + this.mFretGap - 2;
        g.drawLine(left, y, right, y);
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        switch (gameAction) {
            case 1: {
                this.onCursorUp();
                break;
            }
            case 6: {
                this.onCursorDown();
                break;
            }
            case 2: {
                this.onCursorLeft();
                break;
            }
            case 5: {
                this.onCursorRight();
                break;
            }
            case 8: {
                this.onCursorFire();
                break;
            }
        }
        this.repaint();
    }

    private void onCursorUp() {
        if (this.mPortrait) {
            this.mCursorFret = (byte)(this.mCursorFret - 1);
            if (this.mCursorFret < 0) {
                this.mCursorFret = (byte)4;
            }
        } else {
            this.mCursorString = (byte)(this.mCursorString - 1);
            if (this.mCursorString < 0) {
                this.mCursorString = (byte)5;
            }
        }
    }

    private void onCursorDown() {
        if (this.mPortrait) {
            this.mCursorFret = (byte)(this.mCursorFret + 1);
            if (this.mCursorFret > 4) {
                this.mCursorFret = 0;
            }
        } else {
            this.mCursorString = (byte)(this.mCursorString + 1);
            if (this.mCursorString > 5) {
                this.mCursorString = 0;
            }
        }
    }

    private void onCursorLeft() {
        if (this.mPortrait) {
            this.mCursorString = (byte)(this.mCursorString - 1);
            if (this.mCursorString < 0) {
                this.mCursorString = (byte)5;
            }
        } else {
            this.mCursorFret = (byte)(this.mCursorFret - 1);
            if (this.mCursorFret < 0) {
                this.mCursorFret = (byte)4;
            }
        }
    }

    private void onCursorRight() {
        if (this.mPortrait) {
            this.mCursorString = (byte)(this.mCursorString + 1);
            if (this.mCursorString > 5) {
                this.mCursorString = 0;
            }
        } else {
            this.mCursorFret = (byte)(this.mCursorFret + 1);
            if (this.mCursorFret > 4) {
                this.mCursorFret = 0;
            }
        }
    }

    private void onCursorFire() {
        if (this.mPortrait) {
            if (this.mCursorFret + 1 == this.mChord.getFret(this.mCursorString + 1)) {
                this.mChord.setFret(this.mCursorString + 1, 0);
            } else {
                this.mChord.setFret(this.mCursorString + 1, this.mCursorFret + 1);
            }
        } else if (this.mCursorFret + 1 == this.mChord.getFret(6 - this.mCursorString)) {
            this.mChord.setFret(6 - this.mCursorString, 0);
        } else {
            this.mChord.setFret(6 - this.mCursorString, this.mCursorFret + 1);
        }
    }

    private class CursorFlasher
    extends TimerTask {
        private CursorFlasher() {
        }

        public void run() {
            ChordEntryCanvas.this.mCursorVisible = !ChordEntryCanvas.this.mCursorVisible;
            ChordEntryCanvas.this.repaint();
        }
    }
}

