/*
 * Decompiled with CFR 0.152.
 */
package com.sc.chordbook;

import com.sc.chordbook.ChordViewCanvas;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ChordCanvas
extends Canvas {
    protected static final byte VIEW_SCALE = 6;
    protected static final byte MAX_VIEW_SCALE = 12;
    protected static final byte ENTRY_SCALE = 12;
    protected static final byte STRING_TAIL = 2;
    protected static final byte MARGIN_LEFT = 2;
    protected static final byte MARGIN_TOP = 2;
    protected static final byte NAME_GAP = 4;
    protected static final byte MINIMAL_WIDTH = 100;
    protected static final byte MINIMAL_HEIGHT = 60;
    protected static final byte BACK = 0;
    protected static final byte FRETS = 1;
    protected static final byte STRINGS = 2;
    protected static final byte POS = 3;
    protected static final byte X = 4;
    protected static final byte O = 5;
    protected static final byte DOTS = 6;
    protected static final byte FINGERS = 7;
    protected static final byte NAME = 8;
    protected static final byte STRING_LABELS = 9;
    protected static final char[] TUNING;
    protected boolean mUseColour = true;
    protected int mNumColours = 255;
    protected boolean mPortrait = true;
    protected boolean mMinimalScreen = false;
    protected int mWidth = this.getWidth();
    protected int mHeight = this.getHeight();
    protected int mHalfCanvasWidth;
    protected int mBoxLeft;
    protected int mBoxTop;
    protected int mBoxRight;
    protected int mBoxBottom;
    protected int mBoxWidth;
    protected int mBoxHeight;
    protected int mNumFrets;
    protected int mStringGap;
    protected int mFretGap;
    protected int mHalfFretGap;
    protected int mDotRadius;
    protected int mDotDiameter;
    protected Font mFont;
    protected int mFontWidth;
    protected int mHalfFontHeight;
    protected int mDotFingerGap;

    public ChordCanvas() {
        int fontSize = 8;
        int minDimension = Math.min(this.mWidth, this.mHeight);
        fontSize = minDimension < 120 ? 8 : (minDimension < 240 ? 0 : 16);
        this.mFont = Font.getFont((int)64, (int)0, (int)fontSize);
        this.mFontWidth = this.mFont.charWidth('W');
        this.mHalfFontHeight = this.mFont.getHeight() / 2;
    }

    public void setUseColour(boolean state) {
        this.mUseColour = state;
    }

    public void setNumColours(int numColours) {
        this.mNumColours = numColours;
    }

    protected void plotLayout(int highFret) {
        this.mNumFrets = highFret;
        this.mHalfCanvasWidth = this.mWidth / 2;
        this.mPortrait = this.mHeight > this.mWidth;
        if (!this.mPortrait && this.mWidth < 100 && this.mHeight < 60) {
            this.mMinimalScreen = true;
        }
        if (this instanceof ChordViewCanvas) {
            if (this.mMinimalScreen) {
                this.mBoxLeft = this.mWidth / 12 + 1;
                this.mBoxTop = this.mHeight / 12 + 1;
            } else {
                this.mBoxLeft = this.mWidth / 6 + 1;
                this.mBoxTop = this.mHeight / 6 + 1;
            }
        } else {
            this.mBoxLeft = this.mWidth / 12 + 1;
            this.mBoxTop = this.mHeight / 12 + 1;
        }
        this.mBoxWidth = this.mWidth - this.mBoxLeft * 2;
        this.mBoxHeight = this.mHeight - this.mBoxTop * 2 - 4;
        if (this.mPortrait) {
            this.mStringGap = this.mBoxWidth / 5;
            this.mFretGap = this.mBoxHeight / this.mNumFrets;
            this.mHalfFretGap = this.mFretGap / 2;
        } else {
            this.mStringGap = this.mBoxHeight / 5;
            this.mFretGap = this.mBoxWidth / this.mNumFrets;
            this.mHalfFretGap = this.mFretGap / 2;
        }
        if (this.mPortrait) {
            this.mBoxWidth = this.mStringGap * 5;
            this.mBoxHeight = this.mFretGap * this.mNumFrets + 2;
        } else {
            this.mBoxWidth = this.mFretGap * this.mNumFrets + 2;
            this.mBoxHeight = this.mStringGap * 5;
        }
        this.mBoxRight = this.mBoxLeft + this.mBoxWidth;
        this.mBoxBottom = this.mBoxTop + this.mBoxHeight;
        this.mDotDiameter = Math.min(this.mStringGap, this.mFretGap);
        this.mDotRadius = this.mDotDiameter / 2;
        this.mDotDiameter = this.mDotRadius * 2;
        this.mDotFingerGap = this.mDotRadius - this.mHalfFontHeight;
        if (this.mDotFingerGap % 2 > 0) {
            --this.mDotFingerGap;
        }
    }

    public void paint(Graphics g) {
        this.chooseColour(g, (byte)0);
        g.fillRect(0, 0, this.mWidth, this.mHeight);
        g.setFont(this.mFont);
    }

    protected void paintBox(Graphics g, boolean zeroFret) {
        if (this.mPortrait) {
            this.paintBoxPortrait(g, zeroFret);
        } else {
            this.paintBoxLandscape(g, zeroFret);
        }
    }

    private void paintBoxPortrait(Graphics g, boolean zeroFret) {
        this.chooseColour(g, (byte)1);
        if (zeroFret) {
            g.drawLine(this.mBoxLeft, this.mBoxTop - 1, this.mBoxRight, this.mBoxTop - 1);
        }
        int y = this.mBoxTop;
        while (y <= this.mBoxBottom) {
            g.drawLine(this.mBoxLeft, y, this.mBoxRight, y);
            y += this.mFretGap;
        }
        this.chooseColour(g, (byte)2);
        int x = this.mBoxLeft;
        while (x <= this.mBoxRight) {
            g.drawLine(x, this.mBoxTop, x, this.mBoxBottom);
            x += this.mStringGap;
        }
    }

    private void paintBoxLandscape(Graphics g, boolean zeroFret) {
        this.chooseColour(g, (byte)1);
        if (zeroFret) {
            g.drawLine(this.mBoxLeft - 1, this.mBoxTop, this.mBoxLeft - 1, this.mBoxBottom);
        }
        int x = this.mBoxLeft;
        while (x <= this.mBoxRight) {
            g.drawLine(x, this.mBoxTop, x, this.mBoxBottom);
            x += this.mFretGap;
        }
        this.chooseColour(g, (byte)2);
        int y = this.mBoxTop;
        while (y <= this.mBoxBottom) {
            g.drawLine(this.mBoxLeft, y, this.mBoxRight, y);
            y += this.mStringGap;
        }
    }

    protected void paintPos(Graphics g, byte pos) {
        if (this.mPortrait) {
            this.paintPosPortrait(g, pos);
        } else {
            this.paintPosLandscape(g, pos);
        }
    }

    private void paintPosPortrait(Graphics g, byte pos) {
        this.chooseColour(g, (byte)3);
        if (pos > 1) {
            String str = Integer.toString(pos);
            g.drawString(str, this.mBoxLeft - this.mDotRadius, this.mBoxTop, 40);
        }
    }

    private void paintPosLandscape(Graphics g, byte pos) {
        this.chooseColour(g, (byte)3);
        if (pos > 1) {
            String str = Integer.toString(pos);
            if (this.mMinimalScreen) {
                g.drawString(str, this.mBoxLeft, this.mHeight, 33);
            } else {
                g.drawString(str, this.mBoxLeft - this.mFontWidth + 1, this.mBoxBottom + this.mDotRadius, 20);
            }
        }
    }

    protected void paintDots(Graphics g) {
    }

    protected void paintName(Graphics g, String name, int inversion) {
        if (this.mPortrait) {
            this.paintNamePortrait(g, name, inversion);
        } else {
            this.paintNameLandscape(g, name, inversion);
        }
    }

    private void paintNamePortrait(Graphics g, String name, int inversion) {
        this.chooseColour(g, (byte)8);
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append(" <");
        sb.append(inversion);
        sb.append(">");
        g.drawString(sb.toString(), this.mHalfCanvasWidth, this.mHeight, 33);
    }

    private void paintNameLandscape(Graphics g, String name, int inversion) {
        this.chooseColour(g, (byte)8);
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append(" <");
        sb.append(inversion);
        sb.append(">");
        if (this.mMinimalScreen) {
            g.drawString(sb.toString(), this.mHalfCanvasWidth, this.mHeight, 33);
        } else {
            g.drawString(sb.toString(), this.mHalfCanvasWidth, 0, 17);
        }
    }

    protected void chooseColour(Graphics g, byte target) {
        if (this.mNumColours <= 2) {
            switch (target) {
                case 0: {
                    g.setGrayScale(255);
                    break;
                }
                case 1: {
                    g.setGrayScale(0);
                    break;
                }
                case 2: {
                    g.setGrayScale(0);
                    break;
                }
                case 3: {
                    g.setGrayScale(0);
                    break;
                }
                case 4: {
                    g.setGrayScale(0);
                    break;
                }
                case 5: {
                    g.setGrayScale(0);
                    break;
                }
                case 6: {
                    g.setGrayScale(0);
                    break;
                }
                case 7: {
                    g.setGrayScale(255);
                    break;
                }
                case 8: {
                    g.setGrayScale(0);
                    break;
                }
                default: {
                    g.setGrayScale(0);
                    break;
                }
            }
        } else if (this.mUseColour) {
            switch (target) {
                case 0: {
                    g.setGrayScale(255);
                    break;
                }
                case 1: {
                    g.setColor(204, 204, 255);
                    break;
                }
                case 2: {
                    g.setColor(153, 102, 0);
                    break;
                }
                case 3: {
                    g.setColor(153, 0, 255);
                    break;
                }
                case 4: {
                    g.setColor(255, 0, 0);
                    break;
                }
                case 5: {
                    g.setColor(0, 0, 255);
                    break;
                }
                case 6: {
                    g.setColor(102, 102, 255);
                    break;
                }
                case 7: {
                    g.setGrayScale(0);
                    break;
                }
                case 8: {
                    g.setColor(204, 204, 255);
                    break;
                }
                default: {
                    g.setGrayScale(0);
                    break;
                }
            }
        } else {
            switch (target) {
                case 0: {
                    g.setGrayScale(255);
                    break;
                }
                case 1: {
                    g.setGrayScale(0);
                    break;
                }
                case 2: {
                    g.setGrayScale(0);
                    break;
                }
                case 3: {
                    g.setGrayScale(128);
                    break;
                }
                case 4: {
                    g.setGrayScale(128);
                    break;
                }
                case 5: {
                    g.setGrayScale(128);
                    break;
                }
                case 6: {
                    g.setGrayScale(128);
                    break;
                }
                case 7: {
                    g.setGrayScale(0);
                    break;
                }
                case 8: {
                    g.setGrayScale(128);
                    break;
                }
                default: {
                    g.setGrayScale(0);
                }
            }
        }
    }

    static {
        VIEW_SCALE = (byte)6;
        MAX_VIEW_SCALE = (byte)12;
        ENTRY_SCALE = (byte)12;
        STRING_TAIL = (byte)2;
        MARGIN_LEFT = (byte)2;
        MARGIN_TOP = (byte)2;
        NAME_GAP = (byte)4;
        MINIMAL_WIDTH = (byte)100;
        MINIMAL_HEIGHT = (byte)60;
        BACK = 0;
        FRETS = 1;
        STRINGS = (byte)2;
        POS = (byte)3;
        X = (byte)4;
        O = (byte)5;
        DOTS = (byte)6;
        FINGERS = (byte)7;
        NAME = (byte)8;
        STRING_LABELS = (byte)9;
        TUNING = new char[]{'E', 'A', 'D', 'G', 'B', 'E'};
    }
}

