/*
 * Decompiled with CFR 0.152.
 */
package com.sc.chordbook;

public class ChordBox {
    private String name = "";
    private byte pos = 0;
    private byte[] fret = new byte[6];
    private byte[] finger = new byte[6];

    public ChordBox() {
    }

    public ChordBox(String name, byte pos, byte[] frets, byte[] fingers) {
        this();
        this.name = name;
        this.pos = pos;
        this.fret = frets;
        this.finger = fingers;
    }

    public ChordBox(String name, int pos, String shape, String fingering) {
        this();
        this.setName(name);
        this.setPos(pos);
        this.setFrets(shape);
        this.setFingers(fingering);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPos(int pos) {
        this.pos = (byte)pos;
    }

    public byte getPos() {
        return this.pos;
    }

    public byte[] getFretArray() {
        return this.fret;
    }

    public byte[] getFingerArray() {
        return this.finger;
    }

    public void setFrets(String shape) {
        int i = 0;
        while (i < 6) {
            char c = shape.charAt(i);
            int fret = Character.digit(c, 10);
            this.setFret(i + 1, fret);
            ++i;
        }
    }

    public String getFrets() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 6) {
            char c = (char)(this.fret[i] + 48);
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public void setFingers(String fingering) {
        int i = 0;
        while (i < 6) {
            char c = fingering.charAt(i);
            int finger = Character.digit(c, 10);
            this.setFinger(i + 1, finger);
            ++i;
        }
    }

    public String getFingers() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 6) {
            char c = (char)(this.finger[i] + 48);
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public void setFret(int stringNum, int fretNum) {
        if (stringNum > 0 && stringNum <= 6) {
            this.fret[stringNum - 1] = (byte)fretNum;
        }
    }

    public byte getFret(int stringNum) {
        if (stringNum > 0 && stringNum <= 6) {
            return this.fret[stringNum - 1];
        }
        return -1;
    }

    public void setFinger(int stringNum, int fingerNum) {
        if (stringNum > 0 && stringNum <= 6) {
            this.finger[stringNum - 1] = (byte)fingerNum;
        }
    }

    public byte getFinger(int stringNum) {
        if (stringNum > 0 && stringNum <= 6) {
            return this.finger[stringNum - 1];
        }
        return -1;
    }

    public int getHighestFret() {
        int highFret = 0;
        int i = 0;
        while (i < 6) {
            byte fret = this.getFret(i + 1);
            if (fret == 9) {
                fret = 0;
            }
            highFret = Math.max(fret, highFret);
            ++i;
        }
        return highFret;
    }

    public String toString() {
        return this.getPos() + " " + this.getFrets() + " " + this.getFingers();
    }
}

