/*
 * Decompiled with CFR 0.152.
 */
package voipbuster;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class MD5 {
    private MD5State workingState = new MD5State();
    private MD5State finalState = new MD5State();
    private int[] decodeBuffer = new int[16];
    private static final byte[] padding;

    static {
        byte[] byArray = new byte[64];
        byArray[0] = -128;
        padding = byArray;
    }

    public MD5() {
        this.reset();
    }

    public byte[] getHash() {
        if (!this.finalState.valid) {
            this.finalState.copy(this.workingState);
            long bitCount = this.finalState.bitCount;
            int leftOver = (int)(bitCount >>> 3 & 0x3FL);
            int padlen = leftOver < 56 ? 56 - leftOver : 120 - leftOver;
            this.update(this.finalState, padding, 0, padlen);
            this.update(this.finalState, MD5.encode(bitCount), 0, 8);
            this.finalState.valid = true;
        }
        return MD5.encode(this.finalState.state, 16);
    }

    public String getHashString() {
        return MD5.toHex(this.getHash());
    }

    public static byte[] getHash(byte[] b) {
        MD5 md5 = new MD5();
        md5.update(b);
        return md5.getHash();
    }

    public static String getHashString(byte[] b) {
        MD5 md5 = new MD5();
        md5.update(b);
        return md5.getHashString();
    }

    public static byte[] getHash(InputStream in) throws IOException {
        int read;
        MD5 md5 = new MD5();
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            md5.update(buffer, read);
        }
        return md5.getHash();
    }

    public static String getHashString(InputStream in) throws IOException {
        int read;
        MD5 md5 = new MD5();
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            md5.update(buffer, read);
        }
        return md5.getHashString();
    }

    public static byte[] getHash(String s) {
        MD5 md5 = new MD5();
        md5.update(s);
        return md5.getHash();
    }

    public static String getHashString(String s) {
        MD5 md5 = new MD5();
        md5.update(s);
        return md5.getHashString();
    }

    public static byte[] getHash(String s, String enc) throws UnsupportedEncodingException {
        MD5 md5 = new MD5();
        md5.update(s, enc);
        return md5.getHash();
    }

    public static String getHashString(String s, String enc) throws UnsupportedEncodingException {
        MD5 md5 = new MD5();
        md5.update(s, enc);
        return md5.getHashString();
    }

    public void reset() {
        this.workingState.reset();
        this.finalState.valid = false;
    }

    public String toString() {
        return this.getHashString();
    }

    private void update(MD5State state, byte[] buffer, int offset, int length) {
        this.finalState.valid = false;
        if (length + offset > buffer.length) {
            length = buffer.length - offset;
        }
        int index = (int)(state.bitCount >>> 3) & 0x3F;
        state.bitCount += (long)(length << 3);
        int partlen = 64 - index;
        int i = 0;
        if (length >= partlen) {
            System.arraycopy(buffer, offset, state.buffer, index, partlen);
            MD5.transform(state, this.decode(state.buffer, 64, 0));
            i = partlen;
            while (i + 63 < length) {
                MD5.transform(state, this.decode(buffer, 64, i));
                i += 64;
            }
            index = 0;
        }
        if (i < length) {
            int start = i;
            while (i < length) {
                state.buffer[index + i - start] = buffer[i + offset];
                ++i;
            }
        }
    }

    public void update(byte[] buffer, int offset, int length) {
        this.update(this.workingState, buffer, offset, length);
    }

    public void update(byte[] buffer, int length) {
        this.update(buffer, 0, length);
    }

    public void update(byte[] buffer) {
        this.update(buffer, 0, buffer.length);
    }

    public void update(byte b) {
        byte[] buffer = new byte[]{b};
        this.update(buffer, 1);
    }

    public void update(String s) {
        this.update(s.getBytes());
    }

    public void update(String s, String enc) throws UnsupportedEncodingException {
        this.update(s.getBytes(enc));
    }

    private static String toHex(byte[] hash) {
        StringBuffer buf = new StringBuffer(hash.length * 2);
        int i = 0;
        while (i < hash.length) {
            int intVal = hash[i] & 0xFF;
            if (intVal < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(intVal));
            ++i;
        }
        return buf.toString();
    }

    private static int FF(int a, int b, int c, int d, int x, int s, int ac) {
        a += b & c | ~b & d;
        a += x;
        a += ac;
        a = a << s | a >>> 32 - s;
        return a + b;
    }

    private static int GG(int a, int b, int c, int d, int x, int s, int ac) {
        a += b & d | c & ~d;
        a += x;
        a += ac;
        a = a << s | a >>> 32 - s;
        return a + b;
    }

    private static int HH(int a, int b, int c, int d, int x, int s, int ac) {
        a += b ^ c ^ d;
        a += x;
        a += ac;
        a = a << s | a >>> 32 - s;
        return a + b;
    }

    private static int II(int a, int b, int c, int d, int x, int s, int ac) {
        a += c ^ (b | ~d);
        a += x;
        a += ac;
        a = a << s | a >>> 32 - s;
        return a + b;
    }

    private static byte[] encode(long l) {
        byte[] out = new byte[]{(byte)(l & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 56 & 0xFFL)};
        return out;
    }

    private static byte[] encode(int[] input, int len) {
        byte[] out = new byte[len];
        int j = 0;
        int i = 0;
        while (j < len) {
            out[j] = (byte)(input[i] & 0xFF);
            out[j + 1] = (byte)(input[i] >>> 8 & 0xFF);
            out[j + 2] = (byte)(input[i] >>> 16 & 0xFF);
            out[j + 3] = (byte)(input[i] >>> 24 & 0xFF);
            ++i;
            j += 4;
        }
        return out;
    }

    private int[] decode(byte[] buffer, int len, int offset) {
        int j = 0;
        int i = 0;
        while (j < len) {
            this.decodeBuffer[i] = buffer[j + offset] & 0xFF | (buffer[j + 1 + offset] & 0xFF) << 8 | (buffer[j + 2 + offset] & 0xFF) << 16 | (buffer[j + 3 + offset] & 0xFF) << 24;
            ++i;
            j += 4;
        }
        return this.decodeBuffer;
    }

    private static void transform(MD5State state, int[] x) {
        int a = state.state[0];
        int b = state.state[1];
        int c = state.state[2];
        int d = state.state[3];
        a = MD5.FF(a, b, c, d, x[0], 7, -680876936);
        d = MD5.FF(d, a, b, c, x[1], 12, -389564586);
        c = MD5.FF(c, d, a, b, x[2], 17, 606105819);
        b = MD5.FF(b, c, d, a, x[3], 22, -1044525330);
        a = MD5.FF(a, b, c, d, x[4], 7, -176418897);
        d = MD5.FF(d, a, b, c, x[5], 12, 1200080426);
        c = MD5.FF(c, d, a, b, x[6], 17, -1473231341);
        b = MD5.FF(b, c, d, a, x[7], 22, -45705983);
        a = MD5.FF(a, b, c, d, x[8], 7, 1770035416);
        d = MD5.FF(d, a, b, c, x[9], 12, -1958414417);
        c = MD5.FF(c, d, a, b, x[10], 17, -42063);
        b = MD5.FF(b, c, d, a, x[11], 22, -1990404162);
        a = MD5.FF(a, b, c, d, x[12], 7, 1804603682);
        d = MD5.FF(d, a, b, c, x[13], 12, -40341101);
        c = MD5.FF(c, d, a, b, x[14], 17, -1502002290);
        b = MD5.FF(b, c, d, a, x[15], 22, 1236535329);
        a = MD5.GG(a, b, c, d, x[1], 5, -165796510);
        d = MD5.GG(d, a, b, c, x[6], 9, -1069501632);
        c = MD5.GG(c, d, a, b, x[11], 14, 643717713);
        b = MD5.GG(b, c, d, a, x[0], 20, -373897302);
        a = MD5.GG(a, b, c, d, x[5], 5, -701558691);
        d = MD5.GG(d, a, b, c, x[10], 9, 38016083);
        c = MD5.GG(c, d, a, b, x[15], 14, -660478335);
        b = MD5.GG(b, c, d, a, x[4], 20, -405537848);
        a = MD5.GG(a, b, c, d, x[9], 5, 568446438);
        d = MD5.GG(d, a, b, c, x[14], 9, -1019803690);
        c = MD5.GG(c, d, a, b, x[3], 14, -187363961);
        b = MD5.GG(b, c, d, a, x[8], 20, 1163531501);
        a = MD5.GG(a, b, c, d, x[13], 5, -1444681467);
        d = MD5.GG(d, a, b, c, x[2], 9, -51403784);
        c = MD5.GG(c, d, a, b, x[7], 14, 1735328473);
        b = MD5.GG(b, c, d, a, x[12], 20, -1926607734);
        a = MD5.HH(a, b, c, d, x[5], 4, -378558);
        d = MD5.HH(d, a, b, c, x[8], 11, -2022574463);
        c = MD5.HH(c, d, a, b, x[11], 16, 1839030562);
        b = MD5.HH(b, c, d, a, x[14], 23, -35309556);
        a = MD5.HH(a, b, c, d, x[1], 4, -1530992060);
        d = MD5.HH(d, a, b, c, x[4], 11, 1272893353);
        c = MD5.HH(c, d, a, b, x[7], 16, -155497632);
        b = MD5.HH(b, c, d, a, x[10], 23, -1094730640);
        a = MD5.HH(a, b, c, d, x[13], 4, 681279174);
        d = MD5.HH(d, a, b, c, x[0], 11, -358537222);
        c = MD5.HH(c, d, a, b, x[3], 16, -722521979);
        b = MD5.HH(b, c, d, a, x[6], 23, 76029189);
        a = MD5.HH(a, b, c, d, x[9], 4, -640364487);
        d = MD5.HH(d, a, b, c, x[12], 11, -421815835);
        c = MD5.HH(c, d, a, b, x[15], 16, 530742520);
        b = MD5.HH(b, c, d, a, x[2], 23, -995338651);
        a = MD5.II(a, b, c, d, x[0], 6, -198630844);
        d = MD5.II(d, a, b, c, x[7], 10, 1126891415);
        c = MD5.II(c, d, a, b, x[14], 15, -1416354905);
        b = MD5.II(b, c, d, a, x[5], 21, -57434055);
        a = MD5.II(a, b, c, d, x[12], 6, 1700485571);
        d = MD5.II(d, a, b, c, x[3], 10, -1894986606);
        c = MD5.II(c, d, a, b, x[10], 15, -1051523);
        b = MD5.II(b, c, d, a, x[1], 21, -2054922799);
        a = MD5.II(a, b, c, d, x[8], 6, 1873313359);
        d = MD5.II(d, a, b, c, x[15], 10, -30611744);
        c = MD5.II(c, d, a, b, x[6], 15, -1560198380);
        b = MD5.II(b, c, d, a, x[13], 21, 1309151649);
        a = MD5.II(a, b, c, d, x[4], 6, -145523070);
        d = MD5.II(d, a, b, c, x[11], 10, -1120210379);
        c = MD5.II(c, d, a, b, x[2], 15, 718787259);
        b = MD5.II(b, c, d, a, x[9], 21, -343485551);
        state.state[0] = state.state[0] + a;
        state.state[1] = state.state[1] + b;
        state.state[2] = state.state[2] + c;
        state.state[3] = state.state[3] + d;
    }

    private class MD5State {
        public boolean valid = true;
        public int[] state = new int[4];
        public long bitCount;
        public byte[] buffer = new byte[64];

        public void reset() {
            this.state[0] = 1732584193;
            this.state[1] = -271733879;
            this.state[2] = -1732584194;
            this.state[3] = 271733878;
            this.bitCount = 0L;
        }

        public MD5State() {
            this.reset();
        }

        public void copy(MD5State from) {
            System.arraycopy(from.buffer, 0, this.buffer, 0, this.buffer.length);
            System.arraycopy(from.state, 0, this.state, 0, this.state.length);
            this.valid = from.valid;
            this.bitCount = from.bitCount;
        }

        public String toString() {
            return String.valueOf(this.state[0]) + " " + this.state[1] + " " + this.state[2] + " " + this.state[3];
        }
    }
}

