/*
 * Decompiled with CFR 0.152.
 */
package voipbuster;

import voipbuster.GenericCoder;

public class GsmMessages {
    public static final int MT_StartCallToProxyRequest = 2;
    public static final int MT_CallProgress = 3;
    public static final int MT_SessionEnd = 4;
    public static final int MT_RequestIdToGsm = 5;
    public static final int MT_DisconnectRequest = 6;
    public static final int MT_SendSms = 7;
    public static final int MT_UserBalanceRequest = 8;
    public static final int MT_UserBalanceResponse = 9;
    public static final int IE_StartCallInfo = 1;
    public static final int IE_RequestDetails = 2;
    public static final int IE_EndCause = 3;
    public static final int IE_ChargeInfo = 4;
    public static final int IE_CallProgress = 6;
    public static final int IE_UserBalance = 7;
    public static final int IE_Sms = 8;
    public static final int IE_UserDetails = 9;
    public static final int IE_SmsChargeInfo = 10;
    public static final int IE_SmsDeliveryResult = 11;
    public static final int IDS_CAUSE_LOW_BALANCE = 1;
    public static final int IDS_CAUSE_UNKNOWN_ASIDE = 2;
    public static final int IDS_CAUSE_UNKNOWN_BSIDE = 3;
    public static final int IDS_CAUSE_UNKNOWN = 4;
    public static final int IDS_CAUSE_NORMAL_ASIDE = 5;
    public static final int IDS_CAUSE_NORMAL_BSIDE = 6;
    public static final int IDS_CAUSE_BUSY_ASIDE = 8;
    public static final int IDS_CAUSE_BUSY_BSIDE = 9;
    public static final int IDS_CAUSE_NOANSWER_ASIDE = 10;
    public static final int IDS_CAUSE_NOANSWER_BSIDE = 11;
    public static final int IDS_CAUSE_NETFAIL_ASIDE = 12;
    public static final int IDS_CAUSE_NETFAIL_BSIDE = 13;
    public static final int IDS_CAUSE_NETFAIL = 14;
    public static final int IDS_CAUSE_NOT_FREE = 16;
    public static final int IDS_CAUSE_TIMELIMIT = 17;
    public static final int IDS_CAUSE_BLOCKED = 18;
    public static final int IDS_CAUSE_INVALID_NUMBER = 19;
    public static final int IDS_CAUSE_INVALID_NUMBER_ASIDE = 20;
    public static final int IDS_CAUSE_INVALID_NUMBER_BSIDE = 21;
    public static final int IDS_CAUSE_CONDITION_RED = 22;
    public static final int IDS_CAUSE_MAX_FREE_CALLS_REACHED = 23;
    public static final int IDS_CAUSE_REJECTED_ASIDE = 24;
    public static final int IDS_CAUSE_REJECTED_BSIDE = 25;
    public static final int IDS_CAUSE_REJECTED = 26;
    public static final int IDS_CAUSE_DESTINATION_NOT_SUPPORTED = 27;
    public static final int IDS_CAUSE_LOGIN_FAILED = 28;
    public static final int IDS_CAUSE_NOWXXACCOUNT = 123;
    public static final int ECS_ASideDialing = 1;
    public static final int ECS_ASideRinging = 2;
    public static final int ECS_ASideAnswered = 3;
    public static final int ECS_BSideDialing = 4;
    public static final int ECS_BSideRinging = 5;
    public static final int ECS_BSideAnswered = 6;
    public static final int ECS_CallCleared = 7;
    public static final int ECS_StartingCall = 8;
    public static final int ECS_EndingCall = 9;
    public int iMessageType;
    public cl_StartCallInfo tIE_StartCallInfo;
    public cl_RequestDetails tIE_RequestDetails;
    public cl_EndCause tIE_EndCause;
    public cl_ChargeInfo tIE_ChargeInfo;
    public cl_CallProgress tIE_CallProgress;
    public cl_UserBalance tIE_UserBalance;
    public cl_Sms tIE_Sms;
    public cl_UserDetails tIE_UserDetails;
    public cl_SmsChargeInfo tIE_SmsChargeInfo;
    public cl_SmsDeliveryResult tIE_SmsDeliveryResult;

    public GsmMessages() {
        this.Clear();
    }

    public void Clear() {
        this.tIE_StartCallInfo = null;
        this.tIE_RequestDetails = null;
        this.tIE_EndCause = null;
        this.tIE_ChargeInfo = null;
        this.tIE_CallProgress = null;
        this.tIE_UserBalance = null;
        this.tIE_Sms = null;
        this.tIE_UserDetails = null;
        this.tIE_SmsChargeInfo = null;
        this.tIE_SmsDeliveryResult = null;
    }

    public void Prepare_IE_StartCallInfo(String sANr, String sBNr) {
        this.tIE_StartCallInfo = new cl_StartCallInfo();
        this.tIE_StartCallInfo.sANr = sANr;
        this.tIE_StartCallInfo.sBNr = sBNr;
    }

    public void Prepare_IE_RequestDetails(long uiCallId) {
        this.tIE_RequestDetails = new cl_RequestDetails();
        this.tIE_RequestDetails.uiCallId = uiCallId;
    }

    public void Prepare_Ie_EndCause() {
    }

    public void Prepare_IE_ChargeInfo() {
    }

    public void Prepare_IE_CallProgress() {
    }

    public void Prepare_IE_UserBalance() {
    }

    public void Prepare_IE_Sms(String sDestination, String sMessage) {
        this.tIE_Sms = new cl_Sms();
        this.tIE_Sms.sDestination = sDestination;
        this.tIE_Sms.sMessage = sMessage;
    }

    public void Prepare_IE_UserDetails(String sUserName, String sMd5, int iWxxProductNr, int iCdrBrand, int iCdrProduct) {
        this.tIE_UserDetails = new cl_UserDetails();
        this.tIE_UserDetails.sUserName = sUserName;
        this.tIE_UserDetails.sHashResult = sMd5;
        this.tIE_UserDetails.nWxxProductNr = iWxxProductNr;
        this.tIE_UserDetails.nCdrBrandNr = iCdrBrand;
        this.tIE_UserDetails.nCdrProductNr = iCdrProduct;
    }

    public void Prepare_IE_SmsChargeInfo() {
    }

    public void Prepare_IE_SmsDeliveryResult() {
    }

    public boolean Decode(StringBuffer tBuffer, String sError) {
        GenericCoder pPos = new GenericCoder();
        this.iMessageType = GenericCoder.DecodeByte(tBuffer, pPos);
        switch (this.iMessageType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                sError = "Unsupported messagetype received " + this.iMessageType;
                break;
            }
        }
        while (pPos.iPos < tBuffer.length()) {
            byte iIEelement = GenericCoder.DecodeByte(tBuffer, pPos);
            long lIELength = GenericCoder.DecodeUInt(tBuffer, pPos);
            switch (iIEelement) {
                case 1: {
                    this.Decode_IE_StartCallInfo(tBuffer, pPos);
                    break;
                }
                case 2: {
                    this.Decode_IE_RequestDetails(tBuffer, pPos);
                    break;
                }
                case 3: {
                    this.Decode_IE_EndCause(tBuffer, pPos);
                    break;
                }
                case 4: {
                    this.Decode_IE_ChargeInfo(tBuffer, pPos);
                    break;
                }
                case 6: {
                    this.Decode_IE_CallProgress(tBuffer, pPos);
                    break;
                }
                case 7: {
                    this.Decode_IE_UserBalance(tBuffer, pPos);
                    break;
                }
                case 8: {
                    this.Decode_IE_Sms(tBuffer, pPos);
                    break;
                }
                case 9: {
                    this.Decode_IE_UserDetails(tBuffer, pPos);
                    break;
                }
                case 10: {
                    this.Decode_IE_SmsChargeInfo(tBuffer, pPos);
                    break;
                }
                case 11: {
                    this.Decode_IE_SmsDeliveryResult(tBuffer, pPos);
                    break;
                }
                default: {
                    pPos.iPos += (int)lIELength;
                }
            }
        }
        if (!this.MandatoryIEOk(this.iMessageType)) {
            sError = "Mandatory IE missing in message";
            return false;
        }
        return true;
    }

    public boolean Encode(StringBuffer tBuffer) {
        if (!this.MandatoryIEOk(this.iMessageType)) {
            return false;
        }
        GenericCoder.EncodeByte((byte)this.iMessageType, tBuffer);
        this.Encode_IE_StartCallInfo(tBuffer);
        this.Encode_IE_RequestDetails(tBuffer);
        this.Encode_IE_EndCause(tBuffer);
        this.Encode_IE_ChargeInfo(tBuffer);
        this.Encode_IE_CallProgress(tBuffer);
        this.Encode_IE_UserBalance(tBuffer);
        this.Encode_IE_Sms(tBuffer);
        this.Encode_IE_UserDetails(tBuffer);
        this.Encode_IE_SmsChargeInfo(tBuffer);
        this.Encode_IE_SmsDeliveryResult(tBuffer);
        return true;
    }

    public static String CallProgressToString(int iProgress) {
        String sProgress = new String();
        switch (iProgress) {
            case 1: {
                sProgress = "Dialing";
                break;
            }
            case 2: {
                sProgress = "Pick up your phone";
                break;
            }
            case 3: {
                sProgress = "You answered";
                break;
            }
            case 4: {
                sProgress = "Dialing other party";
                break;
            }
            case 5: {
                sProgress = "Other party is ringing";
                break;
            }
            case 6: {
                sProgress = "Connected";
                break;
            }
            case 7: {
                sProgress = "Call ended";
                break;
            }
            case 8: {
                sProgress = "Start call";
                break;
            }
            case 9: {
                sProgress = "End call";
            }
        }
        return sProgress;
    }

    public static String EndCauseToString(int iEndCause) {
        String sCause = new String();
        switch (iEndCause) {
            case 1: {
                sCause = "Not enough credit available";
                break;
            }
            case 2: {
                sCause = "You disconnected, unknown reason";
                break;
            }
            case 3: {
                sCause = "Other party disconnected, unknown reason";
                break;
            }
            case 4: {
                sCause = "Disconnect, unknown reason";
                break;
            }
            case 5: {
                sCause = "You ended the call";
                break;
            }
            case 6: {
                sCause = "Other party ended";
                break;
            }
            case 8: {
                sCause = "You where busy";
                break;
            }
            case 9: {
                sCause = "Other party is busy";
                break;
            }
            case 10: {
                sCause = "You did not answer your own call";
                break;
            }
            case 11: {
                sCause = "No answer";
                break;
            }
            case 12: {
                sCause = "A local phonenetwork problem ended this call";
                break;
            }
            case 13: {
                sCause = "A remote phonenetwork problem ended this call";
                break;
            }
            case 14: {
                sCause = "A phonenetwork problem ended this call";
                break;
            }
            case 16: {
                sCause = "Destination is not free, buy credit";
                break;
            }
            case 17: {
                sCause = "Timelimit of call reached";
                break;
            }
            case 18: {
                sCause = "You are now allowed to make calls";
                break;
            }
            case 19: {
                sCause = "Invalid number";
                break;
            }
            case 20: {
                sCause = "Your own number is invalid";
                break;
            }
            case 21: {
                sCause = "Destination number is invalid";
                break;
            }
            case 22: {
                sCause = "Problem with your account";
                break;
            }
            case 23: {
                sCause = "Max free calls reached";
                break;
            }
            case 24: {
                sCause = "You rejected the call";
                break;
            }
            case 25: {
                sCause = "Other party rejected";
                break;
            }
            case 26: {
                sCause = "Other party rejected";
                break;
            }
            case 27: {
                sCause = "Unsupported destination";
                break;
            }
            case 28: {
                sCause = "Wrong username/password";
                break;
            }
            case 123: {
                sCause = "No wxx-account found";
            }
        }
        return sCause;
    }

    private boolean MandatoryIEOk(int iMessageType) {
        switch (iMessageType) {
            case 2: {
                if (this.tIE_RequestDetails != null && this.tIE_StartCallInfo != null && this.tIE_UserDetails != null) break;
                return false;
            }
            case 3: {
                if (this.tIE_RequestDetails != null && this.tIE_CallProgress != null) break;
                return false;
            }
            case 4: {
                if (this.tIE_RequestDetails != null) break;
                return false;
            }
            case 5: {
                if (this.tIE_RequestDetails != null) break;
                return false;
            }
            case 6: {
                if (this.tIE_RequestDetails != null) break;
                return false;
            }
            case 7: {
                if (this.tIE_RequestDetails != null && this.tIE_Sms != null && this.tIE_UserDetails != null) break;
                return false;
            }
            case 8: {
                if (this.tIE_RequestDetails != null && this.tIE_UserDetails != null) break;
                return false;
            }
            case 9: {
                if (this.tIE_RequestDetails != null && this.tIE_UserBalance != null) break;
                return false;
            }
        }
        return true;
    }

    private void Decode_IE_StartCallInfo(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_StartCallInfo = new cl_StartCallInfo();
        this.tIE_StartCallInfo.sANr = GenericCoder.DecodeString(tBuffer, pPos);
        this.tIE_StartCallInfo.sBNr = GenericCoder.DecodeString(tBuffer, pPos);
    }

    private void Decode_IE_RequestDetails(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_RequestDetails = new cl_RequestDetails();
        this.tIE_RequestDetails.uiCallId = GenericCoder.DecodeUInt(tBuffer, pPos);
    }

    private void Decode_IE_EndCause(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_EndCause = new cl_EndCause();
        this.tIE_EndCause.iEndCause = GenericCoder.DecodeInt(tBuffer, pPos);
    }

    private void Decode_IE_ChargeInfo(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_ChargeInfo = new cl_ChargeInfo();
        this.tIE_ChargeInfo.iASideSetupCharge = GenericCoder.DecodeLong(tBuffer, pPos);
        this.tIE_ChargeInfo.iASideTariff = GenericCoder.DecodeLong(tBuffer, pPos);
        this.tIE_ChargeInfo.uiASideTariffInterval = GenericCoder.DecodeUInt(tBuffer, pPos);
        this.tIE_ChargeInfo.iBSideSetupCharge = GenericCoder.DecodeLong(tBuffer, pPos);
        this.tIE_ChargeInfo.iBSideTariff = GenericCoder.DecodeLong(tBuffer, pPos);
        this.tIE_ChargeInfo.uiBSideTariffInterval = GenericCoder.DecodeUInt(tBuffer, pPos);
    }

    private void Decode_IE_CallProgress(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_CallProgress = new cl_CallProgress();
        this.tIE_CallProgress.iCallProgress = GenericCoder.DecodeInt(tBuffer, pPos);
    }

    private void Decode_IE_UserBalance(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_UserBalance = new cl_UserBalance();
        this.tIE_UserBalance.iBalance = GenericCoder.DecodeLong(tBuffer, pPos);
    }

    private void Decode_IE_Sms(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_Sms = new cl_Sms();
        this.tIE_Sms.sDestination = GenericCoder.DecodeString(tBuffer, pPos);
        this.tIE_Sms.sMessage = GenericCoder.DecodeString(tBuffer, pPos);
    }

    private void Decode_IE_UserDetails(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_UserDetails = new cl_UserDetails();
        this.tIE_UserDetails.sUserName = GenericCoder.DecodeString(tBuffer, pPos);
        this.tIE_UserDetails.sHashResult = GenericCoder.DecodeString(tBuffer, pPos);
        this.tIE_UserDetails.nWxxProductNr = GenericCoder.DecodeInt(tBuffer, pPos);
        this.tIE_UserDetails.nCdrProductNr = GenericCoder.DecodeInt(tBuffer, pPos);
        this.tIE_UserDetails.nCdrBrandNr = GenericCoder.DecodeInt(tBuffer, pPos);
    }

    private void Decode_IE_SmsChargeInfo(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_SmsChargeInfo = new cl_SmsChargeInfo();
        this.tIE_SmsChargeInfo.iTotalCost = GenericCoder.DecodeLong(tBuffer, pPos);
    }

    private void Decode_IE_SmsDeliveryResult(StringBuffer tBuffer, GenericCoder pPos) throws Error {
        this.tIE_SmsDeliveryResult = new cl_SmsDeliveryResult();
        this.tIE_SmsDeliveryResult.bSuccess = GenericCoder.DecodeByte(tBuffer, pPos) == 1;
    }

    private void Encode_IE_StartCallInfo(StringBuffer tBuffer) {
        if (this.tIE_StartCallInfo == null) {
            return;
        }
        StringBuffer tTemp = new StringBuffer();
        GenericCoder.EncodeString(this.tIE_StartCallInfo.sANr, tTemp);
        GenericCoder.EncodeString(this.tIE_StartCallInfo.sBNr, tTemp);
        GenericCoder.EncodeByte((byte)1, tBuffer);
        GenericCoder.EncodeUInt(tTemp.length(), tBuffer);
        GenericCoder.EncodeStringBuffer(tTemp, tBuffer);
    }

    private void Encode_IE_RequestDetails(StringBuffer tBuffer) {
        if (this.tIE_RequestDetails == null) {
            return;
        }
        GenericCoder.EncodeByte((byte)2, tBuffer);
        GenericCoder.EncodeUInt(4L, tBuffer);
        GenericCoder.EncodeUInt(this.tIE_RequestDetails.uiCallId, tBuffer);
    }

    private void Encode_IE_EndCause(StringBuffer tBuffer) {
        if (this.tIE_EndCause == null) {
            return;
        }
        GenericCoder.EncodeByte((byte)3, tBuffer);
        GenericCoder.EncodeUInt(4L, tBuffer);
        GenericCoder.EncodeInt(this.tIE_EndCause.iEndCause, tBuffer);
    }

    private void Encode_IE_ChargeInfo(StringBuffer tBuffer) {
        if (this.tIE_ChargeInfo == null) {
            return;
        }
        GenericCoder.EncodeByte((byte)4, tBuffer);
        GenericCoder.EncodeUInt(49L, tBuffer);
        GenericCoder.EncodeLong(this.tIE_ChargeInfo.iASideSetupCharge, tBuffer);
        GenericCoder.EncodeLong(this.tIE_ChargeInfo.iASideTariff, tBuffer);
        GenericCoder.EncodeUInt(this.tIE_ChargeInfo.uiASideTariffInterval, tBuffer);
        GenericCoder.EncodeLong(this.tIE_ChargeInfo.iBSideSetupCharge, tBuffer);
        GenericCoder.EncodeLong(this.tIE_ChargeInfo.iBSideTariff, tBuffer);
        GenericCoder.EncodeUInt(this.tIE_ChargeInfo.uiBSideTariffInterval, tBuffer);
    }

    private void Encode_IE_CallProgress(StringBuffer tBuffer) {
        if (this.tIE_CallProgress == null) {
            return;
        }
        GenericCoder.EncodeByte((byte)6, tBuffer);
        GenericCoder.EncodeUInt(4L, tBuffer);
        GenericCoder.EncodeInt(this.tIE_CallProgress.iCallProgress, tBuffer);
    }

    private void Encode_IE_UserBalance(StringBuffer tBuffer) {
        if (this.tIE_UserBalance == null) {
            return;
        }
        GenericCoder.EncodeByte((byte)7, tBuffer);
        GenericCoder.EncodeUInt(8L, tBuffer);
        GenericCoder.EncodeLong(this.tIE_UserBalance.iBalance, tBuffer);
    }

    private void Encode_IE_Sms(StringBuffer tBuffer) {
        if (this.tIE_Sms == null) {
            return;
        }
        StringBuffer tTemp = new StringBuffer();
        GenericCoder.EncodeString(this.tIE_Sms.sDestination, tTemp);
        GenericCoder.EncodeString(this.tIE_Sms.sMessage, tTemp);
        GenericCoder.EncodeByte((byte)8, tBuffer);
        GenericCoder.EncodeUInt(tTemp.length(), tBuffer);
        GenericCoder.EncodeStringBuffer(tTemp, tBuffer);
    }

    private void Encode_IE_UserDetails(StringBuffer tBuffer) {
        if (this.tIE_UserDetails == null) {
            return;
        }
        StringBuffer tTemp = new StringBuffer();
        GenericCoder.EncodeString(this.tIE_UserDetails.sUserName, tTemp);
        GenericCoder.EncodeString(this.tIE_UserDetails.sHashResult, tTemp);
        GenericCoder.EncodeInt(this.tIE_UserDetails.nWxxProductNr, tTemp);
        GenericCoder.EncodeInt(this.tIE_UserDetails.nCdrProductNr, tTemp);
        GenericCoder.EncodeInt(this.tIE_UserDetails.nCdrBrandNr, tTemp);
        GenericCoder.EncodeByte((byte)9, tBuffer);
        GenericCoder.EncodeUInt(tTemp.length(), tBuffer);
        GenericCoder.EncodeStringBuffer(tTemp, tBuffer);
    }

    private void Encode_IE_SmsChargeInfo(StringBuffer tBuffer) {
        if (this.tIE_SmsChargeInfo == null) {
            return;
        }
        GenericCoder.EncodeByte((byte)10, tBuffer);
        GenericCoder.EncodeUInt(8L, tBuffer);
        GenericCoder.EncodeLong(this.tIE_SmsChargeInfo.iTotalCost, tBuffer);
    }

    private void Encode_IE_SmsDeliveryResult(StringBuffer tBuffer) {
        if (this.tIE_SmsDeliveryResult == null) {
            return;
        }
        GenericCoder.EncodeByte((byte)11, tBuffer);
        GenericCoder.EncodeUInt(1L, tBuffer);
        byte bResult = 0;
        if (this.tIE_SmsDeliveryResult.bSuccess) {
            bResult = 1;
        }
        GenericCoder.EncodeByte(bResult, tBuffer);
    }

    public class cl_StartCallInfo {
        public String sANr;
        public String sBNr;

        public void cl_StatCallInfo() {
            this.sANr = new String();
            this.sBNr = new String();
        }
    }

    public class cl_RequestDetails {
        public long uiCallId;
    }

    public class cl_EndCause {
        public int iEndCause;
    }

    public class cl_ChargeInfo {
        public long iASideSetupCharge;
        public long iASideTariff;
        public long uiASideTariffInterval;
        public long iBSideSetupCharge;
        public long iBSideTariff;
        public long uiBSideTariffInterval;
    }

    public class cl_CallProgress {
        public int iCallProgress;
    }

    public class cl_UserBalance {
        public long iBalance;
    }

    public class cl_Sms {
        public String sDestination = new String();
        public String sMessage = new String();
    }

    public class cl_UserDetails {
        public String sUserName = new String();
        public String sHashResult = new String();
        public int nWxxProductNr;
        public int nCdrProductNr;
        public int nCdrBrandNr;
    }

    public class cl_SmsChargeInfo {
        public long iTotalCost;
    }

    public class cl_SmsDeliveryResult {
        public boolean bSuccess;
    }
}

