/*
 * Decompiled with CFR 0.152.
 */
package voipbuster;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GenericCoder {
    public int iPos = 0;

    static void EncodeByte(byte ucSourceValue, StringBuffer tBuffer) {
        tBuffer.append((char)ucSourceValue);
    }

    static void EncodeShort(short hiSourceValue, StringBuffer tBuffer) {
        int byte1 = (hiSourceValue & 0xFF00) >> 8;
        int byte2 = hiSourceValue & 0xFF;
        tBuffer.append((char)byte1);
        tBuffer.append((char)byte2);
    }

    static void EncodeInt(int iSourceValue, StringBuffer tBuffer) {
        int byte1 = (iSourceValue & 0xFF000000) >> 24;
        int byte2 = (iSourceValue & 0xFF0000) >> 16;
        int byte3 = (iSourceValue & 0xFF00) >> 8;
        int byte4 = iSourceValue & 0xFF;
        tBuffer.append((char)byte1);
        tBuffer.append((char)byte2);
        tBuffer.append((char)byte3);
        tBuffer.append((char)byte4);
    }

    static void EncodeUInt(long lSourceValue, StringBuffer tBuffer) {
        int byte1 = (int)((lSourceValue & 0xFFFFFFFFFF000000L) >> 24);
        int byte2 = (int)((lSourceValue & 0xFF0000L) >> 16);
        int byte3 = (int)((lSourceValue & 0xFF00L) >> 8);
        int byte4 = (int)(lSourceValue & 0xFFL);
        tBuffer.append((char)byte1);
        tBuffer.append((char)byte2);
        tBuffer.append((char)byte3);
        tBuffer.append((char)byte4);
    }

    static void EncodeLong(long lSourceValue, StringBuffer tBuffer) {
        int byte1 = (int)((lSourceValue & 0xFF00000000000000L) >> 56);
        int byte2 = (int)((lSourceValue & 0xFF000000000000L) >> 48);
        int byte3 = (int)((lSourceValue & 0xFF0000000000L) >> 40);
        int byte4 = (int)((lSourceValue & 0xFF00000000L) >> 32);
        int byte5 = (int)((lSourceValue & 0xFF000000L) >> 24);
        int byte6 = (int)((lSourceValue & 0xFF0000L) >> 16);
        int byte7 = (int)((lSourceValue & 0xFF00L) >> 8);
        int byte8 = (int)(lSourceValue & 0xFFL);
        tBuffer.append((char)byte1);
        tBuffer.append((char)byte2);
        tBuffer.append((char)byte3);
        tBuffer.append((char)byte4);
        tBuffer.append((char)byte5);
        tBuffer.append((char)byte6);
        tBuffer.append((char)byte7);
        tBuffer.append((char)byte8);
    }

    static void EncodeString(String sSourceValue, StringBuffer tBuffer) {
        GenericCoder.EncodeInt(sSourceValue.length() + 1, tBuffer);
        tBuffer.append(sSourceValue);
        tBuffer.append('\u0000');
    }

    static void EncodeStringBuffer(StringBuffer tSourceValue, StringBuffer tBuffer) {
        tBuffer.append((Object)tSourceValue);
    }

    static byte DecodeByte(StringBuffer tBuffer, GenericCoder pPos) {
        if (tBuffer.length() - pPos.iPos < 1) {
            throw new Error("Supplied buffer too small to contain a byte");
        }
        byte bResult = (byte)tBuffer.charAt(pPos.iPos++);
        return bResult;
    }

    static short DecodeShort(StringBuffer tBuffer, GenericCoder pPos) {
        if (tBuffer.length() - pPos.iPos < 2) {
            throw new Error("Supplied buffer too small to contain a short");
        }
        char byte1 = tBuffer.charAt(pPos.iPos++);
        char byte2 = tBuffer.charAt(pPos.iPos++);
        short hiResult = (short)((byte1 << 8) + byte2);
        return hiResult;
    }

    static int DecodeInt(StringBuffer tBuffer, GenericCoder pPos) {
        if (tBuffer.length() - pPos.iPos < 4) {
            throw new Error("Supplied buffer too small to contain an integer");
        }
        int iResult = 0;
        char byte1 = tBuffer.charAt(pPos.iPos++);
        char byte2 = tBuffer.charAt(pPos.iPos++);
        char byte3 = tBuffer.charAt(pPos.iPos++);
        char byte4 = tBuffer.charAt(pPos.iPos++);
        iResult = (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + byte4;
        return iResult;
    }

    static long DecodeUInt(StringBuffer tBuffer, GenericCoder pPos) {
        if (tBuffer.length() - pPos.iPos < 4) {
            throw new Error("Supplied buffer too small to contain an unsigned integer");
        }
        long lResult = 0L;
        char byte1 = tBuffer.charAt(pPos.iPos++);
        char byte2 = tBuffer.charAt(pPos.iPos++);
        char byte3 = tBuffer.charAt(pPos.iPos++);
        char byte4 = tBuffer.charAt(pPos.iPos++);
        lResult = (long)(byte1 << 24) + (long)(byte2 << 16) + (long)(byte3 << 8) + (long)byte4;
        return lResult;
    }

    static long DecodeLong(StringBuffer tBuffer, GenericCoder pPos) {
        if (tBuffer.length() - pPos.iPos < 8) {
            throw new Error("Supplied buffer too small to contain a 64bit integer (long)");
        }
        long lResult = 0L;
        char byte1 = tBuffer.charAt(pPos.iPos++);
        char byte2 = tBuffer.charAt(pPos.iPos++);
        char byte3 = tBuffer.charAt(pPos.iPos++);
        char byte4 = tBuffer.charAt(pPos.iPos++);
        char byte5 = tBuffer.charAt(pPos.iPos++);
        char byte6 = tBuffer.charAt(pPos.iPos++);
        char byte7 = tBuffer.charAt(pPos.iPos++);
        char byte8 = tBuffer.charAt(pPos.iPos++);
        lResult = (long)(byte1 << 56) + (long)(byte2 << 48) + (long)(byte3 << 40) + (long)(byte4 << 32) + (long)(byte5 << 24) + (long)(byte6 << 16) + (long)(byte7 << 8) + (long)byte8;
        return lResult;
    }

    static String DecodeString(StringBuffer tBuffer, GenericCoder pPos) {
        int iStringLength = GenericCoder.DecodeInt(tBuffer, pPos);
        if (iStringLength - pPos.iPos < 0) {
            throw new Error("Supplied buffer too small to contain a string");
        }
        StringBuffer sResult = new StringBuffer();
        sResult.setLength(iStringLength - 1);
        int i = 0;
        while (i < iStringLength - 1) {
            sResult.setCharAt(i, tBuffer.charAt(pPos.iPos++));
            ++i;
        }
        ++pPos.iPos;
        return sResult.toString();
    }

    static boolean FetchVsnMessage(InputStream is, StringBuffer tResult, int iMessageLength) throws IOException {
        int ch = is.read();
        while (ch != -1 && tResult.length() < iMessageLength) {
            tResult.append((char)ch);
            if (tResult.length() == iMessageLength) {
                return true;
            }
            ch = is.read();
        }
        return false;
    }

    static boolean SendVsnMessage(OutputStream os, StringBuffer tBuffer) throws IOException {
        StringBuffer tTemp = new StringBuffer();
        GenericCoder.EncodeInt(tBuffer.length(), tTemp);
        GenericCoder.EncodeByte((byte)3, tTemp);
        os.write(tTemp.toString().getBytes());
        os.write(tBuffer.toString().getBytes());
        os.flush();
        return true;
    }

    static boolean SendVsnWatchdogResponse(OutputStream os) throws IOException {
        StringBuffer tTemp = new StringBuffer();
        GenericCoder.EncodeInt(0, tTemp);
        GenericCoder.EncodeByte((byte)2, tTemp);
        os.write(tTemp.toString().getBytes());
        os.flush();
        return true;
    }

    static boolean SendVsnWatchdogRequest(OutputStream os) throws IOException {
        StringBuffer tTemp = new StringBuffer();
        GenericCoder.EncodeInt(0, tTemp);
        GenericCoder.EncodeByte((byte)1, tTemp);
        os.write(tTemp.toString().getBytes());
        os.flush();
        return true;
    }
}

