/*
 * Decompiled with CFR 0.152.
 */
package voipbuster;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import voipbuster.CommunicatorCallback;
import voipbuster.GenericCoder;
import voipbuster.GsmMessages;
import voipbuster.MyWorker;

public class Communicator
implements Runnable {
    private CommunicatorCallback callback;
    private Thread commThread;
    private String server;
    private String port;
    private InputStream is;
    private OutputStream os;
    private SocketConnection socket;
    private boolean bCancelSend;
    private boolean abort;
    public static final int ComMode_Webcall = 0;
    public static final int ComMode_Sms = 1;
    public static final int ComMode_Balance = 2;
    private int iComMode = 0;

    public Communicator(CommunicatorCallback callback) {
        this.callback = callback;
        this.abort = false;
        this.is = null;
        this.os = null;
        this.socket = null;
        this.bCancelSend = false;
    }

    public void setConnInfo(String server, String port) {
        this.server = server;
        this.port = port;
    }

    public void TryExecute(int iMode) {
        this.abort = false;
        this.startThread(iMode);
    }

    private void startThread(int iMyMode) {
        this.iComMode = iMyMode;
        if (this.settingsOk()) {
            this.bCancelSend = false;
            this.callback.CommDisplayProgress("Connecting..");
            this.commThread = new Thread(this);
            this.commThread.start();
        } else {
            this.callback.CommDisplayError("Settings missing");
        }
    }

    private boolean settingsOk() {
        return !this.server.trim().equals("") && !this.port.trim().equals("");
    }

    public void abort() {
        this.abort = true;
    }

    public void run() {
        try {
            int ch;
            this.connect();
            this.callback.CommDisplayProgress("Requesting access");
            GenericCoder iReadCount = new GenericCoder();
            StringBuffer RemoteData = new StringBuffer();
            while ((ch = this.is.read()) != -1) {
                RemoteData.append((char)ch);
                if (RemoteData.length() != 5) continue;
                int iMessageLength = GenericCoder.DecodeInt(RemoteData, iReadCount);
                switch (RemoteData.toString().toCharArray()[4]) {
                    case '\u0001': {
                        GenericCoder.SendVsnWatchdogResponse(this.os);
                        break;
                    }
                    case '\u0002': {
                        break;
                    }
                    case '\u0003': {
                        StringBuffer Message = new StringBuffer();
                        if (!GenericCoder.FetchVsnMessage(this.is, Message, iMessageLength)) {
                            this.disconnect();
                        }
                        if (this.HandleMessage(Message)) break;
                        this.disconnect();
                        break;
                    }
                    default: {
                        this.disconnect();
                        return;
                    }
                }
                iReadCount.iPos = 0;
                RemoteData = new StringBuffer();
            }
            this.callback.CommDisplayError("Lost connection with server");
        }
        catch (Exception e) {
            if (!this.abort) {
                this.callback.CommDisplayError(e.getMessage());
            }
            this.disconnect();
            return;
        }
        this.disconnect();
    }

    private boolean HandleMessage(StringBuffer sMessage) throws IOException {
        switch (this.iComMode) {
            case 0: {
                return this.HandleMessageComMode_WebCall(sMessage);
            }
            case 2: {
                return this.HandleMessageComMode_Balance(sMessage);
            }
            case 1: {
                return this.HandleMessageComMode_Sms(sMessage);
            }
        }
        return false;
    }

    private boolean HandleMessageComMode_WebCall(StringBuffer sMessage) throws IOException {
        GsmMessages cDecoder = new GsmMessages();
        String sError = new String();
        if (cDecoder.Decode(sMessage, sError)) {
            switch (cDecoder.iMessageType) {
                case 5: {
                    MyWorker.getInstance().uiCallId = cDecoder.tIE_RequestDetails.uiCallId;
                    if (this.bCancelSend) {
                        return false;
                    }
                    this.PerformCallRequest();
                    this.callback.CommDisplayProgress("Sending request");
                    break;
                }
                case 4: {
                    sError = GsmMessages.EndCauseToString(cDecoder.tIE_EndCause.iEndCause);
                    switch (cDecoder.tIE_EndCause.iEndCause) {
                        case 5: 
                        case 6: {
                            this.callback.CommDisplaySuccess(sError);
                            break;
                        }
                        default: {
                            this.callback.CommDisplayError(sError);
                        }
                    }
                    this.abort = true;
                    this.disconnect();
                    break;
                }
                case 3: {
                    sError = GsmMessages.CallProgressToString(cDecoder.tIE_CallProgress.iCallProgress);
                    this.callback.CommDisplayProgress(sError);
                    if (cDecoder.tIE_ChargeInfo == null) break;
                    TarifInfo myTarif = new TarifInfo(cDecoder.tIE_ChargeInfo);
                    this.callback.CommDisplayTariff(myTarif.toStringAside(), myTarif.toStringBside());
                }
            }
            return true;
        }
        this.callback.CommDisplayError("Unknown server response");
        return false;
    }

    private boolean HandleMessageComMode_Balance(StringBuffer sMessage) throws IOException {
        GsmMessages cDecoder = new GsmMessages();
        String sError = new String();
        if (cDecoder.Decode(sMessage, sError)) {
            switch (cDecoder.iMessageType) {
                case 5: {
                    MyWorker.getInstance().uiCallId = cDecoder.tIE_RequestDetails.uiCallId;
                    if (this.bCancelSend) {
                        return false;
                    }
                    this.PerformBalanceRequest();
                    this.callback.CommDisplayProgress("Balance request sent");
                    break;
                }
                case 4: {
                    sError = GsmMessages.EndCauseToString(cDecoder.tIE_EndCause.iEndCause);
                    this.callback.CommDisplayError(sError);
                    this.abort = true;
                    this.disconnect();
                    break;
                }
                case 9: {
                    sError = "Balance = " + LongToMoney.FormatBalance(cDecoder.tIE_UserBalance.iBalance);
                    this.callback.CommDisplaySuccess(sError);
                    this.abort = true;
                    this.disconnect();
                }
            }
            return true;
        }
        this.callback.CommDisplayError("Unknown server response");
        return false;
    }

    private boolean HandleMessageComMode_Sms(StringBuffer sMessage) throws IOException {
        GsmMessages cDecoder = new GsmMessages();
        String sError = new String();
        if (cDecoder.Decode(sMessage, sError)) {
            switch (cDecoder.iMessageType) {
                case 5: {
                    MyWorker.getInstance().uiCallId = cDecoder.tIE_RequestDetails.uiCallId;
                    if (this.bCancelSend) {
                        return false;
                    }
                    this.PerformSmsRequest();
                    this.callback.CommDisplayProgress("Sms request sent, wait result");
                    break;
                }
                case 4: {
                    if (cDecoder.tIE_SmsDeliveryResult != null) {
                        if (cDecoder.tIE_SmsDeliveryResult.bSuccess) {
                            sError = cDecoder.tIE_SmsChargeInfo == null ? "Sms delivered, (no charge info rxd)" : "Sms delivered, charge " + LongToMoney.Format(cDecoder.tIE_SmsChargeInfo.iTotalCost);
                            this.callback.CommDisplaySuccess(sError);
                        } else {
                            sError = "Sms delivery failed " + GsmMessages.EndCauseToString(cDecoder.tIE_EndCause.iEndCause);
                            this.callback.CommDisplayError(sError);
                        }
                    } else {
                        sError = GsmMessages.EndCauseToString(cDecoder.tIE_EndCause.iEndCause);
                        this.callback.CommDisplayError(sError);
                    }
                    this.abort = true;
                    this.disconnect();
                }
            }
            return true;
        }
        this.callback.CommDisplayError("Unknown server response");
        return false;
    }

    private void PerformCallRequest() throws IOException {
        GsmMessages cEncoder = new GsmMessages();
        StringBuffer tData = new StringBuffer();
        cEncoder.iMessageType = 2;
        cEncoder.Prepare_IE_RequestDetails(MyWorker.getInstance().uiCallId);
        MyWorker.getInstance().CalcMd5Hash();
        cEncoder.Prepare_IE_UserDetails(MyWorker.getInstance().sUserName, MyWorker.getInstance().sMd5Hash, MyWorker.getInstance().iWxxProduct, MyWorker.getInstance().iCdrBrand, MyWorker.getInstance().iCdrProduct);
        cEncoder.Prepare_IE_StartCallInfo(MyWorker.getInstance().sMyPhoneNumber, MyWorker.getInstance().sToDial);
        cEncoder.Encode(tData);
        GenericCoder.SendVsnMessage(this.os, tData);
    }

    private void PerformBalanceRequest() throws IOException {
        GsmMessages cEncoder = new GsmMessages();
        StringBuffer tData = new StringBuffer();
        cEncoder.iMessageType = 8;
        cEncoder.Prepare_IE_RequestDetails(MyWorker.getInstance().uiCallId);
        MyWorker.getInstance().CalcMd5Hash();
        cEncoder.Prepare_IE_UserDetails(MyWorker.getInstance().sUserName, MyWorker.getInstance().sMd5Hash, MyWorker.getInstance().iWxxProduct, MyWorker.getInstance().iCdrBrand, MyWorker.getInstance().iCdrProduct);
        cEncoder.Encode(tData);
        GenericCoder.SendVsnMessage(this.os, tData);
    }

    private void PerformSmsRequest() throws IOException {
        GsmMessages cEncoder = new GsmMessages();
        StringBuffer tData = new StringBuffer();
        cEncoder.iMessageType = 7;
        cEncoder.Prepare_IE_RequestDetails(MyWorker.getInstance().uiCallId);
        MyWorker.getInstance().CalcMd5Hash();
        cEncoder.Prepare_IE_UserDetails(MyWorker.getInstance().sUserName, MyWorker.getInstance().sMd5Hash, MyWorker.getInstance().iWxxProduct, MyWorker.getInstance().iCdrBrand, MyWorker.getInstance().iCdrProduct);
        cEncoder.Prepare_IE_Sms(MyWorker.getInstance().sToDial, MyWorker.getInstance().sSms);
        cEncoder.Encode(tData);
        GenericCoder.SendVsnMessage(this.os, tData);
    }

    public void disconnect() {
        try {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            if (this.os != null) {
                this.os.close();
                this.os = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean PerformDisconnectRequest() throws IOException {
        if (this.os == null) {
            return true;
        }
        if (this.iComMode != 0) {
            this.disconnect();
            return true;
        }
        if (this.bCancelSend) {
            this.disconnect();
            return true;
        }
        GsmMessages cEncoder = new GsmMessages();
        StringBuffer tData = new StringBuffer();
        cEncoder.iMessageType = 6;
        cEncoder.Prepare_IE_RequestDetails(MyWorker.getInstance().uiCallId);
        cEncoder.Encode(tData);
        GenericCoder.SendVsnMessage(this.os, tData);
        this.callback.CommDisplayProgress("Cancel call requested");
        this.bCancelSend = true;
        return false;
    }

    private void connect() throws Exception {
        this.disconnect();
        this.socket = (SocketConnection)Connector.open((String)("socket://" + this.server + ":" + this.port));
        this.os = this.socket.openOutputStream();
        this.is = this.socket.openInputStream();
    }

    public static class LongToMoney {
        public static String Format(long iMoney) {
            String sResult = new String("");
            long longRounded = (iMoney + 5000L) / 10000L;
            long longHigh = longRounded / 100L;
            long longLow = longRounded - longHigh * 100L;
            sResult = longLow < 10L ? String.valueOf(longHigh) + ".0" + longLow : String.valueOf(longHigh) + "." + longLow;
            return sResult;
        }

        public static String FormatBalance(long iMoney) {
            return LongToMoney.Format(iMoney * 10L);
        }
    }

    private class TarifInfo {
        private GsmMessages.cl_ChargeInfo tChargeInfo = null;

        public TarifInfo(GsmMessages.cl_ChargeInfo tChargeInfo) {
            this.tChargeInfo = tChargeInfo;
        }

        public String toStringAside() {
            if (this.tChargeInfo == null) {
                return "";
            }
            String sChargeInfo = new String("Your side:");
            sChargeInfo = this.tChargeInfo.iASideSetupCharge != 0L ? String.valueOf(sChargeInfo) + "Setup" + (this.tChargeInfo.iASideSetupCharge + 5000L) / 10000L + " ct/min +" + (this.tChargeInfo.iASideTariff + 5000L) / 10000L + " ct/min" : String.valueOf(sChargeInfo) + (this.tChargeInfo.iASideTariff + 5000L) / 10000L + " ct/min";
            return sChargeInfo;
        }

        public String toStringBside() {
            if (this.tChargeInfo == null) {
                return "";
            }
            String sChargeInfo = new String("Remote side:");
            sChargeInfo = this.tChargeInfo.iBSideSetupCharge != 0L ? String.valueOf(sChargeInfo) + "Setup" + (this.tChargeInfo.iBSideSetupCharge + 5000L) / 10000L + " ct/min +" + (this.tChargeInfo.iBSideTariff + 5000L) / 10000L + " ct/min" : String.valueOf(sChargeInfo) + (this.tChargeInfo.iBSideTariff + 5000L) / 10000L + " ct/min";
            return sChargeInfo;
        }
    }
}

