/*
 * Decompiled with CFR 0.152.
 */
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.Ticker;

public class MainTextBox
extends TextBox
implements CommandListener {
    private Ticker lengthTicker = new Ticker("000");
    private String lengthString = new String();
    private Command sendCommand = new Command("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c", 1, 0);
    private Command compressCommand = new Command("\u0421\u0436\u0430\u0442\u044c", 1, 1);
    private Command decompressCommand = new Command("\u0420\u0430\u0441\u0436\u0430\u0442\u044c", 1, 2);
    private Command openCommand = new Command("\u041e\u0442\u043a\u0440\u044b\u0442\u044c", 1, 3);
    private Command saveCommand = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 1, 4);
    private Command estimateCommand = new Command("\u041e\u0446\u0435\u043d\u0438\u0442\u044c", 1, 5);
    private Command helpCommand = new Command("\u041f\u043e\u043c\u043e\u0449\u044c", 1, 6);
    private Command aboutCommand = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 1, 7);
    private Command exitCommand = new Command("\u0412\u044b\u0445\u043e\u0434", 1, 8);
    private Timer timer = new Timer();
    private TimerTask setTitleTimerTask = new SetTitleTimerTask();
    private String tempString = new String();
    private int length;
    private int shift;
    public boolean openFile;
    public boolean openDirectory;

    public MainTextBox() {
        super("", "", 512, 0);
        this.addCommand(this.sendCommand);
        this.addCommand(this.compressCommand);
        this.addCommand(this.decompressCommand);
        this.addCommand(this.openCommand);
        this.addCommand(this.saveCommand);
        this.addCommand(this.estimateCommand);
        this.addCommand(this.helpCommand);
        this.addCommand(this.aboutCommand);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
        this.setTicker(this.lengthTicker);
        this.timer.schedule(this.setTitleTimerTask, 0L, 500L);
    }

    public void commandAction(Command command, Displayable displayable) {
        block20: {
            if (command == this.sendCommand) {
                SMSplusMIDlet.display.setCurrent((Displayable)SMSplusMIDlet.inputPhoneNumber);
            } else if (command == this.compressCommand) {
                try {
                    if (this.getString().length() == 0) break block20;
                    this.tempString = this.compress(this.getString());
                    if (this.tempString.length() <= 160) {
                        this.setString(this.tempString);
                        break block20;
                    }
                    SMSplusMIDlet.display.setCurrent((Displayable)Alerts.SMSAttention);
                }
                catch (Exception E) {
                    SMSplusMIDlet.display.setCurrent((Displayable)Alerts.SMSAttention);
                }
            } else if (command == this.decompressCommand) {
                this.setString(this.decompress(this.getString()));
            } else if (command == this.openCommand) {
                this.openFile = true;
                this.openDirectory = false;
                Explorer.ExplorerList.leftSoftCommand = Explorer.ExplorerList.openCommand;
                Explorer.run();
            } else if (command == this.saveCommand) {
                this.openFile = false;
                this.openDirectory = true;
                Explorer.ExplorerList.leftSoftCommand = Explorer.ExplorerList.saveCommand;
                Explorer.run();
            } else if (command == this.estimateCommand) {
                Estimation.show();
            } else if (command == this.helpCommand) {
                SMSplusMIDlet.display.setCurrent((Displayable)SMSplusMIDlet.help);
            } else if (command == this.aboutCommand) {
                SMSplusMIDlet.display.setCurrent((Displayable)SMSplusMIDlet.about);
            } else if (command == this.exitCommand) {
                SMSplusMIDlet.display.setCurrent((Displayable)SMSplusMIDlet.exitConfirmation);
            }
        }
    }

    public String compress(String string) {
        int[] data = new int[1792];
        data[0] = 0;
        data[1] = 0;
        data[2] = 0;
        data[3] = 1;
        int[] frequencyVectorArray = Huffman.frequencyVectorToBinaryArray(Huffman.getFrequencyVector(string));
        int frequencyVectorArrayLength = frequencyVectorArray.length;
        int i = 0;
        while (i < frequencyVectorArrayLength) {
            data[4 + i] = frequencyVectorArray[i];
            ++i;
        }
        int[] dataText = SMSUtils.binaryStringToBinaryArray(Huffman.getEncodedBinaryString(string));
        int dataTextLength = dataText.length;
        int sourceTextLength = string.length();
        data[4 + frequencyVectorArrayLength] = (sourceTextLength & 0x100) >> 8;
        data[5 + frequencyVectorArrayLength] = (sourceTextLength & 0x80) >> 7;
        data[6 + frequencyVectorArrayLength] = (sourceTextLength & 0x40) >> 6;
        data[7 + frequencyVectorArrayLength] = (sourceTextLength & 0x20) >> 5;
        data[8 + frequencyVectorArrayLength] = (sourceTextLength & 0x10) >> 4;
        data[9 + frequencyVectorArrayLength] = (sourceTextLength & 8) >> 3;
        data[10 + frequencyVectorArrayLength] = (sourceTextLength & 4) >> 2;
        data[11 + frequencyVectorArrayLength] = (sourceTextLength & 2) >> 1;
        data[12 + frequencyVectorArrayLength] = sourceTextLength & 1;
        int i2 = 0;
        while (i2 < dataTextLength) {
            data[13 + frequencyVectorArrayLength + i2] = dataText[i2];
            ++i2;
        }
        return SMSUtils.binaryArrayToString(data, CharSets.allSendable, 7, false).substring(0, Estimation.ceilDivision(13 + frequencyVectorArrayLength + dataTextLength, 7));
    }

    public String decompress(String string) {
        int[] data = SMSUtils.stringToBinaryArray(string, CharSets.allSendable, 7, false);
        int frequencyVectorSize = 128 * data[4] + 64 * data[5] + 32 * data[6] + 16 * data[7] + 8 * data[8] + 4 * data[9] + 2 * data[10] + data[11];
        int bitsPerFrequency = 8 * data[12] + 4 * data[13] + 2 * data[14] + data[15];
        int[] frequencyVectorArray = new int[12 + (8 + bitsPerFrequency) * frequencyVectorSize];
        int frequencyVectorArrayLength = frequencyVectorArray.length;
        int i = 0;
        while (i < frequencyVectorArrayLength) {
            frequencyVectorArray[i] = data[4 + i];
            ++i;
        }
        int sourceTextLength = 256 * data[4 + frequencyVectorArrayLength] + 128 * data[5 + frequencyVectorArrayLength] + 64 * data[6 + frequencyVectorArrayLength] + 32 * data[7 + frequencyVectorArrayLength] + 16 * data[8 + frequencyVectorArrayLength] + 8 * data[9 + frequencyVectorArrayLength] + 4 * data[10 + frequencyVectorArrayLength] + 2 * data[11 + frequencyVectorArrayLength] + data[12 + frequencyVectorArrayLength];
        int[] dataText = new int[data.length - frequencyVectorArrayLength - 13];
        int dataTextLength = dataText.length;
        int i2 = 0;
        while (i2 < dataTextLength) {
            dataText[i2] = data[13 + frequencyVectorArrayLength + i2];
            ++i2;
        }
        return Huffman.getDecodedString(SMSUtils.binaryArrayToBinaryString(dataText), Huffman.binaryArrayToFrequencyVector(frequencyVectorArray)).substring(0, sourceTextLength);
    }

    public void open(String fileName) {
        SMSUtils.SMS sms = new SMSUtils.SMS(fileName);
        this.tempString = SMSUtils.binaryArrayToString(sms.data, CharSets.allSendable, 7, true).substring(0, sms.charsCount);
        this.length = this.tempString.length();
        this.shift = 0;
        int i = 0;
        while (i < this.length) {
            if (this.tempString.charAt(i) == CharSets.allSendable[27]) {
                ++this.shift;
            }
            ++i;
        }
        this.setString(this.tempString.substring(0, this.length - this.shift));
    }

    public void save(String directoryName) {
        SMSplusMIDlet.inputFileName.setDirectoryName(directoryName);
        SMSplusMIDlet.display.setCurrent((Displayable)SMSplusMIDlet.inputFileName);
    }

    private class SetTitleTimerTask
    extends TimerTask {
        public void run() {
            if (MainTextBox.this.isShown()) {
                MainTextBox.this.tempString = MainTextBox.this.getString();
                MainTextBox.this.length = MainTextBox.this.tempString.length();
                MainTextBox.this.shift = 0;
                int i = 0;
                while (i < MainTextBox.this.length) {
                    if (MainTextBox.this.tempString.charAt(i) == CharSets.allSendable[27]) {
                        MainTextBox.this.shift++;
                    }
                    ++i;
                }
                MainTextBox.this.lengthString = String.valueOf(MainTextBox.this.length + MainTextBox.this.shift);
                switch (MainTextBox.this.lengthString.length()) {
                    case 1: {
                        MainTextBox.this.lengthString = "00" + MainTextBox.this.lengthString;
                        break;
                    }
                    case 2: {
                        MainTextBox.this.lengthString = "0" + MainTextBox.this.lengthString;
                    }
                }
                MainTextBox.this.lengthTicker.setString(MainTextBox.this.lengthString);
            }
        }
    }
}

