/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Huffman {
    private Huffman() {
    }

    private static Vector countSort(Vector vector) {
        int vectorSize = vector.size();
        int max = Huffman.maxFrequencyVectorItem((Vector)vector).frequency;
        int[] count = new int[max + 1];
        Vector<FrequencyVectorItem> sortedVector = new Vector<FrequencyVectorItem>();
        sortedVector.setSize(vectorSize);
        int i = 0;
        while (i < max + 1) {
            count[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < vectorSize) {
            int n = ((FrequencyVectorItem)vector.elementAt((int)i2)).frequency;
            count[n] = count[n] + 1;
            ++i2;
        }
        int i3 = 1;
        while (i3 < max + 1) {
            int n = i3;
            count[n] = count[n] + count[i3 - 1];
            ++i3;
        }
        int i4 = vectorSize - 1;
        while (i4 >= 0) {
            sortedVector.setElementAt((FrequencyVectorItem)vector.elementAt(i4), count[((FrequencyVectorItem)vector.elementAt((int)i4)).frequency] - 1);
            int n = ((FrequencyVectorItem)vector.elementAt((int)i4)).frequency;
            count[n] = count[n] - 1;
            --i4;
        }
        return sortedVector;
    }

    private static int searchInFrequencyVector(Vector vector, char item) {
        int i = 0;
        int vectorSize = vector.size();
        while (i < vectorSize && ((FrequencyVectorItem)vector.elementAt((int)i)).item != item) {
            ++i;
        }
        if (i != vectorSize) {
            return i;
        }
        return -1;
    }

    private static int searchInCodeVector(Vector vector, char item) {
        int i = 0;
        int vectorSize = vector.size();
        while (i < vectorSize && ((CodeVectorItem)vector.elementAt((int)i)).item != item) {
            ++i;
        }
        if (i != vectorSize) {
            return i;
        }
        return -1;
    }

    private static int searchInCodeVector(Vector vector, String code) {
        int i = 0;
        int vectorSize = vector.size();
        while (i < vectorSize && !((CodeVectorItem)vector.elementAt((int)i)).code.equals(code)) {
            ++i;
        }
        if (i != vectorSize) {
            return i;
        }
        return -1;
    }

    private static FrequencyVectorItem maxFrequencyVectorItem(Vector vector) {
        int vectorSize = vector.size();
        FrequencyVectorItem maxFrequencyVectorItem = (FrequencyVectorItem)vector.elementAt(0);
        int maxFrequency = maxFrequencyVectorItem.frequency;
        int i = 1;
        while (i < vectorSize) {
            if (((FrequencyVectorItem)vector.elementAt((int)i)).frequency > maxFrequency) {
                maxFrequencyVectorItem = (FrequencyVectorItem)vector.elementAt(i);
                maxFrequency = maxFrequencyVectorItem.frequency;
            }
            ++i;
        }
        return maxFrequencyVectorItem;
    }

    private static TreeVectorItem minTreeVectorItem(Vector vector) {
        int vectorSize = vector.size();
        TreeVectorItem minTreeVectorItem = (TreeVectorItem)vector.elementAt(0);
        int minFrequency = minTreeVectorItem.frequency;
        int i = 1;
        while (i < vectorSize) {
            if (((TreeVectorItem)vector.elementAt((int)i)).frequency < minFrequency) {
                minTreeVectorItem = (TreeVectorItem)vector.elementAt(i);
                minFrequency = minTreeVectorItem.frequency;
            }
            ++i;
        }
        return minTreeVectorItem;
    }

    private static Vector creatFrequencyVector(String string) {
        int stringLength = string.length();
        Vector<FrequencyVectorItem> vector = new Vector<FrequencyVectorItem>();
        int i = 0;
        while (i < stringLength) {
            int index = Huffman.searchInFrequencyVector(vector, string.charAt(i));
            if (index != -1) {
                ++((FrequencyVectorItem)vector.elementAt((int)index)).frequency;
            } else {
                FrequencyVectorItem frequencyVectorItem = new FrequencyVectorItem();
                frequencyVectorItem.item = string.charAt(i);
                frequencyVectorItem.frequency = 1;
                vector.addElement(frequencyVectorItem);
            }
            ++i;
        }
        return vector;
    }

    private static Vector createCodeVector(Vector frequencyVector) {
        int frequencyVectorSize = frequencyVector.size();
        Vector<CodeVectorItem> codeVector = new Vector<CodeVectorItem>();
        int i = 0;
        while (i < frequencyVectorSize) {
            CodeVectorItem codeVectorItem = new CodeVectorItem();
            codeVectorItem.item = ((FrequencyVectorItem)frequencyVector.elementAt((int)i)).item;
            codeVector.addElement(codeVectorItem);
            ++i;
        }
        Vector<TreeVectorItem> treeVector = new Vector<TreeVectorItem>();
        int i2 = 0;
        while (i2 < frequencyVectorSize) {
            TreeVectorItem treeVectorItem = new TreeVectorItem();
            treeVectorItem.items = String.valueOf(((FrequencyVectorItem)frequencyVector.elementAt((int)i2)).item);
            treeVectorItem.frequency = ((FrequencyVectorItem)frequencyVector.elementAt((int)i2)).frequency;
            treeVector.addElement(treeVectorItem);
            ++i2;
        }
        if (treeVector.size() == 1) {
            ((CodeVectorItem)codeVector.elementAt((int)0)).code = "0";
        }
        while (treeVector.size() != 1) {
            TreeVectorItem minTreeVectorItem1 = Huffman.minTreeVectorItem(treeVector);
            treeVector.removeElement(minTreeVectorItem1);
            TreeVectorItem minTreeVectorItem2 = Huffman.minTreeVectorItem(treeVector);
            treeVector.removeElement(minTreeVectorItem2);
            TreeVectorItem treeVectorItem = new TreeVectorItem();
            treeVectorItem.items = minTreeVectorItem1.items + minTreeVectorItem2.items;
            treeVectorItem.frequency = minTreeVectorItem1.frequency + minTreeVectorItem2.frequency;
            treeVector.insertElementAt(treeVectorItem, 0);
            int i3 = 0;
            while (i3 < minTreeVectorItem1.items.length()) {
                ((CodeVectorItem)codeVector.elementAt((int)Huffman.searchInCodeVector(codeVector, (char)minTreeVectorItem1.items.charAt((int)i3)))).code = "0" + ((CodeVectorItem)codeVector.elementAt((int)Huffman.searchInCodeVector(codeVector, (char)minTreeVectorItem1.items.charAt((int)i3)))).code;
                ++i3;
            }
            int i4 = 0;
            while (i4 < minTreeVectorItem2.items.length()) {
                ((CodeVectorItem)codeVector.elementAt((int)Huffman.searchInCodeVector(codeVector, (char)minTreeVectorItem2.items.charAt((int)i4)))).code = "1" + ((CodeVectorItem)codeVector.elementAt((int)Huffman.searchInCodeVector(codeVector, (char)minTreeVectorItem2.items.charAt((int)i4)))).code;
                ++i4;
            }
        }
        return codeVector;
    }

    private static String createEncodedString(String string, Vector codeVector) {
        int stringLength = string.length();
        String encodedString = new String();
        int i = 0;
        while (i < stringLength) {
            encodedString = encodedString + ((CodeVectorItem)codeVector.elementAt((int)Huffman.searchInCodeVector((Vector)codeVector, (char)string.charAt((int)i)))).code;
            ++i;
        }
        return encodedString;
    }

    public static String getEncodedBinaryString(String string) {
        Vector frequencyVector = Huffman.countSort(Huffman.creatFrequencyVector(string));
        Vector codeVector = Huffman.createCodeVector(frequencyVector);
        String encodedString = Huffman.createEncodedString(string, codeVector);
        return encodedString;
    }

    public static String getDecodedString(String string, Vector frequencyVector) {
        int beginIndex = 0;
        int stringLength = string.length();
        String decodedString = new String();
        Vector codeVector = Huffman.createCodeVector(frequencyVector);
        int i = 1;
        while (i < stringLength + 1) {
            int index = Huffman.searchInCodeVector(codeVector, string.substring(beginIndex, i));
            if (index != -1) {
                decodedString = decodedString + ((CodeVectorItem)codeVector.elementAt((int)index)).item;
                beginIndex = i;
            }
            ++i;
        }
        return decodedString;
    }

    public static Vector getFrequencyVector(String string) {
        Vector frequencyVector = Huffman.countSort(Huffman.creatFrequencyVector(string));
        return frequencyVector;
    }

    public static int[] frequencyVectorToBinaryArray(Vector frequencyVector) {
        int maxFrequency = Huffman.maxFrequencyVectorItem((Vector)frequencyVector).frequency;
        int bitsPerFrequency = 0;
        while (maxFrequency != 0) {
            maxFrequency /= 2;
            ++bitsPerFrequency;
        }
        int frequencyVectorSize = frequencyVector.size();
        int[] data = new int[12 + (8 + bitsPerFrequency) * frequencyVectorSize];
        data[0] = (frequencyVectorSize & 0x80) >> 7;
        data[1] = (frequencyVectorSize & 0x40) >> 6;
        data[2] = (frequencyVectorSize & 0x20) >> 5;
        data[3] = (frequencyVectorSize & 0x10) >> 4;
        data[4] = (frequencyVectorSize & 8) >> 3;
        data[5] = (frequencyVectorSize & 4) >> 2;
        data[6] = (frequencyVectorSize & 2) >> 1;
        data[7] = frequencyVectorSize & 1;
        data[8] = (bitsPerFrequency & 8) >> 3;
        data[9] = (bitsPerFrequency & 4) >> 2;
        data[10] = (bitsPerFrequency & 2) >> 1;
        data[11] = bitsPerFrequency & 1;
        int i = 0;
        while (i < frequencyVectorSize) {
            int item = CharSets.indexOf(((FrequencyVectorItem)frequencyVector.elementAt((int)i)).item, CharSets.allPrintable);
            data[12 + i * (8 + bitsPerFrequency)] = (item & 0x80) >> 7;
            data[13 + i * (8 + bitsPerFrequency)] = (item & 0x40) >> 6;
            data[14 + i * (8 + bitsPerFrequency)] = (item & 0x20) >> 5;
            data[15 + i * (8 + bitsPerFrequency)] = (item & 0x10) >> 4;
            data[16 + i * (8 + bitsPerFrequency)] = (item & 8) >> 3;
            data[17 + i * (8 + bitsPerFrequency)] = (item & 4) >> 2;
            data[18 + i * (8 + bitsPerFrequency)] = (item & 2) >> 1;
            data[19 + i * (8 + bitsPerFrequency)] = item & 1;
            int frequency = ((FrequencyVectorItem)frequencyVector.elementAt((int)i)).frequency;
            switch (bitsPerFrequency) {
                case 1: {
                    data[20 + i * (8 + bitsPerFrequency)] = frequency & 1;
                    break;
                }
                case 2: {
                    data[20 + i * (8 + bitsPerFrequency)] = (frequency & 2) >> 1;
                    data[21 + i * (8 + bitsPerFrequency)] = frequency & 1;
                    break;
                }
                case 3: {
                    data[20 + i * (8 + bitsPerFrequency)] = (frequency & 4) >> 2;
                    data[21 + i * (8 + bitsPerFrequency)] = (frequency & 2) >> 1;
                    data[22 + i * (8 + bitsPerFrequency)] = frequency & 1;
                    break;
                }
                case 4: {
                    data[20 + i * (8 + bitsPerFrequency)] = (frequency & 8) >> 3;
                    data[21 + i * (8 + bitsPerFrequency)] = (frequency & 4) >> 2;
                    data[22 + i * (8 + bitsPerFrequency)] = (frequency & 2) >> 1;
                    data[23 + i * (8 + bitsPerFrequency)] = frequency & 1;
                    break;
                }
                case 5: {
                    data[20 + i * (8 + bitsPerFrequency)] = (frequency & 0x10) >> 4;
                    data[21 + i * (8 + bitsPerFrequency)] = (frequency & 8) >> 3;
                    data[22 + i * (8 + bitsPerFrequency)] = (frequency & 4) >> 2;
                    data[23 + i * (8 + bitsPerFrequency)] = (frequency & 2) >> 1;
                    data[24 + i * (8 + bitsPerFrequency)] = frequency & 1;
                    break;
                }
                case 6: {
                    data[20 + i * (8 + bitsPerFrequency)] = (frequency & 0x20) >> 5;
                    data[21 + i * (8 + bitsPerFrequency)] = (frequency & 0x10) >> 4;
                    data[22 + i * (8 + bitsPerFrequency)] = (frequency & 8) >> 3;
                    data[23 + i * (8 + bitsPerFrequency)] = (frequency & 4) >> 2;
                    data[24 + i * (8 + bitsPerFrequency)] = (frequency & 2) >> 1;
                    data[25 + i * (8 + bitsPerFrequency)] = frequency & 1;
                    break;
                }
                case 7: {
                    data[20 + i * (8 + bitsPerFrequency)] = (frequency & 0x40) >> 6;
                    data[21 + i * (8 + bitsPerFrequency)] = (frequency & 0x20) >> 5;
                    data[22 + i * (8 + bitsPerFrequency)] = (frequency & 0x10) >> 4;
                    data[23 + i * (8 + bitsPerFrequency)] = (frequency & 8) >> 3;
                    data[24 + i * (8 + bitsPerFrequency)] = (frequency & 4) >> 2;
                    data[25 + i * (8 + bitsPerFrequency)] = (frequency & 2) >> 1;
                    data[26 + i * (8 + bitsPerFrequency)] = frequency & 1;
                    break;
                }
                case 8: {
                    data[20 + i * (8 + bitsPerFrequency)] = (frequency & 0x80) >> 7;
                    data[21 + i * (8 + bitsPerFrequency)] = (frequency & 0x40) >> 6;
                    data[22 + i * (8 + bitsPerFrequency)] = (frequency & 0x20) >> 5;
                    data[23 + i * (8 + bitsPerFrequency)] = (frequency & 0x10) >> 4;
                    data[24 + i * (8 + bitsPerFrequency)] = (frequency & 8) >> 3;
                    data[25 + i * (8 + bitsPerFrequency)] = (frequency & 4) >> 2;
                    data[26 + i * (8 + bitsPerFrequency)] = (frequency & 2) >> 1;
                    data[27 + i * (8 + bitsPerFrequency)] = frequency & 1;
                }
            }
            ++i;
        }
        return data;
    }

    public static Vector binaryArrayToFrequencyVector(int[] data) {
        int frequencyVectorSize = 128 * data[0] + 64 * data[1] + 32 * data[2] + 16 * data[3] + 8 * data[4] + 4 * data[5] + 2 * data[6] + data[7];
        int bitsPerFrequency = 8 * data[8] + 4 * data[9] + 2 * data[10] + data[11];
        Vector<FrequencyVectorItem> frequencyVector = new Vector<FrequencyVectorItem>();
        frequencyVector.setSize(frequencyVectorSize);
        int i = 0;
        while (i < frequencyVectorSize) {
            FrequencyVectorItem frequencyVectorItem = new FrequencyVectorItem();
            int index = 128 * data[12 + i * (8 + bitsPerFrequency)] + 64 * data[13 + i * (8 + bitsPerFrequency)] + 32 * data[14 + i * (8 + bitsPerFrequency)] + 16 * data[15 + i * (8 + bitsPerFrequency)] + 8 * data[16 + i * (8 + bitsPerFrequency)] + 4 * data[17 + i * (8 + bitsPerFrequency)] + 2 * data[18 + i * (8 + bitsPerFrequency)] + data[19 + i * (8 + bitsPerFrequency)];
            frequencyVectorItem.item = CharSets.allPrintable[index];
            switch (bitsPerFrequency) {
                case 1: {
                    frequencyVectorItem.frequency = data[20 + i * (8 + bitsPerFrequency)];
                    break;
                }
                case 2: {
                    frequencyVectorItem.frequency = 2 * data[20 + i * (8 + bitsPerFrequency)] + data[21 + i * (8 + bitsPerFrequency)];
                    break;
                }
                case 3: {
                    frequencyVectorItem.frequency = 4 * data[20 + i * (8 + bitsPerFrequency)] + 2 * data[21 + i * (8 + bitsPerFrequency)] + data[22 + i * (8 + bitsPerFrequency)];
                    break;
                }
                case 4: {
                    frequencyVectorItem.frequency = 8 * data[20 + i * (8 + bitsPerFrequency)] + 4 * data[21 + i * (8 + bitsPerFrequency)] + 2 * data[22 + i * (8 + bitsPerFrequency)] + data[23 + i * (8 + bitsPerFrequency)];
                    break;
                }
                case 5: {
                    frequencyVectorItem.frequency = 16 * data[20 + i * (8 + bitsPerFrequency)] + 8 * data[21 + i * (8 + bitsPerFrequency)] + 4 * data[22 + i * (8 + bitsPerFrequency)] + 2 * data[23 + i * (8 + bitsPerFrequency)] + data[24 + i * (8 + bitsPerFrequency)];
                    break;
                }
                case 6: {
                    frequencyVectorItem.frequency = 32 * data[20 + i * (8 + bitsPerFrequency)] + 16 * data[21 + i * (8 + bitsPerFrequency)] + 8 * data[22 + i * (8 + bitsPerFrequency)] + 4 * data[23 + i * (8 + bitsPerFrequency)] + 2 * data[24 + i * (8 + bitsPerFrequency)] + data[25 + i * (8 + bitsPerFrequency)];
                    break;
                }
                case 7: {
                    frequencyVectorItem.frequency = 64 * data[20 + i * (8 + bitsPerFrequency)] + 32 * data[21 + i * (8 + bitsPerFrequency)] + 16 * data[22 + i * (8 + bitsPerFrequency)] + 8 * data[23 + i * (8 + bitsPerFrequency)] + 4 * data[24 + i * (8 + bitsPerFrequency)] + 2 * data[25 + i * (8 + bitsPerFrequency)] + data[26 + i * (8 + bitsPerFrequency)];
                    break;
                }
                case 8: {
                    frequencyVectorItem.frequency = 128 * data[20 + i * (8 + bitsPerFrequency)] + 64 * data[21 + i * (8 + bitsPerFrequency)] + 32 * data[22 + i * (8 + bitsPerFrequency)] + 16 * data[23 + i * (8 + bitsPerFrequency)] + 8 * data[24 + i * (8 + bitsPerFrequency)] + 4 * data[25 + i * (8 + bitsPerFrequency)] + 2 * data[26 + i * (8 + bitsPerFrequency)] + data[27 + i * (8 + bitsPerFrequency)];
                }
            }
            frequencyVector.setElementAt(frequencyVectorItem, i);
            ++i;
        }
        return frequencyVector;
    }

    private static class TreeVectorItem {
        public String items = new String();
        public int frequency;
    }

    private static class CodeVectorItem {
        public char item;
        public String code = new String();
    }

    private static class FrequencyVectorItem {
        public char item;
        public int frequency;
    }
}

