/*
 * Decompiled with CFR 0.152.
 */
package jlayer;

import java.io.InputStream;
import jlayer.BitReserve;
import jlayer.BitStream;
import jlayer.Header;
import jlayer.HuffmanTables;
import jlayer.SampleBuffer;
import jlayer.SynthesisFilter;

public final class LayerIIIDecoder {
    public static final int BOTH_CHANNELS = 0;
    public static final int LEFT_CHANNEL = 1;
    public static final int RIGHT_CHANNEL = 2;
    public static final int DOWNMIX_CHANNELS = 3;
    private static final byte[] pretab = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 3, 2, 0};
    private static final float[] two_to_negative_half_pow = new float[]{1.0f, 0.70710677f, 0.5f, 0.35355338f, 0.25f, 0.17677669f, 0.125f, 0.088388346f, 0.0625f, 0.044194173f, 0.03125f, 0.022097087f, 0.015625f, 0.011048543f, 0.0078125f, 0.0055242716f, 0.00390625f, 0.0027621358f, 0.001953125f, 0.0013810679f, 9.765625E-4f, 6.9053395E-4f, 4.8828125E-4f, 3.4526698E-4f, 2.4414062E-4f, 1.7263349E-4f, 1.2207031E-4f, 8.6316744E-5f, 6.1035156E-5f, 4.3158372E-5f, 3.0517578E-5f, 2.1579186E-5f, 1.5258789E-5f, 1.0789593E-5f, 7.6293945E-6f, 5.3947965E-6f, 3.8146973E-6f, 2.6973983E-6f, 1.9073486E-6f, 1.3486991E-6f, 9.536743E-7f, 6.7434956E-7f, 4.7683716E-7f, 3.3717478E-7f, 2.3841858E-7f, 1.6858739E-7f, 1.1920929E-7f, 8.4293696E-8f, 5.9604645E-8f, 4.2146848E-8f, 2.9802322E-8f, 2.1073424E-8f, 1.4901161E-8f, 1.0536712E-8f, 7.450581E-9f, 5.268356E-9f, 3.7252903E-9f, 2.634178E-9f, 1.8626451E-9f, 1.317089E-9f, 9.313226E-10f, 6.585445E-10f, 4.656613E-10f, 3.2927225E-10f};
    public int every = 6;
    private static final int t43max = 255;
    private static final float[] t_43 = new float[]{0.0f, 1.0f, 2.5198421f, 4.326749f, 6.3496046f, 8.54988f, 10.902724f, 13.390519f, 16.000002f, 18.720757f, 21.54435f, 24.463783f, 27.473145f, 30.567354f, 33.741997f, 36.993187f, 40.31748f, 43.711792f, 47.17335f, 50.69964f, 54.28836f, 57.937416f, 61.644875f, 65.40895f, 69.22799f, 73.10046f, 77.02491f, 81.00001f, 85.024506f, 89.0972f, 93.21699f, 97.38281f, 101.59368f, 105.84865f, 110.14682f, 114.487335f, 118.8694f, 123.29223f, 127.75508f, 132.25726f, 136.7981f, 141.37692f, 145.99313f, 150.64613f, 155.33536f, 160.06023f, 164.82022f, 169.61485f, 174.4436f, 179.30602f, 184.2016f, 189.12994f, 194.0906f, 199.08318f, 204.10724f, 209.16241f, 214.24832f, 219.3646f, 224.51088f, 229.68683f, 234.89209f, 240.12637f, 245.38931f, 250.68065f, 256.00003f, 261.34723f, 266.7219f, 272.12378f, 277.55258f, 283.0081f, 288.49002f, 293.9981f, 299.53214f, 305.09183f, 310.67694f, 316.2873f, 321.92264f, 327.58276f, 333.26743f, 338.97644f, 344.70963f, 350.4667f, 356.24756f, 362.05194f, 367.87967f, 373.7306f, 379.6045f, 385.50122f, 391.42056f, 397.3624f, 403.3265f, 409.31274f, 415.32095f, 421.35098f, 427.40265f, 433.47583f, 439.57034f, 445.68607f, 451.82285f, 457.98053f, 464.15897f, 470.35803f, 476.5776f, 482.81754f, 489.0777f, 495.35797f, 501.65817f, 507.97824f, 514.31805f, 520.6774f, 527.0563f, 533.4545f, 539.87195f, 546.30853f, 552.76416f, 559.2387f, 565.732f, 572.24396f, 578.77454f, 585.3236f, 591.891f, 598.4767f, 605.08057f, 611.70245f, 618.34235f, 625.0001f, 631.67566f, 638.3689f, 645.0797f, 651.80804f, 658.5537f, 665.3168f, 672.09705f, 678.8945f, 685.7089f, 692.5404f, 699.38873f, 706.25385f, 713.13574f, 720.03424f, 726.94934f, 733.88086f, 740.82886f, 747.79315f, 754.7737f, 761.7704f, 768.7832f, 775.8121f, 782.8569f, 789.9176f, 796.9941f, 804.08636f, 811.1943f, 818.3178f, 825.45685f, 832.6114f, 839.7813f, 846.9666f, 854.1672f, 861.38293f, 868.61383f, 875.8598f, 883.1208f, 890.3967f, 897.68756f, 904.9933f, 912.3137f, 919.64886f, 926.9987f, 934.36316f, 941.74207f, 949.13556f, 956.5434f, 963.96564f, 971.4022f, 978.853f, 986.31805f, 993.79724f, 1001.29047f, 1008.7978f, 1016.3191f, 1023.8544f, 1031.4036f, 1038.9666f, 1046.5432f, 1054.1338f, 1061.7379f, 1069.3558f, 1076.9872f, 1084.6322f, 1092.2906f, 1099.9626f, 1107.648f, 1115.3466f, 1123.0586f, 1130.7838f, 1138.5222f, 1146.2739f, 1154.0386f, 1161.8164f, 1169.6073f, 1177.4113f, 1185.228f, 1193.0577f, 1200.9004f, 1208.7559f, 1216.624f, 1224.505f, 1232.3987f, 1240.3049f, 1248.2239f, 1256.1554f, 1264.0995f, 1272.056f, 1280.025f, 1288.0065f, 1296.0002f, 1304.0065f, 1312.0249f, 1320.0557f, 1328.0986f, 1336.1538f, 1344.2212f, 1352.3007f, 1360.3922f, 1368.4957f, 1376.6113f, 1384.7389f, 1392.8784f, 1401.0299f, 1409.1932f, 1417.3684f, 1425.5553f, 1433.754f, 1441.9645f, 1450.1866f, 1458.4205f, 1466.666f, 1474.9231f, 1483.1918f, 1491.4719f, 1499.7637f, 1508.0668f, 1516.3815f, 1524.7075f, 1533.0449f, 1541.3937f, 1549.7538f, 1558.1251f, 1566.5078f, 1574.9016f, 1583.3068f, 1591.723f, 1600.1504f, 1608.5889f, 1617.0385f};
    private static final int ggstart = 138;
    private static final int ggend = 211;
    private static final float[] ggain = new float[]{3.8146973E-6f, 4.536465E-6f, 5.3947965E-6f, 6.4155306E-6f, 7.6293945E-6f, 9.07293E-6f, 1.0789593E-5f, 1.2831061E-5f, 1.5258789E-5f, 1.814586E-5f, 2.1579186E-5f, 2.5662122E-5f, 3.0517578E-5f, 3.629172E-5f, 4.3158372E-5f, 5.1324245E-5f, 6.1035156E-5f, 7.258344E-5f, 8.6316744E-5f, 1.0264849E-4f, 1.2207031E-4f, 1.4516688E-4f, 1.7263349E-4f, 2.0529698E-4f, 2.4414062E-4f, 2.9033376E-4f, 3.4526698E-4f, 4.1059396E-4f, 4.8828125E-4f, 5.806675E-4f, 6.9053395E-4f, 8.211879E-4f, 9.765625E-4f, 0.001161335f, 0.0013810679f, 0.0016423758f, 0.001953125f, 0.00232267f, 0.0027621358f, 0.0032847517f, 0.00390625f, 0.00464534f, 0.0055242716f, 0.0065695033f, 0.0078125f, 0.00929068f, 0.011048543f, 0.013139007f, 0.015625f, 0.01858136f, 0.022097087f, 0.026278013f, 0.03125f, 0.03716272f, 0.044194173f, 0.052556027f, 0.0625f, 0.07432544f, 0.088388346f, 0.10511205f, 0.125f, 0.14865088f, 0.17677669f, 0.2102241f, 0.25f, 0.29730177f, 0.35355338f, 0.4204482f, 0.5f, 0.59460354f, 0.70710677f, 0.8408964f, 1.0f};
    private static final float[] TAN12 = new float[]{0.0f, 0.2679492f, 0.57735026f, 1.0f, 1.7320508f, 3.732051f, 1.0E11f, -3.732051f, -1.7320508f, -1.0f, -0.57735026f, -0.2679492f, 0.0f, 0.2679492f, 0.57735026f, 1.0f};
    private static final float[][] win = new float[][]{{-0.016141215f, -0.05360318f, -0.100707136f, -0.16280818f, -0.5f, -0.38388735f, -0.6206114f, -1.1659756f, -3.8720753f, -4.225629f, -1.519529f, -0.97416484f, -0.73744076f, -1.2071068f, -0.5163616f, -0.45426053f, -0.40715656f, -0.3696946f, -0.3387627f, -0.31242222f, -0.28939587f, -0.26880082f, -0.5f, -0.23251417f, -0.21596715f, -0.20004979f, -0.18449493f, -0.16905846f, -0.15350361f, -0.13758625f, -0.12103922f, -0.20710678f, -0.084752575f, -0.06415752f, -0.041131172f, -0.014790705f}, {-0.016141215f, -0.05360318f, -0.100707136f, -0.16280818f, -0.5f, -0.38388735f, -0.6206114f, -1.1659756f, -3.8720753f, -4.225629f, -1.519529f, -0.97416484f, -0.73744076f, -1.2071068f, -0.5163616f, -0.45426053f, -0.40715656f, -0.3696946f, -0.33908543f, -0.3151181f, -0.29642227f, -0.28184548f, -0.5411961f, -0.2621323f, -0.25387916f, -0.2329629f, -0.19852729f, -0.15233535f, -0.0964964f, -0.03342383f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.0483008f, -0.15715657f, -0.28325045f, -0.42953748f, -1.2071068f, -0.8242648f, -1.1451749f, -1.769529f, -4.5470223f, -3.489053f, -0.7329629f, -0.15076515f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.15076514f, -0.7329629f, -3.489053f, -4.5470223f, -1.769529f, -1.1451749f, -0.8313774f, -1.306563f, -0.54142016f, -0.46528974f, -0.4106699f, -0.3700468f, -0.3387627f, -0.31242222f, -0.28939587f, -0.26880082f, -0.5f, -0.23251417f, -0.21596715f, -0.20004979f, -0.18449493f, -0.16905846f, -0.15350361f, -0.13758625f, -0.12103922f, -0.20710678f, -0.084752575f, -0.06415752f, -0.041131172f, -0.014790705f}};
    private static final int SSLIMIT = 18;
    private static final int SBLIMIT = 32;
    static final byte[] slen0 = new byte[]{0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4};
    static final byte[] slen1 = new byte[]{0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3};
    private static final HuffmanTables.Huffman huff = new HuffmanTables.Huffman();
    private static final int[] is_pos = new int[576];
    private static final float[] is_ratio = new float[576];
    private static final float[] tsOutCopy = new float[18];
    private static final float[] rawout = new float[36];
    private static final int[] is_1d = new int[580];
    private static final float[][][] ro = new float[2][32][18];
    private static final float[][][] lr = new float[2][32][18];
    private static final float[] out_1d = new float[576];
    private static final float[][] prevblck = new float[2][576];
    private static final float[][] k = new float[2][576];
    private static int nonzero0;
    private static int nonzero1;
    private static BitStream stream;
    private static Header header;
    private static SynthesisFilter filter;
    private static SampleBuffer buff;
    private static int which_channels;
    private static BitReserve br;
    private static SideInfo si;
    public static int[] scalefac0L;
    public static int[][] scalefac0S;
    public static int[] scalefac1L;
    public static int[][] scalefac1S;
    private static int max_gr;
    private static int frame_start;
    private static int part2_start;
    private static int channels;
    private static int first_channel;
    private static int last_channel;
    private static int sfreq;
    private static final float[] samples1;
    private static final float[] samples2;
    private static int[] sfBandIndexL;
    private static int[] sfBandIndexS;
    private static HuffmanTables h;
    public HuffmanTables[] ht = new HuffmanTables[]{new HuffmanTables('0', ' ', ' ', 0, 0, 0, 0, -1, 0, 0), new HuffmanTables('1', ' ', ' ', 2, 2, 0, 0, -1, 1, 7), new HuffmanTables('2', ' ', ' ', 3, 3, 0, 0, -1, 2, 17), new HuffmanTables('3', ' ', ' ', 3, 3, 0, 0, -1, 3, 17), new HuffmanTables('4', ' ', ' ', 0, 0, 0, 0, -1, 4, 0), new HuffmanTables('5', ' ', ' ', 4, 4, 0, 0, -1, 5, 31), new HuffmanTables('6', ' ', ' ', 4, 4, 0, 0, -1, 6, 31), new HuffmanTables('7', ' ', ' ', 6, 6, 0, 0, -1, 7, 71), new HuffmanTables('8', ' ', ' ', 6, 6, 0, 0, -1, 8, 71), new HuffmanTables('9', ' ', ' ', 6, 6, 0, 0, -1, 9, 71), new HuffmanTables('1', '0', ' ', 8, 8, 0, 0, -1, 10, 127), new HuffmanTables('1', '1', ' ', 8, 8, 0, 0, -1, 11, 127), new HuffmanTables('1', '2', ' ', 8, 8, 0, 0, -1, 12, 127), new HuffmanTables('1', '3', ' ', 16, 16, 0, 0, -1, 13, 511), new HuffmanTables('1', '4', ' ', 0, 0, 0, 0, -1, 14, 0), new HuffmanTables('1', '5', ' ', 16, 16, 0, 0, -1, 15, 511), new HuffmanTables('1', '6', ' ', 16, 16, 1, 1, -1, 16, 511), new HuffmanTables('1', '7', ' ', 16, 16, 2, 3, 16, 16, 511), new HuffmanTables('1', '8', ' ', 16, 16, 3, 7, 16, 16, 511), new HuffmanTables('1', '9', ' ', 16, 16, 4, 15, 16, 16, 11), new HuffmanTables('2', '0', ' ', 16, 16, 6, 63, 16, 16, 511), new HuffmanTables('2', '1', ' ', 16, 16, 8, 255, 16, 16, 511), new HuffmanTables('2', '2', ' ', 16, 16, 10, 1023, 16, 16, 511), new HuffmanTables('2', '3', ' ', 16, 16, 13, 8191, 16, 16, 511), new HuffmanTables('2', '4', ' ', 16, 16, 4, 15, -1, 17, 512), new HuffmanTables('2', '5', ' ', 16, 16, 5, 31, 24, 17, 512), new HuffmanTables('2', '6', ' ', 16, 16, 6, 63, 24, 17, 512), new HuffmanTables('2', '7', ' ', 16, 16, 7, 127, 24, 17, 512), new HuffmanTables('2', '8', ' ', 16, 16, 8, 255, 24, 17, 512), new HuffmanTables('2', '9', ' ', 16, 16, 9, 511, 24, 17, 512), new HuffmanTables('3', '0', ' ', 16, 16, 11, 2047, 24, 17, 512), new HuffmanTables('3', '1', ' ', 16, 16, 13, 8191, 24, 17, 512), new HuffmanTables('3', '2', ' ', 1, 16, 0, 0, -1, 18, 31), new HuffmanTables('3', '3', ' ', 1, 16, 0, 0, -1, 19, 31)};
    public byte[] huffmantables = null;
    public byte[] reorder_table = null;
    static float tmpf_0;
    static float tmpf_1;
    static float tmpf_2;
    static float tmpf_3;
    static float tmpf_4;
    static float tmpf_5;
    static float tmpf_6;
    static float tmpf_7;
    static float tmpf_8;
    static float tmpf_9;
    static float tmpf_10;
    static float tmpf_11;
    static float tmpf_12;
    static float tmpf_13;
    static float tmpf_14;
    static float tmpf_15;
    static float tmpf_16;
    static float tmpf_17;
    static float e;
    static float o;
    float tmp0;
    float tmp1;
    float tmp2;
    float tmp3;
    float tmp4;
    float tmp0_;
    float tmp1_;
    float tmp2_;
    float tmp3_;
    float tmp0o;
    float tmp1o;
    float tmp2o;
    float tmp3o;
    float tmp4o;
    float tmp0_o;
    float tmp1_o;
    float tmp2_o;
    float tmp3_o;
    static int six_i;
    static int curr0;
    static int curr1;
    static int curr2;
    static int curr3;
    static int curr4;
    static float i00;
    static float iip12;
    static float save;
    static float i66_;
    static float i0;
    static float i0p12;
    static float i6_;
    float pp1;
    float pp2;
    float sum;
    static int window;
    static int scale_comp;
    static int length0;
    static int length1;
    static int cb;
    static int next_cb_boundary;
    static int cb_begin;
    static int cb_width;
    static int t_index;
    static int j;
    static int idx;
    static float g_gain;
    static int freq;
    static int freq3;
    static int src_line;
    static int des_line;
    static int sfb_start;
    static int sfb_start3;
    static int sfb_lines;
    static int reste;
    static int quotien;
    static int sb;
    static int i;
    static int sfb;
    static int lines;
    static int temp;
    static int temp2;
    static int mode_ext;
    static int io_type;
    private static final float[] cs;
    private static final float[] ca;
    static int ss;
    static int sb18lim;
    static int src_idx1;
    static int src_idx2;
    static float bu;
    static float bd;
    static float cat;
    static float cst;
    static int sbt;
    static int sb18;
    static int bt;
    static int cc;
    static int nSlots;
    static int flush_main;
    static int gr;
    static int ch;
    static int main_data_end;
    static int bytes_to_discard;
    static int dvp;
    static int pos;
    static int channels2;
    static float ftemp;

    public LayerIIIDecoder(BitStream bitStream, Header header, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2, SampleBuffer sampleBuffer, int n) {
        int n2;
        stream = bitStream;
        LayerIIIDecoder.header = header;
        filter = synthesisFilter;
        buff = sampleBuffer;
        which_channels = n;
        frame_start = 0;
        channels = LayerIIIDecoder.header.mode() == 3 ? 1 : 2;
        max_gr = LayerIIIDecoder.header.version() == 1 ? 2 : 1;
        sfreq = LayerIIIDecoder.header.sample_frequency() + (LayerIIIDecoder.header.version() == 1 ? 3 : 0);
        switch (sfreq) {
            case 0: {
                sfBandIndexL = new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 18, 24, 32, 42, 56, 74, 100, 132, 174, 192};
                break;
            }
            case 1: {
                sfBandIndexL = new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 114, 136, 162, 194, 232, 278, 330, 394, 464, 540, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 136, 180, 192};
                break;
            }
            case 2: {
                sfBandIndexL = new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 134, 174, 192};
                break;
            }
            case 3: {
                sfBandIndexL = new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90, 110, 134, 162, 196, 238, 288, 342, 418, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 16, 22, 30, 40, 52, 66, 84, 106, 136, 192};
                break;
            }
            case 4: {
                sfBandIndexL = new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128, 156, 190, 230, 276, 330, 384, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 16, 22, 28, 38, 50, 64, 80, 100, 126, 192};
                break;
            }
            case 5: {
                sfBandIndexL = new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156, 194, 240, 296, 364, 448, 550, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 16, 22, 30, 42, 58, 78, 104, 138, 180, 192};
            }
        }
        if (channels == 2) {
            switch (which_channels) {
                case 1: 
                case 3: {
                    last_channel = 0;
                    first_channel = 0;
                    break;
                }
                case 2: {
                    last_channel = 1;
                    first_channel = 1;
                    break;
                }
                default: {
                    first_channel = 0;
                    last_channel = 1;
                    break;
                }
            }
        } else {
            last_channel = 0;
            first_channel = 0;
        }
        for (int i = 0; i < 2; ++i) {
            for (n2 = 0; n2 < 576; ++n2) {
                LayerIIIDecoder.prevblck[i][n2] = 0.0f;
            }
        }
        nonzero1 = 576;
        nonzero0 = 576;
        br = new BitReserve();
        br.reset();
        si = new SideInfo();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/HUFFMAN.TAB");
            this.huffmantables = new byte[inputStream.available()];
            inputStream.read(this.huffmantables);
            inputStream.close();
            inputStream = this.getClass().getResourceAsStream("/REORDER.TAB");
            this.reorder_table = new byte[inputStream.available()];
            inputStream.read(this.reorder_table);
            inputStream.close();
        }
        catch (Exception exception) {
            return;
        }
        for (int i = 0; i < this.ht.length; ++i) {
            n2 = this.ht[i].off << 1;
            this.ht[i].off = this.huffmantables[n2] & 0xFF | (this.huffmantables[n2 + 1] & 0xFF) << 8;
        }
    }

    public void invMDCT(float[] fArray, float[] fArray2, int n) {
        if (n == 2) {
            for (i = 0; i < 36; ++i) {
                fArray2[LayerIIIDecoder.i] = 0.0f;
            }
            six_i = 0;
            for (i = 0; i < 3; ++i) {
                curr0 = 15 + i;
                curr1 = 12 + i;
                curr2 = 9 + i;
                curr3 = 6 + i;
                curr4 = 3 + i;
                int n2 = curr0;
                fArray[n2] = fArray[n2] + fArray[curr1];
                int n3 = curr1;
                fArray[n3] = fArray[n3] + fArray[curr2];
                int n4 = curr2;
                fArray[n4] = fArray[n4] + fArray[curr3];
                int n5 = curr3;
                fArray[n5] = fArray[n5] + fArray[curr4];
                int n6 = curr4;
                fArray[n6] = fArray[n6] + fArray[i];
                int n7 = curr0;
                fArray[n7] = fArray[n7] + fArray[curr2];
                int n8 = curr2;
                fArray[n8] = fArray[n8] + fArray[curr4];
                this.pp2 = fArray[curr1] * 0.5f;
                this.pp1 = fArray[curr3] * 0.8660254f;
                this.sum = fArray[i] + this.pp2;
                tmpf_1 = fArray[i] - fArray[curr1];
                tmpf_0 = this.sum + this.pp1;
                tmpf_2 = this.sum - this.pp1;
                this.pp2 = fArray[curr0] * 0.5f;
                this.pp1 = fArray[curr2] * 0.8660254f;
                this.sum = fArray[curr4] + this.pp2;
                tmpf_4 = fArray[curr4] - fArray[curr0];
                tmpf_5 = this.sum + this.pp1;
                tmpf_3 = this.sum - this.pp1;
                tmpf_3 *= 1.9318516f;
                save = tmpf_0;
                tmpf_0 += (tmpf_5 *= 0.5176381f);
                tmpf_5 = save - tmpf_5;
                save = tmpf_1;
                tmpf_1 += (tmpf_4 *= 0.70710677f);
                tmpf_4 = save - tmpf_4;
                save = tmpf_2;
                tmpf_2 += tmpf_3;
                tmpf_3 = save - tmpf_3;
                tmpf_0 *= 0.5043145f;
                tmpf_1 *= 0.5411961f;
                tmpf_2 *= 0.6302362f;
                tmpf_3 *= 0.8213398f;
                tmpf_4 *= 1.306563f;
                tmpf_5 *= 3.830649f;
                tmpf_8 = -tmpf_0 * 0.7933533f;
                tmpf_9 = -tmpf_0 * 0.6087614f;
                tmpf_7 = -tmpf_1 * 0.9238795f;
                tmpf_10 = -tmpf_1 * 0.38268343f;
                tmpf_6 = -tmpf_2 * 0.9914449f;
                tmpf_11 = -tmpf_2 * 0.13052619f;
                tmpf_0 = tmpf_3;
                tmpf_1 = tmpf_4 * 0.38268343f;
                tmpf_2 = tmpf_5 * 0.6087614f;
                tmpf_3 = -tmpf_5 * 0.7933533f;
                tmpf_4 = -tmpf_4 * 0.9238795f;
                tmpf_5 = -tmpf_0 * 0.9914449f;
                int n9 = six_i + 6;
                fArray2[n9] = fArray2[n9] + (tmpf_0 *= 0.13052619f);
                int n10 = six_i + 7;
                fArray2[n10] = fArray2[n10] + tmpf_1;
                int n11 = six_i + 8;
                fArray2[n11] = fArray2[n11] + tmpf_2;
                int n12 = six_i + 9;
                fArray2[n12] = fArray2[n12] + tmpf_3;
                int n13 = six_i + 10;
                fArray2[n13] = fArray2[n13] + tmpf_4;
                int n14 = six_i + 11;
                fArray2[n14] = fArray2[n14] + tmpf_5;
                int n15 = six_i + 12;
                fArray2[n15] = fArray2[n15] + tmpf_6;
                int n16 = six_i + 13;
                fArray2[n16] = fArray2[n16] + tmpf_7;
                int n17 = six_i + 14;
                fArray2[n17] = fArray2[n17] + tmpf_8;
                int n18 = six_i + 15;
                fArray2[n18] = fArray2[n18] + tmpf_9;
                int n19 = six_i + 16;
                fArray2[n19] = fArray2[n19] + tmpf_10;
                int n20 = six_i + 17;
                fArray2[n20] = fArray2[n20] + tmpf_11;
                six_i += 6;
            }
        } else {
            fArray[17] = fArray[17] + fArray[16];
            fArray[16] = fArray[16] + fArray[15];
            fArray[15] = fArray[15] + fArray[14];
            fArray[14] = fArray[14] + fArray[13];
            fArray[13] = fArray[13] + fArray[12];
            fArray[12] = fArray[12] + fArray[11];
            fArray[11] = fArray[11] + fArray[10];
            fArray[10] = fArray[10] + fArray[9];
            fArray[9] = fArray[9] + fArray[8];
            fArray[8] = fArray[8] + fArray[7];
            fArray[7] = fArray[7] + fArray[6];
            fArray[6] = fArray[6] + fArray[5];
            fArray[5] = fArray[5] + fArray[4];
            fArray[4] = fArray[4] + fArray[3];
            fArray[3] = fArray[3] + fArray[2];
            fArray[2] = fArray[2] + fArray[1];
            fArray[1] = fArray[1] + fArray[0];
            fArray[17] = fArray[17] + fArray[15];
            fArray[15] = fArray[15] + fArray[13];
            fArray[13] = fArray[13] + fArray[11];
            fArray[11] = fArray[11] + fArray[9];
            fArray[9] = fArray[9] + fArray[7];
            fArray[7] = fArray[7] + fArray[5];
            fArray[5] = fArray[5] + fArray[3];
            fArray[3] = fArray[3] + fArray[1];
            i00 = fArray[0] + fArray[0];
            iip12 = i00 + fArray[12];
            this.tmp0 = iip12 + fArray[4] * 1.8793852f + fArray[8] * 1.5320889f + fArray[16] * 0.34729636f;
            this.tmp1 = i00 + fArray[4] - fArray[8] - fArray[12] - fArray[12] - fArray[16];
            this.tmp2 = iip12 - fArray[4] * 0.34729636f - fArray[8] * 1.8793852f + fArray[16] * 1.5320889f;
            this.tmp3 = iip12 - fArray[4] * 1.5320889f + fArray[8] * 0.34729636f - fArray[16] * 1.8793852f;
            this.tmp4 = fArray[0] - fArray[4] + fArray[8] - fArray[12] + fArray[16];
            i66_ = fArray[6] * 1.7320508f;
            this.tmp0_ = fArray[2] * 1.9696155f + i66_ + fArray[10] * 1.2855753f + fArray[14] * 0.6840403f;
            this.tmp1_ = (fArray[2] - fArray[10] - fArray[14]) * 1.7320508f;
            this.tmp2_ = fArray[2] * 1.2855753f - i66_ - fArray[10] * 0.6840403f + fArray[14] * 1.9696155f;
            this.tmp3_ = fArray[2] * 0.6840403f - i66_ + fArray[10] * 1.9696155f - fArray[14] * 1.2855753f;
            i0 = fArray[1] + fArray[1];
            i0p12 = i0 + fArray[13];
            this.tmp0o = i0p12 + fArray[5] * 1.8793852f + fArray[9] * 1.5320889f + fArray[17] * 0.34729636f;
            this.tmp1o = i0 + fArray[5] - fArray[9] - fArray[13] - fArray[13] - fArray[17];
            this.tmp2o = i0p12 - fArray[5] * 0.34729636f - fArray[9] * 1.8793852f + fArray[17] * 1.5320889f;
            this.tmp3o = i0p12 - fArray[5] * 1.5320889f + fArray[9] * 0.34729636f - fArray[17] * 1.8793852f;
            this.tmp4o = (fArray[1] - fArray[5] + fArray[9] - fArray[13] + fArray[17]) * 0.70710677f;
            i6_ = fArray[7] * 1.7320508f;
            this.tmp0_o = fArray[3] * 1.9696155f + i6_ + fArray[11] * 1.2855753f + fArray[15] * 0.6840403f;
            this.tmp1_o = (fArray[3] - fArray[11] - fArray[15]) * 1.7320508f;
            this.tmp2_o = fArray[3] * 1.2855753f - i6_ - fArray[11] * 0.6840403f + fArray[15] * 1.9696155f;
            this.tmp3_o = fArray[3] * 0.6840403f - i6_ + fArray[11] * 1.9696155f - fArray[15] * 1.2855753f;
            e = this.tmp0 + this.tmp0_;
            o = (this.tmp0o + this.tmp0_o) * 0.5019099f;
            tmpf_0 = e + o;
            tmpf_17 = e - o;
            e = this.tmp1 + this.tmp1_;
            o = (this.tmp1o + this.tmp1_o) * 0.5176381f;
            tmpf_1 = e + o;
            tmpf_16 = e - o;
            e = this.tmp2 + this.tmp2_;
            o = (this.tmp2o + this.tmp2_o) * 0.55168897f;
            tmpf_2 = e + o;
            tmpf_15 = e - o;
            e = this.tmp3 + this.tmp3_;
            o = (this.tmp3o + this.tmp3_o) * 0.61038727f;
            tmpf_3 = e + o;
            tmpf_14 = e - o;
            tmpf_4 = this.tmp4 + this.tmp4o;
            tmpf_13 = this.tmp4 - this.tmp4o;
            e = this.tmp3 - this.tmp3_;
            o = (this.tmp3o - this.tmp3_o) * 0.8717234f;
            tmpf_5 = e + o;
            tmpf_12 = e - o;
            e = this.tmp2 - this.tmp2_;
            o = (this.tmp2o - this.tmp2_o) * 1.1831008f;
            tmpf_6 = e + o;
            tmpf_11 = e - o;
            e = this.tmp1 - this.tmp1_;
            o = (this.tmp1o - this.tmp1_o) * 1.9318516f;
            tmpf_7 = e + o;
            tmpf_10 = e - o;
            e = this.tmp0 - this.tmp0_;
            o = (this.tmp0o - this.tmp0_o) * 5.7368565f;
            tmpf_8 = e + o;
            tmpf_9 = e - o;
            float[] fArray3 = win[n];
            fArray2[0] = -tmpf_9 * fArray3[0];
            fArray2[1] = -tmpf_10 * fArray3[1];
            fArray2[2] = -tmpf_11 * fArray3[2];
            fArray2[3] = -tmpf_12 * fArray3[3];
            fArray2[4] = -tmpf_13 * fArray3[4];
            fArray2[5] = -tmpf_14 * fArray3[5];
            fArray2[6] = -tmpf_15 * fArray3[6];
            fArray2[7] = -tmpf_16 * fArray3[7];
            fArray2[8] = -tmpf_17 * fArray3[8];
            fArray2[9] = tmpf_17 * fArray3[9];
            fArray2[10] = tmpf_16 * fArray3[10];
            fArray2[11] = tmpf_15 * fArray3[11];
            fArray2[12] = tmpf_14 * fArray3[12];
            fArray2[13] = tmpf_13 * fArray3[13];
            fArray2[14] = tmpf_12 * fArray3[14];
            fArray2[15] = tmpf_11 * fArray3[15];
            fArray2[16] = tmpf_10 * fArray3[16];
            fArray2[17] = tmpf_9 * fArray3[17];
            fArray2[18] = tmpf_8 * fArray3[18];
            fArray2[19] = tmpf_7 * fArray3[19];
            fArray2[20] = tmpf_6 * fArray3[20];
            fArray2[21] = tmpf_5 * fArray3[21];
            fArray2[22] = tmpf_4 * fArray3[22];
            fArray2[23] = tmpf_3 * fArray3[23];
            fArray2[24] = tmpf_2 * fArray3[24];
            fArray2[25] = tmpf_1 * fArray3[25];
            fArray2[26] = tmpf_0 * fArray3[26];
            fArray2[27] = tmpf_0 * fArray3[27];
            fArray2[28] = tmpf_1 * fArray3[28];
            fArray2[29] = tmpf_2 * fArray3[29];
            fArray2[30] = tmpf_3 * fArray3[30];
            fArray2[31] = tmpf_4 * fArray3[31];
            fArray2[32] = tmpf_5 * fArray3[32];
            fArray2[33] = tmpf_6 * fArray3[33];
            fArray2[34] = tmpf_7 * fArray3[34];
            fArray2[35] = tmpf_8 * fArray3[35];
        }
    }

    private final boolean get_side_info() {
        if (header.version() == 1) {
            Object object;
            int n;
            LayerIIIDecoder.si.main_data_begin = stream.readbits(9);
            LayerIIIDecoder.si.private_bits = channels == 1 ? stream.readbits(5) : stream.readbits(3);
            for (n = 0; n < channels; ++n) {
                object = LayerIIIDecoder.si.ch[n];
                ((Channel)object).scfsi[0] = stream.readbits(1);
                ((Channel)object).scfsi[1] = stream.readbits(1);
                ((Channel)object).scfsi[2] = stream.readbits(1);
                ((Channel)object).scfsi[3] = stream.readbits(1);
            }
            for (int i = 0; i < 2; ++i) {
                for (n = 0; n < channels; ++n) {
                    object = LayerIIIDecoder.si.ch[n].gr[i];
                    ((GRInfo)object).part2_3_length = stream.readbits(12);
                    ((GRInfo)object).big_values = stream.readbits(9);
                    ((GRInfo)object).global_gain = stream.readbits(8);
                    ((GRInfo)object).scalefac_compress = stream.readbits(4);
                    ((GRInfo)object).window_switching_flag = stream.readbits(1);
                    if (((GRInfo)object).window_switching_flag != 0) {
                        ((GRInfo)object).block_type = stream.readbits(2);
                        ((GRInfo)object).mixed_block_flag = stream.readbits(1);
                        ((GRInfo)object).table_select[0] = stream.readbits(5);
                        ((GRInfo)object).table_select[1] = stream.readbits(5);
                        ((GRInfo)object).subblock_gain[0] = stream.readbits(3);
                        ((GRInfo)object).subblock_gain[1] = stream.readbits(3);
                        ((GRInfo)object).subblock_gain[2] = stream.readbits(3);
                        if (((GRInfo)object).block_type == 0) {
                            return false;
                        }
                        ((GRInfo)object).region0_count = ((GRInfo)object).block_type == 2 && ((GRInfo)object).mixed_block_flag == 0 ? 8 : 7;
                        ((GRInfo)object).region1_count = 20 - ((GRInfo)object).region0_count;
                    } else {
                        ((GRInfo)object).table_select[0] = stream.readbits(5);
                        ((GRInfo)object).table_select[1] = stream.readbits(5);
                        ((GRInfo)object).table_select[2] = stream.readbits(5);
                        ((GRInfo)object).region0_count = stream.readbits(4);
                        ((GRInfo)object).region1_count = stream.readbits(3);
                        ((GRInfo)object).block_type = 0;
                    }
                    ((GRInfo)object).preflag = stream.readbits(1);
                    ((GRInfo)object).scalefac_scale = stream.readbits(1);
                    ((GRInfo)object).count1table_select = stream.readbits(1);
                }
            }
        } else {
            LayerIIIDecoder.si.main_data_begin = stream.readbits(8);
            LayerIIIDecoder.si.private_bits = channels == 1 ? stream.readbits(1) : stream.readbits(2);
            for (int i = 0; i < channels; ++i) {
                GRInfo gRInfo = LayerIIIDecoder.si.ch[i].gr[0];
                gRInfo.part2_3_length = stream.readbits(12);
                gRInfo.big_values = stream.readbits(9);
                gRInfo.global_gain = stream.readbits(8);
                gRInfo.scalefac_compress = stream.readbits(9);
                gRInfo.window_switching_flag = stream.readbits(1);
                if (gRInfo.window_switching_flag != 0) {
                    gRInfo.block_type = stream.readbits(2);
                    gRInfo.mixed_block_flag = stream.readbits(1);
                    gRInfo.table_select[0] = stream.readbits(5);
                    gRInfo.table_select[1] = stream.readbits(5);
                    gRInfo.subblock_gain[0] = stream.readbits(3);
                    gRInfo.subblock_gain[1] = stream.readbits(3);
                    gRInfo.subblock_gain[2] = stream.readbits(3);
                    if (gRInfo.block_type == 0) {
                        return false;
                    }
                    if (gRInfo.block_type == 2 && gRInfo.mixed_block_flag == 0) {
                        gRInfo.region0_count = 8;
                    } else {
                        gRInfo.region0_count = 7;
                        gRInfo.region1_count = 20 - gRInfo.region0_count;
                    }
                } else {
                    gRInfo.table_select[0] = stream.readbits(5);
                    gRInfo.table_select[1] = stream.readbits(5);
                    gRInfo.table_select[2] = stream.readbits(5);
                    gRInfo.region0_count = stream.readbits(4);
                    gRInfo.region1_count = stream.readbits(3);
                    gRInfo.block_type = 0;
                }
                gRInfo.scalefac_scale = stream.readbits(1);
                gRInfo.count1table_select = stream.readbits(1);
            }
        }
        return true;
    }

    private final void get_scale_factors(int n, int n2) {
        GRInfo gRInfo = LayerIIIDecoder.si.ch[n].gr[n2];
        scale_comp = gRInfo.scalefac_compress;
        length0 = slen0[scale_comp];
        length1 = slen1[scale_comp];
        int[] nArray = null;
        int[][] nArray2 = null;
        if (n == 0) {
            nArray = scalefac0L;
            nArray2 = scalefac0S;
        } else {
            nArray = scalefac1L;
            nArray2 = scalefac1S;
        }
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
            if (gRInfo.mixed_block_flag != 0) {
                for (sfb = 0; sfb < 8; ++sfb) {
                    nArray[LayerIIIDecoder.sfb] = br.hgetbits(slen0[gRInfo.scalefac_compress]);
                }
                for (sfb = 3; sfb < 6; ++sfb) {
                    for (window = 0; window < 3; ++window) {
                        nArray2[LayerIIIDecoder.window][LayerIIIDecoder.sfb] = br.hgetbits(slen0[gRInfo.scalefac_compress]);
                    }
                }
                for (sfb = 6; sfb < 12; ++sfb) {
                    for (window = 0; window < 3; ++window) {
                        nArray2[LayerIIIDecoder.window][LayerIIIDecoder.sfb] = br.hgetbits(slen1[gRInfo.scalefac_compress]);
                    }
                }
                sfb = 12;
                for (window = 0; window < 3; ++window) {
                    nArray2[LayerIIIDecoder.window][LayerIIIDecoder.sfb] = 0;
                }
            } else {
                nArray2[0][0] = br.hgetbits(length0);
                nArray2[1][0] = br.hgetbits(length0);
                nArray2[2][0] = br.hgetbits(length0);
                nArray2[0][1] = br.hgetbits(length0);
                nArray2[1][1] = br.hgetbits(length0);
                nArray2[2][1] = br.hgetbits(length0);
                nArray2[0][2] = br.hgetbits(length0);
                nArray2[1][2] = br.hgetbits(length0);
                nArray2[2][2] = br.hgetbits(length0);
                nArray2[0][3] = br.hgetbits(length0);
                nArray2[1][3] = br.hgetbits(length0);
                nArray2[2][3] = br.hgetbits(length0);
                nArray2[0][4] = br.hgetbits(length0);
                nArray2[1][4] = br.hgetbits(length0);
                nArray2[2][4] = br.hgetbits(length0);
                nArray2[0][5] = br.hgetbits(length0);
                nArray2[1][5] = br.hgetbits(length0);
                nArray2[2][5] = br.hgetbits(length0);
                nArray2[0][6] = br.hgetbits(length1);
                nArray2[1][6] = br.hgetbits(length1);
                nArray2[2][6] = br.hgetbits(length1);
                nArray2[0][7] = br.hgetbits(length1);
                nArray2[1][7] = br.hgetbits(length1);
                nArray2[2][7] = br.hgetbits(length1);
                nArray2[0][8] = br.hgetbits(length1);
                nArray2[1][8] = br.hgetbits(length1);
                nArray2[2][8] = br.hgetbits(length1);
                nArray2[0][9] = br.hgetbits(length1);
                nArray2[1][9] = br.hgetbits(length1);
                nArray2[2][9] = br.hgetbits(length1);
                nArray2[0][10] = br.hgetbits(length1);
                nArray2[1][10] = br.hgetbits(length1);
                nArray2[2][10] = br.hgetbits(length1);
                nArray2[0][11] = br.hgetbits(length1);
                nArray2[1][11] = br.hgetbits(length1);
                nArray2[2][11] = br.hgetbits(length1);
                nArray2[2][12] = 0;
                nArray2[1][12] = 0;
                nArray2[0][12] = 0;
            }
        } else {
            int[] nArray3 = LayerIIIDecoder.si.ch[n].scfsi;
            if (n2 == 0) {
                nArray[0] = br.hgetbits(length0);
                nArray[1] = br.hgetbits(length0);
                nArray[2] = br.hgetbits(length0);
                nArray[3] = br.hgetbits(length0);
                nArray[4] = br.hgetbits(length0);
                nArray[5] = br.hgetbits(length0);
                nArray[6] = br.hgetbits(length0);
                nArray[7] = br.hgetbits(length0);
                nArray[8] = br.hgetbits(length0);
                nArray[9] = br.hgetbits(length0);
                nArray[10] = br.hgetbits(length0);
                nArray[11] = br.hgetbits(length1);
                nArray[12] = br.hgetbits(length1);
                nArray[13] = br.hgetbits(length1);
                nArray[14] = br.hgetbits(length1);
                nArray[15] = br.hgetbits(length1);
                nArray[16] = br.hgetbits(length1);
                nArray[17] = br.hgetbits(length1);
                nArray[18] = br.hgetbits(length1);
                nArray[19] = br.hgetbits(length1);
                nArray[20] = br.hgetbits(length1);
            } else {
                if (nArray3[0] == 0) {
                    nArray[0] = br.hgetbits(length0);
                    nArray[1] = br.hgetbits(length0);
                    nArray[2] = br.hgetbits(length0);
                    nArray[3] = br.hgetbits(length0);
                    nArray[4] = br.hgetbits(length0);
                    nArray[5] = br.hgetbits(length0);
                }
                if (nArray3[1] == 0) {
                    nArray[6] = br.hgetbits(length0);
                    nArray[7] = br.hgetbits(length0);
                    nArray[8] = br.hgetbits(length0);
                    nArray[9] = br.hgetbits(length0);
                    nArray[10] = br.hgetbits(length0);
                }
                if (nArray3[2] == 0) {
                    nArray[11] = br.hgetbits(length1);
                    nArray[12] = br.hgetbits(length1);
                    nArray[13] = br.hgetbits(length1);
                    nArray[14] = br.hgetbits(length1);
                    nArray[15] = br.hgetbits(length1);
                }
                if (nArray3[3] == 0) {
                    nArray[16] = br.hgetbits(length1);
                    nArray[17] = br.hgetbits(length1);
                    nArray[18] = br.hgetbits(length1);
                    nArray[19] = br.hgetbits(length1);
                    nArray[20] = br.hgetbits(length1);
                }
            }
            nArray[22] = 0;
            nArray[21] = 0;
        }
    }

    private final void huffman_decode(int n, int n2) {
        GRInfo gRInfo = LayerIIIDecoder.si.ch[n].gr[n2];
        int n3 = part2_start + gRInfo.part2_3_length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
            n5 = 36;
            n6 = 576;
        } else {
            int n7 = gRInfo.region0_count + 1;
            int n8 = n7 + gRInfo.region1_count + 1;
            if (n8 > sfBandIndexL.length - 1) {
                n8 = sfBandIndexL.length - 1;
            }
            n5 = sfBandIndexL[n7];
            n6 = sfBandIndexL[n8];
        }
        int n9 = 0;
        int n10 = gRInfo.big_values << 1;
        int n11 = is_1d.length;
        for (i = 0; i < n10 && i < n11; i += 2) {
            h = i < n5 ? this.ht[gRInfo.table_select[0]] : (i < n6 ? this.ht[gRInfo.table_select[1]] : this.ht[gRInfo.table_select[2]]);
            HuffmanTables.decode(this.huffmantables, h, huff, br);
            int n12 = n9++;
            LayerIIIDecoder.is_1d[n12] = HuffmanTables.Huffman.x;
            int n13 = n9++;
            LayerIIIDecoder.is_1d[n13] = HuffmanTables.Huffman.y;
        }
        h = this.ht[gRInfo.count1table_select + 32];
        n4 = BitReserve.totbit;
        while (n4 < n3 && n9 < 576) {
            HuffmanTables.decode(this.huffmantables, h, huff, br);
            int n14 = n9++;
            LayerIIIDecoder.is_1d[n14] = HuffmanTables.Huffman.v;
            int n15 = n9++;
            LayerIIIDecoder.is_1d[n15] = HuffmanTables.Huffman.w;
            int n16 = n9++;
            LayerIIIDecoder.is_1d[n16] = HuffmanTables.Huffman.x;
            int n17 = n9++;
            LayerIIIDecoder.is_1d[n17] = HuffmanTables.Huffman.y;
            n4 = BitReserve.totbit;
        }
        if (n4 > n3) {
            br.rewindNbits(n4 - n3);
            n9 -= 4;
        }
        if ((n4 = BitReserve.totbit) < n3) {
            br.hgetbits(n3 - n4);
        }
        if (n9 < 576) {
            if (n == 0) {
                nonzero0 = n9;
            } else {
                nonzero1 = n9;
            }
        } else if (n == 0) {
            nonzero0 = 576;
        } else {
            nonzero1 = 576;
        }
        if (n9 < 0) {
            n9 = 0;
        }
    }

    private final void dequantize_sample(float[][] fArray, int n, int n2) {
        int n3;
        GRInfo gRInfo = LayerIIIDecoder.si.ch[n].gr[n2];
        j = 0;
        t_index = 0;
        i = 0;
        cb_width = 0;
        cb_begin = 0;
        next_cb_boundary = 0;
        cb = 0;
        g_gain = 0.0f;
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
            if (gRInfo.mixed_block_flag != 0) {
                next_cb_boundary = sfBandIndexL[1];
            } else {
                cb_width = sfBandIndexS[1];
                next_cb_boundary = (cb_width << 2) - cb_width;
                cb_begin = 0;
            }
        } else {
            next_cb_boundary = sfBandIndexL[1];
        }
        g_gain = gRInfo.global_gain >= 138 && gRInfo.global_gain < 211 ? ggain[gRInfo.global_gain - 138] : (float)LayerIIIDecoder.pow(2.0, 0.25 * ((double)gRInfo.global_gain - 210.0));
        int n4 = n == 0 ? nonzero0 : nonzero1;
        for (j = 0; j < n4; ++j) {
            reste = j % 18;
            quotien = (j - reste) / 18;
            fArray[LayerIIIDecoder.quotien][LayerIIIDecoder.reste] = is_1d[j] == 0 ? 0.0f : ((n3 = is_1d[j]) > 0 ? g_gain * t_43[n3 > 255 ? 255 : n3] : -g_gain * t_43[n3 < -255 ? 255 : -n3]);
        }
        n3 = n == 0 ? nonzero0 : nonzero1;
        j = 0;
        while (j < n3) {
            int[] nArray;
            reste = j % 18;
            quotien = (j - reste) / 18;
            if (i == next_cb_boundary) {
                if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
                    if (gRInfo.mixed_block_flag != 0) {
                        if (i == sfBandIndexL[8]) {
                            next_cb_boundary = sfBandIndexS[4];
                            next_cb_boundary = (next_cb_boundary << 2) - next_cb_boundary;
                            cb = 3;
                            cb_width = sfBandIndexS[4] - sfBandIndexS[3];
                            cb_begin = sfBandIndexS[3];
                            cb_begin = (cb_begin << 2) - cb_begin;
                        } else if (i < sfBandIndexL[8]) {
                            next_cb_boundary = sfBandIndexL[++cb + 1];
                        } else {
                            next_cb_boundary = sfBandIndexS[++cb + 1];
                            next_cb_boundary = (next_cb_boundary << 2) - next_cb_boundary;
                            cb_begin = sfBandIndexS[cb];
                            cb_width = sfBandIndexS[cb + 1] - cb_begin;
                            cb_begin = (cb_begin << 2) - cb_begin;
                        }
                    } else {
                        next_cb_boundary = sfBandIndexS[++cb + 1];
                        next_cb_boundary = (next_cb_boundary << 2) - next_cb_boundary;
                        cb_begin = sfBandIndexS[cb];
                        cb_width = sfBandIndexS[cb + 1] - cb_begin;
                        cb_begin = (cb_begin << 2) - cb_begin;
                    }
                } else {
                    next_cb_boundary = sfBandIndexL[++cb + 1];
                }
            }
            int[][] nArray2 = n == 0 ? scalefac0S : scalefac1S;
            int[] nArray3 = nArray = n == 0 ? scalefac0L : scalefac1L;
            if (gRInfo.window_switching_flag != 0 && (gRInfo.block_type == 2 && gRInfo.mixed_block_flag == 0 || gRInfo.block_type == 2 && gRInfo.mixed_block_flag != 0 && j >= 36)) {
                t_index = (i - cb_begin) / cb_width;
                idx = nArray2[t_index][cb] << gRInfo.scalefac_scale;
                float[] fArray2 = fArray[quotien];
                int n5 = reste;
                fArray2[n5] = fArray2[n5] * two_to_negative_half_pow[idx += gRInfo.subblock_gain[t_index] << 2];
            } else {
                idx = nArray[cb];
                if (gRInfo.preflag != 0) {
                    idx += pretab[cb];
                }
                float[] fArray3 = fArray[quotien];
                int n6 = reste;
                fArray3[n6] = fArray3[n6] * two_to_negative_half_pow[idx <<= gRInfo.scalefac_scale];
            }
            ++j;
            ++i;
        }
    }

    private final void reorder(float[][] fArray, int n, int n2) {
        GRInfo gRInfo = LayerIIIDecoder.si.ch[n].gr[n2];
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
            if (gRInfo.mixed_block_flag != 0) {
                for (i = 0; i < 36; ++i) {
                    reste = i % 18;
                    quotien = (i - reste) / 18;
                    LayerIIIDecoder.out_1d[LayerIIIDecoder.i] = fArray[quotien][reste];
                }
                sfb = 3;
                sfb_start = sfBandIndexS[3];
                sfb_lines = sfBandIndexS[4] - sfb_start;
                while (sfb < 13) {
                    sfb_start3 = (sfb_start << 2) - sfb_start;
                    freq = 0;
                    freq3 = 0;
                    while (freq < sfb_lines) {
                        src_line = sfb_start3 + freq;
                        des_line = sfb_start3 + freq3;
                        reste = src_line % 18;
                        quotien = (src_line - reste) / 18;
                        LayerIIIDecoder.out_1d[LayerIIIDecoder.des_line] = fArray[quotien][reste];
                        reste = (src_line += sfb_lines) % 18;
                        quotien = (src_line - reste) / 18;
                        LayerIIIDecoder.out_1d[++LayerIIIDecoder.des_line] = fArray[quotien][reste];
                        reste = (src_line += sfb_lines) % 18;
                        quotien = (src_line - reste) / 18;
                        LayerIIIDecoder.out_1d[++LayerIIIDecoder.des_line] = fArray[quotien][reste];
                        ++freq;
                        freq3 += 3;
                    }
                    sfb_start = sfBandIndexS[++sfb];
                    sfb_lines = sfBandIndexS[sfb + 1] - sfb_start;
                }
            } else {
                i = 0;
                int n3 = sfreq * 1152;
                while (i < 576) {
                    j = this.reorder_table[n3++] & 0xFF | this.reorder_table[n3++] << 8;
                    reste = j % 18;
                    quotien = (j - reste) / 18;
                    LayerIIIDecoder.out_1d[LayerIIIDecoder.i++] = fArray[quotien][reste];
                }
            }
        } else {
            i = 0;
            while (i < 576) {
                reste = i % 18;
                quotien = (i - reste) / 18;
                LayerIIIDecoder.out_1d[LayerIIIDecoder.i++] = fArray[quotien][reste];
            }
        }
    }

    private final void stereo(int n) {
        if (channels == 1) {
            for (sb = 0; sb < 32; ++sb) {
                float[] fArray = lr[0][sb];
                float[] fArray2 = ro[0][sb];
                for (ss = 0; ss < 18; ss += 3) {
                    fArray[LayerIIIDecoder.ss] = fArray2[ss];
                    fArray[LayerIIIDecoder.ss + 1] = fArray2[ss + 1];
                    fArray[LayerIIIDecoder.ss + 2] = fArray2[ss + 2];
                }
            }
        } else {
            int n2;
            GRInfo gRInfo = LayerIIIDecoder.si.ch[0].gr[n];
            mode_ext = header.mode_extension();
            boolean bl = header.mode() == 1 && (mode_ext & 1) != 0;
            io_type = gRInfo.scalefac_compress & 1;
            for (n2 = 0; n2 < is_pos.length; ++n2) {
                LayerIIIDecoder.is_pos[n2] = 7;
            }
            if (bl) {
                if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
                    if (gRInfo.mixed_block_flag != 0) {
                        n2 = 0;
                        for (int i = 0; i < 3; ++i) {
                            int n3 = 2;
                            for (sfb = 12; sfb >= 3; --sfb) {
                                LayerIIIDecoder.i = sfBandIndexS[sfb];
                                lines = sfBandIndexS[sfb + 1] - LayerIIIDecoder.i;
                                LayerIIIDecoder.i = (LayerIIIDecoder.i << 2) - LayerIIIDecoder.i + (i + 1) * lines - 1;
                                while (lines > 0) {
                                    if (ro[1][LayerIIIDecoder.i / 18][LayerIIIDecoder.i % 18] != 0.0f) {
                                        n3 = sfb;
                                        sfb = -10;
                                        lines = -10;
                                    }
                                    --lines;
                                    --LayerIIIDecoder.i;
                                }
                            }
                            sfb = n3 + 1;
                            if (sfb > n2) {
                                n2 = sfb;
                            }
                            int[][] nArray = scalefac1S;
                            while (sfb < 12) {
                                temp = sfBandIndexS[sfb];
                                LayerIIIDecoder.i = (temp << 2) - temp + i * sb;
                                for (sb = sfBandIndexS[sfb + 1] - temp; sb > 0; --sb) {
                                    LayerIIIDecoder.is_pos[LayerIIIDecoder.i] = nArray[i][sfb];
                                    if (is_pos[LayerIIIDecoder.i] != 7) {
                                        LayerIIIDecoder.is_ratio[LayerIIIDecoder.i] = TAN12[is_pos[LayerIIIDecoder.i]];
                                    }
                                    ++LayerIIIDecoder.i;
                                }
                                ++sfb;
                            }
                            sfb = sfBandIndexS[10];
                            sb = sfBandIndexS[11] - sfb;
                            sfb = (sfb << 2) - sfb + i * sb;
                            temp = sfBandIndexS[11];
                            LayerIIIDecoder.i = (temp << 2) - temp + i * sb;
                            for (sb = sfBandIndexS[12] - temp; sb > 0; --sb) {
                                LayerIIIDecoder.is_pos[LayerIIIDecoder.i] = is_pos[sfb];
                                LayerIIIDecoder.is_ratio[LayerIIIDecoder.i] = is_ratio[sfb];
                                ++LayerIIIDecoder.i;
                            }
                        }
                        if (n2 <= 3) {
                            i = 2;
                            ss = 17;
                            sb = -1;
                            while (i >= 0) {
                                if (ro[1][i][ss] != 0.0f) {
                                    sb = (i << 4) + (i << 1) + ss;
                                    i = -1;
                                    continue;
                                }
                                if (--ss >= 0) continue;
                                --i;
                                ss = 17;
                            }
                            i = 0;
                            while (sfBandIndexL[i] <= sb) {
                                ++i;
                            }
                            sfb = i;
                            i = sfBandIndexL[i];
                            int[] nArray = scalefac1L;
                            while (sfb < 8) {
                                for (sb = sfBandIndexL[sfb + 1] - sfBandIndexL[sfb]; sb > 0; --sb) {
                                    LayerIIIDecoder.is_pos[LayerIIIDecoder.i] = nArray[sfb];
                                    if (is_pos[i] != 7) {
                                        LayerIIIDecoder.is_ratio[LayerIIIDecoder.i] = TAN12[is_pos[i]];
                                    }
                                    ++i;
                                }
                                ++sfb;
                            }
                        }
                    } else {
                        for (n2 = 0; n2 < 3; ++n2) {
                            int n4 = -1;
                            for (sfb = 12; sfb >= 0; --sfb) {
                                temp = sfBandIndexS[sfb];
                                lines = sfBandIndexS[sfb + 1] - temp;
                                i = (temp << 2) - temp + (n2 + 1) * lines - 1;
                                while (lines > 0) {
                                    if (ro[1][i / 18][i % 18] != 0.0f) {
                                        n4 = sfb;
                                        sfb = -10;
                                        lines = -10;
                                    }
                                    --lines;
                                    --i;
                                }
                            }
                            for (sfb = n4 + 1; sfb < 12; ++sfb) {
                                temp = sfBandIndexS[sfb];
                                i = (temp << 2) - temp + n2 * sb;
                                for (sb = sfBandIndexS[sfb + 1] - temp; sb > 0; --sb) {
                                    LayerIIIDecoder.is_pos[LayerIIIDecoder.i] = scalefac1S[n2][sfb];
                                    if (is_pos[i] != 7) {
                                        LayerIIIDecoder.is_ratio[LayerIIIDecoder.i] = TAN12[is_pos[i]];
                                    }
                                    ++i;
                                }
                            }
                            temp = sfBandIndexS[10];
                            temp2 = sfBandIndexS[11];
                            sb = temp2 - temp;
                            sfb = (temp << 2) - temp + n2 * sb;
                            i = (temp2 << 2) - temp2 + n2 * sb;
                            float f = k[0][sfb];
                            float f2 = k[1][sfb];
                            for (sb = sfBandIndexS[12] - temp2; sb > 0; --sb) {
                                LayerIIIDecoder.is_pos[LayerIIIDecoder.i] = is_pos[sfb];
                                LayerIIIDecoder.is_ratio[LayerIIIDecoder.i] = is_ratio[sfb];
                                ++i;
                            }
                        }
                    }
                } else {
                    i = 31;
                    ss = 17;
                    sb = 0;
                    while (i >= 0) {
                        if (ro[1][i][ss] != 0.0f) {
                            sb = (i << 4) + (i << 1) + ss;
                            i = -1;
                            continue;
                        }
                        if (--ss >= 0) continue;
                        --i;
                        ss = 17;
                    }
                    i = 0;
                    while (sfBandIndexL[i] <= sb) {
                        ++i;
                    }
                    sfb = i;
                    i = sfBandIndexL[i];
                    while (sfb < 21) {
                        for (sb = sfBandIndexL[sfb + 1] - sfBandIndexL[sfb]; sb > 0; --sb) {
                            LayerIIIDecoder.is_pos[LayerIIIDecoder.i] = n2 = scalefac1L[sfb];
                            if (n2 != 7) {
                                LayerIIIDecoder.is_ratio[LayerIIIDecoder.i] = TAN12[n2];
                            }
                            ++i;
                        }
                        ++sfb;
                    }
                    sfb = sfBandIndexL[20];
                    for (sb = 576 - sfBandIndexL[21]; sb > 0 && i < 576; --sb, ++i) {
                        LayerIIIDecoder.is_pos[LayerIIIDecoder.i] = is_pos[sfb];
                        LayerIIIDecoder.is_ratio[LayerIIIDecoder.i] = is_ratio[sfb];
                    }
                }
            }
            i = 0;
            for (sb = 0; sb < 32; ++sb) {
                float[] fArray = lr[0][sb];
                float[] fArray3 = lr[1][sb];
                float[] fArray4 = ro[0][sb];
                float[] fArray5 = ro[1][sb];
                ss = 0;
                while (ss < 18) {
                    if (is_pos[i] == 7) {
                        if (header.mode() == 1 && (mode_ext & 2) != 0) {
                            fArray[LayerIIIDecoder.ss] = (fArray4[ss] + fArray5[ss]) * 0.70710677f;
                            fArray3[LayerIIIDecoder.ss] = (fArray4[ss] - fArray5[ss]) * 0.70710677f;
                        } else {
                            fArray[LayerIIIDecoder.ss] = fArray4[ss];
                            fArray3[LayerIIIDecoder.ss] = fArray5[ss];
                        }
                    } else if (bl) {
                        fArray3[LayerIIIDecoder.ss] = fArray4[ss] / (1.0f + is_ratio[i]);
                        fArray[LayerIIIDecoder.ss] = fArray3[ss] * is_ratio[i];
                    }
                    ++ss;
                    ++i;
                }
            }
        }
    }

    private final void antialias(int n, int n2) {
        GRInfo gRInfo = LayerIIIDecoder.si.ch[n].gr[n2];
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2 && gRInfo.mixed_block_flag == 0) {
            return;
        }
        sb18lim = gRInfo.window_switching_flag != 0 && gRInfo.mixed_block_flag != 0 && gRInfo.block_type == 2 ? 18 : 558;
        for (sb18 = 0; sb18 < sb18lim; sb18 += 18) {
            src_idx1 = sb18 + 17;
            src_idx2 = sb18 + 18;
            bu = out_1d[src_idx1];
            bd = out_1d[src_idx2];
            cst = cs[0];
            cat = ca[0];
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx1--] = bu * cst - bd * cat;
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx2++] = bd * cst + bu * cat;
            bu = out_1d[src_idx1];
            bd = out_1d[src_idx2];
            cst = cs[1];
            cat = ca[1];
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx1--] = bu * cst - bd * cat;
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx2++] = bd * cst + bu * cat;
            bu = out_1d[src_idx1];
            bd = out_1d[src_idx2];
            cst = cs[2];
            cat = ca[2];
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx1--] = bu * cst - bd * cat;
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx2++] = bd * cst + bu * cat;
            bu = out_1d[src_idx1];
            bd = out_1d[src_idx2];
            cst = cs[3];
            cat = ca[3];
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx1--] = bu * cst - bd * cat;
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx2++] = bd * cst + bu * cat;
            bu = out_1d[src_idx1];
            bd = out_1d[src_idx2];
            cst = cs[4];
            cat = ca[4];
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx1--] = bu * cst - bd * cat;
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx2++] = bd * cst + bu * cat;
            bu = out_1d[src_idx1];
            bd = out_1d[src_idx2];
            cst = cs[5];
            cat = ca[5];
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx1--] = bu * cst - bd * cat;
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx2++] = bd * cst + bu * cat;
            bu = out_1d[src_idx1];
            bd = out_1d[src_idx2];
            cst = cs[6];
            cat = ca[6];
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx1--] = bu * cst - bd * cat;
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx2++] = bd * cst + bu * cat;
            bu = out_1d[src_idx1];
            bd = out_1d[src_idx2];
            cst = cs[7];
            cat = ca[7];
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx1] = bu * cst - bd * cat;
            LayerIIIDecoder.out_1d[LayerIIIDecoder.src_idx2] = bd * cst + bu * cat;
        }
    }

    public static double log(double d) {
        int n;
        double d2;
        if (d <= 0.0) {
            return Double.NaN;
        }
        if (d == 1.0) {
            return 0.0;
        }
        boolean bl = d > 1.0;
        if (bl) {
            d = 1.0 / d;
        }
        if (d <= 0.0) {
            return bl ? Double.NaN : Double.NaN;
        }
        double d3 = 0.0;
        int n2 = 0;
        while (d > 0.0 && d <= 1.0) {
            d *= 2.0;
            ++n2;
        }
        --n2;
        double d4 = (d /= 2.0) - 1.0;
        double d5 = d + 1.0;
        double d6 = d2 = d4 / d5;
        d5 = d6 * d2;
        for (n = 1; n < 50; n += 2) {
            d3 += d6 / (double)n;
            d6 *= d5;
        }
        d3 *= 2.0;
        for (n = 0; n < n2; ++n) {
            d3 += -0.6931471805599453;
        }
        return bl ? -d3 : d3;
    }

    public static double pow(double d, double d2) {
        if (d == 0.0 || d2 == 1.0) {
            return d;
        }
        if (d == 1.0 || d2 == 0.0) {
            return 1.0;
        }
        int n = (int)d2;
        if (d2 == (double)n) {
            boolean bl = d2 < 0.0;
            double d3 = d;
            for (int i = 1; i < (bl ? -n : n); ++i) {
                d3 *= d;
            }
            return bl ? 1.0 / d3 : d3;
        }
        if (d <= 0.0) {
            return Double.NaN;
        }
        if ((d = d2 * LayerIIIDecoder.log(d)) == 0.0) {
            return 1.0;
        }
        boolean bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d4 = 1.0;
        double d5 = d;
        for (int i = 2; i < 50; ++i) {
            d4 += d5;
            d5 = d5 * d / (double)i;
        }
        if (bl) {
            return 1.0 / d4;
        }
        return d4;
    }

    public final void decodeFrame() {
        nSlots = header.slots();
        this.get_side_info();
        for (i = 0; i < nSlots; ++i) {
            br.hputbuf(stream.readbits(8));
        }
        main_data_end = BitReserve.totbit >>> 3;
        flush_main = BitReserve.totbit & 7;
        if (flush_main != 0) {
            br.hgetbits(8 - flush_main);
            ++main_data_end;
        }
        bytes_to_discard = frame_start - main_data_end - LayerIIIDecoder.si.main_data_begin;
        frame_start += nSlots;
        if (bytes_to_discard < 0) {
            return;
        }
        if (main_data_end > 4096) {
            frame_start -= 4096;
            br.rewindNbytes(4096);
        }
        while (bytes_to_discard-- > 0) {
            br.hgetbits(8);
        }
        for (gr = 0; gr < max_gr; ++gr) {
            for (ch = 0; ch < channels; ++ch) {
                part2_start = BitReserve.totbit;
                this.get_scale_factors(ch, gr);
                this.huffman_decode(ch, gr);
                this.dequantize_sample(ro[ch], ch, gr);
            }
            this.stereo(gr);
            ch = 0;
            this.reorder(lr[ch], ch, gr);
            this.antialias(ch, gr);
            GRInfo gRInfo = LayerIIIDecoder.si.ch[LayerIIIDecoder.ch].gr[gr];
            for (sb18 = 0; sb18 < 576; sb18 += 18) {
                bt = gRInfo.window_switching_flag != 0 && gRInfo.mixed_block_flag != 0 && sb18 < 36 ? 0 : gRInfo.block_type;
                for (cc = 0; cc < 18; ++cc) {
                    LayerIIIDecoder.tsOutCopy[LayerIIIDecoder.cc] = out_1d[cc + sb18];
                }
                this.invMDCT(tsOutCopy, rawout, bt);
                for (cc = 0; cc < 18; ++cc) {
                    LayerIIIDecoder.out_1d[LayerIIIDecoder.cc + LayerIIIDecoder.sb18] = tsOutCopy[cc];
                }
                sbt = sb18;
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[0] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[18];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[1] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[19];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[2] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[20];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[3] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[21];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[4] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[22];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[5] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[23];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[6] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[24];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[7] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[25];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[8] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[26];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[9] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[27];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[10] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[28];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[11] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[29];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[12] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[30];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[13] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[31];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[14] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[32];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[15] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[33];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[16] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt++] = rawout[34];
                LayerIIIDecoder.out_1d[LayerIIIDecoder.sbt] = rawout[17] + prevblck[ch][sbt];
                LayerIIIDecoder.prevblck[LayerIIIDecoder.ch][LayerIIIDecoder.sbt] = rawout[35];
            }
            for (sb18 = 18; sb18 < 576; sb18 += 36) {
                for (ss = 1; ss < 18; ss += 2) {
                    int n = sb18 + ss;
                    out_1d[n] = out_1d[n] * -1.0f;
                }
            }
            ss = 0;
            while (ss < 18) {
                sb = 0;
                for (sb18 = 0; sb18 < 576; sb18 += 18) {
                    LayerIIIDecoder.samples1[LayerIIIDecoder.sb] = out_1d[sb18 + ss];
                    ++sb;
                }
                ++ss;
                LayerIIIDecoder.filter.samples = samples1;
                filter.compute_new_v();
                dvp = 0;
                pos = LayerIIIDecoder.buff.pos;
                channels2 = LayerIIIDecoder.buff.channels;
                byte[] byArray = LayerIIIDecoder.buff.buffer;
                for (int i = 0; i < 32; ++i) {
                    if (pos % this.every == 0) {
                        float[] fArray = SynthesisFilter.d16[i];
                        switch (LayerIIIDecoder.filter.actual_write_pos) {
                            case 0: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 1: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 2: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 3: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 4: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 5: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 6: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 7: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 8: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 9: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 10: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 11: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 12: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[0 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 13: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 14: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                                break;
                            }
                            case 15: {
                                ftemp = (LayerIIIDecoder.filter.actual_v[15 + dvp] * fArray[0] + LayerIIIDecoder.filter.actual_v[14 + dvp] * fArray[1] + LayerIIIDecoder.filter.actual_v[13 + dvp] * fArray[2] + LayerIIIDecoder.filter.actual_v[12 + dvp] * fArray[3] + LayerIIIDecoder.filter.actual_v[11 + dvp] * fArray[4] + LayerIIIDecoder.filter.actual_v[10 + dvp] * fArray[5] + LayerIIIDecoder.filter.actual_v[9 + dvp] * fArray[6] + LayerIIIDecoder.filter.actual_v[8 + dvp] * fArray[7] + LayerIIIDecoder.filter.actual_v[7 + dvp] * fArray[8] + LayerIIIDecoder.filter.actual_v[6 + dvp] * fArray[9] + LayerIIIDecoder.filter.actual_v[5 + dvp] * fArray[10] + LayerIIIDecoder.filter.actual_v[4 + dvp] * fArray[11] + LayerIIIDecoder.filter.actual_v[3 + dvp] * fArray[12] + LayerIIIDecoder.filter.actual_v[2 + dvp] * fArray[13] + LayerIIIDecoder.filter.actual_v[1 + dvp] * fArray[14] + LayerIIIDecoder.filter.actual_v[dvp] * fArray[15]) * SynthesisFilter.scalefactor;
                            }
                        }
                        short s = (short)(ftemp > 32767.0f ? 32767.0f : (ftemp < -32767.0f ? -32767.0f : ftemp));
                        byArray[LayerIIIDecoder.pos] = (byte)(s >>> 8);
                    }
                    ++pos;
                    dvp += 16;
                }
                LayerIIIDecoder.buff.pos = pos;
                LayerIIIDecoder.filter.actual_write_pos = LayerIIIDecoder.filter.actual_write_pos + 1 & 0xF;
                LayerIIIDecoder.filter.actual_v = LayerIIIDecoder.filter.actual_v == LayerIIIDecoder.filter.v1 ? LayerIIIDecoder.filter.v2 : LayerIIIDecoder.filter.v1;
            }
        }
    }

    public final void exit() {
        this.ht = null;
        this.huffmantables = null;
        this.reorder_table = null;
        br = null;
        si = null;
    }

    static {
        scalefac0L = new int[23];
        scalefac0S = new int[3][13];
        scalefac1L = new int[23];
        scalefac1S = new int[3][13];
        samples1 = new float[32];
        samples2 = new float[32];
        cs = new float[]{0.8574929f, 0.881742f, 0.94962865f, 0.9833146f, 0.9955178f, 0.9991606f, 0.9998992f, 0.99999315f};
        ca = new float[]{-0.51449573f, -0.47173196f, -0.31337744f, -0.1819132f, -0.09457419f, -0.040965583f, -0.014198569f, -0.0036999746f};
    }

    static final class Channel {
        public final int[] scfsi = new int[4];
        public final GRInfo[] gr = new GRInfo[2];

        public Channel() {
            this.gr[0] = new GRInfo();
            this.gr[1] = new GRInfo();
        }
    }

    static final class SideInfo {
        public int main_data_begin;
        public int private_bits;
        public final Channel[] ch = new Channel[2];

        public SideInfo() {
            this.ch[0] = new Channel();
            this.ch[1] = new Channel();
        }
    }

    static final class GRInfo {
        public int part2_3_length;
        public int big_values;
        public int global_gain;
        public int scalefac_compress;
        public int window_switching_flag;
        public int block_type;
        public int mixed_block_flag;
        public final int[] table_select = new int[3];
        public final int[] subblock_gain = new int[3];
        public int region0_count;
        public int region1_count;
        public int preflag;
        public int scalefac_scale;
        public int count1table_select;

        GRInfo() {
        }
    }
}

