/*
 * Decompiled with CFR 0.152.
 */
package jlayer;

import jlayer.BitReserve;

public class HuffmanTables {
    private char tablename0;
    private char tablename1;
    private char tablename2;
    private int xlen;
    private int ylen;
    private int linbits;
    private int linmax;
    private int ref;
    public int off;
    private int treelen;
    private static int dmask = Integer.MIN_VALUE;
    private static int hs = 32;
    private static int point;
    private static int error;
    private static int level;
    private static final int MXOFF = 250;
    private static final int HTN = 34;
    private static final int[] bitbuf;

    HuffmanTables(char c, char c2, char c3, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.tablename0 = c;
        this.tablename1 = c2;
        this.tablename2 = c3;
        this.xlen = n;
        this.ylen = n2;
        this.linbits = n3;
        this.linmax = n4;
        this.ref = n5;
        this.off = n6;
        this.treelen = n7;
    }

    public static void decode(byte[] byArray, HuffmanTables huffmanTables, Huffman huffman, BitReserve bitReserve) {
        point = 0;
        level = dmask;
        if (huffmanTables.treelen == 0) {
            Huffman.y = 0;
            Huffman.x = 0;
            return;
        }
        do {
            if (byArray[huffmanTables.off + (point << 1)] == 0) {
                Huffman.x = (byArray[huffmanTables.off + (point << 1) + 1] & 0xFF) >>> 4;
                Huffman.y = byArray[huffmanTables.off + (point << 1) + 1] & 0xF;
                break;
            }
            if (bitReserve.hget1bit() != 0) {
                while ((byArray[huffmanTables.off + (point << 1) + 1] & 0xFF) >= 250) {
                    point += byArray[huffmanTables.off + (point << 1) + 1] & 0xFF;
                }
                point += byArray[huffmanTables.off + (point << 1) + 1] & 0xFF;
                continue;
            }
            while ((byArray[huffmanTables.off + (point << 1)] & 0xFF) >= 250) {
                point += byArray[huffmanTables.off + (point << 1)] & 0xFF;
            }
            point += byArray[huffmanTables.off + (point << 1)] & 0xFF;
        } while ((level >>>= 1) != 0 || point < 0);
        if (huffmanTables.tablename0 == '3' && (huffmanTables.tablename1 == '2' || huffmanTables.tablename1 == '3')) {
            Huffman.v = Huffman.y >> 3 & 1;
            Huffman.w = Huffman.y >> 2 & 1;
            Huffman.x = Huffman.y >> 1 & 1;
            Huffman.y &= 1;
            if (Huffman.v != 0 && bitReserve.hget1bit() != 0) {
                Huffman.v *= -1;
            }
            if (Huffman.w != 0 && bitReserve.hget1bit() != 0) {
                Huffman.w *= -1;
            }
            if (Huffman.x != 0 && bitReserve.hget1bit() != 0) {
                Huffman.x *= -1;
            }
            if (Huffman.y != 0 && bitReserve.hget1bit() != 0) {
                Huffman.y *= -1;
            }
        } else {
            if (huffmanTables.linbits != 0) {
                if (huffmanTables.xlen - 1 == Huffman.x) {
                    Huffman.x += bitReserve.hgetbits(huffmanTables.linbits);
                }
            }
            if (Huffman.x != 0 && bitReserve.hget1bit() != 0) {
                Huffman.x *= -1;
            }
            if (huffmanTables.linbits != 0) {
                if (huffmanTables.ylen - 1 == Huffman.y) {
                    Huffman.y += bitReserve.hgetbits(huffmanTables.linbits);
                }
            }
            if (Huffman.y != 0 && bitReserve.hget1bit() != 0) {
                Huffman.y *= -1;
            }
        }
    }

    static {
        bitbuf = new int[32];
    }

    public static class Huffman {
        static int x;
        static int y;
        static int v;
        static int w;
    }
}

