/*
 * Decompiled with CFR 0.152.
 */
package jlayer;

import java.io.IOException;
import jlayer.BitStream;

public final class Header {
    public static final int[][] frequencies = new int[][]{{22050, 24000, 16000, 1}, {44100, 48000, 32000, 1}};
    public static final int MPEG1 = 1;
    public static final int STEREO = 0;
    public static final int JOINT_STEREO = 1;
    public static final int DUAL_CHANNEL = 2;
    public static final int SINGLE_CHANNEL = 3;
    public static final int FOURTYFOUR_POINT_ONE = 0;
    public static final int FOURTYEIGHT = 1;
    public static final int THIRTYTWO = 2;
    public static final int[][][] bitrates = new int[][][]{new int[][]{{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}}, new int[][]{{0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0}, {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0}, {0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}}};
    public static final String[][][] bitrate_str = new String[][][]{{{"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "176 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}}, {{"free format", "32 kbit/s", "64 kbit/s", "96 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "288 kbit/s", "320 kbit/s", "352 kbit/s", "384 kbit/s", "416 kbit/s", "448 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "384 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "forbidden"}}};
    public static int framesize;
    public static int nSlots;
    private static int h_layer;
    private static int h_protection_bit;
    private static int h_bitrate_index;
    private static int h_padding_bit;
    private static int h_mode_extension;
    private static int h_version;
    private static int h_mode;
    private static int h_sample_frequency;
    private static int h_number_of_subbands;
    private static int h_intensity_stereo_bound;
    private static byte syncmode;

    public int version() {
        return h_version;
    }

    public int layer() {
        return h_layer;
    }

    public int bitrate_index() {
        return h_bitrate_index;
    }

    public int sample_frequency() {
        return h_sample_frequency;
    }

    public int frequency() {
        return frequencies[h_version][h_sample_frequency];
    }

    public int mode() {
        return h_mode;
    }

    public boolean padding() {
        return h_padding_bit != 0;
    }

    public int slots() {
        return nSlots;
    }

    public int mode_extension() {
        return h_mode_extension;
    }

    public String layer_string() {
        return "III";
    }

    public String bitrate_string() {
        return bitrate_str[h_version][h_layer - 1][h_bitrate_index];
    }

    public String sample_frequency_string() {
        switch (h_sample_frequency) {
            case 2: {
                return "32 kHz";
            }
            case 0: {
                return "44.1 kHz";
            }
            case 1: {
                return "48 kHz";
            }
        }
        return "not set";
    }

    public String mode_string() {
        switch (h_mode) {
            case 0: {
                return "Stereo";
            }
            case 1: {
                return "Joint stereo";
            }
            case 2: {
                return "Dual channel";
            }
            case 3: {
                return "Single channel";
            }
        }
        return "not set";
    }

    public int number_of_subbands() {
        return h_number_of_subbands;
    }

    public int intensity_stereo_bound() {
        return h_intensity_stereo_bound;
    }

    final void read_header(BitStream bitStream) throws IOException {
        boolean bl = false;
        do {
            int n = bitStream.syncHeader(syncmode);
            if (syncmode == 0) {
                h_version = n >>> 19 & 1;
                h_sample_frequency = n >>> 10 & 3;
                if (h_sample_frequency == 3) {
                    return;
                }
            }
            h_layer = 4 - (n >>> 17) & 3;
            h_protection_bit = n >>> 16 & 1;
            h_bitrate_index = n >>> 12 & 0xF;
            h_padding_bit = n >>> 9 & 1;
            h_mode = n >>> 6 & 3;
            h_mode_extension = n >>> 4 & 3;
            h_intensity_stereo_bound = h_mode == 1 ? (h_mode_extension << 2) + 4 : 0;
            if (h_layer == 1) {
                h_number_of_subbands = 32;
            } else {
                int n2 = h_bitrate_index;
                if (h_mode != 3) {
                    n2 = n2 == 4 ? 1 : (n2 -= 4);
                }
                h_number_of_subbands = n2 == 1 || n2 == 2 ? (h_sample_frequency == 2 ? 12 : 8) : (h_sample_frequency == 1 || n2 >= 3 && n2 <= 5 ? 27 : 30);
            }
            if (h_intensity_stereo_bound > h_number_of_subbands) {
                h_intensity_stereo_bound = h_number_of_subbands;
            }
            this.calFrameSize();
            bitStream.read_frame_data(framesize);
            if (bitStream.isSyncCurrentPosition(syncmode)) {
                if (syncmode == 0) {
                    syncmode = 1;
                    bitStream.set_syncword(n & 0xFFF80CC0);
                }
                bl = true;
                continue;
            }
            bitStream.unreadFrame();
        } while (!bl);
        bitStream.parse_frame();
        if (h_protection_bit == 0) {
            short s = (short)bitStream.readbits(16);
        }
    }

    private final void calFrameSize() {
        framesize = 144 * bitrates[h_version][h_layer - 1][h_bitrate_index] / frequencies[h_version][h_sample_frequency];
        if (h_padding_bit != 0) {
            ++framesize;
        }
        if (h_version == 1) {
            nSlots = framesize - (h_mode == 3 ? 17 : 32) - (h_protection_bit != 0 ? 0 : 2) - 4;
        } else {
            System.out.println("sorry, doesn't support mpeg2 frames");
            System.exit(1);
        }
        framesize -= 4;
    }

    static {
        syncmode = 0;
    }
}

