/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import jlayer.BitStream;
import jlayer.Header;
import jlayer.LayerIIIDecoder;
import jlayer.SampleBuffer;
import jlayer.SynthesisFilter;

public class MP3 {
    ReadPlay rp;
    public SampleBuffer output;
    public SynthesisFilter filter;
    public LayerIIIDecoder decoder;
    public int outputFrequency;
    public int outputChannels;
    private BitStream bitstream;
    InputStream is;
    StreamConnection con;
    Header header;
    public int every = 6;
    public int soundoff;
    private byte[] sound;
    public static final byte[] riffHeader = new byte[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, 64, 31, 0, 0, 64, 31, 0, 0, 1, 0, 8, 0, 100, 97, 116, 97, 0, 0, 0, 0};

    public MP3(ReadPlay readPlay) {
        this.rp = readPlay;
    }

    int decode(String string, String string2, byte[] byArray) {
        int n = 0;
        this.soundoff = riffHeader.length;
        this.sound = byArray;
        if (string.startsWith("a:/") || string.startsWith("A:/")) {
            string = "0" + string.substring(1);
        }
        try {
            int n2;
            this.con = (StreamConnection)Connector.open((String)("file:///" + string + string2));
            this.is = this.con.openInputStream();
            int n3 = this.is.available();
            if (n3 == 0) {
                ++n3;
            }
            this.bitstream = new BitStream(this.is);
            this.header = this.bitstream.readFrame();
            int n4 = n2 = this.header.mode() != 3 ? 2 : 1;
            if (this.header.layer() != 3) {
                return 0;
            }
            int n5 = this.header.mode();
            int n6 = this.header.layer();
            n2 = n5 == 3 ? 1 : 2;
            this.output = new SampleBuffer(this.header.frequency(), n2);
            this.filter = new SynthesisFilter(0, 32700.0f);
            this.outputChannels = n2;
            this.outputFrequency = this.header.frequency();
            this.decoder = new LayerIIIDecoder(this.bitstream, this.header, this.filter, null, this.output, 1);
            this.every = this.outputFrequency / 8000;
            if (this.every == 5) {
                this.every = 6;
            }
            this.decoder.every = this.every;
            this.rp.fmp3 = true;
            while (this.rp.fmp3) {
                this.output.pos = 0;
                this.decoder.decodeFrame();
                int n7 = this.output.pos;
                if (n7 != 0) {
                    if (n % 16 == 0) {
                        this.rp.progressbar((n3 - this.is.available()) * 100 / n3);
                    }
                    ++n;
                    int n8 = n7 / this.every;
                    if (this.soundoff + n8 <= this.sound.length) {
                        int n9 = 0;
                        while (--n8 >= 0) {
                            this.sound[this.soundoff++] = (byte)(this.output.buffer[n9] + 127);
                            n9 += this.every;
                        }
                        this.bitstream.closeFrame();
                        this.header = this.bitstream.readFrame();
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.rp.fmp3 = false;
        this.bitstream.exit();
        int n10 = this.soundoff - 1;
        System.arraycopy(riffHeader, 0, this.sound, 0, riffHeader.length);
        this.sound[4] = (byte)n10;
        this.sound[5] = (byte)(n10 >> 8);
        this.sound[6] = (byte)(n10 >> 16);
        this.sound[7] = (byte)(n10 >> 24);
        int n11 = riffHeader.length;
        this.sound[n11 - 4] = (byte)(n10 -= n11);
        this.sound[n11 - 3] = (byte)(n10 >> 8);
        this.sound[n11 - 2] = (byte)(n10 >> 16);
        this.sound[n11 - 1] = (byte)(n10 >> 24);
        return this.soundoff > riffHeader.length ? this.soundoff : 0;
    }

    void exit() {
        try {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            if (this.con != null) {
                this.con.close();
                this.con = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.decoder != null) {
            this.decoder.exit();
            this.decoder = null;
        }
        this.output = null;
        if (this.filter != null) {
            this.filter.exit();
            this.filter = null;
        }
    }
}

