/*
 * Decompiled with CFR 0.152.
 */
package com.radiobee.player;

import com.radiobee.player.StationInfo;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class StationsDB {
    String storeName;
    RecordStore rs;
    StationInfo[] stations;

    public StationsDB() {
        this.storeName = "stations_db";
    }

    public StationsDB(String store_name) {
        this.storeName = store_name;
    }

    public StationInfo[] getStationsList() throws RecordStoreException {
        this.rs = RecordStore.openRecordStore((String)this.storeName, (boolean)true);
        int recs = this.rs.getNumRecords();
        if (recs == 0) {
            this.fillDefault();
        }
        recs = this.rs.getNumRecords();
        this.stations = new StationInfo[recs];
        RecordEnumeration rEnum = this.rs.enumerateRecords(null, null, false);
        int i = 0;
        while (rEnum.hasNextElement()) {
            int recID = rEnum.nextRecordId();
            this.stations[i++] = new StationInfo(new String(this.rs.getRecord(recID)), recID);
        }
        rEnum.destroy();
        this.rs.closeRecordStore();
        return this.stations;
    }

    public void updateStation(StationInfo stationInfo) throws RecordStoreException {
        byte[] data = stationInfo.toString().getBytes();
        this.rs = RecordStore.openRecordStore((String)this.storeName, (boolean)false);
        this.rs.setRecord(stationInfo.getRecordID(), data, 0, data.length);
        this.rs.closeRecordStore();
    }

    public void deleteStattion(StationInfo stationInfo) throws RecordStoreException {
        this.rs = RecordStore.openRecordStore((String)this.storeName, (boolean)false);
        this.rs.deleteRecord(stationInfo.getRecordID());
        this.rs.closeRecordStore();
    }

    public int addStation(StationInfo stationInfo) throws RecordStoreException {
        byte[] data = stationInfo.toString().getBytes();
        this.rs = RecordStore.openRecordStore((String)this.storeName, (boolean)false);
        int id = this.rs.addRecord(data, 0, data.length);
        this.rs.closeRecordStore();
        stationInfo.setRecordID(id);
        return id;
    }

    void fillDefault() throws RecordStoreException {
        this.addStation(new StationInfo("The Iron Bell\n82.43.210.152:10000\nAlternative\n24", -1));
        this.addStation(new StationInfo("Edge Radio\n65.100.201.222:8000\nClassic & Alternative Rock\n24", -1));
        this.addStation(new StationInfo("Radio Krishna - Hillsborough, North Carolina USA - broadcasting transcendental sounds\n81.25.96.8:8070\nSpiritual, Alternative\n24", -1));
        this.addStation(new StationInfo("Megarock Radio - We are here to kick ass and take names. Requests live via website!\n72.29.84.238:6590\nRock, Metal, Alternative\n32", -1));
        this.addStation(new StationInfo("Virgin Radio Xtreme - New music\n69.28.128.148:80/stream/vruk_vx_lo\nAlternative Rock Pop College\n32", -1));
        this.addStation(new StationInfo("Darik Radio, Sofia, BULGARIA - live broadcast from the U.S.A.\nsc1.abacast.com:8090\nlive\n32", -1));
        this.addStation(new StationInfo("Virgin Radio - The music we all love\nvruk.sc.llnwd.net:12250\nAdult Pop Rock\n32", -1));
    }
}

