/*
 * Decompiled with CFR 0.152.
 */
package com.radiobee.player;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Settings {
    static final String ChunckTag = "C:";
    static final String BufferTag = "B:";
    static final String TimeOutTag1 = "T:";
    static final String DebugTag = "D:";
    static final String PlayChunckTag = "P:";
    static final String ConnFlagsTag = "S:";
    static final String TimeOutTag2 = "R:";
    static final String StreamTypeTag = "M:";
    static final String BufferTypeTag = "U:";
    static final String storeName = "RADIO_RDS_STORE";
    public static final byte KEEP_SOCK = 1;
    public static final byte KEEP_IN = 2;
    public static final byte KEEP_OUT = 4;
    public static final byte FLUSH_OUT = 8;
    public static final byte CLOSE_OUT = 16;
    public static final byte BASIC_BUFFER = 0;
    public static final byte DOUBLE_BUFFER = 1;
    boolean bRun;
    byte BufferType;
    byte StreamType;
    byte ConnFlags;
    byte DebugLevel;
    int ReadChunck;
    int PlayChunck;
    int BufferSize;
    long Timeout1;
    long Timeout2;

    void createDefRecs() throws RecordStoreException {
        RecordStore rs = RecordStore.openRecordStore((String)storeName, (boolean)true);
        int recs = rs.getNumRecords();
        if (recs == 9) {
            rs.closeRecordStore();
            return;
        }
        RecordEnumeration rEnum = rs.enumerateRecords(null, null, false);
        while (rEnum.hasNextElement()) {
            int curID = rEnum.nextRecordId();
            rs.deleteRecord(curID);
        }
        rEnum.destroy();
        rs.closeRecordStore();
        this.setBufferSize(50000);
        this.setReadChunck(1024);
        this.setPlayChunck(8000);
        this.setDebugLevel((byte)0);
        this.setTimeout1(1000L);
        this.setTimeout2(1000L);
        this.setBufferType((byte)0);
        this.setStreamType((byte)0);
        this.setConnFlags((byte)0);
    }

    public void open() throws Exception {
        this.createDefRecs();
        RecordStore rs = RecordStore.openRecordStore((String)storeName, (boolean)true);
        RecordEnumeration rEnum = rs.enumerateRecords(null, null, false);
        while (rEnum.hasNextElement()) {
            byte[] tmpData = rEnum.nextRecord();
            String tmp = new String(tmpData, "UTF-8");
            if (tmp.startsWith(BufferTag)) {
                this.BufferSize = Integer.parseInt(tmp.substring(2));
                continue;
            }
            if (tmp.startsWith(ChunckTag)) {
                this.ReadChunck = Integer.parseInt(tmp.substring(2));
                continue;
            }
            if (tmp.startsWith(PlayChunckTag)) {
                this.PlayChunck = Integer.parseInt(tmp.substring(2));
                continue;
            }
            if (tmp.startsWith(TimeOutTag1)) {
                this.Timeout1 = Long.parseLong(tmp.substring(2));
                continue;
            }
            if (tmp.startsWith(DebugTag)) {
                this.DebugLevel = (byte)Integer.parseInt(tmp.substring(2));
                continue;
            }
            if (tmp.startsWith(TimeOutTag2)) {
                this.Timeout2 = Long.parseLong(tmp.substring(2));
                continue;
            }
            if (tmp.startsWith(ConnFlagsTag)) {
                this.ConnFlags = (byte)Integer.parseInt(tmp.substring(2));
                continue;
            }
            if (tmp.startsWith(BufferTypeTag)) {
                this.BufferType = (byte)Integer.parseInt(tmp.substring(2));
                continue;
            }
            if (!tmp.startsWith(StreamTypeTag)) continue;
            this.StreamType = (byte)Integer.parseInt(tmp.substring(2));
        }
        rEnum.destroy();
        rs.closeRecordStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValue(String tag, String value) throws Exception {
        boolean found = false;
        RecordStore rs = null;
        RecordEnumeration re = null;
        try {
            byte[] data;
            rs = RecordStore.openRecordStore((String)storeName, (boolean)true);
            re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                int recID = re.nextRecordId();
                data = rs.getRecord(recID);
                String tmp = new String(data, "UTF-8");
                if (!tmp.startsWith(tag)) continue;
                data = new String(tag + value).getBytes();
                rs.setRecord(recID, data, 0, data.length);
                found = true;
                break;
            }
            if (!found) {
                data = new String(tag + value).getBytes();
                rs.addRecord(data, 0, data.length);
            }
        }
        finally {
            if (re != null) {
                re.destroy();
            }
            if (rs != null) {
                rs.closeRecordStore();
            }
        }
    }

    int getBufferSize() {
        return this.BufferSize;
    }

    int getReadChunck() {
        return this.ReadChunck;
    }

    int getPlayChunck() {
        return this.PlayChunck;
    }

    long getTimeout1() {
        return this.Timeout1;
    }

    long getTimeout2() {
        return this.Timeout2;
    }

    byte getDebugLevel() {
        return this.DebugLevel;
    }

    void setBufferSize(int val) {
        this.BufferSize = val;
        try {
            String v = String.valueOf(this.BufferSize);
            this.setValue(BufferTag, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setReadChunck(int val) {
        this.ReadChunck = val;
        try {
            String v = String.valueOf(this.ReadChunck);
            this.setValue(ChunckTag, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setPlayChunck(int val) {
        this.PlayChunck = val;
        try {
            String v = String.valueOf(this.PlayChunck);
            this.setValue(PlayChunckTag, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setTimeout1(long val) {
        this.Timeout1 = val;
        try {
            String v = String.valueOf(this.Timeout1);
            this.setValue(TimeOutTag1, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setTimeout2(long val) {
        this.Timeout2 = val;
        try {
            String v = String.valueOf(this.Timeout2);
            this.setValue(TimeOutTag2, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setDebugLevel(byte val) {
        this.DebugLevel = val;
        try {
            String v = String.valueOf(this.DebugLevel);
            this.setValue(DebugTag, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    byte getBufferType() {
        return this.BufferType;
    }

    void setBufferType(byte val) {
        this.BufferType = val;
        try {
            String v = String.valueOf(this.BufferType);
            this.setValue(BufferTypeTag, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    byte getStreamType() {
        return this.StreamType;
    }

    void setStreamType(byte val) {
        this.StreamType = val;
        try {
            String v = String.valueOf(this.StreamType);
            this.setValue(StreamTypeTag, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    byte getConnFlags() {
        return this.ConnFlags;
    }

    void setConnFlags(byte val) {
        this.ConnFlags = val;
        try {
            String v = String.valueOf(this.ConnFlags);
            this.setValue(ConnFlagsTag, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRunning() {
        return this.bRun;
    }

    void stop() {
        this.bRun = false;
    }

    void start() {
        this.bRun = true;
    }

    boolean KeepSock() {
        return (this.ConnFlags & 1) == 1;
    }

    void setKeepSock(boolean yes) {
        this.ConnFlags = yes ? (byte)(this.ConnFlags | 1) : (byte)((this.ConnFlags | 1) & 0xFFFFFFFE);
    }

    boolean FlushOut() {
        return (this.ConnFlags & 8) == 8;
    }

    boolean CloseOut() {
        return (this.ConnFlags & 8) == 16;
    }

    boolean KeepOut() {
        return (this.ConnFlags & 4) == 4;
    }

    boolean KeepIn() {
        return (this.ConnFlags & 2) == 2;
    }
}

