/*
 * Decompiled with CFR 0.152.
 */
package com.radiobee.player;

import com.radiobee.player.RBBuffer;
import com.radiobee.player.Settings;
import java.io.ByteArrayInputStream;

public class RBSimpleBufferV2
implements RBBuffer {
    byte[] Buff;
    int Written = 0;
    Settings mProfile;

    public RBSimpleBufferV2(Settings profile) {
        this.mProfile = profile;
        this.Buff = new byte[this.mProfile.getBufferSize()];
    }

    public synchronized int write(byte[] buff) throws Exception {
        return this.write(buff, buff.length);
    }

    public synchronized int write(byte[] buff, int len) throws Exception {
        while (this.Written + len > this.mProfile.getBufferSize()) {
            if (!this.mProfile.isRunning()) {
                return -1;
            }
            this.wait(this.mProfile.getTimeout2());
        }
        System.arraycopy(buff, 0, this.Buff, this.Written, len);
        this.Written += len;
        this.notifyAll();
        return len;
    }

    public synchronized ByteArrayInputStream read() throws Exception {
        if (this.Written < this.mProfile.getPlayChunck()) {
            this.wait(this.mProfile.getTimeout2());
            if (this.Written < this.mProfile.getPlayChunck()) {
                return null;
            }
        }
        ByteArrayInputStream bRes = new ByteArrayInputStream(this.Buff, 0, this.Written);
        this.Written = 0;
        this.notifyAll();
        return bRes;
    }
}

