/*
 * Decompiled with CFR 0.152.
 */
package com.radiobee.player;

import com.radiobee.player.ICYMetaData;
import com.radiobee.player.PlayerForm;
import com.radiobee.player.RBBuffer;
import com.radiobee.player.RBSimpleBufferV2;
import com.radiobee.player.RBStream;
import com.radiobee.player.RBStreamBufferV2;
import com.radiobee.player.Settings;
import com.radiobee.player.URLParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class RBBasicPlayer
implements Runnable,
PlayerListener {
    RBBuffer mBuff = null;
    Player mP1 = null;
    Player mP2 = null;
    Settings profile = null;
    Thread mReadingThread = null;
    PlayerForm mPlayerForm = null;
    URLParser mURLParser = null;
    SocketConnection mSock = null;
    InputStream mInStream = null;
    OutputStream mOutStream = null;

    public RBBasicPlayer(Settings sets, PlayerForm aPlayerForm, String urlString) {
        this.profile = sets;
        this.mPlayerForm = aPlayerForm;
        this.mURLParser = new URLParser(urlString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.multiPlay();
        }
        catch (Exception e) {
            this.mPlayerForm.addLog("1", e);
        }
        finally {
            try {
                this.profile.stop();
                if (this.mSock != null) {
                    this.mSock.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    String createHttpRequest() {
        String request = "GET " + this.mURLParser.getResource() + " HTTP/1.1\r\n";
        request = request + "Host: " + this.mURLParser.getAddress() + "\r\n";
        request = request + "Connection: keep-alive\r\n";
        request = request + "icy-metadata: 0\r\nUser-Agent: RadioBee2 \r\n";
        request = request + "Accept: */*\r\n\r\n";
        return request;
    }

    String getConnectionString() {
        if (this.mURLParser.getPort() != 0) {
            return "socket://" + this.mURLParser.getAddress() + ":" + this.mURLParser.getPort();
        }
        return "socket://" + this.mURLParser.getAddress();
    }

    SocketConnection connect() throws IOException {
        String url = this.getConnectionString();
        SocketConnection sock = (SocketConnection)Connector.open((String)url);
        sock.setSocketOption((byte)2, 1);
        if (this.profile.KeepSock()) {
            this.mSock = sock;
        }
        return sock;
    }

    OutputStream doOutPut(SocketConnection sock) throws IOException {
        String request = this.createHttpRequest();
        OutputStream sOut = sock.openOutputStream();
        sOut.write(request.getBytes());
        if (this.profile.FlushOut()) {
            sOut.flush();
        }
        if (this.profile.CloseOut()) {
            sOut.close();
        }
        if (this.profile.KeepOut()) {
            this.mOutStream = sOut;
        }
        return sOut;
    }

    InputStream getStream() throws IOException {
        SocketConnection sock = this.connect();
        this.doOutPut(sock);
        InputStream inStr = sock.openInputStream();
        if (this.profile.KeepIn()) {
            this.mInStream = inStr;
        }
        return inStr;
    }

    void ICYHeader(InputStream inStr) throws IOException {
        ICYMetaData icyTags = new ICYMetaData();
        icyTags.readICYTags(inStr);
        this.mPlayerForm.setLog("playing " + this.mURLParser.getAddress());
        this.mPlayerForm.addLog(icyTags.getStationName());
        this.mPlayerForm.addLog("station status is:\n" + icyTags.getStationStatus());
    }

    void createBuffer() {
        switch (this.profile.getBufferType()) {
            case 1: {
                this.mBuff = new RBStreamBufferV2(this.profile);
                break;
            }
            default: {
                this.mBuff = new RBSimpleBufferV2(this.profile);
            }
        }
    }

    RBStream createStreamReader(InputStream inStream) {
        return new RBStream(inStream, this.mBuff, this.profile);
    }

    void multiPlay() throws Exception {
        this.createBuffer();
        InputStream inStream = this.getStream();
        this.ICYHeader(inStream);
        RBStream rbStream = this.createStreamReader(inStream);
        this.mReadingThread = new Thread(rbStream);
        this.mReadingThread.start();
        this.startPlaying();
    }

    void startPlaying() throws Exception {
        this.prepareP1();
        this.usePlayer(this.mP1);
        this.mReadingThread.join();
        if (this.mP1 != null) {
            this.mP1.removePlayerListener((PlayerListener)this);
            this.mP1.close();
        }
        if (this.mP2 != null) {
            this.mP2.removePlayerListener((PlayerListener)this);
            this.mP2.close();
        }
    }

    Player preparePlayer(Player p) throws Exception {
        if (0L < this.profile.getTimeout1()) {
            Thread.sleep(this.profile.getTimeout1());
        }
        if (p != null) {
            p.removePlayerListener((PlayerListener)this);
            p.deallocate();
            p.close();
            p = null;
        }
        ByteArrayInputStream bIn = null;
        int timeouts_count = 0;
        while (bIn == null && this.profile.isRunning()) {
            bIn = this.mBuff.read();
            if (bIn != null) continue;
            this.mPlayerForm.setLog("time out value:" + timeouts_count++);
        }
        p = Manager.createPlayer(bIn, (String)"audio/mpeg");
        p.realize();
        p.prefetch();
        p.addPlayerListener((PlayerListener)this);
        return p;
    }

    void prepareP1() throws Exception {
        this.mP1 = this.preparePlayer(this.mP1);
    }

    void prepareP2() throws Exception {
        this.mP2 = this.preparePlayer(this.mP2);
    }

    void usePlayer(Player player) throws Exception {
        player.start();
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        block12: {
            if (event == "endOfMedia") {
                if (!this.profile.isRunning()) {
                    return;
                }
                try {
                    if (player == this.mP1) {
                        this.usePlayer(this.mP2);
                        break block12;
                    }
                    this.usePlayer(this.mP1);
                }
                catch (Exception e) {
                    this.mPlayerForm.addLog("2\r\n", e);
                }
            } else if (event == "started") {
                if (!this.profile.isRunning()) {
                    return;
                }
                try {
                    if (player == this.mP1) {
                        this.prepareP2();
                    } else {
                        this.prepareP1();
                    }
                }
                catch (Exception e) {
                    this.mPlayerForm.addLog("3\r\n", e);
                }
            }
        }
    }
}

