/*
 * Decompiled with CFR 0.152.
 */
package p;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import p.Cursor;
import p.Float;
import p.Instrument;
import p.MCanvas;
import p.RGBColor;
import p.Rect;

public class DrawField
implements Runnable {
    public static final int MODE_ASSIGN = 1;
    public static final int MODE_FILL = 0;
    private Cursor cursor;
    private int[][] field;
    private int height;
    private Image imField;
    private Image imFieldBACKUP;
    MCanvas mc;
    private int offsetX;
    private int offsetY;
    int runMode;
    private Instrument tool;
    private boolean undoAble;
    private int width;

    public DrawField(int w, int h, MCanvas _mc) {
        this.width = w;
        this.height = h;
        this.mc = _mc;
        this.field = new int[this.width][this.height];
        int i = 0;
        while (i < this.width) {
            int j = 0;
            while (j < this.height) {
                this.field[i][j] = 0xFFFFFF;
                ++j;
            }
            ++i;
        }
        this.offsetX = 0;
        this.offsetY = 0;
        try {
            this.imField = Image.createImage((int)this.width, (int)this.height);
            this.imFieldBACKUP = Image.createImage((int)this.width, (int)this.height);
            this.undoAble = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tool = new Instrument();
        this.cursor = new Cursor(this.width, this.height);
    }

    public boolean canUndo() {
        return this.undoAble;
    }

    public void drawAll(Graphics g, int x, int y) {
        g.drawImage(this.imField, x, y, 20);
    }

    public void drawCoord(Graphics g) {
        String crd = String.valueOf(this.cursor.x + this.offsetX) + ":" + String.valueOf(this.cursor.y + this.offsetY);
        Font f = Font.getFont((int)32, (int)0, (int)8);
        int wdth = f.stringWidth(crd);
        int wdth_C = f.stringWidth("333:333");
        g.setColor(0);
        g.fillRect(this.mc.screenWidth - wdth_C - 8, 0, wdth_C + 8, 10);
        g.setColor(0xFFFFFF);
        g.drawString(crd, this.mc.screenWidth - wdth - 4, 0, 20);
    }

    public void drawCursor(Graphics g) {
        this.cursor.draw(g);
    }

    public void drawToolBar(Graphics g, int x, int y) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.mc.screenWidth, 10);
        this.tool.drawIcon(g, 1, 1);
        this.tool.drawParamIcon(g, 10, 1);
        this.tool.drawColors(g, 19, 1);
    }

    private void fillTrace(int x, int y, RGBColor bg, RGBColor fill, Graphics g, int[][][] matrix) {
        this.mc.serviceMsg = this.mc.app.loc.getString("fill ") + String.valueOf(x) + ":" + String.valueOf(y);
        this.field[x += this.offsetX][y += this.offsetY] = fill.GetInt();
        g.fillRect(x - this.offsetX, y - this.offsetY, 1, 1);
        int i = 0;
        while (i < 3) {
            int flag = 0;
            int j = 0;
            while (j < 2) {
                if (x + matrix[i][j][0] < 1 || x + matrix[i][j][0] > this.width - 2 || y + matrix[i][j][1] < 1 || y + matrix[i][j][1] > this.height - 2) {
                    ++flag;
                } else if (this.field[x + matrix[i][j][0]][y + matrix[i][j][1]] == bg.GetInt()) {
                    this.fillTrace(x + matrix[i][j][0], y + matrix[i][j][1], bg, fill, g, matrix);
                } else {
                    ++flag;
                }
                ++j;
            }
            if (flag < 2 && this.field[x + matrix[i][2][0]][y + matrix[i][2][1]] == bg.GetInt()) {
                this.fillTrace(x + matrix[i][2][0] - this.offsetX, y + matrix[i][2][1] - this.offsetY, bg, fill, g, matrix);
            }
            ++i;
        }
    }

    public RGBColor getColor() {
        return this.tool.getColor();
    }

    public Rect getCoord() {
        return new Rect(this.cursor.x, this.cursor.y, 0, 0);
    }

    public Rect getDimensions() {
        return new Rect(this.width - this.offsetX, this.height - this.offsetY, 0, 0);
    }

    public int[][] getField() {
        return this.field;
    }

    public Rect getOffset() {
        return new Rect(this.offsetX, this.offsetY, 0, 0);
    }

    public int getParam(int idx) {
        return this.tool.getParam(idx);
    }

    public int getToolParam(int idx) {
        return this.tool.getParam(idx);
    }

    public void moveCursor(int dx, int dy, boolean jump) {
        this.cursor.move(dx, dy);
        if (!jump && this.tool.isUsed()) {
            int tt = this.tool.getToolType();
            switch (tt) {
                case 0: {
                    int p = this.tool.getParam(0);
                    RGBColor c = this.tool.getColor();
                    if (p % 2 != 0) {
                        this.setRegion(this.cursor.x - p / 2, this.cursor.y - p / 2, p, p, c);
                        break;
                    }
                    this.setRegion(this.cursor.x - p / 2 + 1, this.cursor.y - p / 2 + 1, p, p, c);
                }
            }
        }
    }

    public void nextTool() {
        int tt = this.tool.getToolType();
        tt = tt + 1 >= 5 ? 0 : ++tt;
        this.tool.setToolType(tt);
    }

    public void pickColor() {
        RGBColor r = new RGBColor(this.field[this.cursor.x][this.cursor.y]);
        this.tool.setColor(r.r, r.g, r.b);
    }

    public void prevTool() {
        int tt = this.tool.getToolType();
        tt = tt - 1 < 0 ? 4 : --tt;
        this.tool.setToolType(tt);
    }

    public void reAssign(int x, int y) {
        Graphics g = this.imField.getGraphics();
        int i = 0;
        while (i < this.width - x) {
            this.mc.serviceMsg = this.mc.app.loc.getString("remap") + " " + String.valueOf(i * (this.width - x) / 100) + " %";
            int j = 0;
            while (j < this.height - y) {
                g.setColor(this.field[i + x][j + y]);
                g.fillRect(i, j, 1, 1);
                ++j;
            }
            ++i;
        }
    }

    public void reAssign() {
        Graphics g = this.imField.getGraphics();
        int i = 0;
        while (i < this.width) {
            this.mc.serviceMsg = this.mc.app.loc.getString("map") + " " + String.valueOf(i * this.width / 100) + " %";
            int j = 0;
            while (j < this.height) {
                g.setColor(this.field[i][j]);
                g.fillRect(i, j, 1, 1);
                ++j;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.runMode == 0) {
            this.mc.startAutoMode();
            this.mc.serviceMsg = this.mc.app.loc.getString("fill:clean mem");
            RGBColor bg = new RGBColor(this.field[this.cursor.x][this.cursor.y]);
            RGBColor fill_c = this.tool.getColor();
            Graphics gg = this.imField.getGraphics();
            gg.setColor(fill_c.r, fill_c.g, fill_c.b);
            int[][][] a = new int[][][]{new int[][]{{-1, 0}, {0, -1}, {-1, -1}}, new int[][]{{-1, 0}, {0, 1}, {-1, 1}}, new int[][]{{1, 0}, {0, 1}, {1, 1}}, new int[][]{{1, 0}, {0, -1}, {1, -1}}};
            System.gc();
            try {
                this.fillTrace(this.cursor.x, this.cursor.y, bg, fill_c, gg, a);
            }
            finally {
                this.tool.switchMode();
                this.mc.done = true;
            }
        }
        if (this.runMode == 1) {
            this.reAssign(this.offsetX, this.offsetY);
            this.mc.done = true;
        }
    }

    public void setColor(int r, int g, int b) {
        this.tool.setColor(r, g, b);
    }

    public void setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        this.cursor.setBounds(this.width - this.offsetX, this.height - this.offsetY);
        if (this.tool.isUsed()) {
            this.tool.switchMode();
        }
        this.cursor.moveCenter();
        try {
            this.imField = Image.createImage((int)(this.width - this.offsetX), (int)(this.height - this.offsetY));
            this.imFieldBACKUP = Image.createImage((int)(this.width - this.offsetX), (int)(this.height - this.offsetY));
            this.undoAble = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Thread t = new Thread(this);
        t.setPriority(10);
        this.runMode = 1;
        t.start();
    }

    public void setParam(int p, int idx) {
        this.tool.setParam(idx, p);
    }

    public void setRegion(int x, int y, int w, int h, RGBColor c) {
        if ((x += this.offsetX) < 0 || (y += this.offsetY) < 0 || x + w > this.width || y + h > this.height) {
            return;
        }
        int i = x;
        while (i < x + w) {
            int j = y;
            while (j < y + h) {
                this.field[i][j] = c.GetInt();
                ++j;
            }
            ++i;
        }
        Graphics g = this.imField.getGraphics();
        g.setColor(c.r, c.g, c.b);
        g.fillRect(x - this.offsetX, y - this.offsetY, w, h);
    }

    public void setTool(int tt) {
        this.tool.setToolType(tt);
    }

    public void swapColors() {
        this.tool.swapColors();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void switchTool() {
        this.tool.switchMode();
        int tt = this.tool.getToolType();
        if (this.tool.isUsed()) {
            this.imFieldBACKUP.getGraphics().drawImage(this.imField, 0, 0, 20);
            this.undoAble = true;
            switch (tt) {
                case 0: {
                    int p = this.tool.getParam(0);
                    RGBColor c = this.tool.getColor();
                    if (p % 2 != 0) {
                        this.setRegion(this.cursor.x - p / 2, this.cursor.y - p / 2, p, p, c);
                        break;
                    }
                    this.setRegion(this.cursor.x - p / 2 + 1, this.cursor.y - p / 2 + 1, p, p, c);
                    break;
                }
                case 1: {
                    Thread t = new Thread(this);
                    t.setPriority(10);
                    this.runMode = 0;
                    t.start();
                    break;
                }
                case 2: {
                    this.tool.setParam(1, this.cursor.x);
                    this.tool.setParam(2, this.cursor.y);
                    break;
                }
                case 3: {
                    this.tool.setParam(1, this.cursor.x);
                    this.tool.setParam(2, this.cursor.y);
                    break;
                }
                case 4: {
                    this.tool.setParam(1, this.cursor.x);
                    this.tool.setParam(2, this.cursor.y);
                }
            }
        }
        if (this.tool.isUsed()) return;
        switch (tt) {
            case 2: {
                RGBColor c = this.tool.getColor();
                int x1 = this.tool.getParam(1);
                int y1 = this.tool.getParam(2);
                int x2 = this.cursor.x;
                int y2 = this.cursor.y;
                int x = x1;
                int y = y1;
                int xs = x2 - x1;
                int ys = y2 - y1;
                int xm = xs < 0 ? -1 : (xs > 0 ? 1 : 0);
                int ym = ys < 0 ? -1 : (ys > 0 ? 1 : 0);
                if (xs < 0) {
                    xs = -xs;
                }
                if (ys < 0) {
                    ys = -ys;
                }
                this.setRegion(x, y, 1, 1, c);
                if (xs > ys) {
                    int count = -(xs / 2);
                    while (x != x2) {
                        x += xm;
                        if ((count += ys) > 0) {
                            y += ym;
                            count -= xs;
                        }
                        this.setRegion(x, y, 1, 1, c);
                    }
                    return;
                } else {
                    int count = -(ys / 2);
                    while (y != y2) {
                        y += ym;
                        if ((count += xs) > 0) {
                            x += xm;
                            count -= ys;
                        }
                        this.setRegion(x, y, 1, 1, c);
                    }
                }
                return;
            }
            case 3: {
                int cx = this.tool.getParam(1);
                int cy = this.tool.getParam(2);
                int x2 = this.cursor.x;
                int y2 = this.cursor.y;
                RGBColor c = this.tool.getColor();
                int dx = Math.abs(cx - x2);
                int dy = Math.abs(cy - y2);
                int r = (int)Float.sqrt(new Float(dx * dx).Add(new Float(dy * dy))).toLong();
                int r2 = r * r;
                this.setRegion(cx, cy + r, 1, 1, c);
                this.setRegion(cx, cy - r, 1, 1, c);
                this.setRegion(cx + r, cy, 1, 1, c);
                this.setRegion(cx - r, cy, 1, 1, c);
                int x = 1;
                int y = (int)Float.sqrt(new Float(r2 - 1)).Add(new Float(1L).Div(2L)).toLong();
                while (x < y) {
                    this.setRegion(cx + x, cy + y, 1, 1, c);
                    this.setRegion(cx + x, cy - y, 1, 1, c);
                    this.setRegion(cx - x, cy + y, 1, 1, c);
                    this.setRegion(cx - x, cy - y, 1, 1, c);
                    this.setRegion(cx + y, cy + x, 1, 1, c);
                    this.setRegion(cx + y, cy - x, 1, 1, c);
                    this.setRegion(cx - y, cy + x, 1, 1, c);
                    this.setRegion(cx - y, cy - x, 1, 1, c);
                    y = (int)Float.sqrt(new Float(r2 - ++x * x)).Add(new Float(1L).Div(2L)).toLong();
                }
                if (x != y) return;
                this.setRegion(cx + x, cy + y, 1, 1, c);
                this.setRegion(cx + x, cy - y, 1, 1, c);
                this.setRegion(cx - x, cy + y, 1, 1, c);
                this.setRegion(cx - x, cy - y, 1, 1, c);
                return;
            }
            case 4: {
                int x1 = this.tool.getParam(1);
                int y1 = this.tool.getParam(2);
                int x2 = this.cursor.x;
                int y2 = this.cursor.y;
                RGBColor c = this.tool.getColor();
                int dx = 0;
                int dy = 0;
                dx = x1 < x2 ? 1 : -1;
                dy = y1 < y2 ? 1 : -1;
                if (this.tool.getParam(0) > 1) {
                    int i = x1;
                    while (i != x2) {
                        int j = y1;
                        while (j != y2) {
                            this.setRegion(i, j, 1, 1, c);
                            j += dy;
                        }
                        i += dx;
                    }
                    return;
                }
                int i = x1;
                while (i != x2) {
                    this.setRegion(i, y1, 1, 1, c);
                    this.setRegion(i, y2, 1, 1, c);
                    i += dx;
                }
                int i2 = y1;
                while (i2 != y2) {
                    this.setRegion(x1, i2, 1, 1, c);
                    this.setRegion(x2, i2, 1, 1, c);
                    i2 += dy;
                }
                this.setRegion(x2, y2, 1, 1, c);
            }
        }
    }

    public int toolType() {
        return this.tool.getToolType();
    }

    public boolean toolUsed() {
        return this.tool.isUsed();
    }

    public void undo() {
        if (!this.undoAble) {
            return;
        }
        if (this.tool.isUsed()) {
            this.tool.switchMode();
        }
        this.imField.getGraphics().drawImage(this.imFieldBACKUP, 0, 0, 20);
        this.undoAble = false;
    }
}

