/*
 * Decompiled with CFR 0.152.
 */
package mps;

import com.siemens.mp.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;
import mp3.MP3;
import mps.FileManager;
import mps.MmpsPlayer;
import mps.PlaylistItem;

public class MainWindow
extends Canvas
implements CommandListener,
PlayerListener {
    final int CANCEL;
    final int CALL;
    final int LEFT_SOFT;
    private int play_time = 0;
    private int cur_time = 0;
    private Player m_player;
    private int x;
    private int y;
    private int h;
    private int w;
    private Command play;
    private Command remove;
    private Command back;
    private Command save;
    private MmpsPlayer m_midlet;
    Vector to_play;
    public int idx = 0;
    final String PROTOCOL;
    Timer timer;
    Timer resume_timer;
    TimerTask wait_to_resume;
    boolean incoming_call = false;
    int pressed_key = 0;
    PlaylistItem item;
    VolumeControl con;
    int m_volume = 50;
    Font m_font_id3;
    private List pl;
    private int pl_size;
    private boolean pl_changed = false;
    private boolean blocked = false;
    private boolean shuffle = false;
    private boolean muted = false;
    static Image skin;
    static Image lock;
    static Image mute;
    static Image mp3_img;
    static Image plt_img;
    static Image folder_img;
    static Image sel_img;
    static Image mmc_img;
    static Image stuff_img;
    public static String path;
    public List options;
    TextBox save_box;
    String saved_pl;
    Stack played;
    boolean m_block_re\u0430leased = true;
    boolean m_backforw_repeated = false;
    private String new_pl = "New playlist...";
    private String add_to_pl = "Add to playlist...";
    private String load_pl = "Load playlist...";
    private String save_pl = "Save playlist...";
    private String play_list = "Playlist";
    private String exit = "Exit";
    Displayable prev_window = this;

    static {
        path = "";
        try {
            folder_img = Image.createImage((String)"/mps/folder.png");
            mp3_img = Image.createImage((String)"/mps/mp3.png");
            plt_img = Image.createImage((String)"/mps/plt.png");
            sel_img = Image.createImage((String)"/mps/sel.png");
            mmc_img = Image.createImage((String)"/mps/mmc.png");
            stuff_img = Image.createImage((String)"/mps/stuff.png");
            skin = Image.createImage((String)"/mps/skin.png");
            lock = Image.createImage((String)"/mps/lock.png");
            mute = Image.createImage((String)"/mps/mute.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    MainWindow(MmpsPlayer a_midlet) {
        this.CANCEL = -12;
        this.CALL = -11;
        this.LEFT_SOFT = -1;
        this.PROTOCOL = "file:///";
        this.m_midlet = a_midlet;
        this.to_play = new Vector();
        this.played = new Stack();
        this.createCommand();
        this.m_font_id3 = Font.getFont((int)32, (int)1, (int)8);
        this.options = new List("           Options", 3, new String[]{this.new_pl, this.load_pl, this.exit}, null);
        this.options.addCommand(this.back);
        this.options.setSelectCommand(List.SELECT_COMMAND);
        this.options.setCommandListener((CommandListener)this);
    }

    private void createCommand() {
        this.play = new Command("Play", 8, 2);
        this.remove = new Command("Remove", 8, 1);
        this.back = new Command("", 2, 1);
        this.save = new Command("Save", 8, 2);
    }

    protected void keyPressed(int a_code) {
        if (a_code == -4 && !this.blocked) {
            this.pressed_key = a_code;
            Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this.options);
            return;
        }
        if (this.m_player.getState() == 0) {
            return;
        }
        if (this.blocked && a_code != -39 && a_code != -20 && a_code != -21) {
            return;
        }
        switch (a_code) {
            case 49: {
                break;
            }
            case 51: {
                break;
            }
            case 55: {
                if (this.shuffle) {
                    this.played.removeAllElements();
                    this.shuffle = false;
                } else {
                    this.played.push(new Integer(this.idx));
                    this.shuffle = true;
                }
                this.repaint();
                break;
            }
            case -61: 
            case 52: {
                this.endPlay();
                this.repaint();
                if (this.to_play.size() == 0) {
                    this.idx = 0;
                } else if (this.shuffle) {
                    if (this.played.size() > 0) {
                        this.played.pop();
                        this.idx = this.played.size() > 0 ? ((Integer)this.played.pop()).intValue() : this.randomSearch();
                    } else {
                        this.idx = this.randomSearch();
                    }
                } else {
                    --this.idx;
                }
                this.Play(this.idx, 0);
                break;
            }
            case -62: 
            case -39: 
            case 54: {
                this.endPlay();
                this.repaint();
                this.idx = this.to_play.size() == 0 ? 0 : (this.shuffle ? this.randomSearch() : ++this.idx);
                this.Play(this.idx, 0);
                break;
            }
            case -59: 
            case -20: 
            case 50: {
                this.muted = false;
                this.con.setMute(false);
                this.m_volume += 25;
                if (this.m_volume > 100) {
                    this.m_volume = 100;
                }
                this.con.setLevel(this.m_volume);
                this.repaint(this.getWidth() - 50, 0, 50, 30);
                break;
            }
            case -60: 
            case -21: 
            case 56: {
                this.muted = false;
                this.con.setMute(false);
                this.m_volume -= 25;
                if (this.m_volume < 0) {
                    this.m_volume = 0;
                }
                this.con.setLevel(this.m_volume);
                this.repaint(this.getWidth() - 50, 0, 50, 30);
                break;
            }
            case 42: {
                if (this.con.isMuted()) {
                    this.muted = false;
                    this.con.setMute(false);
                } else {
                    this.muted = true;
                    this.con.setMute(true);
                }
                this.repaint(this.getWidth() - 50, 0, 50, 30);
                break;
            }
            case 48: {
                this.pressed_key = a_code;
                this.showPlaylist();
                break;
            }
            case -26: 
            case 53: {
                if (this.m_player.getState() == 400) {
                    try {
                        this.m_player.stop();
                        this.timer.cancel();
                    }
                    catch (MediaException e) {
                        this.catchException((Exception)((Object)e));
                    }
                    break;
                }
                if (this.m_player.getState() != 300) break;
                try {
                    this.timer = new Timer();
                    this.m_player.start();
                    this.timer.scheduleAtFixedRate((TimerTask)new PlayTimerTask(this.item.TIME), 0L, 1000L);
                }
                catch (MediaException e) {
                    this.catchException((Exception)((Object)e));
                }
                break;
            }
        }
    }

    protected void keyRepeated(int a_code) {
        if (this.m_player.getState() == 0) {
            return;
        }
        switch (a_code) {
            case 35: {
                if (!this.m_block_re\u0430leased) {
                    return;
                }
                if (this.blocked) {
                    this.blocked = false;
                    this.repaint(this.getWidth() - 46, this.getHeight() - 45, 46, 45);
                } else {
                    this.blocked = true;
                    this.repaint(this.getWidth() - 46, this.getHeight() - 45, 46, 45);
                }
                this.m_block_re\u0430leased = false;
                break;
            }
            case 49: 
            case 51: {
                if (this.m_backforw_repeated || this.blocked) {
                    return;
                }
                this.endPlay();
                this.timer.cancel();
                this.timer = new Timer();
                TimerTask cur_tt = null;
                cur_tt = a_code == 51 ? new RewindForwardTimerTask() : new RewindBackTimerTask();
                this.timer.scheduleAtFixedRate(cur_tt, 0L, 25L);
                this.m_backforw_repeated = true;
                break;
            }
        }
    }

    protected void keyReleased(int a_code) {
        switch (a_code) {
            case 35: {
                if (this.m_block_re\u0430leased) break;
                this.m_block_re\u0430leased = true;
                break;
            }
            case 49: 
            case 51: {
                if (!this.m_backforw_repeated) {
                    return;
                }
                this.timer.cancel();
                this.m_backforw_repeated = false;
                this.Play(this.idx, this.cur_time);
                break;
            }
        }
    }

    protected void paint(Graphics gc) {
        this.x = 10;
        this.h = 15;
        this.y = this.getHeight() - (3 * this.h + 1);
        this.w = this.getWidth() - 2 * this.x;
        gc.drawImage(skin, 0, 0, 20);
        gc.setFont(Font.getFont((int)64, (int)0, (int)8));
        gc.setColor(175, 3, 20);
        gc.drawString("MpS", this.getWidth() / 2, 5, 17);
        gc.drawString(new String(new char[]{'\u00a9'}), this.getWidth() / 2, 15, 17);
        if (this.item != null) {
            gc.setFont(this.m_font_id3);
            gc.setColor(0, 64, 128);
            String to_draw = "";
            if (this.item.SONG == null && this.item.ARTIST == null && this.item.ALBUM == null || this.item.SONG.equals("") && this.item.ARTIST.equals("") && this.item.ALBUM.equals("")) {
                to_draw = this.item.FILE.substring(0, this.item.FILE.length() - 4);
                to_draw = MainWindow.convertISOToUnicode(to_draw);
                if (gc.getFont().stringWidth(to_draw) > this.getWidth()) {
                    gc.drawString(to_draw, 0, 40, 20);
                } else {
                    gc.drawString(to_draw, this.getWidth() / 2, 40, 17);
                }
            } else {
                String string = to_draw = this.item.SONG != null ? MainWindow.convertISOToUnicode(this.item.SONG) : "";
                if (gc.getFont().stringWidth(to_draw) > this.getWidth()) {
                    gc.drawString(to_draw, 0, 40, 20);
                } else {
                    gc.drawString(to_draw, this.getWidth() / 2, 40, 17);
                }
                String string2 = to_draw = this.item.ARTIST != null ? MainWindow.convertISOToUnicode(this.item.ARTIST) : "";
                if (gc.getFont().stringWidth(to_draw) > this.getWidth()) {
                    gc.drawString(to_draw, 0, 60, 20);
                } else {
                    gc.drawString(to_draw, this.getWidth() / 2, 60, 17);
                }
                String string3 = to_draw = this.item.ALBUM != null ? MainWindow.convertISOToUnicode(this.item.ALBUM) : "";
                if (gc.getFont().stringWidth(to_draw) > this.getWidth()) {
                    gc.drawString(to_draw, 0, 80, 20);
                } else {
                    gc.drawString(to_draw, this.getWidth() / 2, 80, 17);
                }
            }
            if (this.item.MODE != null) {
                gc.setFont(this.m_font_id3);
                gc.setColor(64, 0, 67);
                gc.drawString(this.item.MODE, this.getWidth() / 2, 150, 17);
            }
            if (this.item.BITRATE != 0 && this.item.SAMPLERATE != 0) {
                gc.setFont(Font.getFont((int)32, (int)0, (int)8));
                gc.setColor(64, 0, 67);
                gc.drawString(String.valueOf(this.item.BITRATE) + " kbps", this.x, this.y - 15, 20);
                gc.drawString(String.valueOf(this.item.SAMPLERATE / 1000) + " kHz", this.x + this.w, this.y - 15, 24);
            }
            if (this.m_volume > 0) {
                gc.setColor(64, 0, 67);
                int i = 0;
                while (i < this.m_volume / 25) {
                    gc.fillRect(this.getWidth() - 36 + (3 - i) * 7, 30 - 5 * (i + 1) - i * 2, 10 + 7 * i, 5);
                    ++i;
                }
            }
            if (this.muted || this.m_volume == 0) {
                gc.drawImage(mute, this.getWidth() - 45, 10, 20);
            }
            if (this.shuffle) {
                gc.setFont(this.m_font_id3);
                gc.setColor(0, 170, 0);
                gc.drawString("sh", this.x, 150, 20);
            }
            if (this.blocked) {
                gc.drawImage(lock, this.x + this.w, 150, 24);
            }
            if (!this.to_play.isEmpty()) {
                int num = this.to_play.indexOf(this.item);
                int size = this.to_play.size();
                gc.setFont(Font.getFont((int)32, (int)0, (int)8));
                gc.setColor(0, 64, 128);
                gc.drawString(String.valueOf(num + 1) + "/" + size, this.getWidth() / 2, 100, 17);
            }
        } else {
            gc.setFont(Font.getFont((int)32, (int)1, (int)0));
            gc.setColor(175, 3, 20);
            gc.drawString("You should create", this.getWidth() / 2, 40, 17);
            gc.drawString("new playlist!", this.getWidth() / 2, 70, 17);
        }
        if (!this.blocked) {
            gc.setColor(0, 0, 0);
            gc.fillTriangle(this.getWidth() - 16, this.getHeight() - 10, this.getWidth() - 6, this.getHeight() - 10, this.getWidth() - 11, this.getHeight() - 5);
        }
        gc.setFont(Font.getFont((int)64, (int)1, (int)8));
        gc.setColor(211, 183, 154);
        gc.fillRect(this.x, this.y, this.w, this.h);
        gc.setColor(0, 0, 0);
        gc.drawLine(this.x, this.y, this.x, this.y + this.h);
        gc.drawLine(this.x, this.y, this.x + this.w, this.y);
        gc.setColor(255, 255, 255);
        gc.drawLine(this.x, this.y + this.h, this.x + this.w, this.y + this.h);
        gc.drawLine(this.x + this.w, this.y, this.x + this.w, this.y + this.h);
        if (this.play_time != 0) {
            gc.setColor(255, 128, 64);
            gc.fillRect(this.x + 1, this.y + 1, (this.w - 1) * this.cur_time / this.play_time, this.h - 1);
        }
        gc.setColor(0, 0, 0);
        int sec = (this.play_time - this.cur_time) % 60;
        if (sec < 0) {
            sec = 0;
        }
        gc.drawString("-" + (this.play_time - this.cur_time) / 60 + ":" + (sec > 9 ? "" : "0") + sec, this.x + this.w / 2, this.y + 3, 17);
    }

    public void commandAction(Command a_com, Displayable a_cur_window) {
        if (a_com == List.SELECT_COMMAND && a_cur_window.equals(this.options)) {
            int op_idx = this.options.getSelectedIndex();
            if (this.options.getString(op_idx).equals(this.new_pl)) {
                new FileManager(this.m_midlet, 0);
                return;
            }
            if (this.options.getString(op_idx).equals(this.add_to_pl)) {
                new FileManager(this.m_midlet, 1);
                return;
            }
            if (this.options.getString(op_idx).equals(this.play_list)) {
                this.showPlaylist();
                return;
            }
            if (this.options.getString(op_idx).equals(this.save_pl)) {
                this.savePlaylist();
                return;
            }
            if (this.options.getString(op_idx).equals(this.exit)) {
                this.m_midlet.exit();
                return;
            }
            if (this.options.getString(op_idx).equals(this.load_pl)) {
                new FileManager(this.m_midlet, 2);
                return;
            }
        } else if (a_com == List.SELECT_COMMAND && a_cur_window.equals(this.pl)) {
            this.endPlay();
            this.repaint();
            Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this);
            this.Play(this.pl.getSelectedIndex(), 0);
        } else if (a_com == this.remove) {
            int i = this.pl.getSelectedIndex();
            this.to_play.removeElement(this.to_play.elementAt(i));
            this.pl.delete(i);
            this.played.removeAllElements();
            if (this.to_play.size() == 0) {
                this.options.delete(2);
                this.options.delete(2);
                this.options.delete(2);
                Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this);
            }
        } else if (a_com == this.play) {
            this.endPlay();
            this.repaint();
            Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this);
            this.Play(this.pl.getSelectedIndex(), 0);
        } else {
            if (a_com == this.save) {
                this.saved_pl = this.save_box.getString();
                if (!this.saved_pl.trim().equals("")) {
                    new FileManager(this.m_midlet, 3);
                }
                return;
            }
            if (a_com == this.back) {
                this.prev_window = this;
                Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this);
            }
        }
    }

    void savePlaylist() {
        this.save_box = new TextBox(" Playlist' name", "playlist", 20, 0);
        this.prev_window = this.save_box;
        this.save_box.addCommand(this.save);
        this.save_box.addCommand(this.back);
        this.save_box.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this.save_box);
    }

    void setPlayList(Vector a_to_play) {
        if (this.to_play.size() == 0) {
            this.options.insert(2, this.add_to_pl, null);
            this.options.insert(3, this.save_pl, null);
            this.options.insert(4, this.play_list, null);
        }
        this.pl_changed = true;
        this.to_play.removeAllElements();
        this.played.removeAllElements();
        new OperateMP3(a_to_play).start();
        this.endPlay();
        this.repaint();
        while (this.to_play.size() == 0 || ((PlaylistItem)this.to_play.elementAt((int)0)).DID != 1) {
        }
        this.idx = 0;
        this.Play(0, 0);
    }

    void addToPlayList(Vector a_to_play) {
        if (this.to_play.size() == 0) {
            this.options.insert(1, "Add to playlist...", null);
            this.options.insert(2, "Playlist", null);
        }
        this.pl_changed = true;
        new OperateMP3(a_to_play).start();
    }

    synchronized void Play(int a_idx, int a_time_from_begining) {
        boolean catch_exept = false;
        this.incoming_call = false;
        this.m_midlet.paused = false;
        this.resume_timer = null;
        this.m_midlet.after_paused = false;
        if (this.to_play.size() == 0) {
            this.item = null;
            this.cur_time = 0;
            this.play_time = 0;
            this.repaint();
            return;
        }
        this.idx = a_idx == -1 ? this.to_play.size() - 1 : (a_idx >= this.to_play.size() ? 0 : a_idx);
        this.item = (PlaylistItem)this.to_play.elementAt(this.idx);
        try {
            if (this.item.DID == 0) {
                MP3.getMP3Poperties(this.item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (a_time_from_begining - 1 <= 5) {
            a_time_from_begining = 0;
        }
        this.cur_time = a_time_from_begining - 1;
        byte[] bytes_old = new byte[10];
        byte[] bytes_new = new byte[10];
        int f_descr = -1;
        File f = null;
        if (a_time_from_begining > 0) {
            int size_to_seek = (int)((double)(this.cur_time * this.item.BITRATE) / 0.008 + (double)this.item.TAG);
            bytes_new[0] = 73;
            bytes_new[1] = 68;
            bytes_new[2] = 51;
            bytes_new[3] = 3;
            bytes_new[4] = 0;
            bytes_new[5] = 0;
            bytes_new[6] = (byte)(size_to_seek >> 21 & 0x7F);
            bytes_new[7] = (byte)(size_to_seek >> 14 & 0x7F);
            bytes_new[8] = (byte)(size_to_seek >> 7 & 0x7F);
            bytes_new[9] = (byte)(size_to_seek & 0x7F);
            f = new File();
            f_descr = f.open(String.valueOf(this.item.PATH) + this.item.FILE);
            if (f_descr > 0) {
                f.seek(f_descr, 0);
                f.read(f_descr, bytes_old, 0, bytes_old.length);
            }
        }
        try {
            try {
                int i;
                this.timer = new Timer();
                if (f_descr > 0 && a_time_from_begining > 0) {
                    f.seek(f_descr, 0);
                    f.write(f_descr, bytes_new, 0, bytes_new.length);
                }
                this.m_player = Manager.createPlayer((String)("file:///" + this.item.PATH + this.item.FILE));
                this.m_player.realize();
                this.m_player.prefetch();
                this.con = (VolumeControl)this.m_player.getControl("VolumeControl");
                if (this.con != null) {
                    this.con.setLevel(this.m_volume);
                    if (this.muted) {
                        this.con.setMute(true);
                    }
                }
                this.m_player.start();
                this.timer.scheduleAtFixedRate((TimerTask)new PlayTimerTask(this.item.TIME), 1000L, 1000L);
                this.m_player.addPlayerListener((PlayerListener)this);
                this.item.PLAYED = true;
                if (this.shuffle && (i = this.to_play.indexOf(this.item)) != -1) {
                    this.played.push(new Integer(i));
                }
                if (this.pl != null) {
                    if (this.pl.isShown()) {
                        this.pl.setSelectedIndex(this.pl.getSelectedIndex(), false);
                    }
                    this.pl.setSelectedIndex(this.idx, true);
                }
            }
            catch (IOException e) {
                catch_exept = true;
            }
            catch (MediaException e) {
                this.catchException((Exception)((Object)e));
            }
        }
        finally {
            if (f_descr > 0 && a_time_from_begining > 0) {
                f.seek(f_descr, 0);
                f.write(f_descr, bytes_old, 0, bytes_old.length);
                f.close(f_descr);
            }
        }
        if (catch_exept) {
            this.endPlay();
            this.repaint();
            this.Play(this.idx, 0);
        }
    }

    private void catchException(Exception e) {
        this.endPlay();
        this.repaint();
        this.idx = this.to_play.size() == 0 ? 0 : ++this.idx;
        this.Play(this.idx, 0);
    }

    public void playerUpdate(Player a_player, String a_msg, Object a_obj) {
        if (a_msg.equals("endOfMedia")) {
            this.endPlay();
            this.repaint();
            this.idx = this.to_play.size() == 0 ? 0 : (this.shuffle ? this.randomSearch() : ++this.idx);
            this.Play(this.idx, 0);
        }
    }

    public static String convertISOToUnicode(String a_iso_str) {
        if (a_iso_str == null) {
            return null;
        }
        char[] chars = a_iso_str.toCharArray();
        char[] result = new char[chars.length];
        int i = 0;
        while (i < chars.length) {
            result[i] = chars[i] <= '\u00ff' ? (chars[i] == '\u00a8' ? (char)(chars[i] + 857) : (chars[i] == '\u00b8' ? (char)(chars[i] + 921) : ('\u00c0' <= chars[i] && chars[i] <= '\u00ff' ? (char)(chars[i] + 848) : chars[i]))) : chars[i];
            ++i;
        }
        return new String(result);
    }

    public int getCurrentTime() {
        return this.cur_time;
    }

    public synchronized void endPlay() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.m_player != null) {
            this.m_player.close();
        }
    }

    private void showPlaylist() {
        if (this.to_play.size() == 0) {
            return;
        }
        if (this.pl_changed) {
            this.pl_size = this.to_play.size();
            String[] play_list = new String[this.pl_size];
            Image[] pl_img = new Image[this.pl_size];
            Enumeration enumer = this.to_play.elements();
            int i = 0;
            while (enumer.hasMoreElements()) {
                play_list[i] = this.createListItem((PlaylistItem)enumer.nextElement());
                pl_img[i] = mp3_img;
                ++i;
            }
            this.pl = new List("           Playlist", 3, play_list, pl_img);
            this.pl.addCommand(this.remove);
            this.pl.addCommand(this.play);
            this.pl.addCommand(this.back);
            this.pl.setSelectCommand(List.SELECT_COMMAND);
            this.pl.setCommandListener((CommandListener)this);
            this.pl_changed = false;
        }
        if (this.to_play.contains(this.item)) {
            this.pl.setSelectedIndex(this.idx, true);
        } else {
            this.pl.setSelectedIndex(0, true);
        }
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this.pl);
    }

    String createListItem(PlaylistItem a_pli) {
        String result = null;
        boolean show_name = false;
        if (a_pli.SONG != null && a_pli.ARTIST != null) {
            if (!a_pli.SONG.equals("") && !a_pli.ARTIST.equals("")) {
                result = MainWindow.convertISOToUnicode(String.valueOf(a_pli.SONG) + " - " + a_pli.ARTIST);
            } else {
                show_name = true;
            }
        } else {
            show_name = true;
        }
        if (show_name) {
            result = a_pli.FILE.substring(0, a_pli.FILE.length() - 4);
        }
        return result;
    }

    private int randomSearch() {
        int next = new Random().nextInt(this.to_play.size());
        if (!((PlaylistItem)this.to_play.elementAt((int)next)).PLAYED) {
            return next;
        }
        int i = 0;
        while (i < this.to_play.size()) {
            if (!((PlaylistItem)this.to_play.elementAt((int)i)).PLAYED) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.to_play.size()) {
            ((PlaylistItem)this.to_play.elementAt((int)i)).PLAYED = false;
            ++i;
        }
        this.played.removeAllElements();
        next = new Random().nextInt(this.to_play.size());
        return next;
    }

    protected void hideNotify() {
        if ((this.blocked || !this.blocked && this.pressed_key == 0 || this.incoming_call) && !this.m_midlet.paused && !this.m_midlet.after_paused) {
            if (this.resume_timer != null) {
                this.resume_timer.cancel();
                this.incoming_call = true;
            } else {
                this.m_midlet.time_from_begining = this.cur_time;
                this.endPlay();
                this.incoming_call = true;
                this.resume_timer = new Timer();
            }
        }
        if (this.pressed_key != 0) {
            this.pressed_key = 0;
        }
    }

    protected void showNotify() {
        if (this.incoming_call && !this.m_midlet.paused && !this.m_midlet.after_paused) {
            this.wait_to_resume = new TimerTask(){

                public void run() {
                    MainWindow.this.resume_timer.cancel();
                    MainWindow.this.repaint();
                    MainWindow.this.Play(MainWindow.this.idx, ((MainWindow)MainWindow.this).m_midlet.time_from_begining);
                }
            };
            this.resume_timer.schedule(this.wait_to_resume, 1000L);
            return;
        }
    }

    Vector getPlaylist() {
        return this.to_play;
    }

    void forwardBack(int a_time) {
        byte[] bytes_old = new byte[10];
        int size_to_seek = (int)((double)(a_time * this.item.BITRATE) / 0.008 + (double)this.item.TAG);
        byte[] bytes_new = new byte[]{73, 68, 51, 3, 0, 0, (byte)(size_to_seek >> 21 & 0x7F), (byte)(size_to_seek >> 14 & 0x7F), (byte)(size_to_seek >> 7 & 0x7F), (byte)(size_to_seek & 0x7F)};
        File f = new File();
        int f_descr = f.open(String.valueOf(this.item.PATH) + this.item.FILE);
        if (f_descr < 0) {
            return;
        }
        f.seek(f_descr, 0);
        f.read(f_descr, bytes_old, 0, bytes_old.length);
        try {
            try {
                f.seek(f_descr, 0);
                f.write(f_descr, bytes_new, 0, bytes_new.length);
            }
            catch (Exception exception) {}
        }
        finally {
            f.seek(f_descr, 0);
            f.write(f_descr, bytes_old, 0, bytes_old.length);
        }
    }

    private class PlayTimerTask
    extends TimerTask {
        PlayTimerTask(int a_time) {
            MainWindow.this.play_time = a_time;
        }

        public void run() {
            MainWindow mainWindow = MainWindow.this;
            int n = mainWindow.cur_time;
            mainWindow.cur_time = n + 1;
            if (n >= MainWindow.this.play_time) {
                MainWindow.this.repaint(MainWindow.this.x, MainWindow.this.y, MainWindow.this.w, MainWindow.this.h);
                MainWindow.this.timer.cancel();
                return;
            }
            MainWindow.this.repaint(MainWindow.this.x, MainWindow.this.y, MainWindow.this.w, MainWindow.this.h);
        }
    }

    private class RewindBackTimerTask
    extends TimerTask {
        RewindBackTimerTask() {
        }

        public void run() {
            MainWindow mainWindow = MainWindow.this;
            mainWindow.cur_time = mainWindow.cur_time - 1;
            if (MainWindow.this.cur_time < 0) {
                if (MainWindow.this.to_play.size() == 0) {
                    MainWindow.this.Play(0, 0);
                }
                if (MainWindow.this.shuffle) {
                    if (MainWindow.this.played.size() > 0) {
                        MainWindow.this.played.pop();
                        MainWindow.this.idx = MainWindow.this.played.size() > 0 ? (Integer)MainWindow.this.played.pop() : MainWindow.this.randomSearch();
                    } else {
                        MainWindow.this.idx = MainWindow.this.randomSearch();
                    }
                } else if (--MainWindow.this.idx < 0) {
                    MainWindow.this.idx = MainWindow.this.to_play.size() - 1;
                }
                MainWindow.this.item = (PlaylistItem)MainWindow.this.to_play.elementAt(MainWindow.this.idx);
                MainWindow.this.play_time = MainWindow.this.item.TIME;
                MainWindow.this.cur_time = MainWindow.this.item.TIME;
                MainWindow.this.repaint();
            } else {
                MainWindow.this.repaint(MainWindow.this.x, MainWindow.this.y, MainWindow.this.w, MainWindow.this.h);
            }
        }
    }

    private class RewindForwardTimerTask
    extends TimerTask {
        RewindForwardTimerTask() {
        }

        public void run() {
            MainWindow mainWindow = MainWindow.this;
            mainWindow.cur_time = mainWindow.cur_time + 1;
            if (MainWindow.this.cur_time > MainWindow.this.play_time) {
                if (MainWindow.this.to_play.size() == 0) {
                    MainWindow.this.Play(0, 0);
                }
                if (MainWindow.this.shuffle) {
                    MainWindow.this.idx = MainWindow.this.randomSearch();
                } else if (++MainWindow.this.idx >= MainWindow.this.to_play.size()) {
                    MainWindow.this.idx = 0;
                }
                MainWindow.this.item = (PlaylistItem)MainWindow.this.to_play.elementAt(MainWindow.this.idx);
                MainWindow.this.play_time = MainWindow.this.item.TIME;
                MainWindow.this.cur_time = 0;
                MainWindow.this.repaint();
            } else {
                MainWindow.this.repaint(MainWindow.this.x, MainWindow.this.y, MainWindow.this.w, MainWindow.this.h);
            }
        }
    }

    class OperateMP3
    extends Thread {
        Enumeration enumer = null;

        OperateMP3(Vector a_to_play) {
            this.enumer = a_to_play.elements();
        }

        public void run() {
            while (this.enumer.hasMoreElements()) {
                PlaylistItem pli = (PlaylistItem)this.enumer.nextElement();
                if (pli.DID != 0) continue;
                try {
                    MP3.getMP3Poperties(pli);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                MainWindow.this.to_play.addElement(pli);
                if (MainWindow.this.pl != null && Display.getDisplay((MIDlet)MainWindow.this.m_midlet).getCurrent() == MainWindow.this.pl) {
                    MainWindow.this.pl.append(MainWindow.this.createListItem(pli), mp3_img);
                }
                MainWindow.this.pl_changed = true;
            }
            MainWindow.this.repaint(0, 100, MainWindow.this.getWidth(), 20);
        }
    }
}

