/*
 * Decompiled with CFR 0.152.
 */
package mps;

import com.siemens.mp.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import mps.MainWindow;
import mps.MmpsPlayer;
import mps.PlaylistItem;

class FileManager
implements CommandListener {
    private Command open;
    private Command select;
    private Command save;
    private Command cancel;
    private String path = "";
    private String back = "..";
    private String[] root_file_list = new String[]{"\u041c\u043e\u0438 \u0444\u0430\u0439\u043b\u044b", "\u041c\u0443\u043b\u044c\u0442.\u043a\u0430\u0440\u0442\u0430"};
    private String[] file_list = this.root_file_list;
    private MmpsPlayer m_midlet;
    static List FM;
    static String MP3;
    static String PLT;
    private Image[] root_img = new Image[]{MainWindow.stuff_img, MainWindow.mmc_img};
    private int index;
    public static Stack stack;
    private boolean check_stack = false;
    private int regim = 0;
    private Vector m_selected_files = new Vector();

    static {
        MP3 = ".mp3";
        PLT = ".plt";
    }

    FileManager(MmpsPlayer a_midlet, int a_regim) {
        this.regim = a_regim;
        this.open = new Command("Open", 8, 2);
        if (a_regim == 3) {
            this.save = new Command("Save", 8, 1);
        } else {
            this.select = new Command("Select", 8, 1);
        }
        this.cancel = new Command("", 2, 1);
        this.m_midlet = a_midlet;
        if (stack == null) {
            stack = new Stack();
        }
        this.path = MainWindow.path;
        this.check_stack = true;
        this.createList(this.path);
    }

    private void fillList(String[] a_file_list, Image[] a_img_list) {
        FM = new List(this.regim == 3 ? "     Select dir" : "     Select dir/file", 3, a_file_list, a_img_list);
        if (!stack.empty() && this.check_stack) {
            FM.setSelectedIndex(((Integer)stack.pop()).intValue(), true);
        }
        FM.setSelectCommand(List.SELECT_COMMAND);
        FM.addCommand(this.open);
        FM.addCommand(this.cancel);
        if (this.regim == 3) {
            FM.addCommand(this.save);
        } else {
            FM.addCommand(this.select);
        }
        FM.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)FM);
    }

    private void createList(String a_path) {
        if (a_path.equals("")) {
            this.file_list = this.root_file_list;
            this.fillList(this.root_file_list, this.root_img);
            return;
        }
        String[] name_list = File.list((String)a_path);
        if (name_list == null) {
            this.file_list = new String[]{this.back};
            this.fillList(this.file_list, null);
        } else {
            Vector<String> f_list = new Vector<String>();
            Vector<Image> img_list = new Vector<Image>();
            Object[] out_img = null;
            f_list.addElement(this.back);
            img_list.addElement(null);
            int i = 0;
            while (i < name_list.length) {
                if (name_list[i].endsWith("/")) {
                    img_list.addElement(MainWindow.folder_img);
                    f_list.addElement(name_list[i]);
                } else if (FileManager.isMP3(name_list[i]) && this.regim != 2) {
                    img_list.addElement(MainWindow.mp3_img);
                    f_list.addElement(name_list[i]);
                } else if (FileManager.isPLT(name_list[i])) {
                    img_list.addElement(MainWindow.plt_img);
                    f_list.addElement(name_list[i]);
                }
                ++i;
            }
            this.file_list = new String[f_list.size()];
            f_list.copyInto(this.file_list);
            out_img = new Image[img_list.size()];
            img_list.copyInto(out_img);
            this.fillList(this.file_list, (Image[])out_img);
        }
    }

    private void readDirectory(String a_path, Vector a_to_play) {
        String[] name_list = File.list((String)a_path);
        int i = 0;
        while (i < name_list.length) {
            if (name_list[i].endsWith("/")) {
                this.readDirectory(String.valueOf(a_path) + name_list[i], a_to_play);
            } else if (FileManager.isMP3(name_list[i])) {
                a_to_play.addElement(new PlaylistItem(name_list[i], a_path));
            }
            ++i;
        }
    }

    public void commandAction(Command com, Displayable arg1) {
        this.check_stack = false;
        this.index = FM.getSelectedIndex();
        if (this.index != -1) {
            if (com == this.open || com == List.SELECT_COMMAND) {
                if (this.file_list[this.index].equals("..")) {
                    this.path = this.path.substring(0, this.path.substring(0, this.path.length() - 2).lastIndexOf(47) + 1);
                    this.check_stack = true;
                } else if (this.file_list[this.index].endsWith("/")) {
                    this.path = String.valueOf(this.path) + this.file_list[this.index];
                    stack.push(new Integer(this.index));
                } else if (this.file_list[this.index].equals(this.root_file_list[0])) {
                    this.path = "0:/";
                    stack.push(new Integer(this.index));
                } else if (this.file_list[this.index].equals(this.root_file_list[1])) {
                    this.path = "4:/";
                    stack.push(new Integer(this.index));
                } else {
                    if (this.m_selected_files.size() > 0) {
                        Vector<PlaylistItem> to_play = new Vector<PlaylistItem>();
                        Enumeration enumer = this.m_selected_files.elements();
                        while (enumer.hasMoreElements()) {
                            Vector vector;
                            String file_name = FM.getString(((Integer)enumer.nextElement()).intValue());
                            if (FileManager.isMP3(file_name)) {
                                to_play.addElement(new PlaylistItem(file_name, this.path));
                                continue;
                            }
                            if (!FileManager.isPLT(file_name) || (vector = FileManager.parsePlt(String.valueOf(this.path) + file_name)).size() <= 0) continue;
                            Enumeration plt_files = vector.elements();
                            while (plt_files.hasMoreElements()) {
                                to_play.addElement((PlaylistItem)plt_files.nextElement());
                            }
                        }
                        this.play(to_play);
                        return;
                    }
                    if (FileManager.isMP3(this.file_list[this.index])) {
                        this.select(this.file_list[this.index]);
                        return;
                    }
                    if (FileManager.isPLT(this.file_list[this.index])) {
                        this.select(this.file_list[this.index]);
                        return;
                    }
                    return;
                }
                this.m_selected_files.removeAllElements();
                this.createList(this.path);
            } else if (com == this.select) {
                if (FileManager.isMP3(this.file_list[this.index])) {
                    Integer sel_i = new Integer(this.index);
                    if (this.m_selected_files.contains(sel_i)) {
                        this.m_selected_files.removeElement(sel_i);
                        String file_name = FM.getString(this.index);
                        FM.set(this.index, file_name, MainWindow.mp3_img);
                    } else {
                        this.m_selected_files.addElement(sel_i);
                        String file_name = FM.getString(this.index);
                        FM.set(this.index, file_name, MainWindow.sel_img);
                    }
                    return;
                }
                if (FileManager.isPLT(this.file_list[this.index])) {
                    Integer sel_i = new Integer(this.index);
                    if (this.m_selected_files.contains(sel_i)) {
                        this.m_selected_files.removeElement(sel_i);
                        String file_name = FM.getString(this.index);
                        FM.set(this.index, file_name, MainWindow.plt_img);
                    } else {
                        this.m_selected_files.addElement(sel_i);
                        String file_name = FM.getString(this.index);
                        FM.set(this.index, file_name, MainWindow.sel_img);
                    }
                    return;
                }
                if (this.m_selected_files.size() > 0) {
                    Enumeration enumer = this.m_selected_files.elements();
                    while (enumer.hasMoreElements()) {
                        int i = (Integer)enumer.nextElement();
                        String file_name = FM.getString(i);
                        if (FileManager.isMP3(file_name)) {
                            FM.set(i, file_name, MainWindow.mp3_img);
                            continue;
                        }
                        if (!FileManager.isPLT(file_name)) continue;
                        FM.set(i, file_name, MainWindow.plt_img);
                    }
                }
                FM.set(this.index, FM.getString(this.index), MainWindow.sel_img);
                try {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    this.select(this.file_list[this.index]);
                }
            } else if (com == this.save) {
                this.savePlaylist();
                this.m_midlet.getMainWindow().prev_window = this.m_midlet.getMainWindow();
                Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this.m_midlet.getMainWindow());
            }
        }
        if (com == this.cancel) {
            this.m_selected_files.removeAllElements();
            MainWindow.path = this.path;
            stack.push(new Integer(this.index));
            Display.getDisplay((MIDlet)this.m_midlet).setCurrent(this.m_midlet.getMainWindow().prev_window);
        }
    }

    private static boolean isMP3(String a_file) {
        boolean result = false;
        if (a_file.length() > 4) {
            result = a_file.substring(a_file.length() - 4).equalsIgnoreCase(MP3);
        }
        return result;
    }

    private static boolean isPLT(String a_file) {
        boolean result = false;
        if (a_file.length() > 4) {
            result = a_file.substring(a_file.length() - 4).equalsIgnoreCase(PLT);
        }
        return result;
    }

    private void savePlaylist() {
        int num = -1;
        MainWindow main_win = this.m_midlet.getMainWindow();
        Vector playlist = main_win.getPlaylist();
        File file = new File();
        try {
            int descr = File.exists((String)(String.valueOf(this.path) + main_win.saved_pl + ".plt"));
            while (descr > 0) {
                descr = File.exists((String)(String.valueOf(this.path) + main_win.saved_pl + "_" + ++num + ".plt"));
            }
            String plt_name = String.valueOf(this.path) + main_win.saved_pl + (num > -1 ? "_" + num : "") + ".plt";
            descr = file.open(plt_name);
            Enumeration enumer = playlist.elements();
            while (enumer.hasMoreElements()) {
                PlaylistItem item = (PlaylistItem)enumer.nextElement();
                byte[] to_write = (String.valueOf(item.PATH) + item.FILE).getBytes("utf-8");
                char length = (char)to_write.length;
                byte[] length_to_write = new byte[]{(byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
                file.write(descr, length_to_write, 0, length_to_write.length);
                file.write(descr, to_write, 0, to_write.length);
            }
            file.close(descr);
            FileManager.createCfg(plt_name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void select(String a_selection) {
        Vector to_play = new Vector();
        switch (this.regim) {
            case 0: 
            case 1: {
                if (a_selection.equals("..")) {
                    this.readDirectory(this.path, to_play);
                    break;
                }
                if (a_selection.endsWith("/")) {
                    this.readDirectory(String.valueOf(this.path) + a_selection, to_play);
                    break;
                }
                if (FileManager.isMP3(a_selection)) {
                    to_play.addElement(new PlaylistItem(a_selection, this.path));
                    break;
                }
                if (FileManager.isPLT(a_selection)) {
                    to_play = FileManager.parsePlt(String.valueOf(this.path) + a_selection);
                    break;
                }
                return;
            }
            case 2: {
                if (FileManager.isPLT(a_selection)) {
                    to_play = FileManager.parsePlt(String.valueOf(this.path) + a_selection);
                    if (to_play.size() <= 0) break;
                    FileManager.createCfg(String.valueOf(this.path) + a_selection);
                    break;
                }
                return;
            }
        }
        this.play(to_play);
    }

    private void play(Vector a_to_play) {
        if (a_to_play.size() != 0) {
            this.m_selected_files.removeAllElements();
            MainWindow.path = this.path;
            stack.push(new Integer(this.index));
            Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this.m_midlet.getMainWindow());
            if (this.regim == 0 || this.regim == 2) {
                this.m_midlet.getMainWindow().setPlayList(a_to_play);
            } else if (this.regim == 1) {
                this.m_midlet.getMainWindow().addToPlayList(a_to_play);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Vector parsePlt(String a_file) {
        void var1_1;
        Vector<PlaylistItem> to_play = new Vector<PlaylistItem>();
        int descr = -1;
        File file = null;
        try {
            file = new File();
            descr = file.open(a_file);
            if (file.length(descr) < 2) {
                Vector<PlaylistItem> vector = to_play;
                return vector;
            }
            byte[] length = new byte[2];
            int seek_pos = 0;
            while (seek_pos < file.length(descr)) {
                file.read(descr, length, 0, length.length);
                seek_pos += 2;
                int num_simbol = length[0] << 8 | length[1];
                if ((seek_pos += num_simbol) > file.length(descr)) {
                    throw new Exception();
                }
                byte[] byte_item = new byte[num_simbol];
                file.read(descr, byte_item, 0, byte_item.length);
                String item = new String(byte_item, "utf-8");
                if (!FileManager.isMP3(item) || File.exists((String)item) <= 0) continue;
                String item_path = item.substring(0, item.lastIndexOf(47) + 1);
                String item_file = item.substring(item.lastIndexOf(47) + 1);
                to_play.addElement(new PlaylistItem(item_file, item_path));
            }
        }
        catch (Exception e) {
            to_play.removeAllElements();
            e.printStackTrace();
        }
        finally {
            if (descr > 0 && file != null) {
                file.close(descr);
            }
        }
        return var1_1;
    }

    static void createCfg(String a_file) {
        File cfg = null;
        int cfg_descr = -1;
        try {
            try {
                if (File.exists((String)"MpS.cfg") > 0) {
                    File.delete((String)"MpS.cfg");
                }
                cfg = new File();
                cfg_descr = cfg.open("MpS.cfg");
                byte[] to_write = a_file.getBytes("utf-8");
                cfg.write(cfg_descr, to_write, 0, to_write.length);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        finally {
            cfg.close(cfg_descr);
        }
    }
}

